/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.statistics;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rml.dfa.DfaEvaluationStatus;
import com.intellij.rml.dfa.utils.measurements.DfaMeasurementKind;
import com.intellij.rml.dfa.utils.measurements.DfaSingleMeasurementResult;
import com.jetbrains.cidr.lang.dfa.statistics.DfaRunAggregationStatistics;
import com.jetbrains.cidr.lang.dfa.statistics.DfaRunInfoAggregator;
import com.jetbrains.cidr.lang.dfa.statistics.DfaStatisticService;
import com.jetbrains.cidr.lang.dfa.statistics.DfaStatisticsCollector;
import com.jetbrains.cidr.lang.dfa.statistics.DfaStatisticsMeasurement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.HdrHistogram.Histogram;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ,\u0010\r\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u0012\u0004\u0012\u00020\u00120\u000ej\u0002`\u00132\u0006\u0010\t\u001a\u00020\nH\u0002J0\u0010\u0014\u001a\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000ej\u0004\u0018\u0001`\u00132\u0006\u0010\t\u001a\u00020\nH\u0002J`\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001dH\u0002J\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#J8\u0010$\u001a\u00020\u0012*\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u0012\u0004\u0012\u00020\u00120\u000ej\u0002`\u00132\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/cidr/lang/dfa/statistics/DfaStatisticService;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "clearStatistics", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "flushStatistics", "Lkotlinx/coroutines/Job;", "getOrCreateStatistics", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "", "Lcom/intellij/rml/dfa/DfaEvaluationStatus;", "Lcom/jetbrains/cidr/lang/dfa/statistics/DfaRunInfoAggregator;", "Lcom/jetbrains/cidr/lang/dfa/statistics/DfaRunFileStatistics;", "getStatistics", "recordRunInfo", "status", "durationMs", "", "bddOpCount", "bddMem", "hasErrors", "domS", "", "domV", "domC", "domM", "domI", "measurement", "Lcom/jetbrains/cidr/lang/dfa/statistics/DfaStatisticsMeasurement;", "getAggregator", "Companion", "intellij.c.dfa"})
@SourceDebugExtension(value={"SMAP\nDfaStatisticsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DfaStatisticsService.kt\ncom/jetbrains/cidr/lang/dfa/statistics/DfaStatisticService\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n72#2,2:174\n1#3:176\n*S KotlinDebug\n*F\n+ 1 DfaStatisticsService.kt\ncom/jetbrains/cidr/lang/dfa/statistics/DfaStatisticService\n*L\n154#1:174,2\n154#1:176\n*E\n"})
public final class DfaStatisticService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private static final Key<ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator>> KEY;
    @NotNull
    private static final Logger LOG;

    public DfaStatisticService(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recordRunInfo(VirtualFile file, DfaEvaluationStatus status, long durationMs, long bddOpCount, long bddMem, boolean hasErrors, int domS, int domV, int domC, int domM, int domI) {
        Integer fileSize = (Integer)ReadAction.compute(() -> DfaStatisticService.recordRunInfo$lambda$0(file));
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator> stats = this.getOrCreateStatistics(file);
            DfaRunInfoAggregator aggregator = this.getAggregator(stats, hasErrors, status);
            aggregator.addRunInfo(durationMs, bddOpCount, bddMem, fileSize.intValue(), domS, domV, domC, domM, domI);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        LOG.debug("Collect statistics for " + file.getName() + ": " + status + ", hasErrors=" + hasErrors + ", " + durationMs + " ms, " + bddMem + " byte, " + bddOpCount + " ops, " + (long)fileSize.intValue() + " loc, S=" + (long)domS + ", V=" + (long)domV + ", C=" + (long)domC + ", M=" + (long)domM + ", I=" + (long)domI);
    }

    @NotNull
    public final Job recordRunInfo(@NotNull VirtualFile file, @NotNull DfaStatisticsMeasurement measurement) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)measurement), (String)"measurement");
        return BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(measurement, file, null){
            int label;
            final /* synthetic */ DfaStatisticsMeasurement $measurement;
            final /* synthetic */ VirtualFile $file;
            {
                this.$measurement = $measurement;
                this.$file = $file;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DfaSingleMeasurementResult.Status status = this.$measurement.getStatus();
                        if (status == null || (status = status.getValue()) == null) {
                            return Unit.INSTANCE;
                        }
                        DfaSingleMeasurementResult.Status status2 = status;
                        DfaSingleMeasurementResult.Numeric.ExecutionDuration executionDuration = this.$measurement.getTotalTime();
                        if (executionDuration == null) {
                            return Unit.INSTANCE;
                        }
                        long timeMs = executionDuration.getMillis();
                        DfaSingleMeasurementResult.Numeric.MemoryConsumption memoryConsumption = this.$measurement.getMemoryPeak();
                        if (memoryConsumption == null) {
                            return Unit.INSTANCE;
                        }
                        long memBytes = memoryConsumption.getBytes();
                        Object object2 = this.$measurement.getBddOps();
                        if (object2 == null || (object2 = object2.getValue()) == null) {
                            return Unit.INSTANCE;
                        }
                        long bddOps = ((Number)object2).longValue();
                        boolean hasErrors = this.$measurement.hasErrors();
                        Integer n = this.$measurement.getDomainSize((com.intellij.rml.dfa.utils.Key<DfaSingleMeasurementResult.Numeric>)DfaMeasurementKind.DomainSizes.Companion.getDOMAIN_S_SIZE());
                        if (n == null) {
                            return Unit.INSTANCE;
                        }
                        int domS = n;
                        Integer n2 = this.$measurement.getDomainSize((com.intellij.rml.dfa.utils.Key<DfaSingleMeasurementResult.Numeric>)DfaMeasurementKind.DomainSizes.Companion.getDOMAIN_V_SIZE());
                        if (n2 == null) {
                            return Unit.INSTANCE;
                        }
                        int domV = n2;
                        Integer n3 = this.$measurement.getDomainSize((com.intellij.rml.dfa.utils.Key<DfaSingleMeasurementResult.Numeric>)DfaMeasurementKind.DomainSizes.Companion.getDOMAIN_C_SIZE());
                        if (n3 == null) {
                            return Unit.INSTANCE;
                        }
                        int domC = n3;
                        Integer n4 = this.$measurement.getDomainSize((com.intellij.rml.dfa.utils.Key<DfaSingleMeasurementResult.Numeric>)DfaMeasurementKind.DomainSizes.Companion.getDOMAIN_M_SIZE());
                        if (n4 == null) {
                            return Unit.INSTANCE;
                        }
                        int domM = n4;
                        Integer n5 = this.$measurement.getDomainSize((com.intellij.rml.dfa.utils.Key<DfaSingleMeasurementResult.Numeric>)DfaMeasurementKind.DomainSizes.Companion.getDOMAIN_I_SIZE());
                        if (n5 == null) {
                            return Unit.INSTANCE;
                        }
                        int domI = n5;
                        boolean $i$f$service = false;
                        Class<DfaStatisticService> serviceClass$iv = DfaStatisticService.class;
                        Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv);
                        if (object3 == null) {
                            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                        }
                        DfaStatisticService.access$recordRunInfo((DfaStatisticService)object3, this.$file, (DfaEvaluationStatus)status2, timeMs, bddOps, memBytes, hasErrors, domS, domV, domC, domM, domI);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Job flushStatistics(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file, null){
            int label;
            final /* synthetic */ DfaStatisticService this$0;
            final /* synthetic */ VirtualFile $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ConcurrentHashMap $i$a$-withLock-DfaStatisticService$flushStatistics$1$statMap$2;
                        ResultKt.throwOnFailure((Object)object);
                        Object object2 = DfaStatisticService.access$getLock$p(this.this$0);
                        Object[] objectArray = this.this$0;
                        Object object3 = this.$file;
                        object2.lock();
                        try {
                            boolean bl = false;
                            ConcurrentHashMap statMap = DfaStatisticService.access$getStatistics((DfaStatisticService)objectArray, (VirtualFile)object3);
                            if (statMap == null) {
                                Unit unit = Unit.INSTANCE;
                                return unit;
                            }
                            DfaStatisticService.access$clearStatistics((DfaStatisticService)objectArray, (VirtualFile)object3);
                            $i$a$-withLock-DfaStatisticService$flushStatistics$1$statMap$2 = statMap;
                        }
                        finally {
                            object2.unlock();
                        }
                        ConcurrentHashMap statMap = $i$a$-withLock-DfaStatisticService$flushStatistics$1$statMap$2;
                        objectArray = new Boolean[]{Boxing.boxBoolean((boolean)false), Boxing.boxBoolean((boolean)true)};
                        object2 = CollectionsKt.listOf((Object[])objectArray).iterator();
                        while (object2.hasNext()) {
                            boolean hasErrors = (Boolean)object2.next();
                            object3 = flushStatistics.EntriesMappings.entries$0.iterator();
                            while (object3.hasNext()) {
                                DfaEvaluationStatus status;
                                DfaRunInfoAggregator aggregator = DfaStatisticService.access$getAggregator(this.this$0, statMap, hasErrors, status = (DfaEvaluationStatus)object3.next());
                                if (aggregator.getRecordCount() == 0) continue;
                                Histogram durationHist = aggregator.getDurationInMsRecorder().getIntervalHistogram();
                                Histogram memoryHist = aggregator.getMemoryUsageInByteRecorder().getIntervalHistogram();
                                String string = this.$file.getPath();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                                DfaRunAggregationStatistics stat = new DfaRunAggregationStatistics(string, status, hasErrors, aggregator.getRecordCount(), MathKt.roundToLong((double)durationHist.getMean()), durationHist.getMaxValue(), durationHist.getValueAtPercentile(95.0), MathKt.roundToLong((double)memoryHist.getMean()), memoryHist.getMaxValue(), memoryHist.getValueAtPercentile(95.0), MathKt.roundToLong((double)aggregator.getBddOpCountRecorder().getIntervalHistogram().getMean()), MathKt.roundToInt((double)aggregator.getFileLineCountRecorder().getIntervalHistogram().getMean()), MathKt.roundToInt((double)aggregator.getDomSRecorder().getIntervalHistogram().getMean()), MathKt.roundToInt((double)aggregator.getDomVRecorder().getIntervalHistogram().getMean()), MathKt.roundToInt((double)aggregator.getDomCRecorder().getIntervalHistogram().getMean()), MathKt.roundToInt((double)aggregator.getDomMRecorder().getIntervalHistogram().getMean()), MathKt.roundToInt((double)aggregator.getDomIRecorder().getIntervalHistogram().getMean()));
                                DfaStatisticsCollector.INSTANCE.log(stat);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator> getOrCreateStatistics(VirtualFile file) {
        ConcurrentHashMap statMap = (ConcurrentHashMap)file.getUserData(KEY);
        if (statMap == null) {
            ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator> result2 = new ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator>();
            file.putUserData(KEY, result2);
            return result2;
        }
        return statMap;
    }

    private final ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator> getStatistics(VirtualFile file) {
        return (ConcurrentHashMap)file.getUserData(KEY);
    }

    private final void clearStatistics(VirtualFile file) {
        file.putUserData(KEY, null);
    }

    /*
     * WARNING - void declaration
     */
    private final DfaRunInfoAggregator getAggregator(ConcurrentHashMap<Pair<Boolean, DfaEvaluationStatus>, DfaRunInfoAggregator> $this$getAggregator, boolean hasErrors, DfaEvaluationStatus status) {
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = $this$getAggregator;
        Pair key$iv = TuplesKt.to((Object)hasErrors, (Object)status);
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            DfaRunInfoAggregator default$iv = new DfaRunInfoAggregator();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (DfaRunInfoAggregator)object;
    }

    private static final Integer recordRunInfo$lambda$0(VirtualFile $file) {
        Document doc;
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Document document = doc = FileDocumentManager.getInstance().getDocument($file);
        return document != null ? document.getLineCount() : 0;
    }

    public static final /* synthetic */ void access$recordRunInfo(DfaStatisticService $this, VirtualFile file, DfaEvaluationStatus status, long durationMs, long bddOpCount, long bddMem, boolean hasErrors, int domS, int domV, int domC, int domM, int domI) {
        $this.recordRunInfo(file, status, durationMs, bddOpCount, bddMem, hasErrors, domS, domV, domC, domM, domI);
    }

    public static final /* synthetic */ ReentrantLock access$getLock$p(DfaStatisticService $this) {
        return $this.lock;
    }

    public static final /* synthetic */ DfaRunInfoAggregator access$getAggregator(DfaStatisticService $this, ConcurrentHashMap $receiver, boolean hasErrors, DfaEvaluationStatus status) {
        return $this.getAggregator($receiver, hasErrors, status);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getStatistics(DfaStatisticService $this, VirtualFile file) {
        return $this.getStatistics(file);
    }

    public static final /* synthetic */ void access$clearStatistics(DfaStatisticService $this, VirtualFile file) {
        $this.clearStatistics(file);
    }

    static {
        Key key = Key.create((String)"DFA_RUNS_INFO");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
        Logger logger = Logger.getInstance(DfaStatisticService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R[\u0010\u0003\u001aO\u0012F\u0012D\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0004\u0012\u00020\t \u000b*\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0004\u0012\u00020\t\u0018\u00010\u0005j\u0004\u0018\u0001`\n0\u0005j\u0002`\n0\u0004\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/lang/dfa/statistics/DfaStatisticService$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "", "Lcom/intellij/rml/dfa/DfaEvaluationStatus;", "Lcom/jetbrains/cidr/lang/dfa/statistics/DfaRunInfoAggregator;", "Lcom/jetbrains/cidr/lang/dfa/statistics/DfaRunFileStatistics;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.c.dfa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

