/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.msvc;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.cpp.toolchains.msvc.MSVCArch;
import com.jetbrains.cidr.cpp.toolchains.msvc.MSVCArchAndVersion;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/msvc/MSVCCompilerToVersionCacheService;", "", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/jetbrains/cidr/cpp/toolchains/msvc/MSVCArchAndVersion;", "getCompilerVersion", "exePath", "Companion", "intellij.clion.toolchains"})
public final class MSVCCompilerToVersionCacheService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<String, MSVCArchAndVersion> cache = new ConcurrentHashMap();
    private static final Pattern msvcToolsFolderPattern = Pattern.compile(".*vc\\\\tools\\\\msvc\\\\(?<version>.*)\\\\bin\\\\(?<host>.*?)(\\\\(?<target>.*))?\\\\cl.exe");

    @Nullable
    public final MSVCArchAndVersion getCompilerVersion(@NotNull String exePath) {
        Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
        MSVCArchAndVersion result2 = this.cache.computeIfAbsent(exePath, arg_0 -> MSVCCompilerToVersionCacheService.getCompilerVersion$lambda$0((Function1)new Function1<String, MSVCArchAndVersion>(exePath){
            final /* synthetic */ String $exePath;
            {
                this.$exePath = $exePath;
                super(1);
            }

            public final MSVCArchAndVersion invoke(String path) {
                String string = this.$exePath.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String lowercasePath = string;
                Matcher matcher = MSVCCompilerToVersionCacheService.access$getMsvcToolsFolderPattern$cp().matcher(lowercasePath);
                if (matcher.find()) {
                    try {
                        String host;
                        String version = matcher.group("version");
                        String string2 = matcher.group("host");
                        String string3 = host = string2 != null ? StringsKt.replace$default((String)string2, (String)"host", (String)"", (boolean)false, (int)4, null) : null;
                        if (host == null) {
                            throw new IllegalArgumentException();
                        }
                        String target2 = matcher.group("target");
                        MSVCArch arch = MSVCArch.Companion.fromString((String)(Intrinsics.areEqual((Object)host, (Object)target2) ? host : host + "_" + target2));
                        if (version != null) {
                            return new MSVCArchAndVersion(arch, version);
                        }
                    }
                    catch (IllegalArgumentException version) {
                        // empty catch block
                    }
                }
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(MSVCCompilerToVersionCacheService.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Failed to detect compiler arch for " + path);
                return null;
            }
        }, arg_0));
        return result2;
    }

    private static final MSVCArchAndVersion getCompilerVersion$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MSVCArchAndVersion)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Pattern access$getMsvcToolsFolderPattern$cp() {
        return msvcToolsFolderPattern;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/msvc/MSVCCompilerToVersionCacheService$Companion;", "", "()V", "msvcToolsFolderPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "intellij.clion.toolchains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

