/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker;

import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.remoteRunRuntime.WrappedNotFoundException;
import com.intellij.docker.utils.RemoteDockerRuntimeUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerUtil;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.system.TarUtil;
import com.jetbrains.cidr.system.downloading.Downloader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/docker/DockerDownloader;", "Lcom/jetbrains/cidr/system/downloading/Downloader;", "credentialsHolder", "Lcom/intellij/docker/remote/DockerCredentialsHolder;", "containerSettings", "Lcom/intellij/docker/remote/DockerContainerSettings;", "bindVolumes", "", "Lcom/intellij/docker/agent/settings/DockerVolumeBinding;", "(Lcom/intellij/docker/remote/DockerCredentialsHolder;Lcom/intellij/docker/remote/DockerContainerSettings;Ljava/util/List;)V", "downloadFile", "Ljava/nio/file/Path;", "remotePath", "", "localRoot", "downloadFolderWithResolvedSymlinks", "downloadImpl", "localPath", "intellij.clion.docker"})
@SourceDebugExtension(value={"SMAP\nDockerDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerDownloader.kt\ncom/jetbrains/cidr/cpp/toolchains/docker/DockerDownloader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n13#2:80\n*S KotlinDebug\n*F\n+ 1 DockerDownloader.kt\ncom/jetbrains/cidr/cpp/toolchains/docker/DockerDownloader\n*L\n43#1:80\n*E\n"})
public final class DockerDownloader
extends Downloader {
    @NotNull
    private final DockerCredentialsHolder credentialsHolder;
    @Nullable
    private final DockerContainerSettings containerSettings;
    @NotNull
    private final List<DockerVolumeBinding> bindVolumes;

    public DockerDownloader(@NotNull DockerCredentialsHolder credentialsHolder, @Nullable DockerContainerSettings containerSettings, @NotNull List<? extends DockerVolumeBinding> bindVolumes2) {
        Intrinsics.checkNotNullParameter((Object)credentialsHolder, (String)"credentialsHolder");
        Intrinsics.checkNotNullParameter(bindVolumes2, (String)"bindVolumes");
        this.credentialsHolder = credentialsHolder;
        this.containerSettings = containerSettings;
        this.bindVolumes = bindVolumes2;
    }

    @Override
    @Nullable
    protected Path downloadFile(@NotNull String remotePath, @NotNull String localRoot) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
        String[] stringArray = new String[]{localRoot, RemoteUtil.suggestLocalPathName(remotePath)};
        String string = FileUtil.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        String downloadLocation = string;
        try {
            return this.downloadImpl(remotePath, downloadLocation);
        }
        catch (WrappedNotFoundException e) {
            CidrDockerUtil.LOG.warn("File not found: " + remotePath, (Throwable)e);
        }
        catch (Exception e) {
            CidrDockerUtil.LOG.error("Download failed: " + remotePath, (Throwable)e);
        }
        return null;
    }

    @Override
    @Nullable
    protected Path downloadFolderWithResolvedSymlinks(@NotNull String remotePath, @NotNull String localRoot) {
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerDownloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("DockerDownloader does not support folder download to local root");
        return this.downloadFile(remotePath, localRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path downloadImpl(String remotePath, String localPath) throws ExecutionException, IOException, ServerRuntimeException {
        RemoteDockerRuntime dockerRuntime = CidrDockerUtil.getDockerRuntime(this.credentialsHolder);
        String[] stringArray = new String[]{"/bin/true"};
        DockerAgentDeploymentConfigImpl config = CidrDockerUtil.getConfig(this.credentialsHolder, this.containerSettings, dockerRuntime, this.bindVolumes, null).withCommand(stringArray);
        RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)((DockerAgentDeploymentConfig)config));
        File localFilePath = new File(localPath);
        AtomicBoolean success = new AtomicBoolean();
        try {
            RemoteDockerRuntimeUtil.download((DockerAgentContainer)applicationRuntime.getAgentContainer(), (String)remotePath, (String)this.credentialsHolder.getAccountName(), arg_0 -> DockerDownloader.downloadImpl$lambda$0((Function1)new Function1<File, Unit>(success, localFilePath){
                final /* synthetic */ AtomicBoolean $success;
                final /* synthetic */ File $localFilePath;
                {
                    this.$success = $success;
                    this.$localFilePath = $localFilePath;
                    super(1);
                }

                public final void invoke(File file) {
                    this.$success.set(TarUtil.decompress(file, this.$localFilePath.getParentFile()));
                }
            }, arg_0));
        }
        finally {
            applicationRuntime.removeContainerWithVolumes();
        }
        if (success.get()) {
            return localFilePath.toPath();
        }
        return null;
    }

    private static final void downloadImpl$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

