/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.util.text.StringKt;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.toolchains.BuildTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/Make;", "Lcom/jetbrains/cidr/cpp/toolchains/BuildTool;", "executable", "Ljava/io/File;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "(Ljava/io/File;Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;)V", "toolSet", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolSet;", "Lorg/jetbrains/annotations/NotNull;", "readToolVersion", "Lcom/jetbrains/cidr/ToolVersion;", "readVersion", "", "intellij.clion.toolchains"})
@SourceDebugExtension(value={"SMAP\nMake.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Make.kt\ncom/jetbrains/cidr/cpp/toolchains/Make\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public final class Make
extends BuildTool {
    @NotNull
    private final CPPEnvironment environment;
    @NotNull
    private final CPPToolSet toolSet;

    public Make(@NotNull File executable, @NotNull CPPEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        super(executable);
        this.environment = environment2;
        CPPToolSet cPPToolSet = this.environment.getToolSet();
        Intrinsics.checkNotNullExpressionValue((Object)cPPToolSet, (String)"getToolSet(...)");
        this.toolSet = cPPToolSet;
    }

    @Override
    @Nullable
    public String readVersion() throws ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        this.environment.prepare(commandLine, CidrToolEnvironment.PrepareFor.BUILD);
        commandLine.setExePath(this.myExecutable.getPath());
        commandLine.addParameter("--version");
        HostMachine hostMachine = this.environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"getHostMachine(...)");
        HostMachine host = hostMachine;
        ProcessOutput processOutput = host.runProcess(commandLine, 10000);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        ProcessOutput output2 = processOutput;
        String string = output2.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        String result2 = StringKt.nullize((String)((String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)string))), (boolean)true);
        if (CPPLog.LOG.isDebugEnabled()) {
            CPPLog.logReadVersion("Make", this.myExecutable, result2);
        }
        return result2;
    }

    @Override
    @Nullable
    public ToolVersion readToolVersion() {
        ToolVersion toolVersion;
        String string = this.readVersion();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Pattern[] patternArray = new Pattern[]{CPPToolchainsUtil.VERSION_PATTERN};
            toolVersion = ToolVersion.parse((String)it, (Pattern[])patternArray);
        } else {
            toolVersion = null;
        }
        return toolVersion;
    }
}

