/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.external.system.project.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.CidrWorkspaceBundle;
import com.jetbrains.cidr.cpp.external.system.project.ui.UtilsKt;
import com.jetbrains.cidr.project.ui.ProjectStatusHelperKt;
import com.jetbrains.cidr.project.ui.notifications.EditorNotificationWarningProvider;
import com.jetbrains.cidr.project.ui.notifications.ProjectNotification;
import com.jetbrains.cidr.project.ui.popup.ProjectFixesProvider;
import com.jetbrains.cidr.project.ui.widget.DefaultWidgetStatus;
import com.jetbrains.cidr.project.ui.widget.Scope;
import com.jetbrains.cidr.project.ui.widget.Status;
import com.jetbrains.cidr.project.ui.widget.WidgetStatus;
import com.jetbrains.cidr.project.ui.widget.WidgetStatusProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000bH&J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH&J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/cpp/external/system/project/ui/ExternalProjectStatusAndFixesProviderBase;", "Lcom/jetbrains/cidr/project/ui/notifications/EditorNotificationWarningProvider;", "Lcom/jetbrains/cidr/project/ui/popup/ProjectFixesProvider;", "Lcom/jetbrains/cidr/project/ui/widget/WidgetStatusProvider;", "()V", "collectFixes", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "createLoadAction", "buildFile", "createSelectAndLoadAction", "rootDirectory", "getProjectNotification", "Lcom/jetbrains/cidr/project/ui/notifications/ProjectNotification;", "getWidgetStatus", "Lcom/jetbrains/cidr/project/ui/widget/WidgetStatus;", "currentFile", "isBuildFile", "", "intellij.clion.externalSystem"})
@SourceDebugExtension(value={"SMAP\nExternalProjectStatusAndFixesProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalProjectStatusAndFixesProviderBase.kt\ncom/jetbrains/cidr/cpp/external/system/project/ui/ExternalProjectStatusAndFixesProviderBase\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,68:1\n12474#2,2:69\n*S KotlinDebug\n*F\n+ 1 ExternalProjectStatusAndFixesProviderBase.kt\ncom/jetbrains/cidr/cpp/external/system/project/ui/ExternalProjectStatusAndFixesProviderBase\n*L\n61#1:69,2\n*E\n"})
public abstract class ExternalProjectStatusAndFixesProviderBase
implements EditorNotificationWarningProvider,
ProjectFixesProvider,
WidgetStatusProvider {
    public abstract boolean isBuildFile(@NotNull VirtualFile var1);

    @NotNull
    public abstract AnAction createLoadAction(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    public abstract AnAction createSelectAndLoadAction(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    public WidgetStatus getWidgetStatus(@NotNull Project project, @Nullable VirtualFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (currentFile == null) {
            return null;
        }
        if (ProjectStatusHelperKt.isExternalFileOrSingleFile((Project)project, (VirtualFile)currentFile)) {
            return null;
        }
        if (UtilsKt.isLinkedProject(project)) {
            return null;
        }
        if (this.isBuildFile(currentFile) || ProjectStatusHelperKt.isProjectAwareFile((VirtualFile)currentFile, (Project)project)) {
            String string = CidrWorkspaceBundle.message((String)"project.status.widget.not.configured", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return (WidgetStatus)new DefaultWidgetStatus(Status.Warning, Scope.Project, string);
        }
        return null;
    }

    @Nullable
    public ProjectNotification getProjectNotification(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ProjectStatusHelperKt.convertStatus((WidgetStatus)this.getWidgetStatus(project, file));
    }

    @NotNull
    public List<AnAction> collectFixes(@NotNull Project project, @Nullable VirtualFile file, @NotNull DataContext context2) {
        boolean bl;
        VirtualFile rootDirectory;
        block6: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (file != null && ProjectStatusHelperKt.isExternalFileOrSingleFile((Project)project, (VirtualFile)file)) {
                return CollectionsKt.emptyList();
            }
            if (UtilsKt.isLinkedProject(project)) {
                return CollectionsKt.emptyList();
            }
            if (file != null && this.isBuildFile(file)) {
                return CollectionsKt.listOf((Object)this.createLoadAction(project, file));
            }
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
            if (virtualFile == null) {
                return CollectionsKt.emptyList();
            }
            rootDirectory = virtualFile;
            VirtualFile[] virtualFileArray = rootDirectory.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object[] $this$any$iv = virtualFileArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.isBuildFile(it)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            return CollectionsKt.listOf((Object)this.createSelectAndLoadAction(project, rootDirectory));
        }
        return CollectionsKt.emptyList();
    }
}

