/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetCellRenderer;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetEditor;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetParameters;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetService;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.NamedDebugTargetConfigurable;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0016J\b\u0010'\u001a\u00020%H\u0002J\b\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020%H\u0002J\b\u00100\u001a\u00020%H\u0016J\u001a\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\b\u0003\u00105\u001a\u000202H\u0002J\b\u00106\u001a\u000202H\u0017J\b\u00107\u001a\u000202H\u0016J\b\u00108\u001a\u00020.H\u0016J\b\u00109\u001a\u00020%H\u0002J\u0018\u0010:\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u000f0;H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/NamedDebugTargetConfigurable;", "Lcom/intellij/openapi/options/Configurable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "deletedItems", "", "Lcom/intellij/execution/configurations/RunConfiguration;", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "getDisposable$intellij_clion_execution", "()Lcom/intellij/openapi/Disposable;", "editors", "Lkotlin/sequences/Sequence;", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetEditor;", "getEditors$intellij_clion_execution", "()Lkotlin/sequences/Sequence;", "emptyPanel", "Lcom/intellij/ui/components/JBPanel;", "initialTreeAndEditorWidthRatio", "", "nodeComparator", "Ljava/util/Comparator;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getProject", "()Lcom/intellij/openapi/project/Project;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "getTree$intellij_clion_execution", "()Lcom/intellij/ui/treeStructure/Tree;", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "getTreeModel$intellij_clion_execution", "()Ljavax/swing/tree/DefaultTreeModel;", "treeRoot", "addNewDebugTarget", "", "apply", "cloneDebugTarget", "createComponent", "Ljavax/swing/JComponent;", "createTreeNode", "configuration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "newItem", "", "deleteDebugTarget", "disposeUIResources", "findNewName", "", "manager", "Lcom/intellij/execution/RunManager;", "defName", "getDisplayName", "getHelpTopic", "isModified", "refreshTree", "selectedItem", "Lkotlin/Pair;", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nNamedDebugTargetConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamedDebugTargetConfigurable.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/NamedDebugTargetConfigurable\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n31#2,2:217\n14#3:219\n14#3:220\n14#3:232\n14#3:233\n2159#4,2:221\n1247#4,2:223\n1313#4,2:225\n1313#4,2:230\n766#5:227\n857#5,2:228\n*S KotlinDebug\n*F\n+ 1 NamedDebugTargetConfigurable.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/NamedDebugTargetConfigurable\n*L\n53#1:217,2\n76#1:219\n77#1:220\n39#1:232\n40#1:233\n188#1:221,2\n197#1:223,2\n200#1:225,2\n208#1:230,2\n204#1:227\n204#1:228,2\n*E\n"})
public final class NamedDebugTargetConfigurable
implements Configurable {
    @NotNull
    private final Project project;
    private final float initialTreeAndEditorWidthRatio;
    @NotNull
    private final Comparator<DefaultMutableTreeNode> nodeComparator;
    @NotNull
    private final List<RunConfiguration> deletedItems;
    @NotNull
    private final DefaultMutableTreeNode treeRoot;
    @NotNull
    private final DefaultTreeModel treeModel;
    @NotNull
    private final Tree tree;
    @NotNull
    private final JBPanel<JBPanel<?>> emptyPanel;
    @NotNull
    private final Disposable disposable;

    public NamedDebugTargetConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.initialTreeAndEditorWidthRatio = 0.3f;
        this.nodeComparator = NamedDebugTargetConfigurable::nodeComparator$lambda$0;
        this.deletedItems = new ArrayList();
        this.treeRoot = new DefaultMutableTreeNode("root");
        this.treeModel = new DefaultTreeModel(this.treeRoot);
        this.tree = new Tree((TreeModel)this.treeModel);
        this.emptyPanel = new JBPanel();
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DebugTargetService> serviceClass$iv = DebugTargetService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Disposable disposable = Disposer.newDisposable((Disposable)((Disposable)object));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NlsContexts.ConfigurableName
    @NotNull
    public String getDisplayName() {
        String string = CLionExecutionBundle.message("debug.targets.configurable.name.debug.target", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public final DefaultTreeModel getTreeModel$intellij_clion_execution() {
        return this.treeModel;
    }

    @NotNull
    public final Tree getTree$intellij_clion_execution() {
        return this.tree;
    }

    @NotNull
    public final Disposable getDisposable$intellij_clion_execution() {
        return this.disposable;
    }

    @NotNull
    public String getHelpTopic() {
        return "cidr.debugger.targets.configurable";
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        Disposer.dispose((Disposable)this.disposable);
    }

    @NotNull
    public final Sequence<DebugTargetEditor> getEditors$intellij_clion_execution() {
        Enumeration<TreeNode> enumeration = this.treeRoot.children();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
        return SequencesKt.mapNotNull((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)editors.1.INSTANCE);
    }

    private final void refreshTree() {
        TreePath selected = this.tree.getSelectionPath();
        this.treeModel.reload();
        this.tree.setSelectionPath(selected);
    }

    private final Pair<DefaultMutableTreeNode, DebugTargetEditor> selectedItem() {
        DefaultMutableTreeNode node2;
        TreePath treePath = this.tree.getSelectionPath();
        Object $this$asSafely$iv = treePath != null ? treePath.getLastPathComponent() : null;
        boolean $i$f$asSafely = false;
        Object object = $this$asSafely$iv;
        if (!(object instanceof DefaultMutableTreeNode)) {
            object = null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = node2 = (DefaultMutableTreeNode)object;
        $this$asSafely$iv = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
        $i$f$asSafely = false;
        Object object2 = $this$asSafely$iv;
        if (!(object2 instanceof DebugTargetEditor)) {
            object2 = null;
        }
        return TuplesKt.to((Object)node2, (Object)((DebugTargetEditor)object2));
    }

    @NotNull
    public JComponent createComponent() {
        JBSplitter jBSplitter;
        JBSplitter $this$createComponent_u24lambda_u242 = jBSplitter = new JBSplitter(false, this.initialTreeAndEditorWidthRatio);
        boolean bl = false;
        for (RunnerAndConfigurationSettings runConfigAndSettings : RunManagerEx.getInstanceEx((Project)this.project).getAllSettings()) {
            if (!(runConfigAndSettings.getConfiguration() instanceof DebugTargetParameters)) continue;
            this.treeRoot.insert(this.createTreeNode(runConfigAndSettings, false), this.treeRoot.getChildCount());
        }
        TreeUtil.sort((DefaultTreeModel)this.treeModel, this.nodeComparator);
        this.tree.setRootVisible(false);
        this.tree.addTreeSelectionListener(arg_0 -> NamedDebugTargetConfigurable.createComponent$lambda$2$lambda$1(this, $this$createComponent_u24lambda_u242, arg_0));
        this.tree.setCellRenderer((TreeCellRenderer)new DebugTargetCellRenderer());
        Function1 enabledSelection2 = (Function1)new Function1<AnActionEvent, Unit>(this){
            final /* synthetic */ NamedDebugTargetConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull AnActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.getPresentation().setEnabled(!this.this$0.getTree$intellij_clion_execution().isSelectionEmpty());
            }
        };
        AnAction[] anActionArray = new AnAction[3];
        Icon icon = AllIcons.General.Add;
        anActionArray[0] = new DumbAwareAction(this, icon){
            final /* synthetic */ NamedDebugTargetConfigurable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                NamedDebugTargetConfigurable.access$addNewDebugTarget(this.this$0);
            }
        };
        icon = AllIcons.General.Remove;
        anActionArray[1] = new DumbAwareAction((Function1<? super AnActionEvent, Unit>)enabledSelection2, this, icon){
            final /* synthetic */ Function1<AnActionEvent, Unit> $enabledSelection;
            final /* synthetic */ NamedDebugTargetConfigurable this$0;
            {
                this.$enabledSelection = $enabledSelection;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$enabledSelection.invoke((Object)e);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                NamedDebugTargetConfigurable.access$deleteDebugTarget(this.this$0);
            }
        };
        icon = AllIcons.Actions.Copy;
        anActionArray[2] = new DumbAwareAction((Function1<? super AnActionEvent, Unit>)enabledSelection2, this, icon){
            final /* synthetic */ Function1<AnActionEvent, Unit> $enabledSelection;
            final /* synthetic */ NamedDebugTargetConfigurable this$0;
            {
                this.$enabledSelection = $enabledSelection;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$enabledSelection.invoke((Object)e);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                NamedDebugTargetConfigurable.access$cloneDebugTarget(this.this$0);
            }
        };
        DefaultActionGroup actionGroup2 = new DefaultActionGroup(anActionArray);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)actionGroup2, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        $this$createComponent_u24lambda_u242.setFirstComponent((JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(actionToolbar2, this){
            final /* synthetic */ ActionToolbar $actionToolbar;
            final /* synthetic */ NamedDebugTargetConfigurable this$0;
            {
                this.$actionToolbar = $actionToolbar;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$actionToolbar){
                    final /* synthetic */ ActionToolbar $actionToolbar;
                    {
                        this.$actionToolbar = $actionToolbar;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell(this.$actionToolbar.getComponent());
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ NamedDebugTargetConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        JBScrollPane treeScrollPane = new JBScrollPane((Component)this.this$0.getTree$intellij_clion_execution());
                        treeScrollPane.setPreferredSize(new Dimension(100, 100));
                        $this$row.cell((JComponent)treeScrollPane).align(Align.FILL).resizableColumn();
                    }
                }), (int)1, null).resizableRow();
            }
        })));
        actionToolbar2.setTargetComponent($this$createComponent_u24lambda_u242.getFirstComponent());
        $this$createComponent_u24lambda_u242.setSecondComponent((JComponent)this.emptyPanel);
        this.treeModel.reload();
        if (this.treeRoot.getChildCount() > 0) {
            this.tree.setSelectionRow(0);
        }
        $this$createComponent_u24lambda_u242.setMinimumSize(new Dimension(800, 400));
        return (JComponent)jBSplitter;
    }

    private final DefaultMutableTreeNode createTreeNode(RunnerAndConfigurationSettings configuration2, boolean newItem) {
        DebugTargetEditor targetEditor = new DebugTargetEditor(this, configuration2, newItem);
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(targetEditor);
        targetEditor.setNameChanged((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, treeNode){
            final /* synthetic */ NamedDebugTargetConfigurable this$0;
            final /* synthetic */ DefaultMutableTreeNode $treeNode;
            {
                this.this$0 = $receiver;
                this.$treeNode = $treeNode;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.getTreeModel$intellij_clion_execution().nodeChanged(this.$treeNode);
            }
        }));
        return treeNode;
    }

    private final void cloneDebugTarget() {
        Pair<DefaultMutableTreeNode, DebugTargetEditor> pair = this.selectedItem();
        DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)pair.component1();
        DebugTargetEditor editor = (DebugTargetEditor)pair.component2();
        if (node2 != null && editor != null) {
            RunConfiguration runConfiguration = editor.getConfig().getConfiguration().clone();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"clone(...)");
            RunConfiguration newConfiguration = runConfiguration;
            newConfiguration.setName(this.findNewName(RunManager.Companion.getInstance(this.project), editor.currentName()));
            RunManager runManager = RunManager.Companion.getInstance(this.project);
            ConfigurationFactory configurationFactory = editor.getConfig().getFactory();
            Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"getFactory(...)");
            RunnerAndConfigurationSettings configAndSettings = runManager.createConfiguration(newConfiguration, configurationFactory);
            DefaultMutableTreeNode newNode = this.createTreeNode(configAndSettings, true);
            int insertIndex = this.treeRoot.getIndex(node2) + 1;
            this.treeRoot.insert(newNode, insertIndex);
            this.refreshTree();
            TreeUtil.selectInTree((DefaultMutableTreeNode)newNode, (boolean)false, (JTree)((JTree)this.tree)).doWhenDone(NamedDebugTargetConfigurable::cloneDebugTarget$lambda$3);
        }
    }

    private final void addNewDebugTarget() {
        RunManager manager = RunManager.Companion.getInstance(this.project);
        String name2 = NamedDebugTargetConfigurable.findNewName$default(this, manager, null, 2, null);
        ConfigurationType configurationType = ConfigurationTypeUtil.findConfigurationType((String)"com.jetbrains.cidr.embedded.customgdbserver.type");
        if (configurationType == null) {
            throw new IllegalStateException("Giving up - Remote GDB server configuration type is broken");
        }
        ConfigurationType configurationType2 = configurationType;
        RunnerAndConfigurationSettings newConfiguration = manager.createConfiguration(name2, configurationType2.getClass());
        DefaultMutableTreeNode treeNode = this.createTreeNode(newConfiguration, true);
        this.treeRoot.add(treeNode);
        this.treeModel.reload();
        TreeUtil.selectInTree((DefaultMutableTreeNode)treeNode, (boolean)false, (JTree)((JTree)this.tree)).doWhenDone(NamedDebugTargetConfigurable::addNewDebugTarget$lambda$4);
    }

    private final void deleteDebugTarget() {
        Pair<DefaultMutableTreeNode, DebugTargetEditor> pair = this.selectedItem();
        DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)pair.component1();
        DebugTargetEditor editor = (DebugTargetEditor)pair.component2();
        if (node2 != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = node2.getPreviousSibling();
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = node2.getNextSibling();
            }
            DefaultMutableTreeNode nodeToSelect = defaultMutableTreeNode;
            this.treeModel.removeNodeFromParent(node2);
            DebugTargetEditor debugTargetEditor = editor;
            boolean bl = debugTargetEditor != null ? !debugTargetEditor.getNewItem() : false;
            if (bl) {
                RunConfiguration runConfiguration = editor.getConfig().getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
                this.deletedItems.add(runConfiguration);
            }
            this.refreshTree();
            TreeUtil.selectInTree((DefaultMutableTreeNode)nodeToSelect, (boolean)false, (JTree)((JTree)this.tree)).doWhenDone(NamedDebugTargetConfigurable::deleteDebugTarget$lambda$5);
        }
    }

    private final String findNewName(RunManager manager, @NlsSafe String defName) {
        Object newName = null;
        newName = defName;
        int counter = 0;
        while (counter < 1000) {
            if (manager.findConfigurationByName((String)newName) == null) {
                boolean bl;
                block3: {
                    Sequence<DebugTargetEditor> $this$none$iv = this.getEditors$intellij_clion_execution();
                    boolean $i$f$none = false;
                    for (Object element$iv : $this$none$iv) {
                        DebugTargetEditor it = (DebugTargetEditor)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.currentName(), (Object)newName)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
                if (bl) break;
            }
            newName = defName + " (" + ++counter + ")";
        }
        return newName;
    }

    static /* synthetic */ String findNewName$default(NamedDebugTargetConfigurable namedDebugTargetConfigurable, RunManager runManager, String string, int n, Object object) {
        if ((n & 2) != 0) {
            String string2 = CLionExecutionBundle.message("debug.targets.configurable.new.debug.target", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            string = string2;
        }
        return namedDebugTargetConfigurable.findNewName(runManager, string);
    }

    public boolean isModified() {
        boolean bl;
        block1: {
            Sequence<DebugTargetEditor> $this$any$iv = this.getEditors$intellij_clion_execution();
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                DebugTargetEditor it = (DebugTargetEditor)element$iv;
                boolean bl2 = false;
                if (!it.isModified()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl || !this.deletedItems.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public void apply() {
        void $this$filterTo$iv$iv;
        Object it;
        Sequence<DebugTargetEditor> $this$forEach$iv = this.getEditors$intellij_clion_execution();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (DebugTargetEditor)element$iv;
            boolean bl = false;
            ((DebugTargetEditor)it).validate();
        }
        RunManagerImpl manager = RunManagerImpl.Companion.getInstanceImpl(this.project);
        Iterable $this$filter$iv = manager.getAllSettings();
        boolean $i$f$filter = false;
        it = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RunnerAndConfigurationSettings it2 = (RunnerAndConfigurationSettings)element$iv$iv;
            boolean bl = false;
            if (!this.deletedItems.contains(it2.getConfiguration())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List settingsToDelete = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        manager.removeConfigurations((Collection)settingsToDelete);
        Sequence<DebugTargetEditor> $this$forEach$iv2 = this.getEditors$intellij_clion_execution();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            DebugTargetEditor it3 = (DebugTargetEditor)element$iv;
            boolean bl = false;
            it3.apply();
            if (!it3.getNewItem()) continue;
            manager.addConfiguration(it3.getConfig());
        }
    }

    private static final int nodeComparator$lambda$0(DefaultMutableTreeNode node1, DefaultMutableTreeNode node2) {
        Object object;
        Object object2;
        Comparator comparator = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
        Object $this$asSafely$iv = node1.getUserObject();
        boolean $i$f$asSafely = false;
        Object object3 = $this$asSafely$iv;
        if (!(object3 instanceof DebugTargetEditor)) {
            object3 = null;
        }
        if ((object2 = (DebugTargetEditor)object3) == null || (object2 = ((DebugTargetEditor)object2).getConfig()) == null || (object2 = object2.getName()) == null) {
            object2 = "";
        }
        $this$asSafely$iv = node2.getUserObject();
        $i$f$asSafely = false;
        Object object4 = $this$asSafely$iv;
        if (!(object4 instanceof DebugTargetEditor)) {
            object4 = null;
        }
        if ((object = (DebugTargetEditor)object4) == null || (object = ((DebugTargetEditor)object).getConfig()) == null || (object = object.getName()) == null) {
            object = "";
        }
        return comparator.compare(object2, object);
    }

    private static final void createComponent$lambda$2$lambda$1(NamedDebugTargetConfigurable this$0, JBSplitter $this_apply, TreeSelectionEvent treeSelectionEvent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        DebugTargetEditor selectedEditor = (DebugTargetEditor)this$0.selectedItem().component2();
        DebugTargetEditor debugTargetEditor = selectedEditor;
        $this_apply.setSecondComponent(debugTargetEditor != null && (debugTargetEditor = debugTargetEditor.getComponent()) != null ? (JComponent)((Object)debugTargetEditor) : (JComponent)this$0.emptyPanel);
        ActivityTracker.getInstance().inc();
    }

    private static final void cloneDebugTarget$lambda$3() {
        ActivityTracker.getInstance().inc();
    }

    private static final void addNewDebugTarget$lambda$4() {
        ActivityTracker.getInstance().inc();
    }

    private static final void deleteDebugTarget$lambda$5() {
        ActivityTracker.getInstance().inc();
    }

    public static final /* synthetic */ void access$addNewDebugTarget(NamedDebugTargetConfigurable $this) {
        $this.addNewDebugTarget();
    }

    public static final /* synthetic */ void access$deleteDebugTarget(NamedDebugTargetConfigurable $this) {
        $this.deleteDebugTarget();
    }

    public static final /* synthetic */ void access$cloneDebugTarget(NamedDebugTargetConfigurable $this) {
        $this.cloneDebugTarget();
    }
}

