/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.compound.CidrCompoundRunConfiguration;
import com.jetbrains.cidr.cpp.execution.debugger.CLionDebuggerKind;
import com.jetbrains.cidr.cpp.execution.gdbserver.DownloadType;
import com.jetbrains.cidr.cpp.execution.gdbserver.Utils;
import com.jetbrains.cidr.cpp.execution.remote.CLionRemoteRunConfigurationKt;
import com.jetbrains.cidr.cpp.execution.remote.DebuggerData;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class GdbServerRunConfiguration
extends CidrCompoundRunConfiguration {
    protected static final String ATTR_VERSION = "version";
    protected static final String TAG_CUSTOM_GDB_SERVER = "custom-gdb-server";
    protected static final String ATTR_EXECUTABLE = "executable";
    protected static final String ATTR_WARM_UP_MS = "warmup-ms";
    protected static final String ATTR_GDB_CONNECT = "gdb-connect";
    public static final String ATTR_DOWNLOAD_TYPE = "download-type";
    private String gdbRemoteString = "";
    private int warmUpMs = 0;
    @NotNull
    private String serverExecutable = "";
    @NotNull
    private DownloadType myDownloadType = this.defaultDownloadType();
    @NotNull
    private DebuggerData myDebuggerData = new DebuggerData(CLionDebuggerKind.Bundled.GDB.INSTANCE);

    public GdbServerRunConfiguration(Project project, ConfigurationFactory factory, String name2) {
        super(project, factory, name2);
    }

    public void setDebuggerData(@NotNull DebuggerData debuggerData) {
        if (debuggerData == null) {
            GdbServerRunConfiguration.$$$reportNull$$$0(0);
        }
        this.myDebuggerData = debuggerData;
    }

    @NotNull
    public DebuggerData getDebuggerData() {
        DebuggerData debuggerData = this.myDebuggerData;
        if (debuggerData == null) {
            GdbServerRunConfiguration.$$$reportNull$$$0(1);
        }
        return debuggerData;
    }

    @NotNull
    protected DownloadType defaultDownloadType() {
        DownloadType downloadType = DownloadType.UPDATED_ONLY;
        if (downloadType == null) {
            GdbServerRunConfiguration.$$$reportNull$$$0(2);
        }
        return downloadType;
    }

    public String getGdbRemoteString() {
        return this.gdbRemoteString;
    }

    public void setGdbRemoteString(@NotNull String gdbRemoteString) {
        if (gdbRemoteString == null) {
            GdbServerRunConfiguration.$$$reportNull$$$0(3);
        }
        this.gdbRemoteString = gdbRemoteString;
    }

    @Override
    public void readExternal(@NotNull Element parentElement) throws InvalidDataException {
        if (parentElement == null) {
            GdbServerRunConfiguration.$$$reportNull$$$0(4);
        }
        super.readExternal(parentElement);
        this.readExternalGdbServerInfo(parentElement);
    }

    protected void readExternalGdbServerInfo(@NotNull Element parentElement) {
        Element element2;
        if (parentElement == null) {
            GdbServerRunConfiguration.$$$reportNull$$$0(5);
        }
        if ((element2 = parentElement.getChild(TAG_CUSTOM_GDB_SERVER)) != null) {
            this.myDebuggerData.readExternal(element2);
            this.gdbRemoteString = element2.getAttributeValue(ATTR_GDB_CONNECT, "");
            this.serverExecutable = element2.getAttributeValue(ATTR_EXECUTABLE, "");
            this.warmUpMs = Utils.readIntAttr(element2, ATTR_WARM_UP_MS, 0);
            this.myDownloadType = Utils.readEnumAttr(element2, ATTR_DOWNLOAD_TYPE, DownloadType.ALWAYS);
        }
    }

    @Override
    public void writeExternal(@NotNull Element parentElement) throws WriteExternalException {
        if (parentElement == null) {
            GdbServerRunConfiguration.$$$reportNull$$$0(6);
        }
        super.writeExternal(parentElement);
        this.writeExternalGdbServerInfo(parentElement);
    }

    protected void writeExternalGdbServerInfo(@NotNull Element parentElement) {
        if (parentElement == null) {
            GdbServerRunConfiguration.$$$reportNull$$$0(7);
        }
        Element element2 = new Element(TAG_CUSTOM_GDB_SERVER);
        parentElement.addContent(element2);
        this.myDebuggerData.writeExternal(element2);
        element2.setAttribute(ATTR_VERSION, "1");
        element2.setAttribute(ATTR_GDB_CONNECT, this.gdbRemoteString);
        element2.setAttribute(ATTR_EXECUTABLE, this.serverExecutable);
        element2.setAttribute(ATTR_WARM_UP_MS, String.valueOf(this.warmUpMs));
        element2.setAttribute(ATTR_DOWNLOAD_TYPE, this.myDownloadType.name());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        this.doCheckConfiguration(false);
    }

    @Override
    public void checkSettingsBeforeRun() throws RuntimeConfigurationException {
        super.checkSettingsBeforeRun();
        this.doCheckConfiguration(true);
    }

    protected void doCheckConfiguration(boolean checkExecutable) throws RuntimeConfigurationException {
        CLionRemoteRunConfigurationKt.checkDebuggerToolchain(this.getDebuggerData().getOrCreateDebuggerToolchain(), this.getProject());
        if (!this.serverExecutableIsNotEmpty()) {
            throw new RuntimeConfigurationException(CLionExecutionBundle.message("gdbserver.executable.not.specified", new Object[0]));
        }
        if (checkExecutable && !this.serverExecutableExists()) {
            throw new RuntimeConfigurationException(CLionExecutionBundle.message("gdbserver.wrong.executable", new Object[0]));
        }
        if (this.gdbRemoteString.isEmpty()) {
            throw new RuntimeConfigurationException(CLionExecutionBundle.message("gdbserver.target.remote.arguments.not.specified", new Object[0]));
        }
    }

    protected boolean serverExecutableIsNotEmpty() {
        return !StringUtil.isEmptyOrSpaces((String)this.getServerExecutable());
    }

    protected boolean serverExecutableExists() {
        File file = new File(this.getServerExecutable());
        if (file.canExecute() || PathEnvironmentVariableUtil.findInPath((String)this.getServerExecutable()) != null) {
            return true;
        }
        if (SystemInfo.isWindows) {
            return PathEnvironmentVariableUtil.findExecutableInWindowsPath((String)this.getServerExecutable(), null) != null;
        }
        return false;
    }

    @NotNull
    public String getServerExecutable() {
        String string = this.serverExecutable;
        if (string == null) {
            GdbServerRunConfiguration.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setServerExecutable(@NotNull String serverExecutable) {
        if (serverExecutable == null) {
            GdbServerRunConfiguration.$$$reportNull$$$0(9);
        }
        this.serverExecutable = serverExecutable;
    }

    public int getWarmUpMs() {
        return this.warmUpMs;
    }

    public void setWarmUpMs(int warmUpMs) {
        this.warmUpMs = warmUpMs;
    }

    @NotNull
    public DownloadType getDownloadType() {
        DownloadType downloadType = this.myDownloadType;
        if (downloadType == null) {
            GdbServerRunConfiguration.$$$reportNull$$$0(10);
        }
        return downloadType;
    }

    public void setDownloadType(@NotNull DownloadType downloadType) {
        if (downloadType == null) {
            GdbServerRunConfiguration.$$$reportNull$$$0(11);
        }
        this.myDownloadType = downloadType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerData";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/gdbserver/GdbServerRunConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gdbRemoteString";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverExecutable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/gdbserver/GdbServerRunConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultDownloadType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerExecutable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDebuggerData";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setGdbRemoteString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternalGdbServerInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternalGdbServerInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setServerExecutable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDownloadType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 8, 10 -> new IllegalStateException(string);
        };
    }
}

