/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.external.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.CidrRunnerBundle;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.execution.CLionLauncher;
import com.jetbrains.cidr.cpp.execution.CLionRunConfiguration;
import com.jetbrains.cidr.cpp.execution.external.build.CLionExternalBuildConfiguration;
import com.jetbrains.cidr.cpp.execution.external.build.CLionExternalConfiguration;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.BuildConfigurationProblems;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u001a*\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\b\u001a\u00020\u00012\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0002\u001a\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"getBuildConfiguration", "Lcom/jetbrains/cidr/cpp/execution/external/build/CLionExternalBuildConfiguration;", "runConfig", "Lcom/jetbrains/cidr/cpp/execution/CLionRunConfiguration;", "problems", "Lcom/jetbrains/cidr/execution/BuildConfigurationProblems;", "checkExecutableSpecified", "", "getBuildConfigurationOrThrowExecutionException", "configuration", "getExternalRunFileAndEnvironment", "Lkotlin/Pair;", "Ljava/io/File;", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "launcher", "Lcom/jetbrains/cidr/cpp/execution/CLionLauncher;", "getRunEnvironment", "getRunFile", "intellij.clion.execution"})
public final class ExternalRunConfigurationUtilKt {
    @Nullable
    public static final CLionExternalBuildConfiguration getBuildConfiguration(@NotNull CLionRunConfiguration<?, ?> runConfig) {
        Intrinsics.checkNotNullParameter(runConfig, (String)"runConfig");
        BuildConfigurationProblems problems = new BuildConfigurationProblems();
        CLionExternalBuildConfiguration configuration2 = ExternalRunConfigurationUtilKt.getBuildConfiguration(runConfig, problems, false);
        return problems.hasProblems() ? null : configuration2;
    }

    @Nullable
    public static final CLionExternalBuildConfiguration getBuildConfiguration(@NotNull CLionRunConfiguration<?, ?> runConfig, @NotNull BuildConfigurationProblems problems, boolean checkExecutableSpecified) {
        Object[] objectArray;
        CidrBuildConfiguration configuration2;
        Intrinsics.checkNotNullParameter(runConfig, (String)"runConfig");
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        CidrBuildConfigurationHelper cidrBuildConfigurationHelper = runConfig.getHelper();
        Intrinsics.checkNotNull((Object)cidrBuildConfigurationHelper, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.CidrBuildConfigurationHelper<com.jetbrains.cidr.execution.CidrBuildConfiguration, com.jetbrains.cidr.execution.CidrBuildTarget<com.jetbrains.cidr.execution.CidrBuildConfiguration>>");
        CidrBuildConfigurationHelper helper = cidrBuildConfigurationHelper;
        BuildTargetAndConfigurationData buildTargetData = runConfig.getTargetAndConfigurationData();
        if (!BuildTargetAndConfigurationData.checkData((CidrBuildConfigurationHelper)helper, (BuildTargetAndConfigurationData)buildTargetData, (BuildConfigurationProblems)problems, (boolean)false, (boolean)true)) {
            return null;
        }
        CPPLog.LOG.assertTrue(buildTargetData != null);
        BuildTargetAndConfigurationData buildTargetAndConfigurationData = buildTargetData;
        Intrinsics.checkNotNull((Object)buildTargetAndConfigurationData);
        CidrBuildTarget buildTarget = helper.findTarget(buildTargetAndConfigurationData.target);
        if (buildTarget == null) {
            Object[] objectArray2 = new Object[]{CidrRunnerBundle.message((String)"build.configuration.target", (Object[])new Object[0])};
            problems.problems.add(CidrRunnerBundle.message((String)"build.configuration.parameterNotSelected", (Object[])objectArray2));
            return null;
        }
        if (checkExecutableSpecified) {
            ExecutableData executableData = runConfig.getExecutableData();
            if (executableData == null) {
                Object[] objectArray3 = new Object[]{CidrRunnerBundle.message((String)"build.configuration.executable", (Object[])new Object[0])};
                problems.problems.add(CidrRunnerBundle.message((String)"build.configuration.parameterNotSelected", (Object[])objectArray3));
                return null;
            }
            if (executableData.path == null) {
                Object[] objectArray4 = new Object[]{CidrRunnerBundle.message((String)"build.configuration.executable", (Object[])new Object[0])};
                problems.problems.add(CidrRunnerBundle.message((String)"build.configuration.parameterNotSelected", (Object[])objectArray4));
                return null;
            }
        }
        CidrBuildConfiguration cidrBuildConfiguration = configuration2 = buildTargetData.configurationName == null ? helper.getDefaultConfiguration(buildTarget) : helper.findConfiguration(buildTarget, buildTargetData.configurationName);
        if (configuration2 == null || !(configuration2 instanceof CLionExternalBuildConfiguration)) {
            Object[] objectArray5 = new Object[]{helper.getConfigurationTitle(), buildTargetData.configurationName, StringUtil.toLowerCase((String)helper.getTargetTitle()), buildTargetData.getDisplayString()};
            problems.problems.add(CidrRunnerBundle.message((String)"build.configuration.parameterNotFoundForTarget", (Object[])objectArray5));
            return null;
        }
        CLionExternalConfiguration build2 = ((CLionExternalBuildConfiguration)configuration2).getBuild();
        if (build2 == null) {
            objectArray = new Object[1];
            BuildTargetData buildTargetData2 = buildTargetData.target;
            objectArray[0] = buildTargetData2 != null ? buildTargetData2.getDisplayString() : null;
            problems.warnings.add(CLionExecutionBundle.message("external.run.configuration.noBuildToolSpecified", objectArray));
        }
        CLionExternalConfiguration cLionExternalConfiguration = build2;
        boolean bl = cLionExternalConfiguration != null ? !cLionExternalConfiguration.isEnabled() : false;
        if (bl) {
            objectArray = new Object[1];
            BuildTargetData buildTargetData3 = buildTargetData.target;
            objectArray[0] = buildTargetData3 != null ? buildTargetData3.getDisplayString() : null;
            problems.warnings.add(CLionExecutionBundle.message("external.run.configuration.buildToolDisabled", objectArray));
        }
        return (CLionExternalBuildConfiguration)configuration2;
    }

    public static /* synthetic */ CLionExternalBuildConfiguration getBuildConfiguration$default(CLionRunConfiguration cLionRunConfiguration, BuildConfigurationProblems buildConfigurationProblems, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return ExternalRunConfigurationUtilKt.getBuildConfiguration(cLionRunConfiguration, buildConfigurationProblems, bl);
    }

    @NotNull
    public static final Pair<File, CPPEnvironment> getExternalRunFileAndEnvironment(@NotNull CLionLauncher launcher) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)((Object)launcher), (String)"launcher");
        return new Pair((Object)ExternalRunConfigurationUtilKt.getRunFile(launcher), (Object)ExternalRunConfigurationUtilKt.getRunEnvironment(launcher));
    }

    private static final File getRunFile(CLionLauncher launcher) {
        ExecutableData executableData;
        CidrRunConfiguration configuration2 = (CidrRunConfiguration)launcher.getConfiguration();
        CidrExecutableDataHolder cidrExecutableDataHolder = configuration2 instanceof CidrExecutableDataHolder ? (CidrExecutableDataHolder)configuration2 : null;
        Object object = executableData = cidrExecutableDataHolder != null ? cidrExecutableDataHolder.getExecutableData() : null;
        if (executableData == null) {
            Object[] objectArray = new Object[]{CidrRunnerBundle.message((String)"build.configuration.executable", (Object[])new Object[0])};
            throw new RuntimeConfigurationError(CidrRunnerBundle.message((String)"build.configuration.parameterNotSelected", (Object[])objectArray));
        }
        String runPath = executableData.path;
        if (runPath == null) {
            Object[] objectArray = new Object[]{CidrRunnerBundle.message((String)"build.configuration.executable", (Object[])new Object[0])};
            throw new RuntimeConfigurationError(CidrRunnerBundle.message((String)"build.configuration.parameterNotSelected", (Object[])objectArray));
        }
        return new File(runPath);
    }

    private static final CPPEnvironment getRunEnvironment(CLionLauncher launcher) throws ExecutionException {
        CidrRunConfiguration configuration2 = (CidrRunConfiguration)launcher.getConfiguration();
        CPPLog.LOG.assertTrue(configuration2 instanceof CLionRunConfiguration);
        Intrinsics.checkNotNull((Object)configuration2, (String)"null cannot be cast to non-null type com.jetbrains.cidr.cpp.execution.CLionRunConfiguration<*, *>");
        CLionExternalBuildConfiguration buildConfiguration = ExternalRunConfigurationUtilKt.getBuildConfigurationOrThrowExecutionException((CLionRunConfiguration)configuration2);
        EnvironmentProblems environmentProblems = new EnvironmentProblems();
        CPPEnvironment cppEnvironment = CPPToolchains.createCPPEnvironment(configuration2.getProject(), launcher.getProjectBaseDir(), buildConfiguration.getToolchainName(), environmentProblems, false, null);
        if (environmentProblems.hasProblems() || cppEnvironment == null) {
            environmentProblems.throwAsExecutionException();
        }
        CPPLog.LOG.assertTrue(cppEnvironment != null);
        CPPEnvironment cPPEnvironment = cppEnvironment;
        Intrinsics.checkNotNull((Object)cPPEnvironment);
        return cPPEnvironment;
    }

    private static final CLionExternalBuildConfiguration getBuildConfigurationOrThrowExecutionException(CLionRunConfiguration<?, ?> configuration2) throws ExecutionException {
        BuildConfigurationProblems problems = new BuildConfigurationProblems();
        CLionExternalBuildConfiguration buildConfiguration = ExternalRunConfigurationUtilKt.getBuildConfiguration(configuration2, problems, true);
        if (problems.hasProblems() || buildConfiguration == null) {
            throw new ExecutionException(problems.getText());
        }
        return buildConfiguration;
    }
}

