/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.attach;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.attach.SshAttachHost;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.WslAttachHost;
import com.intellij.xdebugger.attach.XAttachDebugger;
import com.intellij.xdebugger.attach.XAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XAttachHost;
import com.intellij.xdebugger.attach.XAttachPresentationGroup;
import com.jetbrains.cidr.cpp.execution.debugger.CLionDebuggerKind;
import com.jetbrains.cidr.cpp.execution.debugger.attach.CLionAttachPresentationGroup;
import com.jetbrains.cidr.cpp.execution.debugger.attach.CLionSshCredentialProvider;
import com.jetbrains.cidr.cpp.execution.debugger.backend.CLionDebuggerFuncAsmTranslatorProvider;
import com.jetbrains.cidr.cpp.execution.debugger.backend.CLionGDBDriverConfiguration;
import com.jetbrains.cidr.cpp.execution.debugger.backend.CLionLLDBDriverConfiguration;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.execution.debugger.CidrCustomDebuggerProvider;
import com.jetbrains.cidr.execution.debugger.CidrLocalAttachDebugger;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class CLionAttachDebuggerProvider
implements XAttachDebuggerProvider {
    private static final Key<List<? extends XAttachDebugger>> DEBUGGERS_KEY = Key.create((String)"CLionAttachDebuggerProvider.DEBUGGERS");
    private static final Key<List<? extends XAttachDebugger>> ELEVATED_DEBUGGERS_KEY = Key.create((String)"CLionAttachDebuggerProvider.ELEVATED_DEBUGGERS");
    private final boolean myFilterUnsupported;
    @NotNull
    private final CPPToolchains myCPPToolchains;

    public CLionAttachDebuggerProvider() {
        this(true, CPPToolchains.getInstance());
    }

    @TestOnly
    public CLionAttachDebuggerProvider(boolean filterUnsupported, @NotNull CPPToolchains toolchains2) {
        if (toolchains2 == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(0);
        }
        this.myFilterUnsupported = filterUnsupported;
        this.myCPPToolchains = toolchains2;
    }

    @NotNull
    public XAttachPresentationGroup<ProcessInfo> getPresentationGroup() {
        CLionAttachPresentationGroup cLionAttachPresentationGroup = CLionAttachPresentationGroup.INSTANCE;
        if (cLionAttachPresentationGroup == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(1);
        }
        return cLionAttachPresentationGroup;
    }

    public boolean isAttachHostApplicable(@NotNull XAttachHost attachHost) {
        if (attachHost == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(2);
        }
        return attachHost instanceof LocalAttachHost || attachHost instanceof WslAttachHost || attachHost instanceof SshAttachHost;
    }

    @NotNull
    public List<? extends XAttachDebugger> getAvailableDebuggers(@NotNull Project project, @NotNull XAttachHost attachHost, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        boolean isElevated;
        Key<List<? extends XAttachDebugger>> key;
        List<CidrLocalAttachDebugger> result2;
        if (project == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(3);
        }
        if (attachHost == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(4);
        }
        if (processInfo == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(5);
        }
        if (contextHolder == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(6);
        }
        if ((result2 = (List<CidrLocalAttachDebugger>)contextHolder.getUserData(key = (isElevated = processInfo.isOwnedByCurrentUser() != ThreeState.YES) ? ELEVATED_DEBUGGERS_KEY : DEBUGGERS_KEY)) == null) {
            result2 = this.computeAvailableDebuggers(project, attachHost, isElevated);
            contextHolder.putUserData(key, result2);
        }
        List<CidrLocalAttachDebugger> list2 = result2;
        if (list2 == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    private List<CidrLocalAttachDebugger> computeAvailableDebuggers(@NotNull Project project, @NotNull XAttachHost attachHost, boolean isElevated) {
        if (project == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(8);
        }
        if (attachHost == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(9);
        }
        ArrayList<CidrLocalAttachDebugger> result2 = new ArrayList<CidrLocalAttachDebugger>();
        List<CLionDebuggerKind> debuggerKinds = this.getConfiguredDebuggerKinds(attachHost);
        for (CLionDebuggerKind debuggerKind : debuggerKinds) {
            CLionDebuggerFuncAsmTranslatorProvider driverConfiguration;
            CPPToolchains.Toolchain toolchain = debuggerKind.getOrCreateDebuggerToolchain(this.myCPPToolchains.getOSType());
            CLionDebuggerFuncAsmTranslatorProvider cLionDebuggerFuncAsmTranslatorProvider = driverConfiguration = toolchain.getDebuggerKind().isLLDB() ? new CLionLLDBDriverConfiguration(project, toolchain, isElevated) : new CLionGDBDriverConfiguration(project, toolchain, isElevated);
            if (this.myFilterUnsupported && !driverConfiguration.isAttachSupported()) continue;
            CidrLocalAttachDebugger attachDebugger = new CidrLocalAttachDebugger((DebuggerDriverConfiguration)driverConfiguration, debuggerKind.getDisplayString());
            result2.add(attachDebugger);
        }
        for (CidrCustomDebuggerProvider eachProvider : CidrCustomDebuggerProvider.EP_NAME.getExtensionList()) {
            List debuggerConfigurations = eachProvider.getDebuggerConfigurations();
            for (DebuggerDriverConfiguration driverConfiguration : debuggerConfigurations) {
                if (this.myFilterUnsupported && !driverConfiguration.isAttachSupported()) continue;
                CidrLocalAttachDebugger attachDebugger = new CidrLocalAttachDebugger(driverConfiguration);
                result2.add(attachDebugger);
            }
        }
        String lastUsed = CidrLocalAttachDebugger.getLastUsedDebuggerConfiguration((Project)project);
        if (lastUsed != null) {
            List preferred = ContainerUtil.filter(result2, it -> lastUsed.equals(it.getConfiguration().getDesignator()));
            List others = ContainerUtil.filter(result2, it -> !lastUsed.equals(it.getConfiguration().getDesignator()));
            List list2 = ContainerUtil.concat((List)preferred, (List)others);
            if (list2 == null) {
                CLionAttachDebuggerProvider.$$$reportNull$$$0(10);
            }
            return list2;
        }
        ArrayList<CidrLocalAttachDebugger> arrayList = result2;
        if (arrayList == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private List<CLionDebuggerKind> getConfiguredDebuggerKinds(@NotNull XAttachHost attachHost) {
        if (attachHost == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(12);
        }
        ArrayList<CLionDebuggerKind> debuggerKinds = new ArrayList<CLionDebuggerKind>();
        List<CPPToolchains.Toolchain> toolchains2 = CLionAttachDebuggerProvider.filterToolchainsMatchingHost(this.myCPPToolchains.getToolchains(), attachHost);
        for (CPPToolchains.Toolchain toolchain : toolchains2) {
            CLionDebuggerKind.Custom.ToolchainOriginated toolchainDebugger = new CLionDebuggerKind.Custom.ToolchainOriginated(toolchain);
            if (toolchainDebugger.getAsBundled() != null) continue;
            debuggerKinds.add(toolchainDebugger);
        }
        if (attachHost instanceof LocalAttachHost) {
            List<CLionDebuggerKind.Bundled> bundledDebuggerKinds = CLionDebuggerKind.Bundled.valuesInPreferredOrder(this.myCPPToolchains.getOSType());
            debuggerKinds.addAll(0, bundledDebuggerKinds);
        }
        List list2 = ContainerUtil.filter(debuggerKinds, it -> it.isValidAndSupported(this.myCPPToolchains.getOSType()));
        if (list2 == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    private static List<CPPToolchains.Toolchain> filterToolchainsMatchingHost(@NotNull List<CPPToolchains.Toolchain> toolchains2, @NotNull XAttachHost attachHost) {
        if (toolchains2 == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(14);
        }
        if (attachHost == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(15);
        }
        if (attachHost instanceof LocalAttachHost) {
            return CLionAttachDebuggerProvider.filterLocalToolchains(toolchains2);
        }
        if (attachHost instanceof WslAttachHost) {
            WslAttachHost wslAttachHost = (WslAttachHost)attachHost;
            return CLionAttachDebuggerProvider.filterWslToolchainsByDistribution(toolchains2, wslAttachHost.getWsl());
        }
        if (attachHost instanceof SshAttachHost) {
            SshAttachHost sshAttachHost = (SshAttachHost)attachHost;
            return CLionAttachDebuggerProvider.filterSshToolchainsByCredentials(toolchains2, sshAttachHost.getCredentials());
        }
        List<CPPToolchains.Toolchain> list2 = Collections.emptyList();
        if (list2 == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    private static List<CPPToolchains.Toolchain> filterLocalToolchains(@NotNull List<CPPToolchains.Toolchain> toolchains2) {
        if (toolchains2 == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(17);
        }
        List list2 = ContainerUtil.filter(toolchains2, toolchain -> !toolchain.getToolSetKind().isRemoteLike());
        if (list2 == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    private static List<CPPToolchains.Toolchain> filterWslToolchainsByDistribution(@NotNull List<CPPToolchains.Toolchain> toolchains2, @NotNull WSLDistribution distribution) {
        if (toolchains2 == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(19);
        }
        if (distribution == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(20);
        }
        List list2 = ContainerUtil.filter(toolchains2, toolchain -> {
            WSL wsl;
            CPPToolSet patt7675$temp = toolchain.getToolSet();
            return patt7675$temp instanceof WSL && distribution.equals((Object)(wsl = (WSL)patt7675$temp).getWslDistribution());
        });
        if (list2 == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @NotNull
    private static List<CPPToolchains.Toolchain> filterSshToolchainsByCredentials(@NotNull List<CPPToolchains.Toolchain> toolchains2, @NotNull RemoteCredentials credentials) {
        if (toolchains2 == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(22);
        }
        if (credentials == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(23);
        }
        List list2 = ContainerUtil.filter(toolchains2, toolchain -> credentials.equals(CLionSshCredentialProvider.getRemoteCredentials(toolchain)));
        if (list2 == null) {
            CLionAttachDebuggerProvider.$$$reportNull$$$0(24);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 10, 11, 13, 16, 18, 21, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchains";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/attach/CLionAttachDebuggerProvider";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachHost";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextHolder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/attach/CLionAttachDebuggerProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDebuggers";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAvailableDebuggers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredDebuggerKinds";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterToolchainsMatchingHost";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "filterLocalToolchains";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "filterWslToolchainsByDistribution";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSshToolchainsByCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAttachHostApplicable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDebuggers";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeAvailableDebuggers";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredDebuggerKinds";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterToolchainsMatchingHost";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filterLocalToolchains";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "filterWslToolchainsByDistribution";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "filterSshToolchainsByCredentials";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 10, 11, 13, 16, 18, 21, 24 -> new IllegalStateException(string);
        };
    }
}

