/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.build;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.cpp.execution.build.CMakeBuildListenerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000b\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\u001a\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/cpp/execution/build/CMakeBuildListener;", "Lcom/intellij/execution/process/ProcessAdapter;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isNinja", "", "(Lcom/intellij/openapi/progress/ProgressIndicator;Z)V", "ignoreLine", "lineBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "setToDeterminate", "chunkIgnored", "", "chunk", "", "matchLine", "Lcom/jetbrains/cidr/cpp/execution/build/CMakeBuildListener$FractionWithMessage;", "line", "", "Lcom/intellij/openapi/util/NlsSafe;", "onTextAvailable", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "FractionWithMessage", "intellij.clion.cmake"})
public class CMakeBuildListener
extends ProcessAdapter {
    @NotNull
    private final ProgressIndicator indicator;
    private final boolean isNinja;
    private boolean ignoreLine;
    @NotNull
    private final StringBuilder lineBuffer;
    private boolean setToDeterminate;

    public CMakeBuildListener(@NotNull ProgressIndicator indicator, boolean isNinja) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.indicator = indicator;
        this.isNinja = isNinja;
        this.lineBuffer = new StringBuilder();
    }

    public /* synthetic */ CMakeBuildListener(ProgressIndicator progressIndicator, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(progressIndicator, bl);
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        String string = event.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.onTextAvailable(string, outputType);
    }

    public final void onTextAvailable(@NotNull String chunk, @NotNull Key<?> outputType) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.SYSTEM) || ProcessOutputType.isStderr(outputType)) {
            return;
        }
        if (this.isNinja || StringsKt.startsWith$default((CharSequence)chunk, (char)'\r', (boolean)false, (int)2, null)) {
            this.ignoreLine = false;
        } else if (!StringsKt.endsWith$default((CharSequence)chunk, (char)'\n', (boolean)false, (int)2, null)) {
            if (!this.ignoreLine && ((CharSequence)this.lineBuffer).length() == 0) {
                boolean bl = this.ignoreLine = !StringsKt.startsWith$default((CharSequence)chunk, (char)'[', (boolean)false, (int)2, null);
            }
            if (!this.ignoreLine) {
                this.lineBuffer.append(chunk);
            } else {
                this.chunkIgnored(chunk);
            }
            return;
        }
        if (this.ignoreLine) {
            this.chunkIgnored(chunk);
            this.ignoreLine = false;
            return;
        }
        if (((CharSequence)this.lineBuffer).length() == 0) {
            charSequence = chunk;
        } else {
            StringBuilder stringBuilder = this.lineBuffer.append(chunk);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            charSequence = stringBuilder;
        }
        CharSequence line = charSequence;
        FractionWithMessage fractionWithMessage = this.matchLine(StringsKt.trim((CharSequence)line));
        if (fractionWithMessage != null) {
            if (!this.setToDeterminate) {
                this.indicator.setIndeterminate(false);
                this.setToDeterminate = true;
            }
            this.indicator.setFraction(fractionWithMessage.getFraction());
            this.indicator.setText2(fractionWithMessage.getMessage());
        }
        this.lineBuffer.setLength(0);
    }

    protected void chunkIgnored(@NotNull String chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
    }

    private final FractionWithMessage matchLine(CharSequence line) {
        MatchResult match;
        if (line.length() <= 5 || line.charAt(0) != '[') {
            return null;
        }
        if (line.charAt(5) == ']') {
            MatchResult matchResult = CMakeBuildListenerKt.access$getMAKEFILE_PATTERN$p().matchEntire(line);
            if (matchResult != null) {
                match = matchResult;
                boolean bl = false;
                double fraction = (double)StringUtil.parseInt((String)((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(1)))).toString(), (int)-1) / 100.0;
                if (!(fraction == -1.0)) {
                    String message = ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(2)))).toString();
                    return new FractionWithMessage(fraction, message);
                }
            }
        }
        MatchResult matchResult = CMakeBuildListenerKt.access$getNINJA_PATTERN$p().matchEntire(line);
        if (matchResult != null) {
            match = matchResult;
            boolean bl = false;
            int numerator = StringUtil.parseInt((String)((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(1)))).toString(), (int)-1);
            int denominator = StringUtil.parseInt((String)((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(2)))).toString(), (int)-1);
            if (numerator != -1 && denominator != -1 && denominator != 0) {
                double fraction = (double)numerator / (double)denominator;
                String message = ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(3)))).toString();
                return new FractionWithMessage(fraction, message);
            }
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001a\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\r\b\u0002\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/cpp/execution/build/CMakeBuildListener$FractionWithMessage;", "", "fraction", "", "message", "", "Lcom/intellij/openapi/util/NlsSafe;", "(DLjava/lang/String;)V", "getFraction", "()D", "getMessage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clion.cmake"})
    private static final class FractionWithMessage {
        private final double fraction;
        @NotNull
        private final String message;

        public FractionWithMessage(double fraction, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.fraction = fraction;
            this.message = message;
        }

        public final double getFraction() {
            return this.fraction;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public final double component1() {
            return this.fraction;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final FractionWithMessage copy(double fraction, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new FractionWithMessage(fraction, message);
        }

        public static /* synthetic */ FractionWithMessage copy$default(FractionWithMessage fractionWithMessage, double d, String string, int n, Object object) {
            if ((n & 1) != 0) {
                d = fractionWithMessage.fraction;
            }
            if ((n & 2) != 0) {
                string = fractionWithMessage.message;
            }
            return fractionWithMessage.copy(d, string);
        }

        @NotNull
        public String toString() {
            return "FractionWithMessage(fraction=" + this.fraction + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result2 = Double.hashCode(this.fraction);
            result2 = result2 * 31 + this.message.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FractionWithMessage)) {
                return false;
            }
            FractionWithMessage fractionWithMessage = (FractionWithMessage)other;
            if (Double.compare(this.fraction, fractionWithMessage.fraction) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)fractionWithMessage.message);
        }
    }
}

