/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCRunConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrExecutionUtil {
    public static boolean compiledWithCompilerSwitches(@NotNull OCRunConfiguration configuration2, @NotNull List<String> switchesToCheck) {
        if (configuration2 == null) {
            CidrExecutionUtil.$$$reportNull$$$0(0);
        }
        if (switchesToCheck == null) {
            CidrExecutionUtil.$$$reportNull$$$0(1);
        }
        return CidrExecutionUtil.getCompilerSwitch(configuration2, switchesToCheck) != null;
    }

    @Nullable
    public static String getCompilerSwitch(@NotNull OCRunConfiguration configuration2, @NotNull List<String> switchesToCheck) {
        ExecutionTarget target2;
        OCResolveConfiguration resolveConfiguration;
        if (configuration2 == null) {
            CidrExecutionUtil.$$$reportNull$$$0(2);
        }
        if (switchesToCheck == null) {
            CidrExecutionUtil.$$$reportNull$$$0(3);
        }
        if ((resolveConfiguration = configuration2.getResolveConfiguration(target2 = ExecutionTargetManager.getInstance((Project)configuration2.getProject()).getActiveTarget())) == null) {
            return null;
        }
        for (CLanguageKind languageKind : CLanguageKind.values()) {
            OCCompilerSettings compilerSettings = resolveConfiguration.getCompilerSettings((OCLanguageKind)languageKind);
            CidrCompilerSwitches compilerSwitches = compilerSettings.getCompilerSwitches();
            if (compilerSwitches == null) continue;
            List compilerSwitchesList = compilerSwitches.getList(CidrCompilerSwitches.Format.RAW);
            for (String compilerSwitch : compilerSwitchesList) {
                if (!ContainerUtil.exists(switchesToCheck, s -> CidrExecutionUtil.isSwitch(compilerSwitch, s))) continue;
                return compilerSwitch;
            }
        }
        return null;
    }

    public static boolean compiledWithCompilerSwitch(@NonNls @NotNull List<String> compilerSwitches, @NonNls @NotNull String compilerSwitch) {
        if (compilerSwitches == null) {
            CidrExecutionUtil.$$$reportNull$$$0(4);
        }
        if (compilerSwitch == null) {
            CidrExecutionUtil.$$$reportNull$$$0(5);
        }
        return ContainerUtil.exists(compilerSwitches, sw -> CidrExecutionUtil.isSwitch(sw, compilerSwitch));
    }

    public static boolean compilerUsed(@NotNull OCRunConfiguration configuration2, OCCompilerKind ... compilers) {
        ExecutionTarget target2;
        OCResolveConfiguration resolveConfiguration;
        if (configuration2 == null) {
            CidrExecutionUtil.$$$reportNull$$$0(6);
        }
        if (compilers == null) {
            CidrExecutionUtil.$$$reportNull$$$0(7);
        }
        if ((resolveConfiguration = configuration2.getResolveConfiguration(target2 = ExecutionTargetManager.getInstance((Project)configuration2.getProject()).getActiveTarget())) == null) {
            return false;
        }
        return ContainerUtil.exists((Object[])CLanguageKind.values(), languageKind -> {
            OCCompilerSettings settings2 = resolveConfiguration.getCompilerSettings((OCLanguageKind)languageKind);
            return ContainerUtil.exists((Object[])compilers, compiler -> compiler == settings2.getCompilerKind());
        });
    }

    private static boolean isSwitch(@NotNull String actualSwitch, @NotNull String switchToCheck) {
        if (actualSwitch == null) {
            CidrExecutionUtil.$$$reportNull$$$0(8);
        }
        if (switchToCheck == null) {
            CidrExecutionUtil.$$$reportNull$$$0(9);
        }
        return actualSwitch.startsWith(switchToCheck) || actualSwitch.startsWith("/clang:" + switchToCheck);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchesToCheck";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSwitches";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSwitch";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilers";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualSwitch";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchToCheck";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/CidrExecutionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "compiledWithCompilerSwitches";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompilerSwitch";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "compiledWithCompilerSwitch";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "compilerUsed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isSwitch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

