/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.settings;

import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0002\u001a\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0000\u001a\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0002*\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u001a\u001a\u0010\u0012\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u001a\"\u0010\u0015\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0018\u0010\b\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\u00a8\u0006\u0016"}, d2={"containsMacro", "", "", "getContainsMacro", "(Ljava/lang/String;)Z", "isBoolean", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeVariable$Type;", "(Lcom/jetbrains/cidr/cpp/cmake/model/CMakeVariable$Type;)Z", "isCMakeTrue", "convertToStringOption", "variable", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeVariable;", "value", "getVariableWithNameRegex", "Lkotlin/text/Regex;", "name", "getVariableValue", "", "removeVariable", "", "", "setVariable", "intellij.clion.cmake"})
public final class CMakeVariableValueColumnInfoKt {
    private static final boolean isBoolean(CMakeVariable.Type $this$isBoolean) {
        return $this$isBoolean == CMakeVariable.Type.BOOL;
    }

    private static final boolean isCMakeTrue(String $this$isCMakeTrue) {
        String string = $this$isCMakeTrue.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return switch (string) {
            case "" -> false;
            case "0" -> false;
            case "OFF" -> false;
            case "N" -> false;
            case "NO" -> false;
            case "FALSE" -> false;
            case "NOTFOUND" -> false;
            case "IGNORE" -> false;
            default -> {
                String value;
                yield !StringsKt.endsWith$default((String)value, (String)"-NOTFOUND", (boolean)false, (int)2, null);
            }
        };
    }

    private static final String getVariableValue(List<String> $this$getVariableValue, String name2) {
        for (String item : $this$getVariableValue) {
            MatchResult result2 = CMakeVariableValueColumnInfoKt.getVariableWithNameRegex(name2).matchEntire((CharSequence)item);
            if (result2 == null) continue;
            MatchGroup matchGroup = result2.getGroups().get(1);
            return matchGroup != null ? matchGroup.getValue() : null;
        }
        return null;
    }

    private static final void setVariable(List<String> $this$setVariable, CMakeVariable variable, String value) {
        Iterator<String> iterator = $this$setVariable.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int idx = n++;
            String item = iterator.next();
            String string = variable.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            MatchResult result2 = CMakeVariableValueColumnInfoKt.getVariableWithNameRegex(string).matchEntire((CharSequence)item);
            if (result2 == null) continue;
            $this$setVariable.set(idx, CMakeVariableValueColumnInfoKt.convertToStringOption(variable, value));
            break;
        }
    }

    private static final String convertToStringOption(CMakeVariable variable, String value) {
        StringBuilder variableString = new StringBuilder("-D" + variable.getName());
        if (variable.getType() != CMakeVariable.Type.UNINITIALIZED) {
            variableString.append(":" + variable.getType());
        }
        variableString.append("=" + value);
        String string = variableString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void removeVariable(List<String> $this$removeVariable, String name2) {
        Iterator<String> iterator = $this$removeVariable.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int idx = n++;
            String item = iterator.next();
            MatchResult result2 = CMakeVariableValueColumnInfoKt.getVariableWithNameRegex(name2).matchEntire((CharSequence)item);
            if (result2 == null) continue;
            $this$removeVariable.remove(idx);
            return;
        }
    }

    @NotNull
    public static final Regex getVariableWithNameRegex(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new Regex("-D(?<name>" + name2 + ")(:(?<type>\\w+?))?=(?<value>.*)");
    }

    public static final boolean getContainsMacro(@NotNull String $this$containsMacro) {
        Intrinsics.checkNotNullParameter((Object)$this$containsMacro, (String)"<this>");
        CharSequence charSequence = $this$containsMacro;
        return new Regex("[$].*[$]").containsMatchIn(charSequence);
    }

    public static final /* synthetic */ void access$removeVariable(List $receiver, String name2) {
        CMakeVariableValueColumnInfoKt.removeVariable($receiver, name2);
    }

    public static final /* synthetic */ String access$getVariableValue(List $receiver, String name2) {
        return CMakeVariableValueColumnInfoKt.getVariableValue($receiver, name2);
    }

    public static final /* synthetic */ void access$setVariable(List $receiver, CMakeVariable variable, String value) {
        CMakeVariableValueColumnInfoKt.setVariable($receiver, variable, value);
    }

    public static final /* synthetic */ String access$convertToStringOption(CMakeVariable variable, String value) {
        return CMakeVariableValueColumnInfoKt.convertToStringOption(variable, value);
    }

    public static final /* synthetic */ boolean access$isBoolean(CMakeVariable.Type $receiver) {
        return CMakeVariableValueColumnInfoKt.isBoolean($receiver);
    }

    public static final /* synthetic */ boolean access$isCMakeTrue(String $receiver) {
        return CMakeVariableValueColumnInfoKt.isCMakeTrue($receiver);
    }
}

