/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.python;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleViewImpl;
import com.jetbrains.cidr.cpp.cmake.flavor.CMakePlainProjectFlavorKt;
import com.jetbrains.cidr.cpp.cmake.python.CMakePythonBundle;
import com.jetbrains.cidr.cpp.cmake.python.CMakePythonSettingsService;
import com.jetbrains.cidr.cpp.cmake.python.CMakePythonUsagesCollector;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/python/CMakePythonConsoleFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "consoleView", "Lcom/jetbrains/cidr/cpp/cmake/console/CMakeConsoleViewImpl;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/cpp/cmake/console/CMakeConsoleViewImpl;)V", "alreadyWarned", "", "isPlainCMakeProject", "isVariablePresentInGenerationOptions", "notUsedVariablesDetectedState", "getProject", "()Lcom/intellij/openapi/project/Project;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "CMakePythonConsoleFilterResultItem", "Companion", "intellij.clion.cmake.python"})
@SourceDebugExtension(value={"SMAP\nCMakePythonConsoleFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakePythonConsoleFilter.kt\ncom/jetbrains/cidr/cpp/cmake/python/CMakePythonConsoleFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1747#2,3:101\n*S KotlinDebug\n*F\n+ 1 CMakePythonConsoleFilter.kt\ncom/jetbrains/cidr/cpp/cmake/python/CMakePythonConsoleFilter\n*L\n37#1:101,3\n*E\n"})
public final class CMakePythonConsoleFilter
implements Filter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final boolean isVariablePresentInGenerationOptions;
    private final boolean isPlainCMakeProject;
    private boolean notUsedVariablesDetectedState;
    private boolean alreadyWarned;
    @NotNull
    private static final String CMAKE_VARIABLES_NOT_USED_WARNING = "Manually-specified variables were not used by the project:";
    @NotNull
    private static final List<String> pythonVariables;

    /*
     * WARNING - void declaration
     */
    public CMakePythonConsoleFilter(@NotNull Project project, @NotNull CMakeConsoleViewImpl consoleView) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
        this.project = project;
        CMakeProfileInfo profileInfo = consoleView.getProfileInfo();
        if (profileInfo != null) {
            boolean bl;
            boolean bl2;
            block5: {
                void $this$any$iv;
                String generationOptions = profileInfo.getProfile().getGenerationOptions();
                List<String> listGenerationOptions = CMakeSettings.Companion.getOptionsList(generationOptions);
                Iterable iterable = pythonVariables;
                CMakePythonConsoleFilter cMakePythonConsoleFilter = this;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!(CMakeSettings.Companion.findFlagIndex(listGenerationOptions, "-D" + it) != -1)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            cMakePythonConsoleFilter.isVariablePresentInGenerationOptions = bl = bl2;
        } else {
            this.isVariablePresentInGenerationOptions = false;
        }
        this.isPlainCMakeProject = CMakePlainProjectFlavorKt.isInitializedPlainCMakeProject(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (this.isVariablePresentInGenerationOptions || !this.isPlainCMakeProject) {
            return null;
        }
        if (this.notUsedVariablesDetectedState) {
            if (StringsKt.isBlank((CharSequence)line)) {
                return null;
            }
            if (Character.isWhitespace(line.charAt(0))) {
                String variable = ((Object)StringsKt.trim((CharSequence)line)).toString();
                if (StringsKt.equals((String)variable, (String)"Python_EXECUTABLE", (boolean)true) || StringsKt.equals((String)variable, (String)"Python2_EXECUTABLE", (boolean)true) || StringsKt.equals((String)variable, (String)"Python3_EXECUTABLE", (boolean)true)) {
                    this.notUsedVariablesDetectedState = false;
                    this.alreadyWarned = true;
                    if (CMakePythonSettingsService.Companion.getInstance(this.project).getPythonState() != ThreeState.YES) {
                        return null;
                    }
                    CMakePythonUsagesCollector.INSTANCE.getCmakeConsoleFixIsShown().log(this.project);
                    return new CMakePythonConsoleFilterResultItem(this.project, 0, entireLength - 1);
                }
            } else {
                this.notUsedVariablesDetectedState = false;
                this.alreadyWarned = true;
            }
        } else if (!this.alreadyWarned && StringsKt.equals((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (String)CMAKE_VARIABLES_NOT_USED_WARNING, (boolean)true)) {
            this.notUsedVariablesDetectedState = true;
        }
        return null;
    }

    static {
        Object[] objectArray = new String[]{"Python_EXECUTABLE", "Python2_EXECUTABLE", "Python3_EXECUTABLE"};
        pythonVariables = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/python/CMakePythonConsoleFilter$CMakePythonConsoleFilterResultItem;", "Lcom/intellij/execution/filters/Filter$Result;", "Lcom/intellij/execution/impl/InlayProvider;", "project", "Lcom/intellij/openapi/project/Project;", "highlightStartOffset", "", "highlightEndOffset", "(Lcom/intellij/openapi/project/Project;II)V", "createInlayRenderer", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.clion.cmake.python"})
    public static final class CMakePythonConsoleFilterResultItem
    extends Filter.Result
    implements InlayProvider {
        @NotNull
        private final Project project;

        public CMakePythonConsoleFilterResultItem(@NotNull Project project, int highlightStartOffset, int highlightEndOffset) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(highlightStartOffset, highlightEndOffset, null);
            this.project = project;
        }

        @NotNull
        public EditorCustomElementRenderer createInlayRenderer(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            PresentationFactory factory = new PresentationFactory(editor);
            InlayPresentation presentation = factory.referenceOnHover(factory.roundWithBackground(factory.smallText(CMakePythonBundle.message("cmake.console.hint", new Object[0]))), (arg_0, arg_1) -> CMakePythonConsoleFilterResultItem.createInlayRenderer$lambda$0(this, arg_0, arg_1));
            return (EditorCustomElementRenderer)new PresentationRenderer(presentation);
        }

        private static final void createInlayRenderer$lambda$0(CMakePythonConsoleFilterResultItem this$0, MouseEvent mouseEvent, Point point) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<anonymous parameter 0>");
            Intrinsics.checkNotNullParameter((Object)point, (String)"<anonymous parameter 1>");
            CMakePythonUsagesCollector.INSTANCE.getCmakeConsoleFixClick().log(this$0.project);
            CMakePythonSettingsService.Companion.getInstance(this$0.project).setPythonState(ThreeState.NO);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/python/CMakePythonConsoleFilter$Companion;", "", "()V", "CMAKE_VARIABLES_NOT_USED_WARNING", "", "Lcom/intellij/openapi/util/NlsSafe;", "pythonVariables", "", "intellij.clion.cmake.python"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

