/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.presets;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.cpp.cmake.presets.ExpandToIdeaMacroPolicy;
import com.jetbrains.cidr.cpp.cmake.presets.MacroString;
import com.jetbrains.cidr.cpp.cmake.presets.ParsedCacheVariable;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007J\b\u0010\u000f\u001a\u00020\u0007H\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u00020\u00018F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/presets/CacheVariable;", "", "parsedCacheVariable", "Lcom/jetbrains/cidr/cpp/cmake/presets/ParsedCacheVariable;", "(Lcom/jetbrains/cidr/cpp/cmake/presets/ParsedCacheVariable;)V", "value", "type", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "getType", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "toCMakeArgument", "key", "wrapValueStringIfNeeded", "intellij.clion.cmake"})
public final class CacheVariable {
    @Nullable
    private final String type;
    @NotNull
    private final Object value;

    public CacheVariable(@NotNull Object value, @Nullable String type) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.type = type;
        this.value = value;
    }

    @Nullable
    public final String getType() {
        return this.type;
    }

    public CacheVariable(@NotNull ParsedCacheVariable parsedCacheVariable) {
        Intrinsics.checkNotNullParameter((Object)parsedCacheVariable, (String)"parsedCacheVariable");
        this(parsedCacheVariable.getValue(), parsedCacheVariable.getType());
    }

    @NotNull
    public final Object getValue() {
        Object object;
        Object object2 = this.value;
        if (object2 instanceof MacroString) {
            object = ((MacroString)this.value).expand(new ExpandToIdeaMacroPolicy());
        } else if (object2 instanceof Boolean) {
            String string = this.value.toString().toUpperCase(Locale.ROOT);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        } else {
            object = this.value;
        }
        return object;
    }

    @NotNull
    public final String toCMakeArgument(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        StringBuilder builder2 = new StringBuilder("-D" + key);
        String string = this.type;
        if (string != null) {
            String it = string;
            boolean bl = false;
            builder2.append(":" + it);
        }
        builder2.append("=" + this.wrapValueStringIfNeeded());
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String wrapValueStringIfNeeded() {
        String string;
        String valueString = this.getValue().toString();
        if (StringsKt.contains$default((CharSequence)valueString, (char)' ', (boolean)false, (int)2, null)) {
            String string2 = StringUtil.wrapWithDoubleQuote((String)valueString);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"wrapWithDoubleQuote(...)");
        } else {
            string = valueString;
        }
        return string;
    }
}

