/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import icons.CLionCMakeIcons;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeTarget
implements Serializable,
CidrBuildTarget<CMakeConfiguration> {
    public static final Icon EXECUTABLE_ICON = CLionCMakeIcons.CMakeTarget_Executable;
    public static final Icon LIBRARY_ICON = AllIcons.Nodes.PpLib;
    public static final Icon UTILITY_ICON = AllIcons.Nodes.Editorconfig;
    public static final Icon META_TARGET_ICON = AllIcons.Nodes.Target;
    @NotNull
    private final String myProjectName;
    @NotNull
    private final String myName;
    @NotNull
    private final List<CMakeConfiguration> myConfigurations;

    public CMakeTarget(@NotNull String projectName, @NotNull String name2, @NotNull List<CMakeConfiguration> configurations2) {
        if (projectName == null) {
            CMakeTarget.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            CMakeTarget.$$$reportNull$$$0(1);
        }
        if (configurations2 == null) {
            CMakeTarget.$$$reportNull$$$0(2);
        }
        this.myProjectName = projectName;
        this.myName = name2;
        this.myConfigurations = Collections.unmodifiableList(configurations2);
    }

    @NotNull
    public String getProjectName() {
        String string = this.myProjectName;
        if (string == null) {
            CMakeTarget.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        CMakeConfiguration target2 = (CMakeConfiguration)ContainerUtil.getFirstItem(this.getBuildConfigurations());
        if (target2 == null) {
            return null;
        }
        return switch (target2.getTargetType()) {
            case CMakeConfiguration.TargetType.EXECUTABLE -> EXECUTABLE_ICON;
            case CMakeConfiguration.TargetType.SHARED_LIBRARY, CMakeConfiguration.TargetType.STATIC_LIBRARY -> LIBRARY_ICON;
            case CMakeConfiguration.TargetType.UTILITY -> UTILITY_ICON;
            default -> null;
        };
    }

    public boolean isExecutable() {
        return ContainerUtil.exists(this.getBuildConfigurations(), configuration2 -> configuration2.getTargetType() == CMakeConfiguration.TargetType.EXECUTABLE);
    }

    public boolean pairOf(@NotNull BuildTargetData targetData) {
        if (targetData == null) {
            CMakeTarget.$$$reportNull$$$0(4);
        }
        return this.getName().equals(targetData.targetName) && this.projectNameEquals(targetData.projectName);
    }

    public boolean projectNameEquals(@Nullable String name2) {
        return this.myProjectName.equalsIgnoreCase(name2);
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            CMakeTarget.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public List<CMakeConfiguration> getBuildConfigurations() {
        List<CMakeConfiguration> list2 = this.myConfigurations;
        if (list2 == null) {
            CMakeTarget.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NonNls
    public String toString() {
        return this.myName + " [" + this.myConfigurations.size() + " configs]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeTarget";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeTarget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "pairOf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

