/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CMakeSettingsFileParser<T> {
    @NotNull
    private final String mySeparator;

    protected CMakeSettingsFileParser() {
        this("=");
    }

    protected CMakeSettingsFileParser(@NotNull String separator) {
        if (separator == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(0);
        }
        this.mySeparator = separator;
    }

    @NotNull
    public MultiMap<String, T> parse(@NotNull File file, @NotNull String encoding) throws CMakeException {
        if (file == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(1);
        }
        if (encoding == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(2);
        }
        MultiMap<String, T> multiMap = this.parse(CMakeSettingsFileParser.loadText(file, encoding));
        if (multiMap == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(3);
        }
        return multiMap;
    }

    @NotNull
    public Map<String, T> parseUnique(@NotNull File file, @NotNull String encoding) throws CMakeException {
        if (file == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(4);
        }
        if (encoding == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(5);
        }
        Map<String, T> map = this.toUniqueMap(this.parse(file, encoding));
        if (map == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    public MultiMap<String, T> parse(@NotNull Path file, @NotNull String encoding) throws CMakeException {
        if (file == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(7);
        }
        if (encoding == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(8);
        }
        MultiMap<String, T> multiMap = this.parse(CMakeSettingsFileParser.loadText(file, encoding));
        if (multiMap == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(9);
        }
        return multiMap;
    }

    @NotNull
    public Map<String, T> parseUnique(@NotNull Path file, @NotNull String encoding) throws CMakeException {
        if (file == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(10);
        }
        if (encoding == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(11);
        }
        Map<String, T> map = this.toUniqueMap(this.parse(file, encoding));
        if (map == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    protected static String loadText(File file, @NotNull String encoding) throws CMakeException {
        String string;
        if (encoding == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(13);
        }
        try {
            string = FileUtil.loadFile((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw CMakeException.cannotReadFile(file, (Throwable)e);
        }
        if (string == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    protected static String loadText(Path file, @NotNull String encoding) throws CMakeException {
        if (encoding == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(15);
        }
        try {
            return new String(Files.readAllBytes(file), encoding);
        }
        catch (IOException e) {
            throw CMakeException.cannotReadFile(file, (Throwable)e);
        }
    }

    @NotNull
    public MultiMap<String, T> parse(@NotNull String text) {
        if (text == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(16);
        }
        MultiMap multiMap = (MultiMap)this.parse((String)text, null).second;
        if (multiMap == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(17);
        }
        return multiMap;
    }

    @NotNull
    public Map<String, T> parseUnique(@NotNull String text) {
        if (text == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(18);
        }
        Map<String, T> map = this.toUniqueMap(this.parse(text));
        if (map == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(19);
        }
        return map;
    }

    @NotNull
    protected Map<String, T> toUniqueMap(MultiMap<String, T> multi) {
        Map<String, Object> unique = this.createMap();
        for (Map.Entry each : multi.entrySet()) {
            Object value = ContainerUtil.getFirstItem((Collection)((Collection)each.getValue()));
            assert (value != null);
            unique.put((String)each.getKey(), value);
        }
        Map<String, Object> map = unique;
        if (map == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(20);
        }
        return map;
    }

    @NotNull
    protected Pair<String, MultiMap<String, T>> parse(@NotNull String text, @Nullable Function<Pair<String, T>, Pair<String, T>> transformer) {
        if (text == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(21);
        }
        MultiMap vars = new MultiMap(this.createMap());
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(StringUtil.splitByLinesKeepSeparators((String)text)));
        int size = lines.size();
        for (int i = 0; i < size; ++i) {
            int eq;
            String eachLine = StringUtil.trimLeading((String)((String)lines.get(i)));
            int newLine = StringUtil.indexOfAny((String)(eachLine = StringUtil.trimLeading((String)this.convertLineAndKeepEOLs(eachLine))), (String)"\r\n");
            String trimmed = newLine == -1 ? eachLine : eachLine.substring(0, newLine);
            String lineSeparators = newLine == -1 ? "" : eachLine.substring(newLine);
            eachLine = trimmed;
            if (eachLine.startsWith("#") || !this.preprocess(eachLine) || (eq = eachLine.indexOf(this.mySeparator)) < 0) continue;
            Trinity<String, T, Integer> result2 = this.parseVariable(eachLine.substring(0, eq).trim(), eachLine.substring(eq + 1), i == size - 1 ? Collections.emptyList() : lines.subList(i + 1, size));
            String name2 = (String)result2.first;
            Object var = result2.second;
            if (transformer != null) {
                Pair transformedLineAndVar = (Pair)transformer.fun((Object)Pair.create((Object)eachLine, (Object)var));
                lines.set(i, (String)transformedLineAndVar.first + lineSeparators);
                var = transformedLineAndVar.second;
            }
            vars.putValue((Object)name2, var);
            i += ((Integer)result2.third).intValue();
        }
        this.cleanup();
        return new Pair((Object)(transformer == null ? text : StringUtil.join(lines, (String)"")), (Object)vars);
    }

    @NotNull
    protected <V> Map<String, V> createMap() {
        Map map = CollectionFactory.createSmallMemoryFootprintLinkedMap();
        if (map == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(22);
        }
        return map;
    }

    @NotNull
    protected String convertLineAndKeepEOLs(@NotNull String lineWithEOLs) {
        if (lineWithEOLs == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(23);
        }
        String string = lineWithEOLs;
        if (string == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(24);
        }
        return string;
    }

    protected boolean preprocess(@NotNull String line) {
        if (line == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(25);
        }
        return true;
    }

    @NotNull
    protected abstract Pair<String, T> parseVariable(@NotNull String var1, @NotNull String var2);

    @NotNull
    protected Trinity<String, T, Integer> parseVariable(@NotNull String beforeEqual, @NotNull String afterEqual, List<String> remainingLines) {
        if (beforeEqual == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(26);
        }
        if (afterEqual == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(27);
        }
        Pair<String, T> result2 = this.parseVariable(beforeEqual, afterEqual);
        Trinity trinity = Trinity.create((Object)((String)result2.first), (Object)result2.second, (Object)0);
        if (trinity == null) {
            CMakeSettingsFileParser.$$$reportNull$$$0(28);
        }
        return trinity;
    }

    protected void cleanup() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 9, 12, 14, 17, 19, 20, 22, 24, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeSettingsFileParser";
                break;
            }
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineWithEOLs";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeEqual";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterEqual";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeSettingsFileParser";
                break;
            }
            case 3: 
            case 9: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 6: 
            case 12: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "parseUnique";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "toUniqueMap";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineAndKeepEOLs";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 16: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 28: {
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseUnique";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "convertLineAndKeepEOLs";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "preprocess";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "parseVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 9, 12, 14, 17, 19, 20, 22, 24, 28 -> new IllegalStateException(string);
        };
    }
}

