/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCompiler;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurationSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeEnvironmentState;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorCommonInfo;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorUtils;
import com.jetbrains.cidr.cpp.cmake.model.CMakeLanguageKindRecognizer;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeProfileTargetInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeStatisticsCollector;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKindProvider;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cmake.psi.CMakeElementFactory;
import com.jetbrains.cmake.psi.CMakeFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CMakeProfileGenerationResult {
    @NotNull
    protected final CMakeGenerator myGenerator;
    @NotNull
    final CMakeGeneratorParameters parameters;
    protected boolean hasGenerationError;
    @NotNull
    File cacheIOFile;
    @NotNull
    String cacheIOFileEncoding;
    @NotNull
    List<String> registeredBuildTypes;
    @NotNull
    CMakeEnvironmentState.Builder environmentStateBuilder;

    public CMakeProfileGenerationResult(@NotNull CMakeGenerator generator2, @NotNull CMakeGeneratorParameters parameters2) {
        if (generator2 == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(0);
        }
        if (parameters2 == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(1);
        }
        this.hasGenerationError = false;
        this.registeredBuildTypes = new ArrayList<String>(CMakeModel.DEFAULT_BUILD_TYPES);
        this.environmentStateBuilder = new CMakeEnvironmentState.Builder();
        this.myGenerator = generator2;
        this.parameters = parameters2;
    }

    protected static OCLanguageKind getEffectiveLanguageKind(@NotNull String sourceName, @NotNull OCLanguageKind effectiveLang, @NotNull Map<OCLanguageKind, OCLanguageKind> predefinedLanguageToExistingLanguage) {
        OCLanguageKind predefinedLang;
        if (sourceName == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(2);
        }
        if (effectiveLang == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(3);
        }
        if (predefinedLanguageToExistingLanguage == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(4);
        }
        if ((predefinedLang = CMakeGenerator.PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.get(FileUtilRt.getExtension((String)sourceName))) != null && predefinedLang != effectiveLang) {
            predefinedLanguageToExistingLanguage.put(predefinedLang, effectiveLang);
            effectiveLang = predefinedLang;
        }
        return effectiveLang;
    }

    protected static void adjustLanguageSettingsMap(@NotNull Map<OCLanguageKind, CMakeConfigurationSettings> settingsMap, @NotNull Map<OCLanguageKind, OCLanguageKind> predefinedLanguageToExistingLanguage) {
        if (settingsMap == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(5);
        }
        if (predefinedLanguageToExistingLanguage == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(6);
        }
        predefinedLanguageToExistingLanguage.forEach((predefined, existing) -> settingsMap.putIfAbsent((OCLanguageKind)predefined, (CMakeConfigurationSettings)settingsMap.get(existing)));
    }

    final void doGenerate(@NotNull CMakeGeneratorCommonInfo commonInfo, @Nullable Runnable onCMakeCompleted) {
        if (commonInfo == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(7);
        }
        File generationDir2 = this.executeCMake();
        if (onCMakeCompleted != null) {
            onCMakeCompleted.run();
        }
        this.loadInfo(generationDir2, commonInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private File executeCMake() {
        File generationDir2 = this.parameters.getGenerationDir();
        if (!this.parameters.getShouldSkipCMake()) {
            Path generationDirHostPath = this.hostMachine().getPath(this.parameters.getGenerationDir().getPath(), new String[0]);
            this.beforeGenerate(generationDirHostPath);
            ProgressManager.checkCanceled();
            long before = System.currentTimeMillis();
            CMakeRunner.CMakeOutput output2 = null;
            try {
                output2 = this.myGenerator.runCMakeGenerator(this.parameters, this.getExtraGeneratorOptions());
                this.hasGenerationError = this.hasGenerationError || output2.getExitCode() != 0;
            }
            catch (CMakeException e) {
                this.hasGenerationError = true;
                if (!(e instanceof CMakeGenerator.EmulatedCMakeException)) {
                    CPPLog.LOG.info((Throwable)e);
                }
                this.parameters.getListener().message(CMakeMessage.fromException(e, this.myGenerator.getCMakeListsFile()));
            }
            finally {
                if (ApplicationManager.getApplication().isUnitTestMode() && output2 != null) {
                    CPPLog.LOG.debug("\n>>>>>>>>>>>>> CMake output >>>>>>>>>>>>>\n" + output2.getOutput() + "\n<<<<<<<<<<<<< CMake output <<<<<<<<<<<<<");
                    if (!output2.getDiagnostics().isEmpty()) {
                        CPPLog.LOG.debug("\n>>>>>>>>>>>>> CMake diagnostics >>>>>>>>>>>>\n" + output2.getDiagnostics() + "\n<<<<<<<<<<<<< CMake diagnostics <<<<<<<<<<<<<");
                    }
                }
                long after = System.currentTimeMillis();
                CPPLog.LOG.info("CMake generation for " + this.parameters.getProfileName() + " took " + StringUtil.formatDuration((long)(after - before)));
            }
        }
        try {
            ProgressManager.checkCanceled();
            generationDir2 = this.hostMachine().resolvePath(this.parameters.getGenerationDir());
        }
        catch (IOException e) {
            CMakeStatisticsCollector.SYNC_FAILED.log(this.myGenerator.myProject);
            this.hasGenerationError = true;
            String message = CLionCMakeBundle.message("cannot.resolve.path", this.parameters.getGenerationDir().getPath());
            this.parameters.getListener().message(new CMakeMessage(CMakeMessage.MessageLevel.ERROR, null, null, message));
        }
        ProgressManager.checkCanceled();
        this.cacheIOFile = new File(generationDir2, "CMakeCache.txt");
        this.cacheIOFileEncoding = this.myGenerator.encodingForFile(this.cacheIOFile);
        File file = generationDir2;
        if (file == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    protected List<String> getExtraGeneratorOptions() {
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Nullable
    protected CMakeGeneratorUtils.CudaTargetInfo loadCudaTargetInfo(@NotNull File targetDir) throws CMakeException {
        Object[] filesInDir;
        if (targetDir == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(10);
        }
        if ((filesInDir = targetDir.listFiles()) == null || filesInDir.length == 0) {
            return null;
        }
        List files = ContainerUtil.filter((Object[])filesInDir, it -> it.getName().endsWith(".cmake"));
        if (files.isEmpty()) {
            return null;
        }
        String compilerPath = null;
        String hostCompiler = null;
        Map sources = FileCollectionFactory.createCanonicalFileMap();
        for (File f : files) {
            List<String> nvccIncludeDirs;
            boolean hasCCbinFlag;
            List<String> hostComp;
            List<String> comp;
            CMakeFile cudaCmakeFile = this.parseCMakeFile(f);
            List<String> values = this.getCMakeVariableValues(cudaCmakeFile, "source_file");
            if (values.isEmpty()) continue;
            if (compilerPath == null && !(comp = this.getCMakeVariableValues(cudaCmakeFile, "CUDA_NVCC_EXECUTABLE")).isEmpty()) {
                compilerPath = comp.get(0);
            }
            if (StringUtil.isEmptyOrSpaces(hostCompiler) && !(hostComp = this.getCMakeVariableValues(cudaCmakeFile, "CUDA_HOST_COMPILER")).isEmpty()) {
                hostCompiler = hostComp.get(0);
            }
            ArrayList<@NlsSafe String> cudaFlags = new ArrayList<String>(0);
            List<String> nvccFlags = this.getCMakeVariableValues(cudaCmakeFile, "CUDA_NVCC_FLAGS");
            if (!nvccFlags.isEmpty()) {
                cudaFlags.addAll(nvccFlags);
            }
            boolean bl = hasCCbinFlag = NVCCCompiler.Companion.getCCBinOption(cudaFlags) != null;
            if (!hasCCbinFlag && !StringUtil.isEmptyOrSpaces((String)hostCompiler)) {
                cudaFlags.add("-ccbin=" + hostCompiler);
            }
            if (!(nvccIncludeDirs = this.getCMakeVariableValues(cudaCmakeFile, "CUDA_NVCC_INCLUDE_DIRS")).isEmpty()) {
                String[] split = nvccIncludeDirs.get(0).split(";");
                List<String> cudaIncludes = Arrays.stream(split).filter(it -> !it.isEmpty()).map(it -> it.startsWith("-I") ? it : "-I" + it).toList();
                cudaFlags.addAll(cudaIncludes);
            }
            ArrayList<String> cudaDefines = new ArrayList();
            List<String> nvccDefines = this.getCMakeVariableValues(cudaCmakeFile, "CUDA_NVCC_COMPILE_DEFINITIONS");
            if (!nvccDefines.isEmpty()) {
                cudaDefines = Arrays.stream(nvccDefines.get(0).split(";")).filter(it -> !it.isEmpty()).map(it -> "-D" + it).collect(Collectors.toList());
            }
            File cudaFile = CMakeGeneratorUtils.toLocalFile(this.parameters.getEnvironment(), values.get(0));
            CMakeFileSettings cmakeSettings = new CMakeFileSettings((OCLanguageKind)CUDALanguageKind.CUDA, cudaFile.getName() + ".o", cudaFlags, Collections.emptyList(), cudaDefines);
            sources.put(cudaFile, cmakeSettings);
        }
        return new CMakeGeneratorUtils.CudaTargetInfo(compilerPath == null ? null : new File(compilerPath), sources);
    }

    protected void addCudaCmakeTargets(@Nullable CMakeGeneratorUtils.CudaTargetInfo targetInfo, @NotNull Map<OCLanguageKind, CMakeConfigurationSettings> settingsMap, @NotNull Map<File, CMakeFileSettings> sources) {
        if (settingsMap == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(11);
        }
        if (sources == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(12);
        }
        if (targetInfo == null) {
            return;
        }
        sources.putAll(targetInfo.getSources());
        if (targetInfo.getCompilerPath() != null) {
            settingsMap.put((OCLanguageKind)CUDALanguageKind.CUDA, new CMakeConfigurationSettings(new CMakeCompiler("NVIDIA", (OCCompilerKind)NVCCCompilerKind.INSTANCE), targetInfo.getCompilerPath(), Collections.emptyList(), Collections.emptyList()));
        }
    }

    protected void beforeGenerate(@NotNull Path generationDir2) {
        if (generationDir2 == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(13);
        }
    }

    protected abstract void loadInfo(@NotNull File var1, @NotNull CMakeGeneratorCommonInfo var2);

    protected void setBuildTypes(@NotNull List<String> typesOrNullForDefault) {
        if (typesOrNullForDefault == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(14);
        }
        this.registeredBuildTypes = new ArrayList<String>(typesOrNullForDefault.size());
        for (String eachType : typesOrNullForDefault) {
            ContainerUtil.addIfNotNull(this.registeredBuildTypes, (Object)StringUtil.nullize((String)eachType.trim()));
        }
    }

    protected CMakeFile parseCMakeFile(@NotNull File file) throws CMakeException {
        String text;
        if (file == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(15);
        }
        try {
            text = FileUtil.loadFile((File)file, (String)this.myGenerator.encodingForFile(file));
        }
        catch (IOException e) {
            throw CMakeException.cannotReadFile(file, (Throwable)e);
        }
        return (CMakeFile)this.runReadActionCanceling(() -> CMakeElementFactory.createFile(this.myGenerator.myProject, text));
    }

    protected <T> T runReadActionCanceling(Computable<T> computable2) {
        return (T)ReadAction.compute(() -> {
            if (this.myGenerator.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            ProgressManager.checkCanceled();
            return computable2.compute();
        });
    }

    protected List<String> getCMakeVariableValues(@NotNull CMakeFile file, @NlsSafe @Nullable String optionName) {
        if (file == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(16);
        }
        return (List)this.runReadActionCanceling(() -> file.findFirstVariableValues(optionName));
    }

    protected void reportNoProductFile(@NotNull CMakeProfileTargetInfo eachTarget) {
        if (eachTarget == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(17);
        }
        this.parameters.getListener().message(new CMakeMessage(CMakeMessage.MessageLevel.WARNING, eachTarget.cmakeListsFile, null, CLionCMakeBundle.message("cmake.unknownTargetProductPath", eachTarget.targetName)));
    }

    @NotNull
    protected CMakeCompiler getCMakeCompiler(@NotNull String path, @NotNull String id) {
        if (path == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(18);
        }
        if (id == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(19);
        }
        if (id.equals("Clang")) {
            if (path.endsWith("clang-cl.exe") || path.endsWith("clang-cl")) {
                id = "clang-cl";
            }
        } else if (id.equals("Intel")) {
            id = this.parameters.getEnvironment().getHostMachine().getOSType().equals((Object)OSType.WIN) ? "MSVC" : "GNU";
        } else if (id.equals("IntelLLVM")) {
            id = this.parameters.getEnvironment().getHostMachine().getOSType().equals((Object)OSType.WIN) ? "clang-cl" : "Clang";
        }
        String finalId = id;
        String finalPath = path;
        OCCompilerKind ocCompilerKind = OCCompilerKindProvider.EP_NAME.getExtensionList().stream().map(provider2 -> provider2.compilerByCmakeId(finalId, this.myGenerator.myProject, finalPath)).filter(Predicates.nonNull()).findFirst().orElse((OCCompilerKind)UnknownCompilerKind.INSTANCE);
        return new CMakeCompiler(id, ocCompilerKind);
    }

    @Nullable
    public abstract String getProjectName();

    @NotNull
    public List<String> getRegisteredBuildTypes() {
        List<String> list2 = this.registeredBuildTypes;
        if (list2 == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @NotNull
    public abstract Collection<? extends CMakeProfileTargetInfo> getTargetInfos();

    @NotNull
    protected HostMachine hostMachine() {
        HostMachine hostMachine = this.parameters.getEnvironment().getHostMachine();
        if (hostMachine == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(21);
        }
        return hostMachine;
    }

    @Nullable
    static OCLanguageKind toLanguageKind(@Nullable String langID) {
        if (langID == null) {
            return null;
        }
        for (CMakeLanguageKindRecognizer detector : CMakeLanguageKindRecognizer.EP_NAME.getExtensionList()) {
            OCLanguageKind recognized = detector.getLanguageKind(langID);
            if (recognized == null) continue;
            return recognized;
        }
        return null;
    }

    static @NotNull Pair<@Nls String, String> resolveToExecutableOrGetFromCache(@NotNull String compilerPath, @NotNull File buildWorkingDir, @NotNull CPPEnvironment env, @NotNull Map<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache) {
        CPPEnvironment.ExecutablePathResult resolveResult;
        block12: {
            Pair pair;
            if (compilerPath == null) {
                CMakeProfileGenerationResult.$$$reportNull$$$0(22);
            }
            if (buildWorkingDir == null) {
                CMakeProfileGenerationResult.$$$reportNull$$$0(23);
            }
            if (env == null) {
                CMakeProfileGenerationResult.$$$reportNull$$$0(24);
            }
            if (resolvedExecutableCache == null) {
                CMakeProfileGenerationResult.$$$reportNull$$$0(25);
            }
            String key = env.isEnvAbsolute(compilerPath) ? compilerPath : new File(buildWorkingDir, compilerPath).getPath();
            try {
                resolveResult = resolvedExecutableCache.get(key);
                if (resolveResult == null) {
                    resolveResult = resolvedExecutableCache.computeIfAbsent(key, k -> {
                        try {
                            return env.resolveEnvPathToLocalExecutable(buildWorkingDir, compilerPath);
                        }
                        catch (ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                if (resolveResult.isResolvedToExecutable) break block12;
                pair = Pair.create((Object)CLionCMakeBundle.message("cannot.resolve.compiler.path", compilerPath), null);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof ExecutionException) {
                    Pair pair2 = Pair.create((Object)CLionCMakeBundle.message("cannot.resolve.compiler.path.exception", compilerPath, e.getMessage()), null);
                    if (pair2 == null) {
                        CMakeProfileGenerationResult.$$$reportNull$$$0(28);
                    }
                    return pair2;
                }
                throw e;
            }
            if (pair == null) {
                CMakeProfileGenerationResult.$$$reportNull$$$0(26);
            }
            return pair;
        }
        Pair pair = Pair.create(null, (Object)resolveResult.path);
        if (pair == null) {
            CMakeProfileGenerationResult.$$$reportNull$$$0(27);
        }
        return pair;
    }

    public boolean hasGenerationError() {
        return this.hasGenerationError;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 20, 21, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectiveLang";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedLanguageToExistingLanguage";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsMap";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonInfo";
                break;
            }
            case 8: 
            case 9: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeProfileGenerationResult";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesOrNullForDefault";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachTarget";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerPath";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildWorkingDir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedExecutableCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeProfileGenerationResult";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCMake";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraGeneratorOptions";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredBuildTypes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "hostMachine";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToExecutableOrGetFromCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveLanguageKind";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "adjustLanguageSettingsMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGenerate";
                break;
            }
            case 8: 
            case 9: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadCudaTargetInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCudaCmakeTargets";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "beforeGenerate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setBuildTypes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseCMakeFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeVariableValues";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reportNoProductFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeCompiler";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveToExecutableOrGetFromCache";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 20, 21, 26, 27, 28 -> new IllegalStateException(string);
        };
    }
}

