/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.CMakeRunnerStep;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorSpec;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorUtils;
import com.jetbrains.cidr.cpp.cmake.presets.CMakePresetLoader;
import com.jetbrains.cidr.cpp.cmake.presets.ConfigurePreset;
import com.jetbrains.cidr.cpp.cmake.presets.PresetKt;
import com.jetbrains.cidr.cpp.cmake.presets.PresetParsingException;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeStatisticsCollector;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\bH\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/model/CMakePlainGenerator;", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGenerator;", "project", "Lcom/intellij/openapi/project/Project;", "projectDir", "Ljava/io/File;", "parameters", "", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorParameters;", "preferredEncoding", "", "defaultCharset", "Ljava/nio/charset/Charset;", "(Lcom/intellij/openapi/project/Project;Ljava/io/File;Ljava/util/List;Ljava/lang/String;Ljava/nio/charset/Charset;)V", "isNotMultiConfigByGeneratorWithPresetCheck", "", "generator", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorSpec;", "runCMakeGenerator", "Lcom/jetbrains/cidr/cpp/cmake/CMakeRunner$CMakeOutput;", "extraOptions", "intellij.clion.cmake"})
@SourceDebugExtension(value={"SMAP\nCMakePlainGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakePlainGenerator.kt\ncom/jetbrains/cidr/cpp/cmake/model/CMakePlainGenerator\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,98:1\n31#2,2:99\n*S KotlinDebug\n*F\n+ 1 CMakePlainGenerator.kt\ncom/jetbrains/cidr/cpp/cmake/model/CMakePlainGenerator\n*L\n90#1:99,2\n*E\n"})
public final class CMakePlainGenerator
extends CMakeGenerator {
    public CMakePlainGenerator(@NotNull Project project, @NotNull File projectDir, @NotNull List<CMakeGeneratorParameters> parameters2, @Nullable String preferredEncoding, @NotNull Charset defaultCharset2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)defaultCharset2, (String)"defaultCharset");
        super(project, projectDir, parameters2, preferredEncoding, defaultCharset2);
    }

    @Override
    @NotNull
    public CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CMakeGeneratorParameters parameters2, @NotNull List<String> extraOptions) throws CMakeException {
        CMakeRunnerStep.Parameters parameters3;
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        if (CMakeGenerator.ourEmulateCMakeExecutionErrorInProfiles != null && CMakeGenerator.ourEmulateCMakeExecutionErrorInProfiles.contains(parameters2.getProfileName())) {
            throw new CMakeGenerator.EmulatedCMakeException("Emulated CMake error in " + parameters2.getProfileName());
        }
        List commandLineOptions = new ArrayList();
        CMakeGeneratorSpec generator2 = parameters2.getGeneratorSpec();
        if (this.isNotMultiConfigByGeneratorWithPresetCheck(generator2, parameters2)) {
            String string = CMakeGeneratorUtils.getBuildTypeOption(parameters2.getBuildType());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBuildTypeOption(...)");
            String buildType2 = string;
            if (!(((CharSequence)buildType2).length() == 0)) {
                commandLineOptions.add(buildType2);
            }
        }
        commandLineOptions.addAll((Collection)parameters2.getAdditionalOptions());
        commandLineOptions.addAll((Collection)extraOptions);
        CMakeGeneratorUtils.addGeneratorParametersIfNeeded(commandLineOptions, generator2.asCommandLineOption());
        ToolVersion cmakeVersion = parameters2.getCmakeVersion();
        boolean useSBSyntax = cmakeVersion != null && cmakeVersion.versionNumber.isOrGreaterThan(Integer.valueOf(3), Integer.valueOf(13));
        CMakeStatisticsCollector.logGenerator(this.myProject, generator2, parameters2.getAdditionalOptions());
        CMakeRunnerStep.Parameters $this$runCMakeGenerator_u24lambda_u241 = parameters3 = new CMakeRunnerStep.Parameters(parameters2.getEnvironment(), this.myProjectDir.toPath(), parameters2.getGenerationDir().toPath(), commandLineOptions, parameters2.getPassSystemEnvironment(), parameters2.getAdditionalEnvironment(), arg_0 -> CMakePlainGenerator.runCMakeGenerator$lambda$0(parameters2, arg_0), useSBSyntax);
        boolean bl = false;
        $this$runCMakeGenerator_u24lambda_u241.putUserData(CMakeRunnerStep.Parameters.PROFILE_NAME, parameters2.getProfileName());
        $this$runCMakeGenerator_u24lambda_u241.putUserData(CMakeRunnerStep.Parameters.TRY_TO_RESOLVE_CMAKE_ERROR, true);
        CMakeRunnerStep.Parameters newParameters = parameters3;
        CMakeRunnerStep.Parameters parameters4 = this.executeRunnerSteps(newParameters);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)parameters4), (String)"executeRunnerSteps(...)");
        newParameters = parameters4;
        CMakeRunner.CMakeOutput cMakeOutput = CMakeRunner.runCMake(newParameters);
        Intrinsics.checkNotNullExpressionValue((Object)cMakeOutput, (String)"runCMake(...)");
        return cMakeOutput;
    }

    private final boolean isNotMultiConfigByGeneratorWithPresetCheck(CMakeGeneratorSpec generator2, CMakeGeneratorParameters parameters2) {
        String string;
        if (CMakeGeneratorType.Companion.isSingleConfigurationGenerator(generator2.getGenerator())) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)generator2, (Object)CMakeGeneratorSpec.NONE)) {
            return false;
        }
        String presetName = PresetKt.getPresetName(parameters2.getAdditionalOptions());
        if (presetName == null) {
            return true;
        }
        try {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CMakePresetLoader> serviceClass$iv = CMakePresetLoader.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ConfigurePreset<?> configurePreset2 = ((CMakePresetLoader)object).loadProjectSchema().getConfigurePresetsMap().get(presetName);
            string = configurePreset2 != null ? configurePreset2.getGenerator() : null;
        }
        catch (PresetParsingException e) {
            throw new CMakeException(CLionCMakeBundle.message("notification.title.failed.to.load.cmake.presets", new Object[0]), e);
        }
        String generatorName = string;
        CMakeGeneratorType generatorType = CMakeGeneratorType.Companion.fromGeneratorSpec(generatorName);
        return CMakeGeneratorType.Companion.isSingleConfigurationGenerator(generatorType);
    }

    private static final void runCMakeGenerator$lambda$0(CMakeGeneratorParameters $parameters, ProcessHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)$parameters, (String)"$parameters");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        $parameters.getListener().attachTo(handler2);
    }
}

