/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.cidr.CidrProjectApplicationVersion;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeMSVCUtilsKt;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorSpec;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorUtils;
import com.jetbrains.cidr.cpp.cmake.model.CMakeListener;
import com.jetbrains.cidr.cpp.cmake.presets.CMakePresetLoader;
import com.jetbrains.cidr.cpp.cmake.presets.ConfigurePreset;
import com.jetbrains.cidr.cpp.cmake.presets.PresetKt;
import com.jetbrains.cidr.cpp.cmake.presets.PresetParsingException;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.cpp.toolchains.MSVC;
import com.jetbrains.cidr.cpp.toolchains.Make;
import com.jetbrains.cidr.cpp.toolchains.Ninja;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b#\u0018\u0000 <2\u00020\u0001:\u0002<=B\u0087\u0001\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\f\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0019B\u001f\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u001cJ\u009c\u0001\u00106\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\f2\b\b\u0002\u0010\u0018\u001a\u00020\fJ\u0014\u00107\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\u000e\u00108\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u00109\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0006\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\"R\u0011\u0010\u0018\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b4\u00100R\u0011\u0010\u0013\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b5\u00100\u00a8\u0006>"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorParameters;", "", "profileId", "", "profileName", "", "buildType", "generationDir", "Ljava/io/File;", "additionalOptions", "", "passSystemEnvironment", "", "additionalEnvironment", "", "cmakeVersion", "Lcom/jetbrains/cidr/ToolVersion;", "generatorSpec", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorSpec;", "shouldUseAPI", "listener", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeListener;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "shouldSkipCMake", "(ILjava/lang/String;Ljava/lang/String;Ljava/io/File;Ljava/util/List;ZLjava/util/Map;Lcom/jetbrains/cidr/ToolVersion;Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorSpec;ZLcom/jetbrains/cidr/cpp/cmake/model/CMakeListener;Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;Z)V", "holder", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorParameters$Holder;", "(Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorParameters$Holder;Lcom/jetbrains/cidr/cpp/cmake/model/CMakeListener;Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;)V", "getAdditionalEnvironment", "()Ljava/util/Map;", "getAdditionalOptions", "()Ljava/util/List;", "getBuildType", "()Ljava/lang/String;", "getCmakeVersion", "()Lcom/jetbrains/cidr/ToolVersion;", "getEnvironment", "()Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "getGenerationDir", "()Ljava/io/File;", "getGeneratorSpec", "()Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorSpec;", "getHolder", "()Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorParameters$Holder;", "getListener", "()Lcom/jetbrains/cidr/cpp/cmake/model/CMakeListener;", "getPassSystemEnvironment", "()Z", "getProfileId", "()I", "getProfileName", "getShouldSkipCMake", "getShouldUseAPI", "with", "withAdditionalOptions", "withGenerationDir", "withListener", "withShouldSkipCMake", "skip", "Companion", "Holder", "intellij.clion.cmake"})
public final class CMakeGeneratorParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Holder holder;
    @NotNull
    private final CMakeListener listener;
    @NotNull
    private final CPPEnvironment environment;

    public CMakeGeneratorParameters(@NotNull Holder holder, @NotNull CMakeListener listener2, @NotNull CPPEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        this.holder = holder;
        this.listener = listener2;
        this.environment = environment2;
    }

    public /* synthetic */ CMakeGeneratorParameters(Holder holder, CMakeListener cMakeListener, CPPEnvironment cPPEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cMakeListener = new CMakeListener(){};
        }
        this(holder, cMakeListener, cPPEnvironment);
    }

    @NotNull
    public final Holder getHolder() {
        return this.holder;
    }

    @NotNull
    public final CMakeListener getListener() {
        return this.listener;
    }

    @NotNull
    public final CPPEnvironment getEnvironment() {
        return this.environment;
    }

    public CMakeGeneratorParameters(int profileId, @NotNull String profileName, @NotNull String buildType2, @NotNull File generationDir2, @NotNull List<String> additionalOptions, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment2, @Nullable ToolVersion cmakeVersion, @NotNull CMakeGeneratorSpec generatorSpec, boolean shouldUseAPI, @NotNull CMakeListener listener2, @NotNull CPPEnvironment environment2, boolean shouldSkipCMake) {
        Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
        Intrinsics.checkNotNullParameter((Object)buildType2, (String)"buildType");
        Intrinsics.checkNotNullParameter((Object)generationDir2, (String)"generationDir");
        Intrinsics.checkNotNullParameter(additionalOptions, (String)"additionalOptions");
        Intrinsics.checkNotNullParameter(additionalEnvironment2, (String)"additionalEnvironment");
        Intrinsics.checkNotNullParameter((Object)generatorSpec, (String)"generatorSpec");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        this(new Holder(profileId, profileName, buildType2, generationDir2, additionalOptions, passSystemEnvironment, additionalEnvironment2, cmakeVersion, generatorSpec, shouldUseAPI, shouldSkipCMake), listener2, environment2);
    }

    public /* synthetic */ CMakeGeneratorParameters(int n, String string, String string2, File file, List list2, boolean bl, Map map, ToolVersion toolVersion, CMakeGeneratorSpec cMakeGeneratorSpec, boolean bl2, CMakeListener cMakeListener, CPPEnvironment cPPEnvironment, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x400) != 0) {
            cMakeListener = new CMakeListener(){};
        }
        if ((n2 & 0x1000) != 0) {
            bl3 = false;
        }
        this(n, string, string2, file, list2, bl, map, toolVersion, cMakeGeneratorSpec, bl2, cMakeListener, cPPEnvironment, bl3);
    }

    public final int getProfileId() {
        return this.holder.getProfileId();
    }

    @NotNull
    public final String getProfileName() {
        return this.holder.getProfileName();
    }

    @NotNull
    public final String getBuildType() {
        return this.holder.getBuildType();
    }

    @NotNull
    public final File getGenerationDir() {
        return this.holder.getGenerationDir();
    }

    @NotNull
    public final List<String> getAdditionalOptions() {
        return this.holder.getAdditionalOptions();
    }

    public final boolean getPassSystemEnvironment() {
        return this.holder.getPassSystemEnvironment();
    }

    @NotNull
    public final Map<String, String> getAdditionalEnvironment() {
        return this.holder.getAdditionalEnvironment();
    }

    @Nullable
    public final ToolVersion getCmakeVersion() {
        return this.holder.getCmakeVersion();
    }

    @NotNull
    public final CMakeGeneratorSpec getGeneratorSpec() {
        return this.holder.getGeneratorSpec();
    }

    public final boolean getShouldUseAPI() {
        return this.holder.getShouldUseAPI();
    }

    public final boolean getShouldSkipCMake() {
        return this.holder.getShouldSkipCMake();
    }

    @NotNull
    public final CMakeGeneratorParameters with(int profileId, @NotNull String profileName, @NotNull String buildType2, @NotNull File generationDir2, @NotNull List<String> additionalOptions, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment2, @NotNull CMakeListener listener2, @NotNull CPPEnvironment environment2, @Nullable ToolVersion cmakeVersion, @NotNull CMakeGeneratorSpec generatorSpec, boolean shouldUseAPI, boolean shouldSkipCMake) {
        Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
        Intrinsics.checkNotNullParameter((Object)buildType2, (String)"buildType");
        Intrinsics.checkNotNullParameter((Object)generationDir2, (String)"generationDir");
        Intrinsics.checkNotNullParameter(additionalOptions, (String)"additionalOptions");
        Intrinsics.checkNotNullParameter(additionalEnvironment2, (String)"additionalEnvironment");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)generatorSpec, (String)"generatorSpec");
        return new CMakeGeneratorParameters(profileId, profileName, buildType2, generationDir2, additionalOptions, passSystemEnvironment, additionalEnvironment2, cmakeVersion, generatorSpec, shouldUseAPI, listener2, environment2, shouldSkipCMake);
    }

    public static /* synthetic */ CMakeGeneratorParameters with$default(CMakeGeneratorParameters cMakeGeneratorParameters, int n, String string, String string2, File file, List list2, boolean bl, Map map, CMakeListener cMakeListener, CPPEnvironment cPPEnvironment, ToolVersion toolVersion, CMakeGeneratorSpec cMakeGeneratorSpec, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = cMakeGeneratorParameters.getProfileId();
        }
        if ((n2 & 2) != 0) {
            string = cMakeGeneratorParameters.getProfileName();
        }
        if ((n2 & 4) != 0) {
            string2 = cMakeGeneratorParameters.getBuildType();
        }
        if ((n2 & 8) != 0) {
            file = cMakeGeneratorParameters.getGenerationDir();
        }
        if ((n2 & 0x10) != 0) {
            list2 = cMakeGeneratorParameters.getAdditionalOptions();
        }
        if ((n2 & 0x20) != 0) {
            bl = cMakeGeneratorParameters.getPassSystemEnvironment();
        }
        if ((n2 & 0x40) != 0) {
            map = cMakeGeneratorParameters.getAdditionalEnvironment();
        }
        if ((n2 & 0x80) != 0) {
            cMakeListener = cMakeGeneratorParameters.listener;
        }
        if ((n2 & 0x100) != 0) {
            cPPEnvironment = cMakeGeneratorParameters.environment;
        }
        if ((n2 & 0x200) != 0) {
            toolVersion = cMakeGeneratorParameters.getCmakeVersion();
        }
        if ((n2 & 0x400) != 0) {
            cMakeGeneratorSpec = cMakeGeneratorParameters.getGeneratorSpec();
        }
        if ((n2 & 0x800) != 0) {
            bl2 = cMakeGeneratorParameters.getShouldUseAPI();
        }
        if ((n2 & 0x1000) != 0) {
            bl3 = cMakeGeneratorParameters.getShouldSkipCMake();
        }
        return cMakeGeneratorParameters.with(n, string, string2, file, list2, bl, map, cMakeListener, cPPEnvironment, toolVersion, cMakeGeneratorSpec, bl2, bl3);
    }

    @NotNull
    public final CMakeGeneratorParameters withShouldSkipCMake(boolean skip) {
        return CMakeGeneratorParameters.with$default(this, 0, null, null, null, null, false, null, null, null, null, null, false, skip, 4095, null);
    }

    @NotNull
    public final CMakeGeneratorParameters withGenerationDir(@NotNull File generationDir2) {
        Intrinsics.checkNotNullParameter((Object)generationDir2, (String)"generationDir");
        return CMakeGeneratorParameters.with$default(this, 0, null, null, generationDir2, null, false, null, null, null, null, null, false, false, 8183, null);
    }

    @NotNull
    public final CMakeGeneratorParameters withAdditionalOptions(@NotNull List<String> additionalOptions) {
        Intrinsics.checkNotNullParameter(additionalOptions, (String)"additionalOptions");
        return CMakeGeneratorParameters.with$default(this, 0, null, null, null, additionalOptions, false, null, null, null, null, null, false, false, 8175, null);
    }

    @NotNull
    public final CMakeGeneratorParameters withListener(@NotNull CMakeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return CMakeGeneratorParameters.with$default(this, 0, null, null, null, null, false, null, listener2, null, null, null, false, false, 8063, null);
    }

    @JvmStatic
    @NotNull
    public static final CMakeGeneratorParameters getFromProfile(@NotNull CMakeProfileInfo profileInfo, int profileId, @NotNull List<String> additionalOptions, @NotNull CMakeListener listener2, @Nullable ToolVersion cmakeVersion, @NotNull CMakeGeneratorSpec generatorSpec, boolean shouldUseAPI) {
        return Companion.getFromProfile(profileInfo, profileId, additionalOptions, listener2, cmakeVersion, generatorSpec, shouldUseAPI);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @TestOnly
    @Nullable
    public static final CMakeGeneratorParameters calculateFromProfile(@NotNull Project project, @NotNull CMakeSettings.Profile profile, @NotNull List<CMakeSettings.Profile> allProfiles, @NotNull ToolVersion cmakeVersion, @NotNull CPPEnvironment environment2) {
        return Companion.calculateFromProfile(project, profile, allProfiles, cmakeVersion, environment2);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @TestOnly
    @Nullable
    public static final CMakeGeneratorParameters calculateFromProfile(@Nullable Project project, @NotNull CMakeSettings.Profile profile, int profileId, @NotNull File generationDir2, @NotNull ToolVersion cmakeVersion, @NotNull CPPEnvironment environment2) {
        return Companion.calculateFromProfile(project, profile, profileId, generationDir2, cmakeVersion, environment2);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @Nullable
    public static final CMakeGeneratorParameters calculateFromProfile(@NotNull Project project, @NotNull CMakeSettings.Profile profile, int profileId, @Nullable File generationDir2) {
        return Companion.calculateFromProfile(project, profile, profileId, generationDir2);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @JvmOverloads
    @Nullable
    public static final CMakeGeneratorParameters calculateFromProfileInfo(@Nullable Project project, @NotNull CMakeProfileInfo profileInfo, int profileId, @NotNull CMakeListener listener2, @Nullable ToolVersion cmakeVersion) {
        return Companion.calculateFromProfileInfo(project, profileInfo, profileId, listener2, cmakeVersion);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @JvmOverloads
    @Nullable
    public static final CMakeGeneratorParameters calculateFromProfileInfo(@Nullable Project project, @NotNull CMakeProfileInfo profileInfo, int profileId, @NotNull CMakeListener listener2) {
        return Companion.calculateFromProfileInfo(project, profileInfo, profileId, listener2);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @JvmOverloads
    @Nullable
    public static final CMakeGeneratorParameters calculateFromProfileInfo(@Nullable Project project, @NotNull CMakeProfileInfo profileInfo, int profileId) {
        return Companion.calculateFromProfileInfo(project, profileInfo, profileId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0003J8\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006J,\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J8\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0007J<\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0007J:\u0010\u001a\u001a\u0004\u0018\u00010\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007JD\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00040 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010#\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020!J\u0018\u0010%\u001a\u0004\u0018\u00010\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\nH\u0002J\u001e\u0010(\u001a\u00020!2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010*\u001a\u00020\u000bH\u0002J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002JP\u0010-\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u000e\b\u0002\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010/\u001a\u00020!H\u0007J\u0016\u00100\u001a\u00020!2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u00061"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorParameters$Companion;", "", "()V", "calculateCMakeApiGeneratorSpec", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorSpec;", "project", "Lcom/intellij/openapi/project/Project;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "additionalCmakeOptions", "", "", "cmakeVersion", "Lcom/jetbrains/cidr/ToolVersion;", "calculateEffectiveGenerationOptions", "options", "generatorSpec", "calculateFromProfile", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorParameters;", "profile", "Lcom/jetbrains/cidr/cpp/cmake/CMakeSettings$Profile;", "profileId", "", "generationDir", "Ljava/io/File;", "allProfiles", "calculateFromProfileInfo", "profileInfo", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeProfileInfo;", "listener", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeListener;", "calculateGeneratorSpec", "Lkotlin/Pair;", "", "expandedCmakeOptions", "myCmakeVersion", "noGenerator", "clangBitnessFlag", "toolSetOptions", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolSet$Option;", "containsClangClBitnessFlag", "optionsList", "flagName", "createLegacyMakeFileGeneratorSpec", "createMakeFileGeneratorSpec", "getFromProfile", "additionalOptions", "shouldUseAPI", "hasToolchainFile", "intellij.clion.cmake"})
    @SourceDebugExtension(value={"SMAP\nCMakeGeneratorParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakeGeneratorParameters.kt\ncom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorParameters$Companion\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,486:1\n14#2:487\n350#3,7:488\n1747#3,3:498\n31#4,2:495\n1#5:497\n*S KotlinDebug\n*F\n+ 1 CMakeGeneratorParameters.kt\ncom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorParameters$Companion\n*L\n162#1:487\n193#1:488,7\n483#1:498,3\n405#1:495,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CMakeGeneratorParameters getFromProfile(@NotNull CMakeProfileInfo profileInfo, int profileId, @NotNull List<String> additionalOptions, @NotNull CMakeListener listener2, @Nullable ToolVersion cmakeVersion, @NotNull CMakeGeneratorSpec generatorSpec, boolean shouldUseAPI) {
            Intrinsics.checkNotNullParameter((Object)profileInfo, (String)"profileInfo");
            Intrinsics.checkNotNullParameter(additionalOptions, (String)"additionalOptions");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)generatorSpec, (String)"generatorSpec");
            CMakeSettings.Profile profile = profileInfo.getProfile();
            File myGenerationDir = new File(FileUtil.toCanonicalPath((String)profileInfo.getGenerationDir().getPath()));
            List<String> myAdditionalOptions = Collections.unmodifiableList(additionalOptions);
            Map<String, String> additionalEnvironment2 = profile.getAdditionalEnvironment();
            if (!additionalEnvironment2.isEmpty()) {
                additionalEnvironment2 = (Map<String, String>)new HashMap<String, String>(additionalEnvironment2);
                EnvironmentUtil.inlineParentOccurrences(additionalEnvironment2);
            }
            Map<String, String> map = Collections.unmodifiableMap(additionalEnvironment2);
            Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
            additionalEnvironment2 = map;
            CPPEnvironment cPPEnvironment = profileInfo.getEnvironment();
            Intrinsics.checkNotNull((Object)cPPEnvironment);
            CPPEnvironment environment2 = cPPEnvironment;
            if (CMakeMSVCUtilsKt.shouldRunCMakeWithoutVcVarsEnvironment(generatorSpec.getGenerator(), environment2)) {
                CPPEnvironment cPPEnvironment2 = environment2.clone();
                Intrinsics.checkNotNullExpressionValue((Object)cPPEnvironment2, (String)"clone(...)");
                environment2 = cPPEnvironment2;
                CPPToolSet $this$asSafely$iv = environment2.getToolSet();
                boolean $i$f$asSafely = false;
                CPPToolSet cPPToolSet = $this$asSafely$iv;
                if (!(cPPToolSet instanceof MSVC)) {
                    cPPToolSet = null;
                }
                MSVC mSVC = (MSVC)cPPToolSet;
                if (mSVC != null) {
                    mSVC.setUseVcVars(false);
                }
            }
            String string = profile.getName();
            String string2 = profile.getBuildType();
            boolean bl = profile.getPassSystemEnvironment();
            Map<String, String> map2 = additionalEnvironment2;
            CPPEnvironment cPPEnvironment3 = environment2;
            Intrinsics.checkNotNull(myAdditionalOptions);
            return new CMakeGeneratorParameters(profileId, string, string2, myGenerationDir, myAdditionalOptions, bl, map2, cmakeVersion, generatorSpec, shouldUseAPI, listener2, cPPEnvironment3, false, 4096, null);
        }

        public static /* synthetic */ CMakeGeneratorParameters getFromProfile$default(Companion companion, CMakeProfileInfo cMakeProfileInfo, int n, List list2, CMakeListener cMakeListener, ToolVersion toolVersion, CMakeGeneratorSpec cMakeGeneratorSpec, boolean bl, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n2 & 8) != 0) {
                cMakeListener = new CMakeListener(){};
            }
            if ((n2 & 0x10) != 0) {
                toolVersion = null;
            }
            return companion.getFromProfile(cMakeProfileInfo, n, list2, cMakeListener, toolVersion, cMakeGeneratorSpec, bl);
        }

        @JvmStatic
        @RequiresBackgroundThread
        @TestOnly
        @Nullable
        public final CMakeGeneratorParameters calculateFromProfile(@NotNull Project project, @NotNull CMakeSettings.Profile profile, @NotNull List<CMakeSettings.Profile> allProfiles, @NotNull ToolVersion cmakeVersion, @NotNull CPPEnvironment environment2) {
            int profileId;
            block3: {
                int n;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
                Intrinsics.checkNotNullParameter(allProfiles, (String)"allProfiles");
                Intrinsics.checkNotNullParameter((Object)cmakeVersion, (String)"cmakeVersion");
                Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
                List<CMakeSettings.Profile> $this$indexOfFirst$iv = allProfiles;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<CMakeSettings.Profile> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    CMakeSettings.Profile item$iv;
                    CMakeSettings.Profile it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getName(), (Object)profile.getName())) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = profileId = -1;
            }
            if (profileId == -1) {
                return null;
            }
            File generationDir2 = (File)CMakeSettings.Companion.getEffectiveProfileGenerationDirs$default(CMakeSettings.Companion, project, allProfiles, null, 4, null).get(profileId);
            CMakeProfileInfo profileInfo = new CMakeProfileInfo(profile, generationDir2, environment2, new EnvironmentProblems());
            return com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters$Companion.calculateFromProfileInfo$default(this, project, profileInfo, profileId, null, cmakeVersion, 8, null);
        }

        @JvmStatic
        @RequiresBackgroundThread
        @TestOnly
        @Nullable
        public final CMakeGeneratorParameters calculateFromProfile(@Nullable Project project, @NotNull CMakeSettings.Profile profile, int profileId, @NotNull File generationDir2, @NotNull ToolVersion cmakeVersion, @NotNull CPPEnvironment environment2) {
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            Intrinsics.checkNotNullParameter((Object)generationDir2, (String)"generationDir");
            Intrinsics.checkNotNullParameter((Object)cmakeVersion, (String)"cmakeVersion");
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            CMakeProfileInfo profileInfo = new CMakeProfileInfo(profile, generationDir2, environment2, new EnvironmentProblems());
            return com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters$Companion.calculateFromProfileInfo$default(this, project, profileInfo, profileId, null, cmakeVersion, 8, null);
        }

        @JvmStatic
        @RequiresBackgroundThread
        @Nullable
        public final CMakeGeneratorParameters calculateFromProfile(@NotNull Project project, @NotNull CMakeSettings.Profile profile, int profileId, @Nullable File generationDir2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            if (generationDir2 == null) {
                return null;
            }
            CMakeProfileInfo profileInfo = CMakeProfileInfo.Companion.collect$default(CMakeProfileInfo.Companion, project, profile, generationDir2, profileId, false, null, 32, null);
            if (profileInfo.getEnvironmentAndCMakeProblems().hasProblems() || profileInfo.getEnvironment() == null) {
                return null;
            }
            return com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters$Companion.calculateFromProfileInfo$default(this, project, profileInfo, profileId, null, null, 24, null);
        }

        @JvmStatic
        @RequiresBackgroundThread
        @JvmOverloads
        @Nullable
        public final CMakeGeneratorParameters calculateFromProfileInfo(@Nullable Project project, @NotNull CMakeProfileInfo profileInfo, int profileId, @NotNull CMakeListener listener2, @Nullable ToolVersion cmakeVersion) {
            Intrinsics.checkNotNullParameter((Object)profileInfo, (String)"profileInfo");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            if (profileInfo.getEnvironmentAndCMakeProblems().hasProblems() || profileInfo.getEnvironment() == null) {
                return null;
            }
            ToolVersion toolVersion = cmakeVersion;
            if (toolVersion == null) {
                toolVersion = CMakeExecutableTool.readCMakeToolVersion(profileInfo.getEnvironment());
            }
            ToolVersion myCmakeVersion = toolVersion;
            ProgressManager.checkCanceled();
            List<String> expandedCmakeOptions = profileInfo.getProfile().expandGenerationOptionsMacros(profileInfo.getEnvironment(), project);
            Pair<Boolean, CMakeGeneratorSpec> pair = this.calculateGeneratorSpec(expandedCmakeOptions, myCmakeVersion, project, profileInfo.getEnvironment(), profileInfo.getProfile().getNoGenerator());
            boolean shouldUseCMakeAPI = (Boolean)pair.component1();
            CMakeGeneratorSpec generatorSpec = (CMakeGeneratorSpec)pair.component2();
            List<String> effectiveGenerationOptions = this.calculateEffectiveGenerationOptions(expandedCmakeOptions, generatorSpec, profileInfo.getEnvironment(), project);
            return this.getFromProfile(profileInfo, profileId, effectiveGenerationOptions, listener2, myCmakeVersion, generatorSpec, shouldUseCMakeAPI);
        }

        public static /* synthetic */ CMakeGeneratorParameters calculateFromProfileInfo$default(Companion companion, Project project, CMakeProfileInfo cMakeProfileInfo, int n, CMakeListener cMakeListener, ToolVersion toolVersion, int n2, Object object) {
            if ((n2 & 8) != 0) {
                cMakeListener = new CMakeListener(){};
            }
            if ((n2 & 0x10) != 0) {
                toolVersion = null;
            }
            return companion.calculateFromProfileInfo(project, cMakeProfileInfo, n, cMakeListener, toolVersion);
        }

        @NotNull
        public final Pair<Boolean, CMakeGeneratorSpec> calculateGeneratorSpec(@NotNull List<String> expandedCmakeOptions, @Nullable ToolVersion myCmakeVersion, @Nullable Project project, @NotNull CPPEnvironment environment2, boolean noGenerator) {
            Intrinsics.checkNotNullParameter(expandedCmakeOptions, (String)"expandedCmakeOptions");
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            boolean shouldUseCMakeAPI = CMakeGeneratorUtils.shouldUseAPI(expandedCmakeOptions, myCmakeVersion, noGenerator, environment2);
            CMakeGeneratorSpec generatorSpec = noGenerator ? CMakeGeneratorSpec.NONE : (shouldUseCMakeAPI ? this.calculateCMakeApiGeneratorSpec(project, environment2, expandedCmakeOptions, myCmakeVersion) : this.createLegacyMakeFileGeneratorSpec(environment2));
            return new Pair((Object)shouldUseCMakeAPI, (Object)generatorSpec);
        }

        private final CMakeGeneratorSpec createLegacyMakeFileGeneratorSpec(CPPEnvironment environment2) {
            return CMakeGeneratorSpec.Companion.createDefaultLegacyGeneratorSpec(environment2.getToolSet(), true);
        }

        private final CMakeGeneratorSpec createMakeFileGeneratorSpec(CPPEnvironment environment2) {
            if (Registry.is((String)"cmake.use.code.blocks")) {
                return this.createLegacyMakeFileGeneratorSpec(environment2);
            }
            return CMakeGeneratorSpec.Companion.createDefaultLegacyGeneratorSpec(environment2.getToolSet(), false);
        }

        @RequiresBackgroundThread
        private final CMakeGeneratorSpec calculateCMakeApiGeneratorSpec(Project project, CPPEnvironment environment2, List<String> additionalCmakeOptions, ToolVersion cmakeVersion) {
            block13: {
                block12: {
                    CMakeGeneratorSpec userSpecifiedGenerator = CMakeGeneratorUtils.getUserSpecifiedGeneratorSpec(additionalCmakeOptions);
                    if (userSpecifiedGenerator != null) {
                        return userSpecifiedGenerator;
                    }
                    if (project == null) break block12;
                    CidrProjectApplicationVersion cidrProjectApplicationVersion = CidrProjectApplicationVersion.Companion.getInstance(project);
                    Version version = CMakeGeneratorUtils.BUILD_TOOL_AS_GENERATOR_IDE_VERSION;
                    Intrinsics.checkNotNullExpressionValue((Object)version, (String)"BUILD_TOOL_AS_GENERATOR_IDE_VERSION");
                    if (!cidrProjectApplicationVersion.isProjectCreatedAfterVersion(version)) break block13;
                }
                if (environment2.getNinja() != null) {
                    return new CMakeGeneratorSpec(CMakeGeneratorType.NINJA.INSTANCE, null, 2, null);
                }
                if (environment2.getMake() != null) {
                    return this.createMakeFileGeneratorSpec(environment2);
                }
            }
            if (AdvancedSettings.Companion.getBoolean("cmake.use.legacy.generator.by.default")) {
                return this.createLegacyMakeFileGeneratorSpec(environment2);
            }
            if (environment2.getHostMachine().isRemote()) {
                return this.createMakeFileGeneratorSpec(environment2);
            }
            if (project != null) {
                CidrProjectApplicationVersion cidrProjectApplicationVersion = CidrProjectApplicationVersion.Companion.getInstance(project);
                Version version = CMakeGeneratorUtils.NINJA_NEW_PROJECT_IDE_VERSION;
                Intrinsics.checkNotNullExpressionValue((Object)version, (String)"NINJA_NEW_PROJECT_IDE_VERSION");
                if (!cidrProjectApplicationVersion.isProjectCreatedAfterVersion(version)) {
                    return this.createMakeFileGeneratorSpec(environment2);
                }
            }
            if (cmakeVersion == null || cmakeVersion.isUnknown()) {
                return CMakeGeneratorSpec.Companion.createDefaultAPIGeneratorSpec();
            }
            if (CPPToolchainsUtil.compareVersions(CMakeGeneratorUtils.API_DEFAULT_CMAKE_VERSION, cmakeVersion.versionNumber) < 0) {
                return this.createMakeFileGeneratorSpec(environment2);
            }
            return CMakeGeneratorSpec.Companion.createDefaultAPIGeneratorSpec();
        }

        @NotNull
        public final List<String> calculateEffectiveGenerationOptions(@NotNull List<String> options, @NotNull CMakeGeneratorSpec generatorSpec, @Nullable CPPEnvironment environment2, @Nullable Project project) {
            List<Object> optionsList;
            ArrayList result2;
            block26: {
                String bitnessFlag;
                boolean hasToolchainFile;
                CPPToolchains.Toolchain $this$calculateEffectiveGenerationOptions_u24lambda_u244;
                block29: {
                    block27: {
                        block28: {
                            String it;
                            CPPToolchains.Toolchain toolchain;
                            Intrinsics.checkNotNullParameter(options, (String)"options");
                            Intrinsics.checkNotNullParameter((Object)generatorSpec, (String)"generatorSpec");
                            CPPLog.LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isReadAccessAllowed());
                            String presetName = PresetKt.getPresetName(options);
                            if (presetName != null && project != null) {
                                try {
                                    ConfigurePreset<?> preset;
                                    ComponentManager $this$service$iv = (ComponentManager)project;
                                    boolean $i$f$service = false;
                                    Class<CMakePresetLoader> serviceClass$iv = CMakePresetLoader.class;
                                    Object object = $this$service$iv.getService(serviceClass$iv);
                                    if (object == null) {
                                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                    }
                                    ConfigurePreset<?> configurePreset2 = preset = ((CMakePresetLoader)object).loadProjectSchema().getConfigurePresetsMap().get(presetName);
                                    if ((configurePreset2 != null ? configurePreset2.getToolchainName() : null) == null) {
                                        return options;
                                    }
                                }
                                catch (PresetParsingException e) {
                                    CPPLog.LOG.warn("--preset option is used, but preset files cannot be read, cannot apply preset-specific handling", (Throwable)e);
                                }
                            }
                            result2 = new ArrayList();
                            if (environment2 != null && !CMakeGeneratorUtils.hasUserSpecifiedMakeProgram(options)) {
                                Ninja cmakeMakeProgram;
                                Object object;
                                if (CMakeGeneratorType.Companion.isNinja(generatorSpec.getGenerator())) {
                                    Ninja toolchainNinja = environment2.getNinja();
                                    object = toolchainNinja;
                                    if (object == null || (object = ((CidrExecutableTool)object).getExecutablePath()) == null) {
                                        Path path = Ninja.Companion.getBundledNinja(environment2);
                                        object = path != null ? ((Object)path).toString() : null;
                                    }
                                } else if (CMakeGeneratorType.Companion.isMakefileGenerator(generatorSpec.getGenerator())) {
                                    Make make = environment2.getMake();
                                    object = make != null ? make.getExecutablePath() : null;
                                } else {
                                    object = null;
                                }
                                Ninja ninja = cmakeMakeProgram = object;
                                if (ninja != null) {
                                    Ninja it2 = ninja;
                                    boolean bl = false;
                                    ((Collection)result2).add("-DCMAKE_MAKE_PROGRAM=" + com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters$Companion.calculateEffectiveGenerationOptions$toEnvPath(environment2, (String)((Object)it2)));
                                }
                            }
                            CPPEnvironment cPPEnvironment = environment2;
                            CPPToolchains.Toolchain toolchain2 = cPPEnvironment != null ? cPPEnvironment.getToolchain() : null;
                            optionsList = null;
                            optionsList = new ArrayList(options);
                            CPPToolchains.Toolchain toolchain3 = toolchain2;
                            if (toolchain3 == null) break block26;
                            $this$calculateEffectiveGenerationOptions_u24lambda_u244 = toolchain = toolchain3;
                            boolean bl = false;
                            String string = $this$calculateEffectiveGenerationOptions_u24lambda_u244.getCustomCCompilerPath();
                            if (string != null) {
                                it = string;
                                boolean bl2 = false;
                                Collection collection = result2;
                                Intrinsics.checkNotNull((Object)it);
                                collection.add("-DCMAKE_C_COMPILER=" + com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters$Companion.calculateEffectiveGenerationOptions$toEnvPath(environment2, it));
                            }
                            String string2 = $this$calculateEffectiveGenerationOptions_u24lambda_u244.getCustomCXXCompilerPath();
                            if (string2 != null) {
                                it = string2;
                                boolean bl3 = false;
                                Collection collection = result2;
                                Intrinsics.checkNotNull((Object)it);
                                collection.add("-DCMAKE_CXX_COMPILER=" + com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters$Companion.calculateEffectiveGenerationOptions$toEnvPath(environment2, it));
                            }
                            hasToolchainFile = Companion.hasToolchainFile((List<String>)optionsList);
                            if ($this$calculateEffectiveGenerationOptions_u24lambda_u244.getCustomCCompilerPath() == null) break block27;
                            String string3 = $this$calculateEffectiveGenerationOptions_u24lambda_u244.getCustomCCompilerPath();
                            Intrinsics.checkNotNull((Object)string3);
                            if (StringsKt.endsWith$default((String)string3, (String)"clang-cl", (boolean)false, (int)2, null)) break block28;
                            String string4 = $this$calculateEffectiveGenerationOptions_u24lambda_u244.getCustomCCompilerPath();
                            Intrinsics.checkNotNull((Object)string4);
                            if (!StringsKt.endsWith$default((String)string4, (String)"clang-cl.exe", (boolean)false, (int)2, null)) break block27;
                        }
                        if (!hasToolchainFile) {
                            List<CPPToolSet.Option> list2 = $this$calculateEffectiveGenerationOptions_u24lambda_u244.getToolSetOptions();
                            Intrinsics.checkNotNullExpressionValue(list2, (String)"getToolSetOptions(...)");
                            bitnessFlag = Companion.clangBitnessFlag(list2);
                            if (bitnessFlag != null && !Companion.containsClangClBitnessFlag((List<String>)optionsList, "-DCMAKE_C_FLAGS")) {
                                optionsList = CMakeSettings.Companion.addCFlags((List<String>)optionsList, bitnessFlag);
                            }
                        }
                    }
                    if ($this$calculateEffectiveGenerationOptions_u24lambda_u244.getCustomCXXCompilerPath() == null) break block26;
                    String string = $this$calculateEffectiveGenerationOptions_u24lambda_u244.getCustomCXXCompilerPath();
                    Intrinsics.checkNotNull((Object)string);
                    if (StringsKt.endsWith$default((String)string, (String)"clang-cl", (boolean)false, (int)2, null)) break block29;
                    String string5 = $this$calculateEffectiveGenerationOptions_u24lambda_u244.getCustomCXXCompilerPath();
                    Intrinsics.checkNotNull((Object)string5);
                    if (!StringsKt.endsWith$default((String)string5, (String)"clang-cl.exe", (boolean)false, (int)2, null)) break block26;
                }
                if (!hasToolchainFile) {
                    List<CPPToolSet.Option> list3 = $this$calculateEffectiveGenerationOptions_u24lambda_u244.getToolSetOptions();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"getToolSetOptions(...)");
                    bitnessFlag = Companion.clangBitnessFlag(list3);
                    if (bitnessFlag != null && !Companion.containsClangClBitnessFlag((List<String>)optionsList, "-DCMAKE_CXX_FLAGS")) {
                        optionsList = CMakeSettings.Companion.addCxxFlags((List<String>)optionsList, bitnessFlag);
                    }
                }
            }
            CollectionsKt.addAll((Collection)result2, (Iterable)optionsList);
            return result2;
        }

        public static /* synthetic */ List calculateEffectiveGenerationOptions$default(Companion companion, List list2, CMakeGeneratorSpec cMakeGeneratorSpec, CPPEnvironment cPPEnvironment, Project project, int n, Object object) {
            if ((n & 8) != 0) {
                project = null;
            }
            return companion.calculateEffectiveGenerationOptions(list2, cMakeGeneratorSpec, cPPEnvironment, project);
        }

        private final String clangBitnessFlag(List<? extends CPPToolSet.Option> toolSetOptions) {
            MSVC.Arch first = (MSVC.Arch)MSVC.getOptions(toolSetOptions).component1();
            return MSVC.getClangClBitnessFlag(first);
        }

        private final boolean containsClangClBitnessFlag(List<String> optionsList, String flagName) {
            int flagIndex = CMakeSettings.Companion.findFlagIndex(optionsList, flagName);
            if (flagIndex < 0) {
                return false;
            }
            String flagValue = CMakeSettings.Companion.getFlagValue(optionsList.get(flagIndex));
            return StringsKt.startsWith$default((String)flagValue, (String)"-m", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)flagValue, (CharSequence)" -m", (boolean)false, (int)2, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasToolchainFile(List<String> options) {
            String it;
            if (CMakeGeneratorUtils.hasUserSpecifiedCMakeVariable(options, "CMAKE_TOOLCHAIN_FILE")) return true;
            Iterable $this$any$iv = options;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl = false;
            } while (!StringsKt.startsWith$default((String)it, (String)"--toolchain", (boolean)false, (int)2, null));
            return true;
        }

        @JvmStatic
        @RequiresBackgroundThread
        @JvmOverloads
        @Nullable
        public final CMakeGeneratorParameters calculateFromProfileInfo(@Nullable Project project, @NotNull CMakeProfileInfo profileInfo, int profileId, @NotNull CMakeListener listener2) {
            Intrinsics.checkNotNullParameter((Object)profileInfo, (String)"profileInfo");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            return com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters$Companion.calculateFromProfileInfo$default(this, project, profileInfo, profileId, listener2, null, 16, null);
        }

        @JvmStatic
        @RequiresBackgroundThread
        @JvmOverloads
        @Nullable
        public final CMakeGeneratorParameters calculateFromProfileInfo(@Nullable Project project, @NotNull CMakeProfileInfo profileInfo, int profileId) {
            Intrinsics.checkNotNullParameter((Object)profileInfo, (String)"profileInfo");
            return com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters$Companion.calculateFromProfileInfo$default(this, project, profileInfo, profileId, null, null, 24, null);
        }

        private static final String calculateEffectiveGenerationOptions$toEnvPath(CPPEnvironment $environment, String path) {
            CPPEnvironment cPPEnvironment = $environment;
            String string = cPPEnvironment != null ? cPPEnvironment.toEnvPath(path) : null;
            if (string == null) {
                string = path;
            }
            String string2 = FileUtil.toSystemIndependentName((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001Bs\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\f\u0012\b\b\u0002\u0010\u0014\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0015J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\fH\u00c6\u0003J\t\u0010+\u001a\u00020\fH\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J\t\u0010-\u001a\u00020\u0005H\u00c6\u0003J\t\u0010.\u001a\u00020\bH\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u00c6\u0003J\t\u00100\u001a\u00020\fH\u00c6\u0003J\u0015\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000eH\u00c6\u0003J\u000b\u00102\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\t\u00103\u001a\u00020\u0012H\u00c6\u0003J\u008b\u0001\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\fH\u00c6\u0001J\u0013\u00105\u001a\u00020\f2\b\u00106\u001a\u0004\u0018\u000107H\u00d6\u0003J\t\u00108\u001a\u00020\u0003H\u00d6\u0001J\t\u00109\u001a\u00020\u0005H\u00d6\u0001R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001bR\u0011\u0010\u0014\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010#R\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010#\u00a8\u0006:"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorParameters$Holder;", "Ljava/io/Serializable;", "profileId", "", "profileName", "", "buildType", "generationDir", "Ljava/io/File;", "additionalOptions", "", "passSystemEnvironment", "", "additionalEnvironment", "", "cmakeVersion", "Lcom/jetbrains/cidr/ToolVersion;", "generatorSpec", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorSpec;", "shouldUseAPI", "shouldSkipCMake", "(ILjava/lang/String;Ljava/lang/String;Ljava/io/File;Ljava/util/List;ZLjava/util/Map;Lcom/jetbrains/cidr/ToolVersion;Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorSpec;ZZ)V", "getAdditionalEnvironment", "()Ljava/util/Map;", "getAdditionalOptions", "()Ljava/util/List;", "getBuildType", "()Ljava/lang/String;", "getCmakeVersion", "()Lcom/jetbrains/cidr/ToolVersion;", "getGenerationDir", "()Ljava/io/File;", "getGeneratorSpec", "()Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorSpec;", "getPassSystemEnvironment", "()Z", "getProfileId", "()I", "getProfileName", "getShouldSkipCMake", "getShouldUseAPI", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "toString", "intellij.clion.cmake"})
    public static final class Holder
    implements Serializable {
        private final int profileId;
        @NotNull
        private final String profileName;
        @NotNull
        private final String buildType;
        @NotNull
        private final File generationDir;
        @NotNull
        private final List<String> additionalOptions;
        private final boolean passSystemEnvironment;
        @NotNull
        private final Map<String, String> additionalEnvironment;
        @Nullable
        private final ToolVersion cmakeVersion;
        @NotNull
        private final CMakeGeneratorSpec generatorSpec;
        private final boolean shouldUseAPI;
        private final boolean shouldSkipCMake;

        public Holder(int profileId, @NotNull String profileName, @NotNull String buildType2, @NotNull File generationDir2, @NotNull List<String> additionalOptions, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment2, @Nullable ToolVersion cmakeVersion, @NotNull CMakeGeneratorSpec generatorSpec, boolean shouldUseAPI, boolean shouldSkipCMake) {
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            Intrinsics.checkNotNullParameter((Object)buildType2, (String)"buildType");
            Intrinsics.checkNotNullParameter((Object)generationDir2, (String)"generationDir");
            Intrinsics.checkNotNullParameter(additionalOptions, (String)"additionalOptions");
            Intrinsics.checkNotNullParameter(additionalEnvironment2, (String)"additionalEnvironment");
            Intrinsics.checkNotNullParameter((Object)generatorSpec, (String)"generatorSpec");
            this.profileId = profileId;
            this.profileName = profileName;
            this.buildType = buildType2;
            this.generationDir = generationDir2;
            this.additionalOptions = additionalOptions;
            this.passSystemEnvironment = passSystemEnvironment;
            this.additionalEnvironment = additionalEnvironment2;
            this.cmakeVersion = cmakeVersion;
            this.generatorSpec = generatorSpec;
            this.shouldUseAPI = shouldUseAPI;
            this.shouldSkipCMake = shouldSkipCMake;
        }

        public /* synthetic */ Holder(int n, String string, String string2, File file, List list2, boolean bl, Map map, ToolVersion toolVersion, CMakeGeneratorSpec cMakeGeneratorSpec, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x400) != 0) {
                bl3 = false;
            }
            this(n, string, string2, file, list2, bl, map, toolVersion, cMakeGeneratorSpec, bl2, bl3);
        }

        public final int getProfileId() {
            return this.profileId;
        }

        @NotNull
        public final String getProfileName() {
            return this.profileName;
        }

        @NotNull
        public final String getBuildType() {
            return this.buildType;
        }

        @NotNull
        public final File getGenerationDir() {
            return this.generationDir;
        }

        @NotNull
        public final List<String> getAdditionalOptions() {
            return this.additionalOptions;
        }

        public final boolean getPassSystemEnvironment() {
            return this.passSystemEnvironment;
        }

        @NotNull
        public final Map<String, String> getAdditionalEnvironment() {
            return this.additionalEnvironment;
        }

        @Nullable
        public final ToolVersion getCmakeVersion() {
            return this.cmakeVersion;
        }

        @NotNull
        public final CMakeGeneratorSpec getGeneratorSpec() {
            return this.generatorSpec;
        }

        public final boolean getShouldUseAPI() {
            return this.shouldUseAPI;
        }

        public final boolean getShouldSkipCMake() {
            return this.shouldSkipCMake;
        }

        public final int component1() {
            return this.profileId;
        }

        @NotNull
        public final String component2() {
            return this.profileName;
        }

        @NotNull
        public final String component3() {
            return this.buildType;
        }

        @NotNull
        public final File component4() {
            return this.generationDir;
        }

        @NotNull
        public final List<String> component5() {
            return this.additionalOptions;
        }

        public final boolean component6() {
            return this.passSystemEnvironment;
        }

        @NotNull
        public final Map<String, String> component7() {
            return this.additionalEnvironment;
        }

        @Nullable
        public final ToolVersion component8() {
            return this.cmakeVersion;
        }

        @NotNull
        public final CMakeGeneratorSpec component9() {
            return this.generatorSpec;
        }

        public final boolean component10() {
            return this.shouldUseAPI;
        }

        public final boolean component11() {
            return this.shouldSkipCMake;
        }

        @NotNull
        public final Holder copy(int profileId, @NotNull String profileName, @NotNull String buildType2, @NotNull File generationDir2, @NotNull List<String> additionalOptions, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment2, @Nullable ToolVersion cmakeVersion, @NotNull CMakeGeneratorSpec generatorSpec, boolean shouldUseAPI, boolean shouldSkipCMake) {
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            Intrinsics.checkNotNullParameter((Object)buildType2, (String)"buildType");
            Intrinsics.checkNotNullParameter((Object)generationDir2, (String)"generationDir");
            Intrinsics.checkNotNullParameter(additionalOptions, (String)"additionalOptions");
            Intrinsics.checkNotNullParameter(additionalEnvironment2, (String)"additionalEnvironment");
            Intrinsics.checkNotNullParameter((Object)generatorSpec, (String)"generatorSpec");
            return new Holder(profileId, profileName, buildType2, generationDir2, additionalOptions, passSystemEnvironment, additionalEnvironment2, cmakeVersion, generatorSpec, shouldUseAPI, shouldSkipCMake);
        }

        public static /* synthetic */ Holder copy$default(Holder holder, int n, String string, String string2, File file, List list2, boolean bl, Map map, ToolVersion toolVersion, CMakeGeneratorSpec cMakeGeneratorSpec, boolean bl2, boolean bl3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = holder.profileId;
            }
            if ((n2 & 2) != 0) {
                string = holder.profileName;
            }
            if ((n2 & 4) != 0) {
                string2 = holder.buildType;
            }
            if ((n2 & 8) != 0) {
                file = holder.generationDir;
            }
            if ((n2 & 0x10) != 0) {
                list2 = holder.additionalOptions;
            }
            if ((n2 & 0x20) != 0) {
                bl = holder.passSystemEnvironment;
            }
            if ((n2 & 0x40) != 0) {
                map = holder.additionalEnvironment;
            }
            if ((n2 & 0x80) != 0) {
                toolVersion = holder.cmakeVersion;
            }
            if ((n2 & 0x100) != 0) {
                cMakeGeneratorSpec = holder.generatorSpec;
            }
            if ((n2 & 0x200) != 0) {
                bl2 = holder.shouldUseAPI;
            }
            if ((n2 & 0x400) != 0) {
                bl3 = holder.shouldSkipCMake;
            }
            return holder.copy(n, string, string2, file, list2, bl, map, toolVersion, cMakeGeneratorSpec, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "Holder(profileId=" + this.profileId + ", profileName=" + this.profileName + ", buildType=" + this.buildType + ", generationDir=" + this.generationDir + ", additionalOptions=" + this.additionalOptions + ", passSystemEnvironment=" + this.passSystemEnvironment + ", additionalEnvironment=" + this.additionalEnvironment + ", cmakeVersion=" + this.cmakeVersion + ", generatorSpec=" + this.generatorSpec + ", shouldUseAPI=" + this.shouldUseAPI + ", shouldSkipCMake=" + this.shouldSkipCMake + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.profileId);
            result2 = result2 * 31 + this.profileName.hashCode();
            result2 = result2 * 31 + this.buildType.hashCode();
            result2 = result2 * 31 + this.generationDir.hashCode();
            result2 = result2 * 31 + ((Object)this.additionalOptions).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.passSystemEnvironment);
            result2 = result2 * 31 + ((Object)this.additionalEnvironment).hashCode();
            result2 = result2 * 31 + (this.cmakeVersion == null ? 0 : this.cmakeVersion.hashCode());
            result2 = result2 * 31 + this.generatorSpec.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.shouldUseAPI);
            result2 = result2 * 31 + Boolean.hashCode(this.shouldSkipCMake);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Holder)) {
                return false;
            }
            Holder holder = (Holder)other;
            if (this.profileId != holder.profileId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.profileName, (Object)holder.profileName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.buildType, (Object)holder.buildType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.generationDir, (Object)holder.generationDir)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.additionalOptions, holder.additionalOptions)) {
                return false;
            }
            if (this.passSystemEnvironment != holder.passSystemEnvironment) {
                return false;
            }
            if (!Intrinsics.areEqual(this.additionalEnvironment, holder.additionalEnvironment)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cmakeVersion, (Object)holder.cmakeVersion)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.generatorSpec, (Object)holder.generatorSpec)) {
                return false;
            }
            if (this.shouldUseAPI != holder.shouldUseAPI) {
                return false;
            }
            return this.shouldSkipCMake == holder.shouldSkipCMake;
        }
    }
}

