/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeFileSettings
implements Serializable {
    @NotNull
    private final OCLanguageKind myLanguageKind;
    @Nullable
    private final String myObjectTargetName;
    @NotNull
    private final List<String> myLeadingFlags;
    @NotNull
    private final List<String> myTrailingFlags;
    @NotNull
    private final List<String> myDefines;
    private final boolean myIsModule;

    public CMakeFileSettings(@NotNull OCLanguageKind languageKind, @Nullable String objectTargetName, @NotNull List<String> leadingFlags, @NotNull List<String> trailingFlags, @NotNull List<String> defines) {
        if (languageKind == null) {
            CMakeFileSettings.$$$reportNull$$$0(0);
        }
        if (leadingFlags == null) {
            CMakeFileSettings.$$$reportNull$$$0(1);
        }
        if (trailingFlags == null) {
            CMakeFileSettings.$$$reportNull$$$0(2);
        }
        if (defines == null) {
            CMakeFileSettings.$$$reportNull$$$0(3);
        }
        this(languageKind, objectTargetName, leadingFlags, trailingFlags, defines, false);
    }

    public CMakeFileSettings(@NotNull OCLanguageKind languageKind, @Nullable String objectTargetName, @NotNull List<String> leadingFlags, @NotNull List<String> trailingFlags, @NotNull List<String> defines, boolean isModule) {
        if (languageKind == null) {
            CMakeFileSettings.$$$reportNull$$$0(4);
        }
        if (leadingFlags == null) {
            CMakeFileSettings.$$$reportNull$$$0(5);
        }
        if (trailingFlags == null) {
            CMakeFileSettings.$$$reportNull$$$0(6);
        }
        if (defines == null) {
            CMakeFileSettings.$$$reportNull$$$0(7);
        }
        this.myLanguageKind = languageKind;
        this.myObjectTargetName = objectTargetName;
        this.myLeadingFlags = Collections.unmodifiableList(ContainerUtil.trimToSize(leadingFlags));
        this.myTrailingFlags = Collections.unmodifiableList(ContainerUtil.trimToSize(trailingFlags));
        this.myDefines = Collections.unmodifiableList(ContainerUtil.trimToSize(defines));
        this.myIsModule = isModule;
    }

    @NotNull
    public OCLanguageKind getLanguageKind() {
        OCLanguageKind oCLanguageKind = this.myLanguageKind;
        if (oCLanguageKind == null) {
            CMakeFileSettings.$$$reportNull$$$0(8);
        }
        return oCLanguageKind;
    }

    public boolean hasCustomSettings() {
        return !this.myLeadingFlags.isEmpty() || !this.myTrailingFlags.isEmpty() || !this.myDefines.isEmpty();
    }

    @Nullable
    public String getObjectTargetName() {
        return this.myObjectTargetName;
    }

    @NotNull
    public List<String> getLeadingFlags() {
        List<String> list2 = this.myLeadingFlags;
        if (list2 == null) {
            CMakeFileSettings.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    public List<String> getTrailingFlags() {
        List<String> list2 = this.myTrailingFlags;
        if (list2 == null) {
            CMakeFileSettings.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public List<String> getDefines() {
        List<String> list2 = this.myDefines;
        if (list2 == null) {
            CMakeFileSettings.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NonNls
    public String toString() {
        return "FileSettings: {LanguageKind=" + this.myLanguageKind + "}";
    }

    public boolean isModule() {
        return this.myIsModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leadingFlags";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trailingFlags";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defines";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeFileSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeFileSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageKind";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadingFlags";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrailingFlags";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

