/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCodeBlocks;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCompiler;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurationSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFlagsFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorCommonInfo;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorSpec;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorUtils;
import com.jetbrains.cidr.cpp.cmake.model.CMakeListener;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMakeFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeProfileGenerationResult;
import com.jetbrains.cidr.cpp.cmake.model.CMakeProfileTargetInfo;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeStatisticsCollector;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cmake.psi.CMakeFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CMakeFileProfileGenerationResult
extends CMakeProfileGenerationResult {
    private static final Pattern CMAKE_COMPILER_FILE_PATTERN = Pattern.compile("CMakeFiles/(?:[^/]+/)?CMake(\\w+)Compiler\\.cmake", SystemInfo.isFileSystemCaseSensitive ? 0 : 2);
    @Nullable
    private final CMakeModel myPreviousModel;
    @Nullable
    private String myProjectName;
    @NotNull
    String myActualBuildType;
    @NotNull
    Collection<TargetInfo> myTargetInfos;
    @NotNull
    Map<File, CMakeGeneratorUtils.CudaTargetInfo> myCudaTargetsInfo;

    CMakeFileProfileGenerationResult(@NotNull CMakeGenerator generator2, @NotNull CMakeGeneratorParameters parameters2, @Nullable CMakeModel previousModel) {
        if (generator2 == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(0);
        }
        if (parameters2 == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(1);
        }
        super(generator2, parameters2);
        this.myTargetInfos = Collections.emptyList();
        this.myCudaTargetsInfo = FileCollectionFactory.createCanonicalFileMap();
        this.myPreviousModel = previousModel;
    }

    @Override
    @NotNull
    public Collection<? extends CMakeProfileTargetInfo> getTargetInfos() {
        Collection<TargetInfo> collection = this.myTargetInfos;
        if (collection == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Override
    @NotNull
    protected List<String> getExtraGeneratorOptions() {
        ToolVersion cmakeVersion = this.parameters.getCmakeVersion();
        List<String> list2 = cmakeVersion != null && cmakeVersion.versionNumber.isOrGreaterThan(Integer.valueOf(3), Integer.valueOf(20)) ? Collections.singletonList("-DCMAKE_DEPENDS_USE_COMPILER=FALSE") : Collections.emptyList();
        if (list2 == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    protected void loadInfo(@NotNull File generationDir2, @NotNull CMakeGeneratorCommonInfo commonInfo) {
        CMakeCacheFile loadedCacheFile;
        block9: {
            if (generationDir2 == null) {
                CMakeFileProfileGenerationResult.$$$reportNull$$$0(4);
            }
            if (commonInfo == null) {
                CMakeFileProfileGenerationResult.$$$reportNull$$$0(5);
            }
            this.myActualBuildType = this.parameters.getBuildType();
            loadedCacheFile = null;
            try {
                loadedCacheFile = new CMakeCacheFile(this.cacheIOFile, this.cacheIOFileEncoding);
                String cacheBuildType = loadedCacheFile.getVariableValue("CMAKE_BUILD_TYPE");
                this.myActualBuildType = StringUtil.notNullize((String)cacheBuildType, (String)"Default");
            }
            catch (CMakeException e) {
                CMakeStatisticsCollector.LOAD_MODEL_FAILED.log(this.myGenerator.myProject);
                if (this.hasGenerationError) break block9;
                this.parameters.getListener().message(CMakeMessage.fromException(e, this.myGenerator.getCMakeListsFile()));
            }
        }
        ProgressManager.checkCanceled();
        if (loadedCacheFile != null) {
            this.myProjectName = loadedCacheFile.getProjectName();
            CMakeCodeBlocks codeBlocksProject = this.loadCodeBlocksProject(loadedCacheFile);
            HashMap<String, String> myTargetTypes = codeBlocksProject != null ? codeBlocksProject.getTargetTypes() : new HashMap<String, String>();
            this.myTargetInfos = this.loadTargetInfos(loadedCacheFile, myTargetTypes);
            List<String> specifiedBuildTypes = loadedCacheFile.getConfigurationTypesValue();
            if (specifiedBuildTypes != null) {
                this.setBuildTypes(specifiedBuildTypes);
            }
            HashMap<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache = new HashMap<String, CPPEnvironment.ExecutablePathResult>(2);
            for (TargetInfo eachTarget : this.myTargetInfos) {
                try {
                    this.loadPerConfigurationTargetInfo(eachTarget, resolvedExecutableCache);
                }
                catch (CMakeException e) {
                    CPPLog.LOG.info((Throwable)e);
                    this.parameters.getListener().message(CMakeMessage.fromException(e, eachTarget.cmakeListsFile));
                }
            }
            this.loadConfigResources(codeBlocksProject, commonInfo);
            this.loadFileExtensions(commonInfo);
            this.loadOsxRoot(loadedCacheFile);
        }
    }

    @Nullable
    private CMakeFile loadDependenciesFile(@NotNull File generatedDir, @NotNull CMakeListener listener2) {
        File makeFile2;
        if (generatedDir == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(6);
        }
        if (listener2 == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(7);
        }
        if ((makeFile2 = new File(generatedDir, "CMakeFiles/Makefile.cmake")).exists() || !this.hasGenerationError) {
            try {
                return this.parseCMakeFile(makeFile2);
            }
            catch (CMakeException e) {
                String text = CLionCMakeBundle.message("cannot.read.cmake.dependency.file", makeFile2.toString());
                CPPLog.LOG.warn(text, (Throwable)e);
                listener2.message(new CMakeMessage(CMakeMessage.MessageLevel.ERROR, this.myGenerator.getCMakeListsFile(), null, text));
            }
        }
        return null;
    }

    private void loadConfigResources(@Nullable CMakeCodeBlocks codeBlocks, @NotNull CMakeGeneratorCommonInfo commonInfo) {
        if (commonInfo == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(8);
        }
        if (codeBlocks != null) {
            for (Map.Entry<String, String> each : codeBlocks.getFilePathsWithFolders().entrySet()) {
                File file = CMakeGeneratorUtils.toLocalFile(this.parameters.getEnvironment(), FileUtil.toCanonicalPath((String)each.getKey(), (boolean)true));
                if (each.getValue().startsWith("CMake Files\\")) {
                    commonInfo.addDependencyFile(file);
                    continue;
                }
                commonInfo.addSourceFile(file);
            }
        }
    }

    @Nullable
    private CMakeCodeBlocks loadCodeBlocksProject(@NotNull CMakeCacheFile cacheFile) {
        if (cacheFile == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(9);
        }
        File codeBlocksFile = new File(this.parameters.getGenerationDir(), cacheFile.getProjectNameValueOrDefault() + ".cbp");
        try {
            return CMakeCodeBlocks.load(codeBlocksFile);
        }
        catch (IOException | JDOMException e) {
            String text = "Cannot read project file " + codeBlocksFile;
            CPPLog.LOG.warn(text, e);
            this.parameters.getListener().message(new CMakeMessage(CMakeMessage.MessageLevel.ERROR, this.myGenerator.getCMakeListsFile(), null, text));
            return null;
        }
    }

    private void loadFileExtensions(@NotNull CMakeGeneratorCommonInfo commonInfo) {
        CMakeFile makeFileCMake;
        if (commonInfo == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(10);
        }
        if ((makeFileCMake = this.loadDependenciesFile(this.parameters.getGenerationDir(), this.parameters.getListener())) == null) {
            return;
        }
        for (String each : this.getCMakeVariableValues(makeFileCMake, "CMAKE_MAKEFILE_DEPENDS")) {
            String langID;
            OCLanguageKind langKind;
            File file = CMakeGeneratorUtils.toLocalFile(this.parameters.getEnvironment(), each);
            Matcher matcher = CMAKE_COMPILER_FILE_PATTERN.matcher(FileUtil.toSystemIndependentName((String)file.getPath()));
            if (!matcher.matches() || (langKind = CMakeFileProfileGenerationResult.toLanguageKind(langID = matcher.group(1))) == null) continue;
            try {
                CMakeFile compilerFile = this.parseCMakeFile(new File(this.parameters.getGenerationDir(), file.getPath()));
                for (String eachExt : this.getCMakeVariableValues(compilerFile, "CMAKE_" + langID + "_SOURCE_FILE_EXTENSIONS")) {
                    commonInfo.addExtension(eachExt, langKind);
                }
            }
            catch (CMakeException e) {
                CPPLog.LOG.debug((Throwable)e);
                this.parameters.getListener().message(new CMakeMessage(CMakeMessage.MessageLevel.ERROR, this.myGenerator.getCMakeListsFile(), null, e.getMessage()));
            }
        }
    }

    private void loadPerConfigurationTargetInfo(@NotNull TargetInfo targetInfo, @NotNull Map<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache) throws CMakeException {
        CMakeMakeFile makeFile2;
        if (targetInfo == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(11);
        }
        if (resolvedExecutableCache == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(12);
        }
        CidrCompilerSwitches.Format compilerSwitchesFormat = targetInfo.generatorType == CMakeGeneratorType.MINGW_MAKEFILES.INSTANCE ? CidrCompilerSwitches.Format.MINGW_MAKEFILES : (targetInfo.generatorType == CMakeGeneratorType.NMAKE_MAKEFILES.INSTANCE ? CidrCompilerSwitches.Format.NMAKE_MAKEFILES : CidrCompilerSwitches.Format.GNU_MAKEFILES);
        CMakeFile dependsInfoCmake = this.parseCMakeFile(new File(targetInfo.targetDir, "DependInfo.cmake"));
        ArrayList<Pair> supportedLanguages = new ArrayList<Pair>();
        for (String eachLangID : this.getCMakeVariableValues(dependsInfoCmake, "CMAKE_DEPENDS_LANGUAGES")) {
            OCLanguageKind languageKind = CMakeFileProfileGenerationResult.toLanguageKind(eachLangID);
            if (languageKind == null) continue;
            supportedLanguages.add(Pair.create((Object)eachLangID, (Object)languageKind));
        }
        File flagsIOFile = new File(targetInfo.targetDir, "flags.make");
        File makeIOFile = new File(targetInfo.targetDir, "build.make");
        CMakeMakeFile cMakeMakeFile = makeFile2 = makeIOFile.isFile() ? new CMakeMakeFile(makeIOFile, this.myGenerator.encodingForFile(makeIOFile)) : null;
        if (flagsIOFile.exists()) {
            CMakeFlagsFile flagsFile = new CMakeFlagsFile(flagsIOFile, this.myGenerator.encodingForFile(flagsIOFile));
            HashMap<OCLanguageKind, CMakeConfigurationSettings> settingsMap = new HashMap<OCLanguageKind, CMakeConfigurationSettings>(supportedLanguages.size());
            String adHocTargetFlags = flagsFile.getVariable("_AD_HOC_TARGET_FLAGS_");
            HashMap<String, String> langIdToCompilerPath = new HashMap<String, String>();
            for (Pair eachLang : supportedLanguages) {
                String compilerPath;
                String langID = (String)eachLang.first;
                Object flags = StringUtil.notNullize((String)flagsFile.getVariable(langID + "_FLAGS"));
                String defines = StringUtil.notNullize((String)flagsFile.getVariable(langID + "_DEFINES"));
                String includes = StringUtil.notNullize((String)flagsFile.getVariable(langID + "_INCLUDES"));
                if (!StringUtil.isEmptyOrSpaces((String)includes)) {
                    flags = includes + " " + (String)flags;
                }
                if (!StringUtil.isEmptyOrSpaces((String)adHocTargetFlags)) {
                    flags = (String)flags + "   " + adHocTargetFlags;
                }
                if ((compilerPath = StringUtil.nullize((String)flagsFile.getVariable(langID + "_COMPILER"), (boolean)true)) == null) {
                    compilerPath = StringUtil.nullize((String)targetInfo.cacheFile.getVariableValue("CMAKE_" + langID + "_COMPILER"), (boolean)true);
                }
                @NlsSafe String compilerID = (String)ContainerUtil.getFirstItem(this.getCMakeVariableValues(dependsInfoCmake, "CMAKE_" + langID + "_COMPILER_ID"));
                CMakeCompiler compiler = this.getCMakeCompiler(StringUtil.notNullize((String)compilerPath), StringUtil.notNullize((String)compilerID));
                if (compilerPath != null) {
                    langIdToCompilerPath.put(langID, compilerPath);
                    Pair<String, String> result2 = CMakeFileProfileGenerationResult.resolveToExecutableOrGetFromCache(compilerPath, targetInfo.buildWorkingDir, this.parameters.getEnvironment(), resolvedExecutableCache);
                    String errorMessage = (String)result2.first;
                    if (errorMessage != null) {
                        throw new CMakeException(errorMessage);
                    }
                    compilerPath = (String)result2.second;
                }
                File compilerExec = compilerPath == null ? null : new File(compilerPath);
                settingsMap.put((OCLanguageKind)eachLang.second, new CMakeConfigurationSettings(compiler, compilerExec, CidrSwitchBuilder.parseArgs((String)flags, (CidrCompilerSwitches.Format)compilerSwitchesFormat), CidrSwitchBuilder.parseArgs((String)defines, (CidrCompilerSwitches.Format)compilerSwitchesFormat)));
            }
            HashMap<OCLanguageKind, OCLanguageKind> predefinedLanguageToExistingLanguage = new HashMap<OCLanguageKind, OCLanguageKind>();
            Map sources = null;
            for (Pair eachLang : supportedLanguages) {
                String langID = (String)eachLang.first;
                List<String> values = this.getCMakeVariableValues(dependsInfoCmake, "CMAKE_DEPENDS_CHECK_" + langID);
                if (values.isEmpty()) continue;
                int size = values.size();
                if (sources == null) {
                    sources = FileCollectionFactory.createCanonicalFileMap((int)(size / 2));
                }
                MakeRulesConvertor rulesConvertor = new MakeRulesConvertor(targetInfo.generatorType);
                for (int i = 0; i < size - 1; i += 2) {
                    File source = CMakeGeneratorUtils.toLocalFile(targetInfo.environment, values.get(i));
                    File object = CMakeGeneratorUtils.toLocalFile(targetInfo.environment, values.get(i + 1));
                    List fileFlagsLeading = null;
                    List fileFlagsTrailing = null;
                    List<String> fileDefines = null;
                    String relativeObjectPath = CMakeFileProfileGenerationResult.getRelativePath(targetInfo.generatedDir, object);
                    String compilerPath = (String)langIdToCompilerPath.get(langID);
                    if (relativeObjectPath != null && StringUtil.isNotEmpty((String)compilerPath)) {
                        CMakeConfigurationSettings languageSettings = (CMakeConfigurationSettings)settingsMap.get(eachLang.second);
                        if (makeFile2 != null && (languageSettings == null || languageSettings.getCompiler().getCompilerKind() != MSVCCompilerKind.INSTANCE && languageSettings.getCompiler().getCompilerKind() != ClangClCompilerKind.INSTANCE) && compilerSwitchesFormat != CidrCompilerSwitches.Format.NMAKE_MAKEFILES) {
                            Collection<CMakeMakeFile.Rule> rules = makeFile2.getRules(rulesConvertor.toRuleName(relativeObjectPath, true));
                            if (rules == null) {
                                rules = Collections.emptyList();
                            }
                            for (CMakeMakeFile.Rule eachRule : rules) {
                                int launcherIndex;
                                String defines;
                                String recipe = eachRule.getRecipe();
                                int definesIndex = recipe.indexOf(defines = String.format("$(%s_DEFINES)", langID));
                                if (definesIndex == -1) continue;
                                int commandStart = Math.max(0, Math.max(recipe.lastIndexOf("&&", definesIndex) + 2, recipe.lastIndexOf("\n", definesIndex) + 1));
                                String compileCommand = recipe.substring(commandStart, definesIndex);
                                List arguments = CidrSwitchBuilder.parseArgs((String)compileCommand, (CidrCompilerSwitches.Format)compilerSwitchesFormat);
                                @NlsSafe String compilerLauncherVar = String.format("CMAKE_%s_COMPILER_LAUNCHER", langID);
                                List<String> compilerLauncher = targetInfo.cacheFile.getVariableListValue(compilerLauncherVar);
                                if (compilerLauncher != null && (launcherIndex = Collections.indexOfSubList(arguments, compilerLauncher)) != -1) {
                                    arguments = ContainerUtil.subList((List)arguments, (int)(launcherIndex + compilerLauncher.size()));
                                }
                                fileFlagsLeading = this.findCompilerArguments(compilerPath, arguments);
                                if (languageSettings == null || fileFlagsLeading == null) continue;
                                fileFlagsLeading = languageSettings.getCompiler().getCompilerKind().skipLanguageNotRelatedSwitches(fileFlagsLeading);
                            }
                            if (rules.isEmpty() || fileFlagsLeading == null) {
                                CPPLog.LOG.warn("Unable to find " + (rules.isEmpty() ? "rules" : "compiler rule") + " for object :\n: " + relativeObjectPath + "\nCompiler path: " + (String)langIdToCompilerPath.get(langID) + "\nGenerated dir: " + targetInfo.generatedDir + "\nTarget dir: " + targetInfo.targetDir + "\nMakefile keys: \n" + StringUtil.join(makeFile2.getRules(), it -> it.getTarget(), (String)"\n"));
                            }
                        }
                        String keyPrefixInFlagsFile = FileUtil.toSystemIndependentName((String)relativeObjectPath);
                        String flagsValue = flagsFile.getVariable(keyPrefixInFlagsFile + "_FLAGS");
                        fileFlagsTrailing = CidrSwitchBuilder.parseArgs((String)StringUtil.notNullize((String)flagsValue), (CidrCompilerSwitches.Format)compilerSwitchesFormat);
                        String pchOptionsValue = flagsFile.getVariable(keyPrefixInFlagsFile + "_OPTIONS");
                        if (!StringUtil.isEmptyOrSpaces((String)pchOptionsValue)) {
                            ArrayList<String> pchOptions = new ArrayList<String>(Arrays.asList(pchOptionsValue.trim().split(";")));
                            CMakeConfigurationSettings settings2 = (CMakeConfigurationSettings)settingsMap.get(eachLang.second);
                            if (settings2 != null) {
                                List fixedPchOptions = settings2.getCompiler().getCompilerKind().fixPchSwitches(pchOptions);
                                fileFlagsTrailing.addAll(fixedPchOptions);
                            }
                        }
                        String definesValue = flagsFile.getVariable(keyPrefixInFlagsFile + "_DEFINES");
                        fileDefines = CMakeFileProfileGenerationResult.convertPerFileDefines(definesValue);
                    }
                    OCLanguageKind effectiveLang = CMakeFileProfileGenerationResult.getEffectiveLanguageKind(source.getName(), (OCLanguageKind)eachLang.second, predefinedLanguageToExistingLanguage);
                    String objectTargetName = StringUtil.notNullize((String)relativeObjectPath, (String)object.getName());
                    if (targetInfo.generatorType != CMakeGeneratorType.NMAKE_MAKEFILES.INSTANCE) {
                        objectTargetName = FileUtil.toSystemIndependentName((String)objectTargetName);
                    }
                    sources.put(source, new CMakeFileSettings(effectiveLang, objectTargetName, ContainerUtil.notNullize(fileFlagsLeading), ContainerUtil.notNullize((List)fileFlagsTrailing), ContainerUtil.notNullize(fileDefines)));
                }
            }
            if (sources == null) {
                sources = FileCollectionFactory.createCanonicalFileMap();
            }
            if (makeFile2 != null) {
                for (CMakeMakeFile.Rule rule : makeFile2.getRules()) {
                    String recipe;
                    String target2 = rule.getTarget();
                    if (!target2.endsWith(".obj") && !target2.endsWith(".o") || (recipe = rule.getRecipe()).isEmpty()) continue;
                    this.tryAddCudaTarget(recipe, targetInfo.environment, settingsMap, sources);
                }
            }
            targetInfo.sources = sources;
            CMakeFileProfileGenerationResult.adjustLanguageSettingsMap(settingsMap, predefinedLanguageToExistingLanguage);
            CollectionFactory.trimMap(settingsMap);
            targetInfo.perLanguageSettings = settingsMap;
        }
        if (this.hasGenerationError && targetInfo.sources.isEmpty() && targetInfo.perLanguageSettings.isEmpty() && this.myPreviousModel != null) {
            for (CMakeTarget eachTarget : this.myPreviousModel.getTargets()) {
                for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                    if (!FileUtil.filesEqual((File)eachConfig.getConfigurationAndTargetGenerationDir(), (File)targetInfo.targetDir)) continue;
                    targetInfo.sources = new HashMap<File, CMakeFileSettings>(eachConfig.getSourcesMap());
                    targetInfo.perLanguageSettings = new HashMap<OCLanguageKind, CMakeConfigurationSettings>(eachConfig.getPerLanguageSettingsMap());
                    targetInfo.productFile = eachConfig.getProductFile();
                }
            }
        } else if (makeFile2 != null) {
            this.loadProductPathAndLinkerInfo(makeFile2, targetInfo);
        }
    }

    @Nullable
    private List<String> findCompilerArguments(@NotNull String compilerPath, @NotNull List<String> commandLine) {
        Function<String, String> winPathResolver;
        if (compilerPath == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(13);
        }
        if (commandLine == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(14);
        }
        if (this.parameters.getEnvironment().getHostMachine().getOSType() == OSType.WIN) {
            CPPLog.LOG.assertTrue(SystemInfo.isWindows, (Object)"Remote Windows path resolving is not yet supported");
            winPathResolver = path -> {
                try {
                    return FileUtil.resolveShortWindowsName((String)path);
                }
                catch (IOException e) {
                    return path;
                }
            };
        } else {
            winPathResolver = null;
        }
        Function<Boolean, Integer> lookup = lookupByFileName -> {
            String lookupPath = lookupByFileName != false ? PathUtil.getFileName((String)compilerPath) : FileUtil.toSystemIndependentName((String)compilerPath);
            return ContainerUtil.indexOf((List)commandLine, arg -> {
                arg = lookupByFileName != false ? PathUtil.getFileName((String)arg) : arg;
                return lookupPath.equals(FileUtil.toSystemIndependentName((String)arg)) || winPathResolver != null && lookupPath.equalsIgnoreCase(FileUtil.toSystemIndependentName((String)((String)winPathResolver.apply((String)arg))));
            });
        };
        int compilerIndex = lookup.apply(false);
        if (compilerIndex == -1) {
            compilerIndex = lookup.apply(true);
        }
        if (compilerIndex == -1) {
            return null;
        }
        return new ArrayList<String>(ContainerUtil.subList(commandLine, (int)(compilerIndex + 1)));
    }

    @Contract(value="null -> null")
    private static List<String> convertPerFileDefines(@Nullable String definesString) {
        if (definesString == null) {
            return null;
        }
        ArrayList<@NlsSafe String> result2 = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        Runnable append = () -> {
            if (current.length() > 0) {
                result2.add("-D" + current.toString().trim());
            }
        };
        int length = definesString.length();
        for (int i = 0; i < length; ++i) {
            char c = definesString.charAt(i);
            if (c == ';') {
                append.run();
                current.setLength(0);
                continue;
            }
            if (c == '\\' && i < length - 1 && definesString.charAt(i + 1) == ';') {
                current.append(';');
                ++i;
                continue;
            }
            current.append(c);
        }
        append.run();
        Collections.sort(result2);
        return result2;
    }

    @NotNull
    private static String getFileSeparator(HostMachine hostMachine) {
        return hostMachine.getOSType() == OSType.WIN ? "\\" : "/";
    }

    private void tryAddCudaTarget(@NotNull String recipe, @NotNull CPPEnvironment environment2, @NotNull Map<OCLanguageKind, CMakeConfigurationSettings> settingsMap, @NotNull Map<File, CMakeFileSettings> sources) throws CMakeException {
        String directory;
        File cudaDirectory;
        String findCmd;
        int dirIndex;
        if (recipe == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(15);
        }
        if (environment2 == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(16);
        }
        if (settingsMap == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(17);
        }
        if (sources == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(18);
        }
        if ((dirIndex = recipe.indexOf(findCmd = "-E make_directory")) != -1 && (cudaDirectory = new File(directory = environment2.toLocalPath(recipe.substring(dirIndex + findCmd.length() + 1, recipe.indexOf("\n", dirIndex) - 1)))).exists() && cudaDirectory.isDirectory()) {
            CMakeGeneratorUtils.CudaTargetInfo cudaTargetInfo = this.computeCudaTargetInfo(cudaDirectory);
            this.addCudaCmakeTargets(cudaTargetInfo, settingsMap, sources);
        }
    }

    @Nullable
    private CMakeGeneratorUtils.CudaTargetInfo computeCudaTargetInfo(@NotNull File cudaDirectory) throws CMakeException {
        CMakeGeneratorUtils.CudaTargetInfo cached;
        if (cudaDirectory == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(19);
        }
        if ((cached = this.myCudaTargetsInfo.get(cudaDirectory)) != null) {
            return cached;
        }
        CMakeGeneratorUtils.CudaTargetInfo targetInfo = this.loadCudaTargetInfo(cudaDirectory);
        if (targetInfo != null) {
            this.myCudaTargetsInfo.put(cudaDirectory, targetInfo);
        }
        return targetInfo;
    }

    private void loadProductPathAndLinkerInfo(@NotNull CMakeMakeFile makeFile2, @NotNull TargetInfo eachTarget) throws CMakeException {
        String relativeTargetPath;
        String canonicalTargetPath;
        String absoluteTargetPath;
        if (makeFile2 == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(20);
        }
        if (eachTarget == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(21);
        }
        String productName = null;
        boolean emulateNotFound = this.myGenerator.shouldEmulateProductNotFoundForTargetAndProfile((Pair<String, String>)Pair.create((Object)eachTarget.targetName, (Object)eachTarget.profileName));
        try {
            File canonicalTargetDir = eachTarget.targetDir.getCanonicalFile();
            absoluteTargetPath = eachTarget.targetDir.getPath();
            canonicalTargetPath = canonicalTargetDir.getPath();
            relativeTargetPath = CMakeFileProfileGenerationResult.getRelativePath(eachTarget.generatedDir.getCanonicalFile(), canonicalTargetDir);
        }
        catch (IOException e) {
            throw new CMakeException(e);
        }
        MakeRulesConvertor rulesConvertor = new MakeRulesConvertor(eachTarget.generatorType);
        LinkedHashSet<String> keys = new LinkedHashSet<String>(Arrays.asList(rulesConvertor.toRuleName(relativeTargetPath + "/build", true), rulesConvertor.toRuleName(absoluteTargetPath + "/build", true), rulesConvertor.toRuleName(canonicalTargetPath + "/build", true), rulesConvertor.toRuleName(CMakeFileProfileGenerationResult.toEnvPath(eachTarget.environment, absoluteTargetPath + "/build"), false), rulesConvertor.toRuleName(CMakeFileProfileGenerationResult.toEnvPath(eachTarget.environment, canonicalTargetPath + "/build"), false)));
        if (!emulateNotFound && relativeTargetPath != null) {
            String separator = CMakeFileProfileGenerationResult.getFileSeparator(eachTarget.environment.getHostMachine());
            @NlsSafe String cudaIgnoreTarget = CMakeFileProfileGenerationResult.toEnvPath(eachTarget.environment, relativeTargetPath) + separator + "cmake_device_link";
            for (String each : keys) {
                Collection<CMakeMakeFile.Rule> rules = makeFile2.getRules(each);
                if (rules != null) {
                    CMakeMakeFile.Rule rule;
                    Iterator<CMakeMakeFile.Rule> iterator = rules.iterator();
                    while (iterator.hasNext() && (productName = (rule = iterator.next()).getDependencies()).startsWith(cudaIgnoreTarget)) {
                    }
                }
                if (productName == null) continue;
                break;
            }
        }
        if (productName != null) {
            productName = rulesConvertor.toFileName(productName);
            eachTarget.productFile = CMakeGeneratorUtils.toLocalFile(eachTarget.environment, eachTarget.generatedDir, productName);
        } else {
            CPPLog.LOG.debug("Unable to determine product file path:\nGenerated dir: " + eachTarget.generatedDir + "\nTarget dir: " + eachTarget.targetDir + "\nTried keys: \n" + StringUtil.join(keys, (String)"\n") + "\nMakefile keys: \n" + StringUtil.join(makeFile2.getRules(), (String)"\n"));
            this.reportNoProductFile(eachTarget);
        }
        if (eachTarget.generatorType == CMakeGeneratorType.NMAKE_MAKEFILES.INSTANCE) {
            if (eachTarget.productFile != null) {
                int to;
                int from;
                String productFileName = eachTarget.productFile.getName();
                CMakeMakeFile.Rule linkerRule = (CMakeMakeFile.Rule)ContainerUtil.find(makeFile2.getRules(), it -> FileUtil.namesEqual((String)productFileName, (String)PathUtil.getFileName((String)it.getTarget())) && it.getRecipe().contains("link.exe") && it.getRecipe().contains("@<<"));
                if (linkerRule != null && (from = StringUtil.indexOfSubstringEnd((String)linkerRule.getRecipe(), (String)"@<<")) != -1 && (to = linkerRule.getRecipe().indexOf("<<", from)) != -1) {
                    eachTarget.linkerFlags = CidrSwitchBuilder.parseArgs((String)linkerRule.getRecipe().substring(from, to), (CidrCompilerSwitches.Format)CidrCompilerSwitches.Format.MSVC_RESPONSE_FILE);
                }
            }
        } else {
            File linkerFile = new File(eachTarget.targetDir, eachTarget.generatorType == CMakeGeneratorType.MINGW_MAKEFILES.INSTANCE ? "linklibs.rsp" : "link.txt");
            if (linkerFile.exists()) {
                try {
                    eachTarget.linkerFlags = CidrSwitchBuilder.parseArgs((String)FileUtilRt.loadFile((File)linkerFile, (String)this.myGenerator.encodingForFile(linkerFile)), (CidrCompilerSwitches.Format)CidrCompilerSwitches.Format.GCC_RESPONSE_FILE);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @NotNull
    private static String toEnvPath(@NotNull CPPEnvironment environment2, @NlsSafe @NotNull String absoluteLocalPath) {
        if (environment2 == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(22);
        }
        if (absoluteLocalPath == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(23);
        }
        String string = environment2.toEnvPath(absoluteLocalPath);
        if (string == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Override
    @Nullable
    public String getProjectName() {
        return this.myProjectName;
    }

    @NotNull
    private Collection<TargetInfo> loadTargetInfos(@NotNull CMakeCacheFile cache2, @NotNull Map<String, String> targetTypes) {
        if (cache2 == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(25);
        }
        if (targetTypes == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(26);
        }
        Map targets = CMakeGeneratorUtils.createOrderedTargetKeysMap();
        this.processTargetDirectories(this.parameters.getGenerationDir(), this.parameters.getListener(), (Processor<File>)((Processor)targetDir -> {
            File buildWorkingDir;
            File cmakeFiles;
            for (cmakeFiles = targetDir.getParentFile(); cmakeFiles != null && !FileUtil.namesEqual((String)cmakeFiles.getName(), (String)"CMakeFiles"); cmakeFiles = cmakeFiles.getParentFile()) {
            }
            File file = buildWorkingDir = cmakeFiles == null ? null : cmakeFiles.getParentFile();
            if (buildWorkingDir == null) {
                CPPLog.LOG.error("Cannot find target build working dir for: " + targetDir);
                return true;
            }
            File cmakeListsFile = this.myGenerator.getCMakeListsFile();
            if (!buildWorkingDir.exists()) {
                CPPLog.LOG.error("Target build working dir doesn't exist: " + buildWorkingDir);
            } else {
                try {
                    List cmake_install = FileUtil.loadLines((File)new File(buildWorkingDir, "cmake_install.cmake"));
                    for (String eachLine : cmake_install) {
                        if (!eachLine.startsWith("# Install script for directory:")) continue;
                        cmakeListsFile = CMakeGeneratorUtils.getCMakeListsFile(CMakeGeneratorUtils.toLocalFile(this.parameters.getEnvironment(), StringUtil.trimStart((String)eachLine, (String)"# Install script for directory:").trim()));
                    }
                }
                catch (IOException e) {
                    String[] files = buildWorkingDir.list();
                    CPPLog.LOG.error("Cannot read cmake directory from " + buildWorkingDir + ":" + (String)(files == null || files.length == 0 ? " <empty>" : "\n\t" + StringUtil.join((String[])files, (String)"\n\t")), (Throwable)e);
                }
            }
            String relativeTargetPath = FileUtil.getRelativePath((File)cmakeFiles, (File)targetDir);
            CPPLog.LOG.assertTrue(relativeTargetPath != null);
            File relativeTarget = new File(relativeTargetPath);
            String targetName = new File(relativeTarget.getParentFile(), FileUtilRt.getNameWithoutExtension((String)relativeTarget.getName())).getPath();
            targetName = FileUtil.toSystemIndependentName((String)targetName);
            String targetTypeString = (String)targetTypes.get(targetName);
            CMakeConfiguration.TargetType targetType = CMakeConfiguration.TargetType.fromCodeBlocksTypeNumeral(targetTypeString);
            TargetInfo targetInfo = new TargetInfo(this.parameters.getEnvironment(), cmakeListsFile, this.parameters.getGenerationDir(), (File)targetDir, targetName, targetType, this.parameters.getGeneratorSpec(), this.myActualBuildType, this.parameters.getProfileName(), buildWorkingDir, cache2, cache2.getGeneratorType());
            targets.put(targetInfo.targetName, targetInfo);
            return true;
        }));
        Collection<TargetInfo> collection = targets.values();
        if (collection == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(27);
        }
        return collection;
    }

    private boolean processTargetDirectories(@NotNull File configGenerationDir, @NotNull CMakeListener listener2, @NotNull Processor<File> processor) {
        File targetsListFile;
        if (configGenerationDir == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(28);
        }
        if (listener2 == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(29);
        }
        if (processor == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(30);
        }
        if ((targetsListFile = new File(configGenerationDir, "CMakeFiles/TargetDirectories.txt")).exists() || !this.hasGenerationError) {
            try {
                for (String each : FileUtil.loadLines((File)targetsListFile, (String)this.myGenerator.encodingForFile(targetsListFile))) {
                    File targetDir = CMakeGeneratorUtils.toLocalFile(this.parameters.getEnvironment(), each);
                    if (!targetDir.exists() || processor.process((Object)targetDir)) continue;
                    return false;
                }
            }
            catch (IOException e) {
                listener2.message(CMakeMessage.fromException(CMakeException.cannotReadFile(targetsListFile, (Throwable)e), null));
            }
        }
        return true;
    }

    private void loadOsxRoot(@NotNull CMakeCacheFile cacheFile) {
        if (cacheFile == null) {
            CMakeFileProfileGenerationResult.$$$reportNull$$$0(31);
        }
        String osxRoot = cacheFile.getVariableValue("CMAKE_OSX_SYSROOT");
        this.environmentStateBuilder.withOsxRoot(osxRoot);
    }

    @Nullable
    private static String getRelativePath(File base, File subFile) {
        String result2 = FileUtil.getRelativePath((File)base, (File)subFile);
        if (result2 == null) {
            CPPLog.LOG.error("Cannot convert to relative path:\n\tbase=" + base + "\n\tpath=" + subFile + "\n\nIMPORTANT! If you see this problem, we kindly ask you to submit an issue at our tracker\n(https://youtrack.jetbrains.com/issues/CPP) and provide the details, ideally with a sample project.\nIt will help us to track down and fix this problem.\n\n");
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 24, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 3: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeFileProfileGenerationResult";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationDir";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedDir";
                break;
            }
            case 7: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedExecutableCache";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recipe";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsMap";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cudaDirectory";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "makeFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachTarget";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteLocalPath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTypes";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configGenerationDir";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeFileProfileGenerationResult";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetInfos";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraGeneratorOptions";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toEnvPath";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTargetInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 24: 
            case 27: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadConfigResources";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadCodeBlocksProject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadFileExtensions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadPerConfigurationTargetInfo";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findCompilerArguments";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryAddCudaTarget";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computeCudaTargetInfo";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadProductPathAndLinkerInfo";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "toEnvPath";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadTargetInfos";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processTargetDirectories";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "loadOsxRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 24, 27 -> new IllegalStateException(string);
        };
    }

    private static final class TargetInfo
    extends CMakeProfileTargetInfo {
        @NotNull
        final CMakeCacheFile cacheFile;
        @NotNull
        final CMakeGeneratorType generatorType;
        @NotNull
        final String profileName;

        private TargetInfo(@NotNull CPPEnvironment environment2, @NotNull File cmakeListsFile, @NotNull File generatedDir, @NotNull File targetDir, @NotNull String targetName, @NotNull CMakeConfiguration.TargetType targetType, @NotNull CMakeGeneratorSpec generator2, @NotNull String buildType2, @NotNull String profileName, @NotNull File buildWorkingDir, @NotNull CMakeCacheFile cacheFile, @NotNull CMakeGeneratorType generatorType) {
            if (environment2 == null) {
                TargetInfo.$$$reportNull$$$0(0);
            }
            if (cmakeListsFile == null) {
                TargetInfo.$$$reportNull$$$0(1);
            }
            if (generatedDir == null) {
                TargetInfo.$$$reportNull$$$0(2);
            }
            if (targetDir == null) {
                TargetInfo.$$$reportNull$$$0(3);
            }
            if (targetName == null) {
                TargetInfo.$$$reportNull$$$0(4);
            }
            if (targetType == null) {
                TargetInfo.$$$reportNull$$$0(5);
            }
            if (generator2 == null) {
                TargetInfo.$$$reportNull$$$0(6);
            }
            if (buildType2 == null) {
                TargetInfo.$$$reportNull$$$0(7);
            }
            if (profileName == null) {
                TargetInfo.$$$reportNull$$$0(8);
            }
            if (buildWorkingDir == null) {
                TargetInfo.$$$reportNull$$$0(9);
            }
            if (cacheFile == null) {
                TargetInfo.$$$reportNull$$$0(10);
            }
            if (generatorType == null) {
                TargetInfo.$$$reportNull$$$0(11);
            }
            super(environment2, cmakeListsFile, generatedDir, targetDir, targetName, targetType, new CMakeConfiguration.Generator(generator2, false), buildType2, buildWorkingDir);
            this.cacheFile = cacheFile;
            this.generatorType = generatorType;
            this.profileName = profileName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "environment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cmakeListsFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "generatedDir";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetDir";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "generator";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buildType";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[0] = "profileName";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buildWorkingDir";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cacheFile";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[0] = "generatorType";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeFileProfileGenerationResult$TargetInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MakeRulesConvertor {
        final boolean isNMake;

        MakeRulesConvertor(CMakeGeneratorType generatorType) {
            this.isNMake = generatorType == CMakeGeneratorType.NMAKE_MAKEFILES.INSTANCE;
        }

        public String toRuleName(@NlsSafe @NotNull String fileName, boolean convertSeparators) {
            if (fileName == null) {
                MakeRulesConvertor.$$$reportNull$$$0(0);
            }
            if (convertSeparators) {
                fileName = this.isNMake ? FileUtil.toSystemDependentName((String)fileName) : FileUtil.toSystemIndependentName((String)fileName);
            }
            return this.doEscapeSpaces(fileName);
        }

        public String toFileName(@NotNull String ruleName) {
            if (ruleName == null) {
                MakeRulesConvertor.$$$reportNull$$$0(1);
            }
            return this.doUnescapeSpaces(ruleName);
        }

        private String doEscapeSpaces(String s) {
            if (!this.isNMake) {
                return StringUtil.escapeChar((String)s, (char)' ');
            }
            if (s.indexOf(32) == -1) {
                return s;
            }
            return "\"" + StringUtil.escapeChar((String)s, (char)'\"') + "\"";
        }

        private String doUnescapeSpaces(String s) {
            if (!this.isNMake) {
                return StringUtil.unescapeChar((String)s, (char)' ');
            }
            if (s.startsWith("\"")) {
                return StringUtil.unescapeChar((String)StringUtil.unquoteString((String)s), (char)'\"');
            }
            return s;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ruleName";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeFileProfileGenerationResult$MakeRulesConvertor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toRuleName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toFileName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

