/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeCodeBlocks {
    @NotNull
    private final Map<String, String> myFilePathsWithFolders;
    @NotNull
    private final Map<String, String> myTargetTypes;

    private CMakeCodeBlocks(@NotNull Element root) {
        if (root == null) {
            CMakeCodeBlocks.$$$reportNull$$$0(0);
        }
        Element project = root.getChild("Project");
        HashMap<String, String> filePaths = new HashMap<String, String>();
        HashMap<String, String> targetTypes = new HashMap<String, String>();
        if (project != null) {
            for (Element eachUnit : project.getChildren("Unit")) {
                String path = eachUnit.getAttributeValue("filename");
                if (path == null) continue;
                Element option = eachUnit.getChild("Option");
                String group2 = StringUtil.notNullize(option == null ? null : option.getAttributeValue("virtualFolder"));
                filePaths.put(path, group2);
            }
            Element build2 = project.getChild("Build");
            if (build2 != null) {
                block1: for (Element eachTarget : build2.getChildren("Target")) {
                    String targetName = eachTarget.getAttributeValue("title");
                    if (targetName == null) continue;
                    for (Element eachOption : eachTarget.getChildren("Option")) {
                        String type = eachOption.getAttributeValue("type");
                        if (type == null) continue;
                        targetTypes.put(targetName, type);
                        continue block1;
                    }
                }
            }
        }
        this.myFilePathsWithFolders = Collections.unmodifiableMap(filePaths);
        this.myTargetTypes = Collections.unmodifiableMap(targetTypes);
    }

    @Nullable
    public static CMakeCodeBlocks load(@NotNull File codeBlocksFile) throws JDOMException, IOException {
        if (codeBlocksFile == null) {
            CMakeCodeBlocks.$$$reportNull$$$0(1);
        }
        return codeBlocksFile.exists() ? new CMakeCodeBlocks(JDOMUtil.load((File)codeBlocksFile)) : null;
    }

    @NotNull
    public Map<String, String> getFilePathsWithFolders() {
        Map<String, String> map = this.myFilePathsWithFolders;
        if (map == null) {
            CMakeCodeBlocks.$$$reportNull$$$0(2);
        }
        return map;
    }

    @NotNull
    public Map<String, String> getTargetTypes() {
        Map<String, String> map = this.myTargetTypes;
        if (map == null) {
            CMakeCodeBlocks.$$$reportNull$$$0(3);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlocksFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeCodeBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeCodeBlocks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathsWithFolders";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

