/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.actions;

import com.intellij.execution.actions.ExecutionTargetComboBoxActionKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.flavor.CMakePlainProjectFlavorKt;
import com.jetbrains.cidr.cpp.cmake.settings.CMakeConfigurable;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

public class OpenCMakeSettingsAction
extends DumbAwareAction {
    public static final String ID = "CMake.OpenSettings";
    private final int myProfileIndex;

    public OpenCMakeSettingsAction() {
        this(-1);
    }

    public OpenCMakeSettingsAction(int profileIndex) {
        super(CLionCMakeBundle.message("cmake.action.settings", new Object[0]), null, AllIcons.General.Settings);
        this.myProfileIndex = profileIndex;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenCMakeSettingsAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project != null && CMakePlainProjectFlavorKt.isInitializedPlainCMakeProject(project)) {
            presentation.setEnabledAndVisible(true);
            if (e.getPlace().equals(ExecutionTargetComboBoxActionKt.EXECUTION_TARGETS_COMBO_ACTION_PLACE)) {
                presentation.setIcon(null);
                presentation.setText(CLionCMakeBundle.message("cmake.action.settings.popup", new Object[0]));
            }
        } else {
            presentation.setEnabledAndVisible(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenCMakeSettingsAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenCMakeSettingsAction.$$$reportNull$$$0(2);
        }
        if ((project = OpenCMakeSettingsAction.getEventProject((AnActionEvent)e)) == null) {
            return;
        }
        OpenCMakeSettingsAction.openProfile(project, this.myProfileIndex);
    }

    public static void openProfileSettings(@NotNull Project project) {
        if (project == null) {
            OpenCMakeSettingsAction.$$$reportNull$$$0(3);
        }
        OpenCMakeSettingsAction.openProfile(project, -1);
    }

    public static void openProfile(@NotNull Project project, int profileIndex) {
        if (project == null) {
            OpenCMakeSettingsAction.$$$reportNull$$$0(4);
        }
        CMakeSettings.Profile profile = (CMakeSettings.Profile)CollectionsKt.getOrNull(CMakeSettings.getInstance(project).getProfiles(), (int)profileIndex);
        ShowSettingsUtil.getInstance().showSettingsDialog(project, CMakeConfigurable.class, configurable -> configurable.setPreselectedProfile(profile));
    }

    public static void openProfile(@NotNull Project project, @NotNull String profileName) {
        if (project == null) {
            OpenCMakeSettingsAction.$$$reportNull$$$0(5);
        }
        if (profileName == null) {
            OpenCMakeSettingsAction.$$$reportNull$$$0(6);
        }
        for (CMakeSettings.Profile profile : CMakeSettings.getInstance(project).getProfiles()) {
            if (!profileName.contentEquals(profile.getName())) continue;
            ShowSettingsUtil.getInstance().showSettingsDialog(project, CMakeConfigurable.class, configurable -> configurable.setPreselectedProfile(profile));
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/actions/OpenCMakeSettingsAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/actions/OpenCMakeSettingsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openProfileSettings";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openProfile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

