/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.CidrProjectOpenProcessor;
import com.jetbrains.cidr.ProjectOpenFileHelper;
import com.jetbrains.cidr.ProjectOpenHelper;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.flavor.CMakeProjectFlavorService;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorSpec;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.fus.CidrWorkspaceUsageCounterCollector;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeProjectOpenProcessor
extends CidrProjectOpenProcessor {
    private static final Key<OpenProjectSpec> DATA_KEY = Key.create((String)"CMAKE_FILE_TO_OPEN_KEY");
    private static final Key<Boolean> OPENED_KEY = Key.create((String)"CMAKE_PROCESSOR_OPENED");
    public static final List<String> SUPPORTED_FILES = List.of("CMakeLists.txt", "CMakeCache.txt");
    private static final ProjectOpenHelper<OpenProjectSpec> ourProjectOpenHelper = new ProjectOpenFileHelper(SUPPORTED_FILES, DATA_KEY);

    public CMakeProjectOpenProcessor() {
        super(ourProjectOpenHelper);
    }

    @NotNull
    @Nls
    public String getName() {
        String string = CLionCMakeBundle.message("cmake", new Object[0]);
        if (string == null) {
            CMakeProjectOpenProcessor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static ProjectOpenHelper<OpenProjectSpec> getHelper() {
        ProjectOpenHelper<OpenProjectSpec> projectOpenHelper = ourProjectOpenHelper;
        if (projectOpenHelper == null) {
            CMakeProjectOpenProcessor.$$$reportNull$$$0(1);
        }
        return projectOpenHelper;
    }

    public boolean canOpenProject(@NotNull VirtualFile file) {
        if (file == null) {
            CMakeProjectOpenProcessor.$$$reportNull$$$0(2);
        }
        if ((file = ourProjectOpenHelper.findSupportedSubFile(file)) == null) {
            return false;
        }
        return super.canOpenProject(file);
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Project project;
        if (virtualFile == null) {
            CMakeProjectOpenProcessor.$$$reportNull$$$0(3);
        }
        if ((virtualFile = ourProjectOpenHelper.findSupportedSubFile(virtualFile)) == null) {
            return null;
        }
        Project existingProject = ourProjectOpenHelper.openExistingProjectInDirectory(virtualFile, projectToClose, forceOpenInNewFrame);
        if (existingProject != null) {
            return existingProject;
        }
        Pair<VirtualFile, OpenProjectSpec> spec = CMakeProjectOpenProcessor.createOpenProjectSpec(virtualFile);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && ((OpenProjectSpec)spec.second).generationDir != null && !((OpenProjectSpec)spec.second).isInSourceGeneration()) {
            String messageString;
            CMakeGeneratorType generatorType;
            String productName = ApplicationNamesInfo.getInstance().getFullProductName();
            String relativeSourcePath = FileUtil.getRelativePath((File)((OpenProjectSpec)spec.second).generationDir, (File)((OpenProjectSpec)spec.second).sourceDir);
            StringBuilder message = new StringBuilder();
            message.append(CLionCMakeBundle.message("cmake.directory.contains.generated.files", relativeSourcePath == null ? ((OpenProjectSpec)spec.second).sourceDir : relativeSourcePath));
            CMakeGeneratorType cMakeGeneratorType = generatorType = ((OpenProjectSpec)spec.second).generator == null ? null : ((OpenProjectSpec)spec.second).generator.getGenerator();
            if (generatorType instanceof CMakeGeneratorType.UNKNOWN) {
                CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
                message.append("\n\n");
                message.append(CLionCMakeBundle.message("cmake.wrong.generator.was.used", generatorType.getName(), productName, CMakeGeneratorSpec.createDefaultLegacyGeneratorSpec(toolchain == null ? null : toolchain.getToolSet(), false)));
            }
            if (Messages.showOkCancelDialog((Project)projectToClose, (String)(messageString = message.toString()), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.yes", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                return null;
            }
        }
        if ((project = ourProjectOpenHelper.openProject((VirtualFile)spec.first, projectToClose, forceOpenInNewFrame, (Object)((OpenProjectSpec)spec.second), it -> {
            it.putUserData(OPENED_KEY, (Object)true);
            CidrWorkspaceUsageCounterCollector.logProjectCreated((String)"CMake", (Project)it);
            return true;
        })) != null) {
            CMakeProjectFlavorService.getInstance(project);
        }
        return project;
    }

    @NotNull
    private static Pair<VirtualFile, OpenProjectSpec> createOpenProjectSpec(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CMakeProjectOpenProcessor.$$$reportNull$$$0(4);
        }
        File selectedDir = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile.getParent());
        File cacheIOFile = new File(selectedDir, "CMakeCache.txt");
        VirtualFile cmakeListsFile = virtualFile;
        File sourceDir = selectedDir;
        File generationDir2 = null;
        String buildType2 = null;
        CMakeGeneratorSpec generator2 = null;
        if (cacheIOFile.exists()) {
            generationDir2 = selectedDir;
            try {
                CPPEnvironment env;
                String sourceDirPathFromCache;
                VirtualFile cacheVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(cacheIOFile);
                CMakeCacheFile cacheFile = new CMakeCacheFile(cacheIOFile, cacheVFile == null ? "UTF-8" : cacheVFile.getCharset().name());
                generator2 = CMakeGeneratorSpec.readGeneratorFromCMakeCache(cacheFile);
                CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
                if (toolchain != null && (sourceDirPathFromCache = (env = new CPPEnvironment(toolchain)).toLocalPath(cacheFile.getVariableValue("CMAKE_HOME_DIRECTORY"))) != null) {
                    File cmakeLists = new File(sourceDirPathFromCache + "/CMakeLists.txt");
                    VirtualFile cmakeListsFileFromCache = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(cmakeLists);
                    if (cmakeListsFileFromCache != null) {
                        cmakeListsFile = cmakeListsFileFromCache;
                        sourceDir = new File(sourceDirPathFromCache);
                        buildType2 = cacheFile.getVariableValue("CMAKE_BUILD_TYPE");
                    }
                }
            }
            catch (CMakeException e) {
                CPPLog.LOG.warn((Throwable)e);
            }
        }
        Pair pair = Pair.create((Object)cmakeListsFile, (Object)new OpenProjectSpec(sourceDir, generationDir2, buildType2, generator2));
        if (pair == null) {
            CMakeProjectOpenProcessor.$$$reportNull$$$0(5);
        }
        return pair;
    }

    public static boolean opened(@NotNull Project project) {
        if (project == null) {
            CMakeProjectOpenProcessor.$$$reportNull$$$0(6);
        }
        return project.getUserData(OPENED_KEY) == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/CMakeProjectOpenProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/CMakeProjectOpenProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpenProjectSpec";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canOpenProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doOpenProject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createOpenProjectSpec";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "opened";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }

    public static class OpenProjectSpec {
        @NotNull
        public final File sourceDir;
        @Nullable
        public final File generationDir;
        @Nullable
        public final String buildType;
        @Nullable
        public final CMakeGeneratorSpec generator;

        public OpenProjectSpec(@NotNull File sourceDir, @Nullable File generationDir2, @Nullable String buildType2, @Nullable CMakeGeneratorSpec generator2) {
            if (sourceDir == null) {
                OpenProjectSpec.$$$reportNull$$$0(0);
            }
            this.sourceDir = sourceDir;
            this.generationDir = generationDir2;
            this.buildType = buildType2;
            this.generator = generator2;
        }

        public boolean isInSourceGeneration() {
            return FileUtil.filesEqual((File)this.sourceDir, (File)this.generationDir);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDir", "com/jetbrains/cidr/cpp/cmake/CMakeProjectOpenProcessor$OpenProjectSpec", "<init>"));
        }
    }
}

