/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.actions;

import com.intellij.cidr.translateCode.CidrTranslateCodeService;
import com.intellij.cidr.translateCode.CidrTranslationCommand;
import com.intellij.cidr.translateCode.CidrTranslationResult;
import com.intellij.cidr.translateCode.CidrTranslationResultBuilder;
import com.intellij.cidr.translateCode.GasAsm;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.actions.MSVCAsmTranslator;
import com.jetbrains.cidr.cpp.execution.build.CLionCompileFileUtil;
import com.jetbrains.cidr.execution.debugger.memory.disasm.DisasmFileType;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/cpp/actions/ClangClAsmTranslator;", "Lcom/jetbrains/cidr/cpp/actions/MSVCAsmTranslator;", "compileDescriptor", "Lcom/jetbrains/cidr/cpp/execution/build/CLionCompileFileUtil$FileDescriptor;", "srcFilePath", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/cidr/cpp/execution/build/CLionCompileFileUtil$FileDescriptor;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "getTranslationResult", "Lcom/intellij/cidr/translateCode/CidrTranslationResult;", "command", "Lcom/intellij/cidr/translateCode/CidrTranslationCommand;", "compilerResult", "Lcom/intellij/execution/process/ProcessOutput;", "intellij.clion.execution"})
public final class ClangClAsmTranslator
extends MSVCAsmTranslator {
    public ClangClAsmTranslator(@NotNull CLionCompileFileUtil.FileDescriptor compileDescriptor, @NotNull String srcFilePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)compileDescriptor), (String)"compileDescriptor");
        Intrinsics.checkNotNullParameter((Object)srcFilePath, (String)"srcFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(compileDescriptor, srcFilePath, project);
    }

    @Override
    @NotNull
    public CidrTranslationResult getTranslationResult(@NotNull CidrTranslationCommand command, @NotNull ProcessOutput compilerResult) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)compilerResult, (String)"compilerResult");
        List<ToggleAction> options = this.createOptions(false);
        if (compilerResult.getExitCode() != 0) {
            String string = compilerResult.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            return new CidrTranslationResult(string, null, null, command, options, null, 38, null);
        }
        File asmFile = new File(this.getCompileDescriptor().getDirectory(), "output.asm");
        if (!asmFile.exists()) {
            return new CidrTranslationResult("Cannot find assembly file " + asmFile.getAbsolutePath(), null, null, command, options, null, 38, null);
        }
        String asm = FilesKt.readText$default((File)asmFile, null, (int)1, null);
        asmFile.delete();
        DisasmFileType disasmFileType = DisasmFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)disasmFileType, (String)"INSTANCE");
        CidrTranslationResultBuilder builder2 = new CidrTranslationResultBuilder((FileType)disasmFileType, command, options, null, 8, null);
        GasAsm gasAsm = new GasAsm(asm, this.getSrcFilePath(), CidrTranslateCodeService.Companion.getShowRawTranslatedCode(), this.getCompileDescriptor().getEnvironment().getToolchain().getToolSetKind().isRemoteLike(), true, null, 32, null);
        return gasAsm.processLines(builder2);
    }
}

