/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.clion.ProfilerEnvironmentHost;
import com.intellij.profiler.linux.KernelVariable;
import com.intellij.profiler.linux.KernelVariablesFixer;
import com.intellij.profiler.linux.OK;
import com.intellij.profiler.linux.VariableValidationResult;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J(\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001aH\u0014J \u0010\u001b\u001a\u00020\n2\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001aH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/clion/perf/RemoteKernelVariablesFixer;", "Lcom/intellij/profiler/linux/KernelVariablesFixer;", "environmentHost", "Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;Lcom/intellij/openapi/project/Project;)V", "createTempExecutableScript", "Ljava/nio/file/Path;", "prefix", "", "suffix", "content", "executeScript", "Lcom/intellij/execution/process/ProcessOutput;", "scriptPath", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "timeout", "", "getChangeVarsPermanentlyScript", "sysctlPath", "validationResult", "", "Lcom/intellij/profiler/linux/KernelVariable;", "Lcom/intellij/profiler/linux/VariableValidationResult;", "Lcom/intellij/profiler/linux/AllVariablesValidationResult;", "getChangeVarsUntilRestartScriptPath", "intellij.profiler.clion"})
@SourceDebugExtension(value={"SMAP\nRemoteKernelVariablesFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteKernelVariablesFixer.kt\ncom/intellij/profiler/clion/perf/RemoteKernelVariablesFixer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n494#2,7:52\n494#2,7:63\n1549#3:59\n1620#3,3:60\n1549#3:70\n1620#3,3:71\n*S KotlinDebug\n*F\n+ 1 RemoteKernelVariablesFixer.kt\ncom/intellij/profiler/clion/perf/RemoteKernelVariablesFixer\n*L\n21#1:52,7\n27#1:63,7\n21#1:59\n21#1:60,3\n27#1:70\n27#1:71,3\n*E\n"})
public final class RemoteKernelVariablesFixer
extends KernelVariablesFixer {
    @NotNull
    private final ProfilerEnvironmentHost environmentHost;
    @NotNull
    private final Project project;

    public RemoteKernelVariablesFixer(@NotNull ProfilerEnvironmentHost environmentHost, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.environmentHost = environmentHost;
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String getChangeVarsUntilRestartScriptPath(@NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Map<KernelVariable, ? extends VariableValidationResult> $this$filterValues$iv = validationResult;
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry<KernelVariable, ? extends VariableValidationResult> entry$iv : $this$filterValues$iv.entrySet()) {
            VariableValidationResult it = entry$iv.getValue();
            boolean bl = false;
            if (!(!(it instanceof OK))) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$map$iv = ((Map)result$iv).keySet();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KernelVariable kernelVariable = (KernelVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("echo " + it.getRequiredValue() + " > " + it.getPath());
        }
        List echoLines = (List)destination$iv$iv;
        String script = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"#!/bin/sh"), (Iterable)echoLines), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return ((Object)this.createTempExecutableScript("change_kernel_variables_until_restart", ".sh", script)).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String getChangeVarsPermanentlyScript(@NotNull String sysctlPath, @NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sysctlPath, (String)"sysctlPath");
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Map<KernelVariable, ? extends VariableValidationResult> $this$filterValues$iv = validationResult;
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry<KernelVariable, ? extends VariableValidationResult> entry$iv : $this$filterValues$iv.entrySet()) {
            VariableValidationResult it = entry$iv.getValue();
            boolean bl = false;
            if (!(!(it instanceof OK))) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$map$iv = ((Map)result$iv).keySet();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KernelVariable kernelVariable = (KernelVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("echo kernel." + it.getName() + "=" + it.getRequiredValue() + " >> " + ((Object)this.environmentHost.getPath(sysctlPath, this.project)).toString());
        }
        List sysctlLines = (List)destination$iv$iv;
        Object[] objectArray = new String[]{"#!/bin/sh", "set -e"};
        String script = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)sysctlLines), (Object)"sysctl --system"), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return ((Object)this.createTempExecutableScript("change_kernel_variables_permanently", ".sh", script)).toString();
    }

    @NotNull
    protected ProcessOutput executeScript(@NotNull String scriptPath, @NotNull ProgressIndicator indicator, int timeout) {
        Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String[] stringArray = new String[]{scriptPath};
        BaseProcessHandler handler2 = ProfilerEnvironmentHost.createProcessHandler$default(this.environmentHost, new GeneralCommandLine(stringArray), this.project, null, null, null, null, true, 60, null);
        return this.environmentHost.runProcess((ProcessHandler)handler2, indicator, timeout, this.project);
    }

    private final Path createTempExecutableScript(String prefix, String suffix, String content) {
        Path tempFile = Files.createTempFile(this.environmentHost.getTempDirectory(this.project), prefix, suffix, new FileAttribute[0]);
        byte[] byArray = content.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Files.write(tempFile, byArray, new OpenOption[0]);
        if (this.environmentHost.isRemote(this.project) && !this.environmentHost.isWSL(this.project)) {
            Files.setPosixFilePermissions(tempFile, PosixFilePermissions.fromString("rwxr-xr-x"));
        } else {
            Intrinsics.checkNotNull((Object)tempFile);
            FileUtil.setExecutable((File)new File(((Object)tempFile).toString()));
        }
        Intrinsics.checkNotNull((Object)tempFile);
        return tempFile;
    }
}

