/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Version;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.LineByLineParser;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.MisConfiguredExceptionKt;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.clion.ProfilerConfigurable;
import com.intellij.profiler.clion.ProfilerEnvironmentHost;
import com.intellij.profiler.clion.perf.PerfProfilerProcess;
import com.intellij.profiler.clion.perf.PerfProfilerSettings;
import com.intellij.profiler.clion.perf.PerfUtils;
import com.intellij.profiler.clion.perf.RemoteKernelVariable;
import com.intellij.profiler.clion.perf.RemoteKernelVariablesFixer;
import com.intellij.profiler.dtrace.SimpleProfilerSettingsState;
import com.intellij.profiler.linux.HasInvalidVariables;
import com.intellij.profiler.linux.KernelVariable;
import com.intellij.profiler.linux.KernelVariablesChangeRequiredException;
import com.intellij.profiler.linux.KernelVariablesFixer;
import com.intellij.profiler.linux.KernelVariablesValidatorKt;
import com.intellij.profiler.linux.ValidationResult;
import com.intellij.util.VersionUtil;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.text.StringKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/clion/perf/PerfUtils;", "", "()V", "Companion", "intellij.profiler.clion"})
public final class PerfUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<SimpleProfilerSettingsState> defaultPerfSettings$delegate = LazyKt.lazy((Function0)Companion.defaultPerfSettings.2.INSTANCE);
    @NotNull
    private static final Pattern VERSION_PATTERN = new Regex("perf version ([0-9]+(?:\\.[0-9]+)+).*").toPattern();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\r\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J.\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\u0019\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ \u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J*\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u00105\u001a\u0004\u0018\u0001062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u00067"}, d2={"Lcom/intellij/profiler/clion/perf/PerfUtils$Companion;", "", "()V", "VERSION_PATTERN", "Ljava/util/regex/Pattern;", "getVERSION_PATTERN", "()Ljava/util/regex/Pattern;", "defaultPerfSettings", "Lcom/intellij/profiler/dtrace/SimpleProfilerSettingsState;", "getDefaultPerfSettings", "()Lcom/intellij/profiler/dtrace/SimpleProfilerSettingsState;", "defaultPerfSettings$delegate", "Lkotlin/Lazy;", "attachPerfProfiler", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/profiler/api/ProfilerProcess;", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "targetProcess", "backgroundOption", "Lcom/intellij/openapi/progress/PerformInBackgroundOption;", "environmentHost", "Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;", "project", "Lcom/intellij/openapi/project/Project;", "createLRUCache", "", "T", "V", "maxCapacity", "", "loadFactor", "", "createOutputFilePath", "Ljava/nio/file/Path;", "outputDirectory", "", "createProcessHandler", "Lcom/intellij/execution/process/BaseProcessHandler;", "cl", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "parser", "Lcom/intellij/profiler/LineByLineParser;", "getKernelVariableFixer", "Lcom/intellij/profiler/linux/KernelVariablesFixer;", "getPerfVersion", "Lcom/intellij/openapi/util/Version;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getRequiredKernelVariables", "", "Lcom/intellij/profiler/linux/KernelVariable;", "validateKernelVariables", "Lcom/intellij/profiler/linux/KernelVariablesChangeRequiredException;", "validatePerfSettings", "Lcom/intellij/profiler/MisConfiguredException;", "intellij.profiler.clion"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleProfilerSettingsState getDefaultPerfSettings() {
            Lazy lazy = defaultPerfSettings$delegate;
            return (SimpleProfilerSettingsState)lazy.getValue();
        }

        @NotNull
        public final Pattern getVERSION_PATTERN() {
            return VERSION_PATTERN;
        }

        @NotNull
        public final BaseProcessHandler<?> createProcessHandler(@NotNull GeneralCommandLine cl, @NotNull LineByLineParser parser2, @NotNull ProfilerEnvironmentHost environmentHost, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
            Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BaseProcessHandler processHandler = ProfilerEnvironmentHost.createProcessHandler$default(environmentHost, cl, project, false, false, false, true, null, 64, null);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(parser2){
                final /* synthetic */ LineByLineParser $parser;
                {
                    this.$parser = $parser;
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT)) {
                        String string = event.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        LineByLineParser.consumeText$default((LineByLineParser)this.$parser, (String)string, null, (int)2, null);
                    }
                }
            });
            return processHandler;
        }

        @NotNull
        public final <T, V> Map<T, V> createLRUCache(int maxCapacity, float loadFactor) {
            return (Map)new FixedHashMap(maxCapacity, 10, loadFactor, true);
        }

        @Nullable
        public final Version getPerfVersion(@NotNull ProgressIndicator indicator, @NotNull ProfilerEnvironmentHost environmentHost, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String perfExecutablePath = environmentHost.getEnvPath(PerfProfilerSettings.Companion.getInstance().getState().getExecutablePath(), project);
            String[] stringArray = new String[]{perfExecutablePath, "--version"};
            GeneralCommandLine cl = new GeneralCommandLine(stringArray);
            Ref ref = Ref.create();
            Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
            Ref version = ref;
            BaseProcessHandler<?> handler2 = this.createProcessHandler(cl, new LineByLineParser((Ref<Version>)version){
                final /* synthetic */ Ref<Version> $version;
                {
                    this.$version = $version;
                }

                public void consumeLine(@NotNull String line) {
                    Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                    if (this.$version.isNull()) {
                        Pattern[] patternArray = new Pattern[]{PerfUtils.Companion.getVERSION_PATTERN()};
                        this.$version.set((Object)VersionUtil.parseVersion((String)line, (Pattern[])patternArray));
                    }
                }
            }, environmentHost, project);
            environmentHost.runProcess((ProcessHandler)handler2, indicator, -1, project);
            return !version.isNull() ? (Version)version.get() : null;
        }

        @Nullable
        public final MisConfiguredException validatePerfSettings(@NotNull ProfilerEnvironmentHost environmentHost, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            SimpleProfilerSettingsState state = PerfProfilerSettings.Companion.getInstance().getState();
            String string = state.getExecutablePath();
            if (string == null) {
                string = "";
            }
            Path perfPath = environmentHost.getPath(string, project);
            String string2 = state.getOutputDirectory();
            if (string2 == null) {
                string2 = "";
            }
            Path outputDirectoryPath = environmentHost.getPath(string2, project);
            boolean checkFilePathExist = environmentHost.shouldCheckFilePathExist(project);
            MisConfiguredException misConfiguredException = MisConfiguredExceptionKt.validateLocalPath$default((Path)perfPath, (String)"Perf executable", (boolean)checkFilePathExist, (Project)project, ProfilerConfigurable.class, null, (int)32, null);
            if (misConfiguredException == null && (misConfiguredException = MisConfiguredExceptionKt.validateOutputDirectory((Path)outputDirectoryPath, (boolean)checkFilePathExist, (Project)project, ProfilerConfigurable.class)) == null) {
                misConfiguredException = (MisConfiguredException)MisConfiguredExceptionKt.validateFrequency((int)state.getSamplingFrequency(), (Project)project, ProfilerConfigurable.class);
            }
            return misConfiguredException;
        }

        @Nullable
        public final KernelVariablesChangeRequiredException validateKernelVariables(@NotNull ProfilerEnvironmentHost environmentHost, @NotNull Project project) {
            ValidationResult validationResult;
            Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (environmentHost.shouldCheckFilePathExist(project) && (validationResult = KernelVariablesValidatorKt.checkKernelVariables(this.getRequiredKernelVariables(environmentHost, project), (KernelVariablesFixer)this.getKernelVariableFixer(environmentHost, project))) instanceof HasInvalidVariables) {
                return new KernelVariablesChangeRequiredException((HasInvalidVariables)validationResult, project);
            }
            return null;
        }

        private final KernelVariablesFixer getKernelVariableFixer(ProfilerEnvironmentHost environmentHost, Project project) {
            return environmentHost.isRemote(project) ? (KernelVariablesFixer)new RemoteKernelVariablesFixer(environmentHost, project) : new KernelVariablesFixer();
        }

        @NotNull
        public final Promise<? extends ProfilerProcess<? extends AttachableTargetProcess>> attachPerfProfiler(@NotNull AttachableTargetProcess targetProcess, @NotNull PerformInBackgroundOption backgroundOption, @NotNull ProfilerEnvironmentHost environmentHost, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
            Intrinsics.checkNotNullParameter((Object)backgroundOption, (String)"backgroundOption");
            Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AsyncPromise result2 = new AsyncPromise();
            String string = CommonProfilerBundleKt.commonProfilerMessage((String)"attach.task.title", (Object[])new Object[0]);
            new Task.Backgroundable(project, backgroundOption, environmentHost, targetProcess, (AsyncPromise<PerfProfilerProcess>)result2, string){
                final /* synthetic */ Project $project;
                final /* synthetic */ ProfilerEnvironmentHost $environmentHost;
                final /* synthetic */ AttachableTargetProcess $targetProcess;
                final /* synthetic */ AsyncPromise<PerfProfilerProcess> $result;
                {
                    this.$project = $project;
                    this.$environmentHost = $environmentHost;
                    this.$targetProcess = $targetProcess;
                    this.$result = $result;
                    super($project, $super_call_param$1, true, $backgroundOption);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    SimpleProfilerSettingsState settings2 = PerfProfilerSettings.Companion.getInstance().getState();
                    String perfPath = this.$environmentHost.getEnvPath(settings2.getExecutablePath(), this.$project);
                    Path outputFilePath = PerfUtils.Companion.createOutputFilePath(StringKt.nullize$default((String)settings2.getOutputDirectory(), (boolean)false, (int)1, null), this.$environmentHost, this.$project);
                    String[] stringArray = new String[]{perfPath};
                    GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray);
                    stringArray = new String[]{"record", "-p", String.valueOf(this.$targetProcess.getPid()), "--freq=" + settings2.getSamplingFrequency()};
                    GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters(stringArray).withParameters(settings2.getDefaultCmdArgs());
                    stringArray = new String[]{"-o", this.$environmentHost.getEnvPath(((Object)outputFilePath).toString(), this.$project)};
                    GeneralCommandLine generalCommandLine3 = generalCommandLine2.withParameters(stringArray);
                    Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine3, (String)"withParameters(...)");
                    GeneralCommandLine cl = generalCommandLine3;
                    BaseProcessHandler perfRecordProcessHandler = ProfilerEnvironmentHost.createProcessHandler$default(this.$environmentHost, cl, this.$project, false, false, false, false, null, 64, null);
                    if (perfRecordProcessHandler instanceof KillableProcessHandler) {
                        ((KillableProcessHandler)perfRecordProcessHandler).setShouldKillProcessSoftly(true);
                    }
                    perfRecordProcessHandler.startNotify();
                    PerfProfilerProcess perfProfilerProcess = new PerfProfilerProcess(perfRecordProcessHandler, outputFilePath, this.$targetProcess.getShortName(), System.currentTimeMillis(), this.$environmentHost, this.$project);
                    this.$result.setResult((Object)((Object)perfProfilerProcess));
                }
            }.queue();
            return (Promise)result2;
        }

        @NotNull
        public final Path createOutputFilePath(@Nullable String outputDirectory, @NotNull ProfilerEnvironmentHost environmentHost, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            CharSequence charSequence = outputDirectory;
            if (charSequence == null || charSequence.length() == 0) {
                Path path = Files.createTempFile(environmentHost.getTempDirectory(project), "clion", "perf", new FileAttribute[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
                return path;
            }
            Path path = Files.createTempFile(environmentHost.getPath(outputDirectory, project), "clion", "perf", new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
            return path;
        }

        private final List<KernelVariable> getRequiredKernelVariables(ProfilerEnvironmentHost environmentHost, Project project) {
            RemoteKernelVariable[] remoteKernelVariableArray = new RemoteKernelVariable[]{new RemoteKernelVariable(environmentHost, project, "perf_event_paranoid", "1", (Function1<? super String, Boolean>)((Function1)getRequiredKernelVariables.1.INSTANCE)), new RemoteKernelVariable(environmentHost, project, "kptr_restrict", "0", (Function1<? super String, Boolean>)((Function1)getRequiredKernelVariables.2.INSTANCE))};
            return CollectionsKt.listOf((Object[])remoteKernelVariableArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

