/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.profiler.api.XLocalAttachProfiler;
import com.intellij.profiler.api.XLocalAttachProfilerProvider;
import com.intellij.profiler.clion.ProfilerPresentationGroup;
import com.intellij.profiler.clion.dtrace.DTraceAttachProfiler;
import com.intellij.profiler.clion.perf.PerfAttachProfiler;
import com.intellij.xdebugger.attach.XAttachProcessPresentationGroup;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/clion/CLionLocalAttachProfilerProvider;", "Lcom/intellij/profiler/api/XLocalAttachProfilerProvider;", "()V", "getAvailableProfilers", "", "Lcom/intellij/profiler/api/XLocalAttachProfiler;", "project", "Lcom/intellij/openapi/project/Project;", "process", "Lcom/intellij/execution/process/ProcessInfo;", "contextHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "getPresentationGroup", "Lcom/intellij/xdebugger/attach/XAttachProcessPresentationGroup;", "isEnabled", "", "intellij.profiler.clion"})
public final class CLionLocalAttachProfilerProvider
implements XLocalAttachProfilerProvider {
    public boolean isEnabled() {
        return SystemInfo.isMac || SystemInfo.isLinux;
    }

    @NotNull
    public XAttachProcessPresentationGroup getPresentationGroup() {
        return ProfilerPresentationGroup.Companion.getPresentationGroup();
    }

    @NotNull
    public List<XLocalAttachProfiler> getAvailableProfilers(@NotNull Project project, @NotNull ProcessInfo process2, @NotNull UserDataHolder contextHolder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)contextHolder, (String)"contextHolder");
        if (SystemInfo.isMac) {
            return CollectionsKt.listOf((Object)new DTraceAttachProfiler(process2));
        }
        if (SystemInfo.isLinux) {
            return CollectionsKt.listOf((Object)new PerfAttachProfiler(process2));
        }
        return CollectionsKt.emptyList();
    }
}

