/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.profiler;

import com.intellij.clion.profiling.memory.CLionMemoryProfileUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.clion.ProfilerEnvironmentHost;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JS\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010)\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/clion/profiling/profiler/CppProfilerEnvironmentHost;", "Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "(Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;)V", "createProcessHandler", "Lcom/intellij/execution/process/BaseProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "project", "Lcom/intellij/openapi/project/Project;", "colored", "", "usePty", "captureProcessOutput", "splitLines", "withElevated", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/intellij/openapi/project/Project;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/intellij/execution/process/BaseProcessHandler;", "getEnvPath", "", "path", "getPath", "Ljava/nio/file/Path;", "getProcessList", "", "Lcom/intellij/execution/process/ProcessInfo;", "getTempDirectory", "getWSLVersion", "", "isRemote", "isWSL", "runProcess", "Lcom/intellij/execution/process/ProcessOutput;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "timeout", "sendSignal", "pid", "signalName", "shouldCheckFilePathExist", "intellij.clion.profiling"})
public final class CppProfilerEnvironmentHost
implements ProfilerEnvironmentHost {
    @NotNull
    private final CidrToolEnvironment environment;

    public CppProfilerEnvironmentHost(@NotNull CidrToolEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        this.environment = environment2;
    }

    @Override
    public boolean shouldCheckFilePathExist(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CLionMemoryProfileUtil.checkPathExistAllowed(this.environment.getHostMachine());
    }

    @Override
    @NotNull
    public Path getPath(@NotNull String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path2 = this.environment.getHostMachine().getPath(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPath(...)");
        return path2;
    }

    @Override
    @NotNull
    public String getEnvPath(@Nullable String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = this.environment.toEnvPath(path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toEnvPath(...)");
        return string;
    }

    @Override
    @NotNull
    public Path getTempDirectory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path = this.environment.getHostMachine().getTempDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getTempDirectory(...)");
        return path;
    }

    @Override
    public boolean isRemote(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.environment.getHostMachine().isRemote();
    }

    @Override
    public boolean isWSL(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.environment instanceof CPPEnvironment && ((CPPEnvironment)this.environment).getToolSet().isWSL();
    }

    @Override
    public int getWSLVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.isWSL(project)) {
            return -1;
        }
        CidrToolEnvironment cidrToolEnvironment = this.environment;
        Intrinsics.checkNotNull((Object)cidrToolEnvironment, (String)"null cannot be cast to non-null type com.jetbrains.cidr.cpp.toolchains.CPPEnvironment");
        WSL wSL = (WSL)((CPPEnvironment)cidrToolEnvironment).getToolSet();
        if (wSL == null) {
            return -1;
        }
        WSL wsl = wSL;
        WSLDistribution wSLDistribution = wsl.getWslDistribution();
        return wSLDistribution != null ? wSLDistribution.getVersion() : -1;
    }

    @Override
    @NotNull
    public BaseProcessHandler<?> createProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull Project project, @Nullable Boolean colored, @Nullable Boolean usePty, @Nullable Boolean captureProcessOutput, @Nullable Boolean splitLines, @Nullable Boolean withElevated) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CidrProcessBuilder cidrProcessBuilder = this.environment.getHostMachine().createProcessBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)cidrProcessBuilder, (String)"createProcessBuilder(...)");
        CidrProcessBuilder processBuilder = cidrProcessBuilder;
        if (colored != null) {
            processBuilder.withColoredOutput(colored.booleanValue());
        }
        if (usePty != null) {
            processBuilder.withPty(usePty.booleanValue());
        }
        if (captureProcessOutput != null) {
            processBuilder.withCapturedOutput(captureProcessOutput.booleanValue());
        }
        if (splitLines != null) {
            processBuilder.withSplitToLines(splitLines.booleanValue());
        }
        if (withElevated != null) {
            processBuilder.withElevated(withElevated.booleanValue());
        }
        return processBuilder.build(commandLine);
    }

    @Override
    @NotNull
    public ProcessOutput runProcess(@NotNull ProcessHandler handler2, @NotNull ProgressIndicator indicator, int timeout, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProcessOutput processOutput = CidrRunProcessUtil.runProcess((ProcessHandler)handler2, (ProgressIndicator)indicator, (int)timeout);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return processOutput;
    }

    @Override
    @NotNull
    public List<ProcessInfo> getProcessList(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List list2 = this.environment.getHostMachine().getProcessList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getProcessList(...)");
        return list2;
    }

    @Override
    public int sendSignal(int pid, @NotNull String signalName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)signalName, (String)"signalName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.environment.getHostMachine().sendSignal(pid, signalName);
    }
}

