/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.ide;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.project.workspace.OCRootTree;
import com.jetbrains.cidr.workspaceModelBridge.OCExcludeWorkspaceModelRootsBuilder;
import com.jetbrains.cidr.workspaceModelBridge.OCWorkspaceModelRootsBuilder;
import com.jetbrains.cidr.workspaceModelBridge.OCWorkspaceModelRootsSynchronizer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u0019H\u0016R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/clion/ide/CLionWorkspaceModelRootsBuilder;", "Lcom/jetbrains/cidr/workspaceModelBridge/OCExcludeWorkspaceModelRootsBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "myModule", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleBridge;", "myModuleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "myBuilder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "externalSystemId", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleBridge;Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;Lcom/intellij/platform/workspace/storage/MutableEntityStorage;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;Ljava/lang/String;)V", "contentRoots", "", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "Lcom/intellij/platform/workspace/jps/entities/ContentRootEntity;", "addContentRoot", "", "state", "Lcom/jetbrains/cidr/workspaceModelBridge/OCWorkspaceModelRootsBuilder$State;", "url", "visitSubTree", "Lcom/jetbrains/cidr/project/workspace/OCRootTree;", "path", "subTree", "Companion", "Provider", "intellij.clion.ide"})
@SourceDebugExtension(value={"SMAP\nCLionWorkspaceModelRootsBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLionWorkspaceModelRootsBuilder.kt\ncom/intellij/clion/ide/CLionWorkspaceModelRootsBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1747#2,3:119\n*S KotlinDebug\n*F\n+ 1 CLionWorkspaceModelRootsBuilder.kt\ncom/intellij/clion/ide/CLionWorkspaceModelRootsBuilder\n*L\n55#1:119,3\n*E\n"})
public final class CLionWorkspaceModelRootsBuilder
extends OCExcludeWorkspaceModelRootsBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFileUrl, ContentRootEntity> contentRoots;

    public CLionWorkspaceModelRootsBuilder(@NotNull Project project, @NotNull ModuleBridge myModule, @NotNull ModuleEntity myModuleEntity, @NotNull MutableEntityStorage myBuilder, @NotNull VirtualFileUrlManager virtualFileManager, @Nullable String externalSystemId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myModule, (String)"myModule");
        Intrinsics.checkNotNullParameter((Object)myModuleEntity, (String)"myModuleEntity");
        Intrinsics.checkNotNullParameter((Object)myBuilder, (String)"myBuilder");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        super(myModule, myModuleEntity, myBuilder, virtualFileManager, externalSystemId);
        this.project = project;
        this.contentRoots = new HashMap();
    }

    @NotNull
    public OCRootTree visitSubTree(@Nullable String path, @NotNull OCRootTree subTree) {
        Intrinsics.checkNotNullParameter((Object)subTree, (String)"subTree");
        if (!Companion.isEnabled()) {
            OCRootTree oCRootTree = super.visitSubTree(path, subTree);
            Intrinsics.checkNotNullExpressionValue((Object)oCRootTree, (String)"visitSubTree(...)");
            return oCRootTree;
        }
        if (path == null) {
            return subTree;
        }
        boolean isLibrary = subTree.getItems().contains(OCRootTree.RootKind.LIBRARY);
        if (isLibrary) {
            boolean bl;
            block7: {
                Collection collection = subTree.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChildren(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        OCRootTree it = (OCRootTree)element$iv;
                        boolean bl2 = false;
                        if (!(it.getItems().contains(OCRootTree.RootKind.CONTENT) || it.getItems().contains(OCRootTree.RootKind.SOURCE))) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                OCRootTree.RootKind[] rootKindArray = new OCRootTree.RootKind[]{OCRootTree.RootKind.CONTENT};
                OCRootTree oCRootTree = subTree.replaceItems(rootKindArray);
                Intrinsics.checkNotNullExpressionValue((Object)oCRootTree, (String)"replaceItems(...)");
                return oCRootTree;
            }
        }
        return subTree;
    }

    public void addContentRoot(@NotNull OCWorkspaceModelRootsBuilder.State state, @NotNull String url) {
        ContentRootEntity oldContentEntry;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        boolean bl2 = bl = state.getContentEntry() == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (!Companion.isEnabled() || !PluginUtils.hasCLion() || PlatformProjectOpenProcessor.Companion.isTempProject(this.project)) {
            super.addContentRoot(state, url);
            return;
        }
        VirtualFileUrl virtualFileUrl = this.getVirtualFileManager().getOrCreateFromUrl(url);
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isRegularFile(VirtualFileUrlManagerUtil.toPath((VirtualFileUrl)virtualFileUrl), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                VirtualFileUrl virtualFileUrl2 = virtualFileUrl.getParent();
                if (virtualFileUrl2 == null) {
                    virtualFileUrl2 = virtualFileUrl;
                }
                virtualFileUrl = virtualFileUrl2;
            }
        }
        catch (IOException ex) {
            OCWorkspaceModelRootsSynchronizer.LOG.warn((Throwable)ex);
        }
        if ((oldContentEntry = this.contentRoots.get(virtualFileUrl)) != null) {
            state.setContentEntry(oldContentEntry);
            return;
        }
        String string = virtualFileUrl.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        super.addContentRoot(state, string);
        ContentRootEntity newContentEntry = state.getContentEntry();
        if (newContentEntry != null) {
            this.contentRoots.put(virtualFileUrl, newContentEntry);
        }
    }

    @JvmStatic
    public static final boolean isEnabled() {
        return Companion.isEnabled();
    }

    @JvmStatic
    @TestOnly
    public static final void setEnabled(boolean value, @NotNull Disposable disposable) {
        Companion.setEnabled(value, disposable);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007R\u0011\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u000b"}, d2={"Lcom/intellij/clion/ide/CLionWorkspaceModelRootsBuilder$Companion;", "", "()V", "isEnabled", "", "()Z", "setEnabled", "", "value", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.clion.ide"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isEnabled() {
            return Registry.is((String)"clion.workspace.external.source.group.into.folders", (boolean)true);
        }

        @JvmStatic
        @TestOnly
        public final void setEnabled(boolean value, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Registry.get((String)"clion.workspace.external.source.group.into.folders").setValue(String.valueOf(value), disposable);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/clion/ide/CLionWorkspaceModelRootsBuilder$Provider;", "Lcom/jetbrains/cidr/workspaceModelBridge/OCWorkspaceModelRootsBuilder$Provider;", "()V", "getRootsBuilder", "Lcom/jetbrains/cidr/workspaceModelBridge/OCWorkspaceModelRootsBuilder;", "module", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleBridge;", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "externalSystemId", "", "intellij.clion.ide"})
    public static final class Provider
    extends OCWorkspaceModelRootsBuilder.Provider {
        @NotNull
        protected OCWorkspaceModelRootsBuilder getRootsBuilder(@NotNull ModuleBridge module, @NotNull ModuleEntity moduleEntity, @NotNull MutableEntityStorage builder2, @NotNull VirtualFileUrlManager virtualFileManager, @Nullable String externalSystemId) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return (OCWorkspaceModelRootsBuilder)new CLionWorkspaceModelRootsBuilder(project, module, moduleEntity, builder2, virtualFileManager, externalSystemId);
        }
    }
}

