/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.valgrind;

import com.intellij.cidr.profiling.CidrProfilingBundle;
import com.intellij.cidr.profiling.valgrind.ValgrindSettings;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\r\u0010\u0015\u001a\u00070\n\u00a2\u0006\u0002\b\u0016H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/cidr/profiling/valgrind/ValgrindConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "()V", "myCommandLineEditor", "Lcom/intellij/ui/RawCommandLineEditor;", "mySettings", "Lcom/intellij/cidr/profiling/valgrind/ValgrindSettings;", "Lorg/jetbrains/annotations/NotNull;", "mySuppressionFiles", "", "", "mySuppressionListModel", "Ljavax/swing/DefaultListModel;", "myValgrindPathTextFieldWithBrowseButton", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "createSuppressionFilesPanel", "Ljavax/swing/JPanel;", "getDisplayName", "Lorg/jetbrains/annotations/Nls;", "getHelpTopic", "getId", "isModified", "", "reset", "resetSuppressionFilesModel", "intellij.cidr.profiling"})
public final class ValgrindConfigurable
implements SearchableConfigurable {
    @NotNull
    private final ValgrindSettings mySettings;
    @NotNull
    private TextFieldWithBrowseButton myValgrindPathTextFieldWithBrowseButton;
    @NotNull
    private final RawCommandLineEditor myCommandLineEditor;
    @Nullable
    private DefaultListModel<String> mySuppressionListModel;
    @NotNull
    private List<String> mySuppressionFiles;

    public ValgrindConfigurable() {
        ValgrindSettings valgrindSettings = ValgrindSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)valgrindSettings, (String)"getInstance(...)");
        this.mySettings = valgrindSettings;
        this.myValgrindPathTextFieldWithBrowseButton = new TextFieldWithBrowseButton();
        this.myCommandLineEditor = new RawCommandLineEditor();
        this.mySuppressionFiles = new ArrayList(this.mySettings.getSuppressionFiles());
    }

    @NotNull
    public String getId() {
        return "dynamic.analysis.tools.valgrind";
    }

    @NotNull
    public String getDisplayName() {
        String string = CidrProfilingBundle.message("dynamic.analysis.tools.valgrind.configurable.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public JComponent createComponent() {
        this.myValgrindPathTextFieldWithBrowseButton.setText(this.mySettings.getValgrindPath());
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
        BrowseFilesListener listener2 = new BrowseFilesListener(this.myValgrindPathTextFieldWithBrowseButton.getTextField(), CidrProfilingBundle.message("valgrind.configurable.executable.dialog.title", new Object[0]), "", descriptor2);
        this.myValgrindPathTextFieldWithBrowseButton.addActionListener((ActionListener)listener2);
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ ValgrindConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = CidrProfilingBundle.message("valgrind.configurable.executable.label", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ ValgrindConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)ValgrindConfigurable.access$getMyValgrindPathTextFieldWithBrowseButton$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE);
                    }
                }).bottomGap(BottomGap.SMALL);
                String string2 = CidrProfilingBundle.message("valgrind.confugurable.analysisOptions.label", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ ValgrindConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Cell.comment$default((Cell)$this$row.cell((JComponent)ValgrindConfigurable.access$getMyCommandLineEditor$p(this.this$0)), (String)Strings.escapeXmlEntities((String)CidrProfilingBundle.message("valgrind.argument.hint", new Object[0])), (int)90, null, (int)4, null).align((Align)AlignX.FILL.INSTANCE);
                    }
                }).bottomGap(BottomGap.MEDIUM);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ ValgrindConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)ValgrindConfigurable.access$createSuppressionFilesPanel(this.this$0)).align((Align)AlignX.FILL.INSTANCE);
                    }
                }), (int)1, null);
            }
        }));
    }

    public boolean isModified() {
        return !Intrinsics.areEqual((Object)this.myValgrindPathTextFieldWithBrowseButton.getText(), (Object)this.mySettings.getValgrindPath()) || !Intrinsics.areEqual((Object)this.myCommandLineEditor.getText(), (Object)this.mySettings.getAnalysisOptions()) || !Intrinsics.areEqual(this.mySuppressionFiles, this.mySettings.getSuppressionFiles());
    }

    public void apply() throws ConfigurationException {
        this.mySettings.setValgrindPath(this.myValgrindPathTextFieldWithBrowseButton.getText());
        this.mySettings.setAnalysisOptions(this.myCommandLineEditor.getText());
        this.mySettings.setSuppressionFiles(this.mySuppressionFiles);
    }

    public void reset() {
        this.myValgrindPathTextFieldWithBrowseButton.setText(this.mySettings.getValgrindPath());
        this.myCommandLineEditor.setText(this.mySettings.getAnalysisOptions());
        this.mySuppressionFiles = new ArrayList(this.mySettings.getSuppressionFiles());
        this.resetSuppressionFilesModel();
    }

    private final JPanel createSuppressionFilesPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        this.mySuppressionListModel = new DefaultListModel();
        for (String suppressionFile : this.mySuppressionFiles) {
            DefaultListModel<String> defaultListModel = this.mySuppressionListModel;
            Intrinsics.checkNotNull(defaultListModel);
            defaultListModel.addElement(suppressionFile);
        }
        DefaultListModel<String> defaultListModel = this.mySuppressionListModel;
        Intrinsics.checkNotNull(defaultListModel);
        JBList suppressionFilesList = new JBList((ListModel)defaultListModel);
        suppressionFilesList.getEmptyText().setText(CidrProfilingBundle.message("valgrind.configurable.no.suppression.files", new Object[0]));
        suppressionFilesList.setSelectionMode(0);
        suppressionFilesList.setVisibleRowCount(5);
        String[] stringArray = new String[]{CommonActionsPanel.Buttons.ADD.getText(), CommonActionsPanel.Buttons.REMOVE.getText()};
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JList)((JList)suppressionFilesList)).setAddAction(arg_0 -> ValgrindConfigurable.createSuppressionFilesPanel$lambda$1(this, arg_0)).setRemoveAction(arg_0 -> ValgrindConfigurable.createSuppressionFilesPanel$lambda$2(suppressionFilesList, this, arg_0)).setButtonComparator(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)toolbarDecorator, (String)"setButtonComparator(...)");
        ToolbarDecorator decorator2 = toolbarDecorator;
        decorator2.setToolbarPosition(ActionToolbarPosition.RIGHT);
        panel2.add((Component)new JLabel(CidrProfilingBundle.message("valgrind.configurable.add.suppression.files.label", new Object[0])), "North");
        panel2.add((Component)decorator2.createPanel(), "Center");
        return panel2;
    }

    private final void resetSuppressionFilesModel() {
        DefaultListModel<String> defaultListModel = this.mySuppressionListModel;
        Intrinsics.checkNotNull(defaultListModel);
        defaultListModel.removeAllElements();
        for (String suppressionFile : this.mySuppressionFiles) {
            DefaultListModel<String> defaultListModel2 = this.mySuppressionListModel;
            Intrinsics.checkNotNull(defaultListModel2);
            defaultListModel2.addElement(suppressionFile);
        }
    }

    @NotNull
    public String getHelpTopic() {
        return "Valgrind";
    }

    private static final void createSuppressionFilesPanel$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void createSuppressionFilesPanel$lambda$1(ValgrindConfigurable this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor();
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, null, null, arg_0 -> ValgrindConfigurable.createSuppressionFilesPanel$lambda$1$lambda$0((Function1)new Function1<List<? extends VirtualFile>, Unit>(this$0){
            final /* synthetic */ ValgrindConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<? extends VirtualFile> files) {
                Intrinsics.checkNotNullParameter(files, (String)"files");
                String string = files.get(0).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                String filePath = string;
                DefaultListModel defaultListModel = ValgrindConfigurable.access$getMySuppressionListModel$p(this.this$0);
                Intrinsics.checkNotNull((Object)defaultListModel);
                defaultListModel.addElement(filePath);
                ValgrindConfigurable.access$getMySuppressionFiles$p(this.this$0).add(filePath);
            }
        }, arg_0));
    }

    private static final void createSuppressionFilesPanel$lambda$2(JBList $suppressionFilesList, ValgrindConfigurable this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)$suppressionFilesList, (String)"$suppressionFilesList");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int selectedIndex = $suppressionFilesList.getSelectedIndex();
        DefaultListModel<String> defaultListModel = this$0.mySuppressionListModel;
        Intrinsics.checkNotNull(defaultListModel);
        defaultListModel.remove(selectedIndex);
        this$0.mySuppressionFiles.remove(selectedIndex);
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getMyValgrindPathTextFieldWithBrowseButton$p(ValgrindConfigurable $this) {
        return $this.myValgrindPathTextFieldWithBrowseButton;
    }

    public static final /* synthetic */ RawCommandLineEditor access$getMyCommandLineEditor$p(ValgrindConfigurable $this) {
        return $this.myCommandLineEditor;
    }

    public static final /* synthetic */ JPanel access$createSuppressionFilesPanel(ValgrindConfigurable $this) {
        return $this.createSuppressionFilesPanel();
    }

    public static final /* synthetic */ DefaultListModel access$getMySuppressionListModel$p(ValgrindConfigurable $this) {
        return $this.mySuppressionListModel;
    }

    public static final /* synthetic */ List access$getMySuppressionFiles$p(ValgrindConfigurable $this) {
        return $this.mySuppressionFiles;
    }
}

