/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.memory.tree;

import com.intellij.cidr.profiling.CidrProfilingBundle;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileErrorCaptionTreeNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MemoryProfileTreeNode
extends DefaultMutableTreeNode {
    protected MemoryProfileTreeNode() {
    }

    protected MemoryProfileTreeNode(@NotNull Object userObject) {
        if (userObject == null) {
            MemoryProfileTreeNode.$$$reportNull$$$0(0);
        }
        super(userObject);
    }

    public final void customizeCellRenderer(@NotNull ColoredTextContainer renderer) {
        if (renderer == null) {
            MemoryProfileTreeNode.$$$reportNull$$$0(1);
        }
        this.render(renderer);
        if (this.showTotalWarnings()) {
            this.appendTotalWarningsText(renderer);
        }
    }

    protected void render(@NotNull ColoredTextContainer renderer) {
        String text;
        if (renderer == null) {
            MemoryProfileTreeNode.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(text = this.toString()))) {
            MemoryProfileTreeNode.appendEmptyText(renderer);
        } else {
            renderer.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            MemoryProfileTreeNode.appendSeparator(renderer);
        }
    }

    protected boolean showTotalWarnings() {
        return false;
    }

    private void appendTotalWarningsText(@NotNull ColoredTextContainer renderer) {
        if (renderer == null) {
            MemoryProfileTreeNode.$$$reportNull$$$0(3);
        }
        int totalWarnings = this.calculateTotalWarnings();
        renderer.append(CidrProfilingBundle.message("memory.profile.warnings.count", totalWarnings), SimpleTextAttributes.GRAY_ATTRIBUTES);
        MemoryProfileTreeNode.appendSeparator(renderer);
    }

    protected static void appendEmptyText(@NotNull ColoredTextContainer renderer) {
        if (renderer == null) {
            MemoryProfileTreeNode.$$$reportNull$$$0(4);
        }
        renderer.append(CidrProfilingBundle.message("memory.profile.node.empty", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        MemoryProfileTreeNode.appendSeparator(renderer);
    }

    protected static void appendSeparator(@NotNull ColoredTextContainer renderer) {
        if (renderer == null) {
            MemoryProfileTreeNode.$$$reportNull$$$0(5);
        }
        renderer.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    public Navigatable getNavigatable() {
        return null;
    }

    public boolean canBeExcluded() {
        return true;
    }

    @Override
    @Nls
    @NotNull
    public abstract String toString();

    private int calculateTotalWarnings() {
        HashSet errors = new HashSet();
        TreeUtil.traverse((TreeNode)this, node2 -> {
            if (node2 instanceof MemoryProfileErrorCaptionTreeNode) {
                errors.add(((MemoryProfileErrorCaptionTreeNode)node2).getError());
            }
            return true;
        });
        return errors.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cidr/profiling/memory/tree/MemoryProfileTreeNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendTotalWarningsText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "appendEmptyText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSeparator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

