/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.memory;

import com.intellij.cidr.profiling.memory.MemoryProfileFileReader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryProfileFileWatcher {
    private static final Logger LOG = Logger.getInstance(MemoryProfileFileWatcher.class);
    @NotNull
    private final VirtualFile myBaseDirectory;
    @Nullable
    private final Consumer<String> myConsumer;
    @Nullable
    private final Supplier<? extends Consumer<String>> myConsumerSupplier;
    @NotNull
    private final String myProfilerName;
    private final Project myProject;
    private final Set<String> myProcessedFiles;
    private final List<MemoryProfileFileReader> myReaders;
    private boolean myIsStopped;

    public MemoryProfileFileWatcher(@NotNull VirtualFile baseDirectory, @NotNull Consumer<String> consumer, @NotNull String profilerName, @NotNull Project project, @NotNull Disposable parentDisposable) {
        if (baseDirectory == null) {
            MemoryProfileFileWatcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            MemoryProfileFileWatcher.$$$reportNull$$$0(1);
        }
        if (profilerName == null) {
            MemoryProfileFileWatcher.$$$reportNull$$$0(2);
        }
        if (project == null) {
            MemoryProfileFileWatcher.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            MemoryProfileFileWatcher.$$$reportNull$$$0(4);
        }
        this.myProcessedFiles = new HashSet<String>();
        this.myReaders = new SmartList();
        this.myIsStopped = false;
        this.myBaseDirectory = baseDirectory;
        this.myConsumer = consumer;
        this.myConsumerSupplier = null;
        this.myProfilerName = profilerName;
        this.myProject = project;
        this.start(parentDisposable);
    }

    public MemoryProfileFileWatcher(@NotNull VirtualFile baseDirectory, @NotNull Supplier<? extends Consumer<String>> consumerSupplier, @NotNull String profilerName, @NotNull Project project, @NotNull Disposable parentDisposable) {
        if (baseDirectory == null) {
            MemoryProfileFileWatcher.$$$reportNull$$$0(5);
        }
        if (consumerSupplier == null) {
            MemoryProfileFileWatcher.$$$reportNull$$$0(6);
        }
        if (profilerName == null) {
            MemoryProfileFileWatcher.$$$reportNull$$$0(7);
        }
        if (project == null) {
            MemoryProfileFileWatcher.$$$reportNull$$$0(8);
        }
        if (parentDisposable == null) {
            MemoryProfileFileWatcher.$$$reportNull$$$0(9);
        }
        this.myProcessedFiles = new HashSet<String>();
        this.myReaders = new SmartList();
        this.myIsStopped = false;
        this.myBaseDirectory = baseDirectory;
        this.myConsumer = null;
        this.myConsumerSupplier = consumerSupplier;
        this.myProfilerName = profilerName;
        this.myProject = project;
        this.start(parentDisposable);
    }

    public void stop() {
        if (this.myIsStopped) {
            LOG.debug("MemoryProfileFileWatcher already stopped");
            return;
        }
        this.myIsStopped = true;
        this.myBaseDirectory.refresh(false, true);
        for (VirtualFile childrenFile : this.myBaseDirectory.getChildren()) {
            this.processFile(childrenFile);
        }
        for (MemoryProfileFileReader reader : this.myReaders) {
            reader.stop();
        }
    }

    private void start(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MemoryProfileFileWatcher.$$$reportNull$$$0(10);
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect(parentDisposable);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    MemoryProfileFileWatcher.this.processEvent(vFileEvent);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/cidr/profiling/memory/MemoryProfileFileWatcher$1", "after"));
            }
        });
    }

    private void processEvent(@NotNull VFileEvent event) {
        if (event == null) {
            MemoryProfileFileWatcher.$$$reportNull$$$0(11);
        }
        if (!(event instanceof VFileCreateEvent)) {
            return;
        }
        VFileCreateEvent createEvent = (VFileCreateEvent)event;
        if (createEvent.isDirectory()) {
            return;
        }
        VirtualFile createdFile = createEvent.getFile();
        if (createdFile == null || !createdFile.isValid()) {
            return;
        }
        if (createdFile.getParent() == null || !FileUtil.pathsEqual((String)this.myBaseDirectory.getPath(), (String)createdFile.getParent().getPath())) {
            return;
        }
        this.processFile(createdFile);
    }

    private synchronized void processFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            MemoryProfileFileWatcher.$$$reportNull$$$0(12);
        }
        if (!virtualFile.isValid()) {
            return;
        }
        String fileName = virtualFile.getName();
        if (this.myProcessedFiles.contains(fileName)) {
            return;
        }
        this.myProcessedFiles.add(fileName);
        try {
            Consumer<String> consumer = this.myConsumer != null ? this.myConsumer : this.myConsumerSupplier.get();
            MemoryProfileFileReader reader = new MemoryProfileFileReader(new File(virtualFile.getPath()), consumer, this.myProfilerName);
            this.myReaders.add(reader);
        }
        catch (IOException e) {
            LOG.warn("Cannot process output file due to error: " + e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerName";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumerSupplier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cidr/profiling/memory/MemoryProfileFileWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processEvent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "processFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

