/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.web;

import com.intellij.javascript.web.WebFramework;
import com.intellij.javascript.web.html.WebFrameworkHtmlFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolQualifiedKind;
import com.intellij.webSymbols.WebSymbolQualifiedName;
import com.intellij.webSymbols.query.WebSymbolNamesProvider;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VuejsIcons;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.lang.html.VueFileType;
import org.jetbrains.vuejs.lang.html.VueLanguage;
import org.jetbrains.vuejs.web.VueAttributeNameCodeCompletionFilter;
import org.jetbrains.vuejs.web.VueWebSymbolsQueryConfiguratorKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lorg/jetbrains/vuejs/web/VueFramework;", "Lcom/intellij/javascript/web/WebFramework;", "()V", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "getAttributeNameCodeCompletionFilter", "Ljava/util/function/Predicate;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "getFileType", "Lcom/intellij/javascript/web/html/WebFrameworkHtmlFileType;", "kind", "Lcom/intellij/javascript/web/WebFramework$SourceFileKind;", "context", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getNames", "", "qualifiedName", "Lcom/intellij/webSymbols/WebSymbolQualifiedName;", "target", "Lcom/intellij/webSymbols/query/WebSymbolNamesProvider$Target;", "isOwnTemplateLanguage", "", "language", "Lcom/intellij/lang/Language;", "Companion", "intellij.vuejs"})
public final class VueFramework
extends WebFramework {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String displayName;
    @NotNull
    public static final String ID = "vue";

    public VueFramework() {
        this.displayName = "Vue";
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = VuejsIcons.Vue;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Vue");
        return icon;
    }

    public boolean isOwnTemplateLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language.isKindOf((Language)VueLanguage.Companion.getINSTANCE());
    }

    @Nullable
    public WebFrameworkHtmlFileType getFileType(@NotNull WebFramework.SourceFileKind kind, @NotNull VirtualFile context, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1, 2 -> VueFileType.INSTANCE;
            default -> null;
        };
    }

    @NotNull
    public List<String> getNames(@NotNull WebSymbolQualifiedName qualifiedName, @NotNull WebSymbolNamesProvider.Target target) {
        List list;
        block18: {
            block20: {
                WebSymbolQualifiedKind webSymbolQualifiedKind;
                String name;
                block19: {
                    block17: {
                        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
                        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                        name = qualifiedName.getName();
                        webSymbolQualifiedKind = qualifiedName.getQualifiedKind();
                        if (!Intrinsics.areEqual((Object)webSymbolQualifiedKind, (Object)VueWebSymbolsQueryConfiguratorKt.getVUE_COMPONENTS())) break block17;
                        switch (WhenMappings.$EnumSwitchMapping$1[target.ordinal()]) {
                            case 1: {
                                Object[] objectArray = new String[]{name, VueUtilKt.fromAsset(name, true)};
                                list = CollectionsKt.listOf((Object[])objectArray);
                                break block18;
                            }
                            case 2: {
                                list = StringsKt.contains$default((CharSequence)name, (char)'-', (boolean)false, (int)2, null) ? CollectionsKt.listOf((Object)name) : CollectionsKt.listOf((Object)VueUtilKt.fromAsset(name, true));
                                break block18;
                            }
                            case 3: {
                                if (StringsKt.contains$default((CharSequence)name, (char)'-', (boolean)false, (int)2, null)) {
                                    list = CollectionsKt.listOf((Object)name);
                                } else {
                                    Object[] objectArray = new String[]{name, VueUtilKt.fromAsset$default(name, false, 2, null)};
                                    list = CollectionsKt.listOf((Object[])objectArray);
                                }
                                break block18;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    if (!Intrinsics.areEqual((Object)webSymbolQualifiedKind, (Object)VueWebSymbolsQueryConfiguratorKt.getVUE_COMPONENT_PROPS())) break block19;
                    switch (WhenMappings.$EnumSwitchMapping$1[target.ordinal()]) {
                        case 1: {
                            list = CollectionsKt.listOf((Object)VueUtilKt.fromAsset$default(name, false, 2, null));
                            break block18;
                        }
                        case 2: {
                            list = CollectionsKt.listOf((Object)VueUtilKt.fromAsset$default(name, false, 2, null));
                            break block18;
                        }
                        case 3: {
                            list = CollectionsKt.listOf((Object)VueUtilKt.fromAsset$default(name, false, 2, null));
                            break block18;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (!Intrinsics.areEqual((Object)webSymbolQualifiedKind, (Object)WebSymbol.Companion.getJS_EVENTS())) break block20;
                switch (WhenMappings.$EnumSwitchMapping$1[target.ordinal()]) {
                    case 1: {
                        Object[] objectArray = new String[]{VueUtilKt.fromAsset$default(name, false, 2, null), name, VueUtilKt.fromAsset(name, true)};
                        list = CollectionsKt.listOf((Object[])objectArray);
                        break block18;
                    }
                    case 2: {
                        list = CollectionsKt.listOf((Object)VueUtilKt.fromAsset(name, true));
                        break block18;
                    }
                    case 3: {
                        Object[] objectArray = new String[]{VueUtilKt.fromAsset$default(name, false, 2, null), VueUtilKt.toAsset$default(name, false, 2, null)};
                        list = CollectionsKt.listOf((Object[])objectArray);
                        break block18;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public Predicate<String> getAttributeNameCodeCompletionFilter(@NotNull XmlTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return new VueAttributeNameCodeCompletionFilter(tag);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/vuejs/web/VueFramework$Companion;", "", "()V", "ID", "", "intellij.vuejs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WebFramework.SourceFileKind.values().length];
            try {
                nArray[WebFramework.SourceFileKind.HTML.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebFramework.SourceFileKind.STANDALONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WebSymbolNamesProvider.Target.values().length];
            try {
                nArray[WebSymbolNamesProvider.Target.NAMES_QUERY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebSymbolNamesProvider.Target.NAMES_MAP_STORAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebSymbolNamesProvider.Target.CODE_COMPLETION_VARIANTS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

