/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.typed;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.JSFrameworkMarkersIndex;
import com.intellij.lang.javascript.psi.stubs.TypeScriptSingleTypeStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptTypeArgumentListStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptUnionOrIntersectionTypeStub;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.typescript.modules.TypeScriptNodeSearchProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.model.VueComponent;
import org.jetbrains.vuejs.model.source.VueEntityDescriptor;
import org.jetbrains.vuejs.model.typed.VueTypedComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/vuejs/model/typed/VueTypedEntitiesProvider;", "", "()V", "vueComponentTypenameRegex", "Lkotlin/text/Regex;", "calculateDtsComponents", "", "", "Lorg/jetbrains/vuejs/model/VueComponent;", "moduleDir", "Lcom/intellij/psi/PsiDirectory;", "getComponent", "Lorg/jetbrains/vuejs/model/typed/VueTypedComponent;", "descriptor", "Lorg/jetbrains/vuejs/model/source/VueEntityDescriptor;", "getComponentDescriptor", "element", "Lcom/intellij/psi/PsiElement;", "isComponentDefinition", "", "definition", "Lcom/intellij/lang/javascript/psi/ecmal4/JSQualifiedNamedElement;", "VueTypedComponentDescriptor", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nVueTypedEntitiesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueTypedEntitiesProvider.kt\norg/jetbrains/vuejs/model/typed/VueTypedEntitiesProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1#2:144\n1855#3,2:145\n1855#3,2:147\n1855#3,2:149\n*S KotlinDebug\n*F\n+ 1 VueTypedEntitiesProvider.kt\norg/jetbrains/vuejs/model/typed/VueTypedEntitiesProvider\n*L\n113#1:145,2\n130#1:147,2\n53#1:149,2\n*E\n"})
public final class VueTypedEntitiesProvider {
    @NotNull
    public static final VueTypedEntitiesProvider INSTANCE = new VueTypedEntitiesProvider();
    @NotNull
    private static final Regex vueComponentTypenameRegex = new Regex("(import\\s*\\(\\s*['\"]vue['\"]\\s*\\)\\s*\\.\\s*|vue\\s*\\.\\s*)?(DefineComponent|ComponentOptionsBase|ComponentOptionsMixin|ComponentCustomProps)");

    private VueTypedEntitiesProvider() {
    }

    public final boolean isComponentDefinition(@NotNull JSQualifiedNamedElement definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        if (definition.getName() == null || definition instanceof JSField) {
            return false;
        }
        JSQualifiedNamedElement jSQualifiedNamedElement = definition;
        if (jSQualifiedNamedElement instanceof TypeScriptVariable) {
            StubElement typeStub;
            TypeScriptType typeScriptType = ((TypeScriptVariable)definition).getTypeElement();
            if (typeScriptType == null) {
                return false;
            }
            TypeScriptType typeElement = typeScriptType;
            Ref.BooleanRef result2 = new Ref.BooleanRef();
            StubBasedPsiElement stubBasedPsiElement = typeElement instanceof StubBasedPsiElement ? (StubBasedPsiElement)typeElement : null;
            Object object = typeStub = stubBasedPsiElement != null ? stubBasedPsiElement.getStub() : null;
            if (typeStub != null) {
                VueTypedEntitiesProvider.isComponentDefinition$visit(result2, (Stub)typeStub);
            } else {
                typeElement.accept((PsiElementVisitor)new JSElementVisitor(result2){
                    final /* synthetic */ Ref.BooleanRef $result;
                    {
                        this.$result = $result;
                    }

                    public void visitJSElement(@NotNull JSElement node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (node instanceof TypeScriptSingleType && VueTypedEntitiesProvider.access$isComponentDefinition$checkTypeName(((TypeScriptSingleType)node).getQualifiedTypeName())) {
                            this.$result.element = true;
                        } else if (node instanceof TypeScriptTypeArgumentList || node instanceof TypeScriptUnionOrIntersectionType || node instanceof TypeScriptSingleType) {
                            node.acceptChildren((PsiElementVisitor)this);
                        }
                    }
                });
            }
            return result2.element;
        }
        if (jSQualifiedNamedElement instanceof TypeScriptClass) {
            return TypeScriptUtil.isDefinitionFile((PsiFile)((TypeScriptClass)definition).getContainingFile());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final VueEntityDescriptor getComponentDescriptor(@Nullable PsiElement element) {
        VueTypedComponentDescriptor vueTypedComponentDescriptor;
        if (element == null) {
            return null;
        }
        PsiElement source2 = element instanceof JSPsiNamedElementBase ? (PsiElement)VueUtilKt.resolveIfImportSpecifier((JSPsiNamedElementBase)element) : element;
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(TypeScriptVariable.class), Reflection.getOrCreateKotlinClass(TypeScriptInterfaceClass.class)};
        JSQualifiedNamedElement componentDefinition = (JSQualifiedNamedElement)VueUtilKt.resolveElementTo(element, kClassArray);
        Object object = componentDefinition;
        if (object != null) {
            JSQualifiedNamedElement jSQualifiedNamedElement;
            JSQualifiedNamedElement it = jSQualifiedNamedElement = object;
            boolean bl = false;
            object = INSTANCE.isComponentDefinition(it) ? jSQualifiedNamedElement : null;
            if (object != null) {
                it = object;
                boolean bl2 = false;
                Object object2 = source2 instanceof PsiNamedElement ? (PsiNamedElement)source2 : null;
                if (object2 == null || (object2 = object2.getName()) == null) {
                    String string = componentDefinition.getName();
                    object2 = string;
                    Intrinsics.checkNotNull((Object)string);
                }
                Object object3 = object2;
                Intrinsics.checkNotNull((Object)object3);
                VueTypedComponentDescriptor vueTypedComponentDescriptor = new VueTypedComponentDescriptor(source2, (String)object3);
                vueTypedComponentDescriptor = vueTypedComponentDescriptor;
                return vueTypedComponentDescriptor;
            }
        }
        vueTypedComponentDescriptor = null;
        return vueTypedComponentDescriptor;
    }

    @Nullable
    public final VueTypedComponent getComponent(@Nullable VueEntityDescriptor descriptor) {
        VueTypedComponent vueTypedComponent;
        VueTypedComponentDescriptor vueTypedComponentDescriptor = descriptor instanceof VueTypedComponentDescriptor ? (VueTypedComponentDescriptor)descriptor : null;
        if (vueTypedComponentDescriptor != null) {
            VueTypedComponentDescriptor it = vueTypedComponentDescriptor;
            boolean bl = false;
            vueTypedComponent = new VueTypedComponent(it.getSource(), it.getName());
        } else {
            vueTypedComponent = null;
        }
        return vueTypedComponent;
    }

    @NotNull
    public final Map<String, VueComponent> calculateDtsComponents(@NotNull PsiDirectory moduleDir) {
        JSFile mainPsiFile;
        PsiFile psiFile;
        VirtualFile mainFile;
        Intrinsics.checkNotNullParameter((Object)moduleDir, (String)"moduleDir");
        Map componentsFromDts = new LinkedHashMap();
        Project project = moduleDir.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Set componentDefs = CollectionsKt.toSet((Iterable)JSFrameworkMarkersIndex.Companion.getElements("Vue Typed Component", TypeScriptVariable.class, project, GlobalSearchScopesCore.directoryScope((PsiDirectory)moduleDir, (boolean)true)));
        if (componentDefs.isEmpty()) {
            return MapsKt.emptyMap();
        }
        TypeScriptNodeSearchProcessor searchProcessor = new TypeScriptNodeSearchProcessor();
        VirtualFile virtualFile = mainFile = JSExactFileReference.resolveForNpmPackages((VirtualFile)moduleDir.getVirtualFile(), (JSDirectorySearchProcessor)((JSDirectorySearchProcessor)searchProcessor));
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            psiFile = moduleDir.getManager().findFile(it);
        } else {
            psiFile = null;
        }
        Object object = psiFile;
        JSFile jSFile = mainPsiFile = object instanceof JSFile ? (JSFile)object : null;
        if (mainPsiFile != null) {
            Collection collection = new JSModuleTypeImpl(mainPsiFile, false).asRecordType().getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getProperties(...)");
            object = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VueTypedComponent it;
                JSRecordType.PropertySignature export = (JSRecordType.PropertySignature)element$iv;
                boolean bl = false;
                List list = export.getMemberSource().getAllSourceElements();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllSourceElements(...)");
                if ((VueTypedComponent)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<PsiElement, VueTypedComponent>((Set<? extends TypeScriptVariable>)componentDefs, export){
                    final /* synthetic */ Set<TypeScriptVariable> $componentDefs;
                    final /* synthetic */ JSRecordType.PropertySignature $export;
                    {
                        this.$componentDefs = $componentDefs;
                        this.$export = $export;
                        super(1);
                    }

                    @Nullable
                    public final VueTypedComponent invoke(PsiElement it) {
                        VueTypedComponent vueTypedComponent;
                        TypeScriptVariable variable;
                        if (!(it instanceof TypeScriptVariable)) {
                            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(TypeScriptVariable.class)};
                            v0 = (TypeScriptVariable)VueUtilKt.resolveElementTo(it, kClassArray);
                        } else {
                            v0 = variable = (TypeScriptVariable)it;
                        }
                        if (variable != null && this.$componentDefs.contains(variable)) {
                            Intrinsics.checkNotNull((Object)it);
                            String string = this.$export.getMemberName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMemberName(...)");
                            vueTypedComponent = new VueTypedComponent(it, string);
                        } else {
                            vueTypedComponent = null;
                        }
                        return vueTypedComponent;
                    }
                }))) == null) continue;
                boolean bl2 = false;
                componentsFromDts.put(it.getDefaultName(), it);
            }
        } else {
            $this$forEach$iv = componentDefs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TypeScriptVariable variable = (TypeScriptVariable)element$iv;
                boolean bl = false;
                String name = variable.getName();
                if (!variable.isExported() || name == null) continue;
                componentsFromDts.put(name, new VueTypedComponent((PsiElement)variable, name));
            }
        }
        return componentsFromDts;
    }

    private static final boolean isComponentDefinition$checkTypeName(String typeName) {
        CharSequence charSequence;
        return typeName != null && vueComponentTypenameRegex.matches(charSequence = (CharSequence)typeName);
    }

    private static final void isComponentDefinition$visit(Ref.BooleanRef result2, Stub stub) {
        if (stub instanceof TypeScriptSingleTypeStub && VueTypedEntitiesProvider.isComponentDefinition$checkTypeName(((TypeScriptSingleTypeStub)stub).getQualifiedTypeName())) {
            result2.element = true;
        } else if (stub instanceof TypeScriptTypeArgumentListStub || stub instanceof TypeScriptUnionOrIntersectionTypeStub || stub instanceof TypeScriptSingleTypeStub) {
            List list = stub.getChildrenStubs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenStubs(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Stub it = (Stub)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                VueTypedEntitiesProvider.isComponentDefinition$visit(result2, it);
            }
        }
    }

    public static final /* synthetic */ boolean access$isComponentDefinition$checkTypeName(String typeName) {
        return VueTypedEntitiesProvider.isComponentDefinition$checkTypeName(typeName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/vuejs/model/typed/VueTypedEntitiesProvider$VueTypedComponentDescriptor;", "Lorg/jetbrains/vuejs/model/source/VueEntityDescriptor;", "source", "Lcom/intellij/psi/PsiElement;", "name", "", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getSource", "()Lcom/intellij/psi/PsiElement;", "intellij.vuejs"})
    public static final class VueTypedComponentDescriptor
    implements VueEntityDescriptor {
        @NotNull
        private final PsiElement source;
        @NotNull
        private final String name;

        public VueTypedComponentDescriptor(@NotNull PsiElement source2, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.source = source2;
            this.name = name;
        }

        @Override
        @NotNull
        public PsiElement getSource() {
            return this.source;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }
    }
}

