/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.libraries.prettier;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.prettierjs.PrettierConfig;
import com.intellij.prettierjs.codeStyle.PrettierCodeStyleInstaller;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.lang.html.VueLanguage;
import org.jetbrains.vuejs.lang.html.psi.formatter.VueCodeStyleSettings;
import org.jetbrains.vuejs.libraries.prettier.VuePrettierCodeStyleInstaller;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/vuejs/libraries/prettier/VuePrettierCodeStyleInstaller;", "Lcom/intellij/prettierjs/codeStyle/PrettierCodeStyleInstaller;", "()V", "getIndentChildrenOfTopLevelSequence", "Lkotlin/sequences/Sequence;", "", "settings", "Lorg/jetbrains/vuejs/lang/html/psi/formatter/VueCodeStyleSettings;", "Lorg/jetbrains/annotations/NotNull;", "install", "", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/intellij/prettierjs/PrettierConfig;", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "isInstalled", "", "intellij.vuejs"})
public final class VuePrettierCodeStyleInstaller
implements PrettierCodeStyleInstaller {
    public void install(@NotNull Project project, @NotNull PrettierConfig config, @NotNull CodeStyleSettings settings) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        VueCodeStyleSettings it = (VueCodeStyleSettings)settings.getCustomSettings(VueCodeStyleSettings.class);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)((Object)it));
        Sequence sequence2 = SequencesKt.plus(this.getIndentChildrenOfTopLevelSequence(it), (Object)"template");
        VueCodeStyleSettings vueCodeStyleSettings = it;
        boolean bl2 = false;
        if (config.vueIndentScriptAndStyle) {
            Object[] objectArray = new String[]{"script", "style"};
            sequence = SequencesKt.plus((Sequence)tags, (Sequence)SequencesKt.sequenceOf((Object[])objectArray));
        } else {
            Object[] objectArray = new String[]{"script", "style"};
            sequence = SequencesKt.minus((Sequence)tags, (Sequence)SequencesKt.sequenceOf((Object[])objectArray));
        }
        vueCodeStyleSettings.INDENT_CHILDREN_OF_TOP_LEVEL = SequencesKt.joinToString$default((Sequence)SequencesKt.distinct((Sequence)sequence), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        it.UNIFORM_INDENT = true;
        it.SPACES_WITHIN_INTERPOLATION_EXPRESSIONS = true;
        it.INTERPOLATION_NEW_LINE_AFTER_START_DELIMITER = false;
        it.INTERPOLATION_NEW_LINE_BEFORE_END_DELIMITER = false;
        it.INTERPOLATION_WRAP = 0;
        PrettierCodeStyleInstaller.applyCommonPrettierSettings((PrettierConfig)config, (CodeStyleSettings)settings, (Language)((Language)VueLanguage.Companion.getINSTANCE()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInstalled(@NotNull Project project, @NotNull PrettierConfig config, @NotNull CodeStyleSettings settings) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        VueCodeStyleSettings it = (VueCodeStyleSettings)settings.getCustomSettings(VueCodeStyleSettings.class);
        boolean bl2 = false;
        if (!it.UNIFORM_INDENT) return false;
        if (!it.SPACES_WITHIN_INTERPOLATION_EXPRESSIONS) return false;
        if (it.INTERPOLATION_NEW_LINE_AFTER_START_DELIMITER) return false;
        if (it.INTERPOLATION_NEW_LINE_BEFORE_END_DELIMITER) return false;
        if (it.INTERPOLATION_WRAP != 0) return false;
        Intrinsics.checkNotNull((Object)((Object)it));
        Set tags = SequencesKt.toSet(this.getIndentChildrenOfTopLevelSequence(it));
        boolean bl3 = false;
        if (config.vueIndentScriptAndStyle) {
            if (!tags.contains("script")) return false;
            if (!tags.contains("style")) return false;
            bl = true;
        } else {
            if (tags.contains("script")) return false;
            if (tags.contains("style")) return false;
            bl = true;
        }
        if (!bl) return false;
        if (!tags.contains("template")) return false;
        boolean bl4 = true;
        if (!bl4) return false;
        boolean bl5 = true;
        if (!bl5) return false;
        if (!PrettierCodeStyleInstaller.commonPrettierSettingsApplied((PrettierConfig)config, (CodeStyleSettings)settings, (Language)((Language)VueLanguage.Companion.getINSTANCE()))) return false;
        return true;
    }

    private final Sequence<String> getIndentChildrenOfTopLevelSequence(VueCodeStyleSettings settings) {
        char[] cArray = new char[]{','};
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)settings.INDENT_CHILDREN_OF_TOP_LEVEL, (char[])cArray, (boolean)false, (int)0, (int)6, null)), (Function1)getIndentChildrenOfTopLevelSequence.1.INSTANCE);
    }
}

