/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript.service;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerState;
import com.intellij.lang.typescript.lsp.JSFrameworkLspServerDescriptorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.context.VueContextKt;
import org.jetbrains.vuejs.lang.html.VueFileType;
import org.jetbrains.vuejs.options.VueServiceSettings;
import org.jetbrains.vuejs.options.VueSettingsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"isTypeScriptServiceBefore5Context", "", "project", "Lcom/intellij/openapi/project/Project;", "isVueClassicTypeScriptServiceEnabled", "context", "Lcom/intellij/openapi/vfs/VirtualFile;", "isVueServiceContext", "intellij.vuejs"})
public final class VueServicesKt {
    private static final boolean isVueServiceContext(Project project, VirtualFile context) {
        return context.getFileType() instanceof VueFileType || VueContextKt.isVueContext(context, project);
    }

    public static final boolean isVueClassicTypeScriptServiceEnabled(@NotNull Project project, @NotNull VirtualFile context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!VueServicesKt.isVueServiceContext(project, context)) {
            return false;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[VueSettingsKt.getVueSettings(project).getServiceType().ordinal()]) {
            case 1, 2 -> false;
            case 3 -> VueServicesKt.isTypeScriptServiceBefore5Context(project);
            case 4 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final boolean isTypeScriptServiceBefore5Context(Project project) {
        String path = JSFrameworkLspServerDescriptorKt.getTypeScriptServiceDirectory((Project)project);
        VirtualFile packageJson = TypeScriptServerState.getPackageJsonFromServicePath((String)path);
        if (packageJson == null) {
            return false;
        }
        SemVer semVer = PackageJsonData.getOrCreate((VirtualFile)packageJson).getVersion();
        if (semVer == null) {
            return true;
        }
        SemVer version = semVer;
        return version.getMajor() < 5;
    }

    public static final /* synthetic */ boolean access$isVueServiceContext(Project project, VirtualFile context) {
        return VueServicesKt.isVueServiceContext(project, context);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VueServiceSettings.values().length];
            try {
                nArray[VueServiceSettings.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueServiceSettings.VOLAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueServiceSettings.TS_SERVICE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueServiceSettings.DISABLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

