/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript.service;

import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceProvider;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;
import org.jetbrains.vuejs.lang.typescript.service.VolarServiceWrapper;
import org.jetbrains.vuejs.lang.typescript.service.VueClassicServiceWrapper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/service/VueLanguageServiceProvider;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "classicLanguageService", "Lorg/jetbrains/vuejs/lang/typescript/service/VueClassicServiceWrapper;", "getClassicLanguageService", "()Lorg/jetbrains/vuejs/lang/typescript/service/VueClassicServiceWrapper;", "classicLanguageService$delegate", "Lkotlin/Lazy;", "volarLanguageService", "Lorg/jetbrains/vuejs/lang/typescript/service/VolarServiceWrapper;", "getVolarLanguageService", "()Lorg/jetbrains/vuejs/lang/typescript/service/VolarServiceWrapper;", "volarLanguageService$delegate", "getAllServices", "", "Lcom/intellij/lang/javascript/service/JSLanguageService;", "getService", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isHighlightingCandidate", "", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nVueLanguageServiceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueLanguageServiceProvider.kt\norg/jetbrains/vuejs/lang/typescript/service/VueLanguageServiceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n288#2,2:48\n*S KotlinDebug\n*F\n+ 1 VueLanguageServiceProvider.kt\norg/jetbrains/vuejs/lang/typescript/service/VueLanguageServiceProvider\n*L\n23#1:48,2\n*E\n"})
public final class VueLanguageServiceProvider
implements JSLanguageServiceProvider {
    @NotNull
    private final Lazy classicLanguageService$delegate;
    @NotNull
    private final Lazy volarLanguageService$delegate;

    public VueLanguageServiceProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.classicLanguageService$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<VueClassicServiceWrapper>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final VueClassicServiceWrapper invoke() {
                ComponentManager $this$service$iv = (ComponentManager)this.$project;
                boolean $i$f$service = false;
                Class<VueClassicServiceWrapper> serviceClass$iv = VueClassicServiceWrapper.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (VueClassicServiceWrapper)object;
            }
        }));
        this.volarLanguageService$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<VolarServiceWrapper>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final VolarServiceWrapper invoke() {
                ComponentManager $this$service$iv = (ComponentManager)this.$project;
                boolean $i$f$service = false;
                Class<VolarServiceWrapper> serviceClass$iv = VolarServiceWrapper.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (VolarServiceWrapper)object;
            }
        }));
    }

    private final VueClassicServiceWrapper getClassicLanguageService() {
        Lazy lazy = this.classicLanguageService$delegate;
        return (VueClassicServiceWrapper)lazy.getValue();
    }

    private final VolarServiceWrapper getVolarLanguageService() {
        Lazy lazy = this.volarLanguageService$delegate;
        return (VolarServiceWrapper)lazy.getValue();
    }

    @NotNull
    public List<JSLanguageService> getAllServices() {
        Object[] objectArray = new JSLanguageService[]{this.getClassicLanguageService().getService(), this.getVolarLanguageService().getService()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public JSLanguageService getService(@NotNull VirtualFile file) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$firstOrNull$iv = this.getAllServices();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JSLanguageService it = (JSLanguageService)element$iv;
                boolean bl = false;
                if (!it.isAcceptable(file)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public boolean isHighlightingCandidate(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return TypeScriptLanguageServiceProvider.isJavaScriptOrTypeScriptFileType((FileType)file.getFileType()) || VueFileTypeKt.isVueFile(file);
    }
}

