/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.index;

import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.index.VueIndexBase;
import org.jetbrains.vuejs.index.VueIndexData;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001d0\u001c\u001a\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0018\u001a\u0010\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0001H\u0000\u001a0\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180$2\u0006\u0010\"\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001d0\u001c\u001a.\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*\u001a\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00010-2\u0006\u0010.\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"BOOTSTRAP_VUE_MODULE", "", "COMPOSITION_API_MODULE", "DELIMITER", "", "GLOBAL", "GLOBAL_BINDING_MARK", "GLOBAL_COMPONENTS", "INDEXED_ACCESS_HINT", "LOCAL", "SHARDS_VUE_MODULE", "VUETIFY_MODULE", "VUE_DEFAULT_EXTENSIONS_WITH_DOT", "", "getVUE_DEFAULT_EXTENSIONS_WITH_DOT", "()[Ljava/lang/String;", "[Ljava/lang/String;", "VUE_FILE_EXTENSION", "VUE_INSTANCE_MODULE", "VUE_MODULE", "escapePart", "part", "getForAllKeys", "Lkotlin/sequences/Sequence;", "Lcom/intellij/lang/javascript/psi/stubs/JSImplicitElement;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "key", "Lcom/intellij/psi/stubs/StubIndexKey;", "Lcom/intellij/lang/javascript/psi/JSImplicitElementProvider;", "getVueIndexData", "Lorg/jetbrains/vuejs/index/VueIndexData;", "element", "normalizeNameForIndex", "name", "resolve", "", "serializeUserStringData", "originalName", "nameQualifiedReference", "descriptorQualifiedReference", "indexedAccessUsed", "", "isGlobal", "splitAndUnescape", "", "s", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nVueIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueIndex.kt\norg/jetbrains/vuejs/index/VueIndexKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n766#2:137\n857#2,2:138\n1855#2,2:140\n*S KotlinDebug\n*F\n+ 1 VueIndex.kt\norg/jetbrains/vuejs/index/VueIndexKt\n*L\n58#1:137\n58#1:138,2\n59#1:140,2\n*E\n"})
public final class VueIndexKt {
    @NotNull
    public static final String VUE_FILE_EXTENSION = ".vue";
    @NotNull
    public static final String VUE_MODULE = "vue";
    @NotNull
    public static final String VUE_INSTANCE_MODULE = "vue/types/vue";
    @NotNull
    public static final String VUETIFY_MODULE = "vuetify";
    @NotNull
    public static final String BOOTSTRAP_VUE_MODULE = "bootstrap-vue";
    @NotNull
    public static final String SHARDS_VUE_MODULE = "shards-vue";
    @NotNull
    public static final String COMPOSITION_API_MODULE = "@vue/composition-api";
    @NotNull
    public static final String GLOBAL_COMPONENTS = "GlobalComponents";
    @NotNull
    private static final String[] VUE_DEFAULT_EXTENSIONS_WITH_DOT;
    @NotNull
    public static final String GLOBAL = "global";
    @NotNull
    public static final String LOCAL = "local";
    @NotNull
    public static final String GLOBAL_BINDING_MARK = "*";
    @NotNull
    private static final String INDEXED_ACCESS_HINT = "[]";
    private static final char DELIMITER = ';';

    @NotNull
    public static final String[] getVUE_DEFAULT_EXTENSIONS_WITH_DOT() {
        return VUE_DEFAULT_EXTENSIONS_WITH_DOT;
    }

    @NotNull
    public static final Sequence<JSImplicitElement> getForAllKeys(@NotNull GlobalSearchScope scope, @NotNull StubIndexKey<String, JSImplicitElementProvider> key) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Project project = scope.getProject();
        Intrinsics.checkNotNull((Object)project);
        if (DumbService.Companion.isDumb(project)) {
            return SequencesKt.emptySequence();
        }
        StubIndex stubIndex = StubIndex.getInstance();
        Project project2 = scope.getProject();
        Intrinsics.checkNotNull((Object)project2);
        Collection collection = stubIndex.getAllKeys(key, project2);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllKeys(...)");
        Collection keys = collection;
        return SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)keys), (Function1)((Function1)new Function1<String, Collection<? extends JSImplicitElement>>(scope, key){
            final /* synthetic */ GlobalSearchScope $scope;
            final /* synthetic */ StubIndexKey<String, JSImplicitElementProvider> $key;
            {
                this.$scope = $scope;
                this.$key = $key;
                super(1);
            }

            @NotNull
            public final Collection<JSImplicitElement> invoke(String it) {
                Intrinsics.checkNotNull((Object)it);
                return VueIndexKt.resolve(it, this.$scope, this.$key);
            }
        }));
    }

    @NotNull
    public static final Collection<JSImplicitElement> resolve(@NotNull String name, @NotNull GlobalSearchScope scope, @NotNull StubIndexKey<String, JSImplicitElementProvider> key) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Project project = scope.getProject();
        Intrinsics.checkNotNull((Object)project);
        if (DumbService.Companion.isDumb(project)) {
            return CollectionsKt.emptyList();
        }
        String normalized = VueIndexKt.normalizeNameForIndex(name);
        String indexKey = VueIndexBase.Companion.createJSKey(key);
        List result2 = new ArrayList();
        StubIndex stubIndex = StubIndex.getInstance();
        Project project2 = scope.getProject();
        Intrinsics.checkNotNull((Object)project2);
        stubIndex.processElements(key, (Object)normalized, project2, scope, JSImplicitElementProvider.class, arg_0 -> VueIndexKt.resolve$lambda$2(indexKey, normalized, result2, arg_0));
        return result2;
    }

    @NotNull
    public static final String normalizeNameForIndex(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return VueUtilKt.fromAsset$default(StringsKt.substringBeforeLast$default((String)name, (String)GLOBAL_BINDING_MARK, null, (int)2, null), false, 2, null);
    }

    private static final List<String> splitAndUnescape(String s) {
        ArrayList<String> result2 = new ArrayList<String>(4);
        StringBuilder builder = new StringBuilder();
        boolean prevIsEscape = false;
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (prevIsEscape) {
                builder.append(c);
                prevIsEscape = false;
                continue;
            }
            if (c == '\\') {
                prevIsEscape = true;
                continue;
            }
            if (c == ';') {
                result2.add(builder.toString());
                StringsKt.clear((StringBuilder)builder);
                continue;
            }
            builder.append(c);
        }
        result2.add(builder.toString());
        return result2;
    }

    @Nullable
    public static final VueIndexData getVueIndexData(@NotNull JSImplicitElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getUserStringData();
        if (string == null) {
            return null;
        }
        String userStringData = string;
        List<String> parts = VueIndexKt.splitAndUnescape(userStringData);
        boolean bl2 = bl = parts.size() == 4;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-VueIndexKt$getVueIndexData$22 = false;
            String $i$a$-assert-VueIndexKt$getVueIndexData$22 = "Error with " + element + " [name = " + element.getName() + ", userString = " + element.getUserString() + ", userStringData = " + userStringData + ", parts=" + parts + "]";
            throw new AssertionError((Object)$i$a$-assert-VueIndexKt$getVueIndexData$22);
        }
        String originalName = parts.get(0);
        String nameQualifiedReference = parts.get(1);
        String descriptorQualifiedReference = StringsKt.substringBefore$default((String)parts.get(2), (String)INDEXED_ACCESS_HINT, null, (int)2, null);
        boolean indexedAccessUsed = StringsKt.endsWith$default((String)parts.get(2), (String)INDEXED_ACCESS_HINT, (boolean)false, (int)2, null);
        boolean isGlobal = Intrinsics.areEqual((Object)parts.get(3), (Object)"1");
        return new VueIndexData(originalName, nameQualifiedReference, descriptorQualifiedReference, indexedAccessUsed, isGlobal);
    }

    @NotNull
    public static final String serializeUserStringData(@NotNull String originalName, @NotNull String nameQualifiedReference, @NotNull String descriptorQualifiedReference, boolean indexedAccessUsed, boolean isGlobal) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
        Intrinsics.checkNotNullParameter((Object)nameQualifiedReference, (String)"nameQualifiedReference");
        Intrinsics.checkNotNullParameter((Object)descriptorQualifiedReference, (String)"descriptorQualifiedReference");
        StringBuilder $this$serializeUserStringData_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$serializeUserStringData_u24lambda_u244.append(VueIndexKt.escapePart(originalName));
        $this$serializeUserStringData_u24lambda_u244.append(';');
        $this$serializeUserStringData_u24lambda_u244.append(VueIndexKt.escapePart(nameQualifiedReference));
        $this$serializeUserStringData_u24lambda_u244.append(';');
        $this$serializeUserStringData_u24lambda_u244.append(VueIndexKt.escapePart(descriptorQualifiedReference));
        if (indexedAccessUsed) {
            $this$serializeUserStringData_u24lambda_u244.append(INDEXED_ACCESS_HINT);
        }
        $this$serializeUserStringData_u24lambda_u244.append(';');
        $this$serializeUserStringData_u24lambda_u244.append(isGlobal ? "1" : "0");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String escapePart(String part) {
        char[] cArray = new char[]{'\\', ';'};
        String string = StringUtil.escapeChars((String)part, (char[])cArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeChars(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean resolve$lambda$2(String $indexKey, String $normalized, List $result, JSImplicitElementProvider provider) {
        Collection collection;
        JSElementIndexingData jSElementIndexingData;
        Intrinsics.checkNotNullParameter((Object)$indexKey, (String)"$indexKey");
        Intrinsics.checkNotNullParameter((Object)$normalized, (String)"$normalized");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        if (provider != null && (jSElementIndexingData = provider.getIndexingData()) != null && (collection = jSElementIndexingData.getImplicitElements()) != null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = collection;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                JSImplicitElement it = (JSImplicitElement)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getUserString(), (Object)$indexKey) && Intrinsics.areEqual((Object)$normalized, (Object)it.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JSImplicitElement it = (JSImplicitElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                $result.add(it);
            }
        }
        return true;
    }

    static {
        String[] stringArray = new String[]{VUE_FILE_EXTENSION};
        VUE_DEFAULT_EXTENSIONS_WITH_DOT = stringArray;
    }
}

