/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.Function;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.jetbrains.firefox.FirefoxListener;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.StandaloneFirefoxVm;
import com.jetbrains.firefox.rdp.ListTabsResult;
import com.jetbrains.firefox.rdp.Tab;
import com.jetbrains.firefox.rdp.TabAttached;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import java.net.InetSocketAddress;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.UtilKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.RemoteVmConnectionKt;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/firefox/FirefoxRemoteVmConnection;", "Lorg/jetbrains/debugger/connection/RemoteVmConnection;", "Lorg/jetbrains/debugger/Vm;", "()V", "tabLabel", "", "connectedAddressToPresentation", "address", "Ljava/net/InetSocketAddress;", "vm", "createBootstrap", "Lio/netty/bootstrap/Bootstrap;", "vmResult", "Lorg/jetbrains/concurrency/AsyncPromise;", "describeTab", "tab", "Lcom/jetbrains/firefox/rdp/Tab;", "intellij.javascript.firefox.connector"})
@SourceDebugExtension(value={"SMAP\nFirefoxRemoteVmConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirefoxRemoteVmConnection.kt\ncom/jetbrains/firefox/FirefoxRemoteVmConnection\n+ 2 netty.kt\ncom/intellij/util/io/NettyKt\n*L\n1#1,72:1\n39#2,6:73\n*S KotlinDebug\n*F\n+ 1 FirefoxRemoteVmConnection.kt\ncom/jetbrains/firefox/FirefoxRemoteVmConnection\n*L\n23#1:73,6\n*E\n"})
public class FirefoxRemoteVmConnection
extends RemoteVmConnection<Vm> {
    @Nullable
    private String tabLabel;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Bootstrap createBootstrap(@NotNull InetSocketAddress address, @NotNull AsyncPromise<Vm> vmResult) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(vmResult, (String)"vmResult");
        Bootstrap $this$handler$iv = this.createBootstrap();
        boolean $i$f$handler = false;
        $this$handler$iv.handler((ChannelHandler)new ChannelInitializer<Channel>(this, vmResult){
            final /* synthetic */ FirefoxRemoteVmConnection this$0;
            final /* synthetic */ AsyncPromise $vmResult$inlined;
            {
                this.this$0 = firefoxRemoteVmConnection;
                this.$vmResult$inlined = asyncPromise;
            }

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Channel channel2 = channel;
                boolean bl = false;
                StandaloneFirefoxVm vm = new StandaloneFirefoxVm(FirefoxRemoteVmConnection.access$getDebugEventListener(this.this$0), channel2, UtilKt.createDebugLogger$default((String)"js.debugger.firefox.log", null, (int)2, null));
                Function1 function1 = (Function1)new Function1<ListTabsResult, Promise<Tab>>((AsyncPromise<Vm>)this.$vmResult$inlined, this.this$0){
                    final /* synthetic */ AsyncPromise<Vm> $vmResult;
                    final /* synthetic */ FirefoxRemoteVmConnection this$0;
                    {
                        this.$vmResult = $vmResult;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final Promise<Tab> invoke(ListTabsResult it) {
                        return Promises.isRejected((Promise)((Promise)this.$vmResult)) ? Promises.rejectedPromise((String)"rejected") : RemoteVmConnectionKt.chooseDebuggee((Collection)it.tabs(), (int)it.selected(), (Function2)((Function2)new Function2<Tab, ColoredListCellRenderer<?>, Unit>(this.this$0){
                            final /* synthetic */ FirefoxRemoteVmConnection this$0;
                            {
                                this.this$0 = $receiver;
                                super(2);
                            }

                            public final void invoke(Tab item, @NotNull ColoredListCellRenderer<?> renderer) {
                                Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
                                Intrinsics.checkNotNull((Object)item);
                                renderer.append(FirefoxRemoteVmConnection.access$describeTab(this.this$0, item));
                            }
                        }));
                    }
                };
                Function function = new Function(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ Object fun(Object p0) {
                        return this.function.invoke(p0);
                    }
                };
                function1 = (Function1)new Function1<Tab, Promise<TabAttached>>((AsyncPromise<Vm>)this.$vmResult$inlined, this.this$0, vm){
                    final /* synthetic */ AsyncPromise<Vm> $vmResult;
                    final /* synthetic */ FirefoxRemoteVmConnection this$0;
                    final /* synthetic */ StandaloneFirefoxVm $vm;
                    {
                        this.$vmResult = $vmResult;
                        this.this$0 = $receiver;
                        this.$vm = $vm;
                        super(1);
                    }

                    public final Promise<TabAttached> invoke(Tab it) {
                        Promise promise;
                        if (Promises.isRejected((Promise)((Promise)this.$vmResult))) {
                            promise = Promises.rejectedPromise((String)"rejected");
                        } else {
                            Intrinsics.checkNotNull((Object)it);
                            FirefoxRemoteVmConnection.access$setTabLabel$p(this.this$0, FirefoxRemoteVmConnection.access$describeTab(this.this$0, it));
                            this.$vm.setTabActor(it.actor());
                            promise = this.$vm.getCommandProcessor().send(FirefoxRequest.Companion.attachToTab(it.actor()));
                        }
                        return promise;
                    }
                };
                Function function2 = new /* invalid duplicate definition of identical inner class */;
                function1 = (Function1)new Function1<TabAttached, Vm>((AsyncPromise<Vm>)this.$vmResult$inlined, vm, this.this$0){
                    final /* synthetic */ AsyncPromise<Vm> $vmResult;
                    final /* synthetic */ StandaloneFirefoxVm $vm;
                    final /* synthetic */ FirefoxRemoteVmConnection this$0;
                    {
                        this.$vmResult = $vmResult;
                        this.$vm = $vm;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Vm invoke(@NotNull TabAttached tabAttached) {
                        Intrinsics.checkNotNullParameter((Object)tabAttached, (String)"tabAttached");
                        if (!Promises.isRejected((Promise)((Promise)this.$vmResult))) {
                            this.$vm.setThreadActor(tabAttached.threadActor());
                            this.$vm.getCommandProcessor().addListener(new FirefoxListener(this.$vm, this.this$0){
                                final /* synthetic */ StandaloneFirefoxVm $vm;
                                final /* synthetic */ FirefoxRemoteVmConnection this$0;
                                {
                                    this.$vm = $vm;
                                    this.this$0 = $receiver;
                                }

                                public void tabDetached(@NotNull String actor) {
                                    Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
                                    if (Intrinsics.areEqual((Object)actor, (Object)this.$vm.getTabActor())) {
                                        this.$vm.setTabActor(null);
                                        this.$vm.setThreadActor(null);
                                        this.this$0.close(ConnectionStatus.DISCONNECTED.getStatusText() + " (tab detached)", ConnectionStatus.DETACHED);
                                    }
                                }
                            });
                        }
                        return (Vm)this.$vm;
                    }
                };
                vm.getCommandProcessor().addInitialMessageHandler().thenAsync(new Function(vm){
                    final /* synthetic */ StandaloneFirefoxVm $vm;
                    {
                        this.$vm = $vm;
                    }

                    public final Promise<ListTabsResult> fun(Object it) {
                        return this.$vm.getCommandProcessor().send(FirefoxRequest.Companion.listTabs());
                    }
                }).thenAsync(function).thenAsync(function2).then(new /* invalid duplicate definition of identical inner class */).processed((Promise)this.$vmResult$inlined);
            }
        });
        return var3_3;
    }

    @NotNull
    protected Bootstrap createBootstrap() {
        return BuiltInServerManager.Companion.getInstance().createClientBootstrap();
    }

    @NlsSafe
    private final String describeTab(Tab tab) {
        return tab.title() + " (" + JsFileUtil.trimTitle((String)tab.url()) + ")";
    }

    @NotNull
    protected String connectedAddressToPresentation(@NotNull InetSocketAddress address, @NotNull Vm vm) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        String string = super.connectedAddressToPresentation(address, vm);
        if (this.tabLabel == null) {
            object = "";
        } else {
            String string2 = this.tabLabel;
            Intrinsics.checkNotNull((Object)string2);
            object = " \u2013 " + string2;
        }
        return string + (String)object;
    }

    public static final /* synthetic */ DebugEventListener access$getDebugEventListener(FirefoxRemoteVmConnection $this) {
        return $this.getDebugEventListener();
    }

    public static final /* synthetic */ String access$describeTab(FirefoxRemoteVmConnection $this, Tab tab) {
        return $this.describeTab(tab);
    }

    public static final /* synthetic */ void access$setTabLabel$p(FirefoxRemoteVmConnection $this, String string) {
        $this.tabLabel = string;
    }
}

