/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModelUtil;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.actions.ChangeColumnDisplayTypeAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.CellRenderingUtils;
import com.intellij.database.run.ui.grid.GridRowHeader;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.run.ui.table.TableScrollPane;
import com.intellij.database.run.ui.table.TableSelectionModel;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.database.util.DataGridUIUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableResultRowHeader
extends GridRowHeader {
    private final DataGrid myResultPanel;
    private final TableResultView myTable;
    private final ActionGroup myPopupActions;
    private final GridRowHeader.RowHeaderCellRenderer myRenderer;

    public TableResultRowHeader(@NotNull DataGrid resultPanel, @NotNull TableResultView view, @Nullable ActionGroup popupActions) {
        if (resultPanel == null) {
            TableResultRowHeader.$$$reportNull$$$0(0);
        }
        if (view == null) {
            TableResultRowHeader.$$$reportNull$$$0(1);
        }
        super((JTable)((Object)view), () -> view.getShowHorizontalLines(), () -> view.getShowLastHorizontalLine());
        this.myResultPanel = resultPanel;
        this.myTable = view;
        this.myPopupActions = popupActions;
        this.myRenderer = new MyRowHeaderCellRenderer(this.createTransposedRenderer(), this.createRegularRenderer());
        GutterMouseListener mouseListener2 = new GutterMouseListener();
        this.addMouseMotionListener((MouseMotionListener)((Object)mouseListener2));
        this.addMouseListener((MouseListener)((Object)mouseListener2));
        new TableHoverListener(){

            public void onHover(@NotNull JTable table2, int row, int column) {
                if (table2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                TableResultRowHeader.this.revalidate();
                TableResultRowHeader.this.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/table/TableResultRowHeader$1", "onHover"));
            }
        }.addTo((JComponent)((Object)this.myTable));
    }

    @NotNull
    protected RowHeaderCellComponentBase createRegularRenderer() {
        return new RowNumberRowHeaderCellComponent();
    }

    @NotNull
    protected RowHeaderCellComponentBase createTransposedRenderer() {
        return new ColumnInfoRowHeaderCellComponent();
    }

    @Override
    @NotNull
    public GridRowHeader.RowHeaderCellRenderer getCellRenderer() {
        GridRowHeader.RowHeaderCellRenderer rowHeaderCellRenderer = this.myRenderer;
        if (rowHeaderCellRenderer == null) {
            TableResultRowHeader.$$$reportNull$$$0(2);
        }
        return rowHeaderCellRenderer;
    }

    @Override
    @NotNull
    public JTable getTable() {
        TableResultView tableResultView = this.myTable;
        if (tableResultView == null) {
            TableResultRowHeader.$$$reportNull$$$0(3);
        }
        return tableResultView;
    }

    private boolean isTransposed() {
        return this.myTable.isTransposed();
    }

    public int rowForPoint(@Nullable Point point) {
        return point != null ? this.myTable.rowAtPoint(point) : -1;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintCellsEffects(g);
    }

    @Override
    protected int calcPreferredWidthWithoutInsets() {
        if (this.isTransposed() || this.myTable.isEmpty()) {
            return super.calcPreferredWidthWithoutInsets();
        }
        int lastRowIdx = this.myTable.getModel().getRowCount() - 1;
        return ((RowNumberRowHeaderCellComponent)((Object)this.getCellRenderer().getRendererComponent(lastRowIdx, false))).getPreferredWidth();
    }

    private void paintCellsEffects(Graphics g) {
        CellRenderingUtils.processVisibleRows((JTable)((Object)this.myTable), g, (row, y) -> {
            this.paintCellEffects(g, row, new Rectangle(0, y, this.getWidth(), this.myTable.getRowHeight(row)));
            return true;
        });
    }

    private void paintCellEffects(Graphics g, int row, Rectangle cellRect) {
        CellAttributes attributes = this.isTransposed() ? this.myResultPanel.getMarkupModel().getColumnHeaderAttributes((ModelIndex<GridColumn>)ViewIndex.forColumn((CoreGrid)this.myResultPanel, (int)row).toModel((CoreGrid)this.myResultPanel), this.myResultPanel.getColorsScheme()) : this.myResultPanel.getMarkupModel().getRowHeaderAttributes((ModelIndex<GridRow>)ViewIndex.forRow((CoreGrid)this.myResultPanel, (int)row).toModel((CoreGrid)this.myResultPanel), this.myResultPanel.getColorsScheme());
        if (attributes != null) {
            CellRenderingUtils.paintCellEffect(g, cellRect, attributes, DataGridUIUtil.softHighlightOf(attributes.getEffectColor()));
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point point = event.getPoint();
        int viewRowIdx = this.rowForPoint(point);
        if (viewRowIdx < 0 || !this.isTransposed()) {
            return null;
        }
        ModelIndex columnIdx = ModelIndex.forColumn((CoreGrid)this.myResultPanel, (int)this.myTable.convertRowIndexToModel(viewRowIdx));
        return GridHelper.get(this.myResultPanel).getColumnTooltipHtml(this.myResultPanel, (ModelIndex<GridColumn>)columnIdx);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/table/TableResultRowHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/table/TableResultRowHeader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private class MyRowHeaderCellRenderer
    implements GridRowHeader.RowHeaderCellRenderer {
        final RowHeaderCellComponentBase myTransposed;
        final RowHeaderCellComponentBase myRegular;

        MyRowHeaderCellRenderer(RowHeaderCellComponentBase transposed, RowHeaderCellComponentBase regular) {
            this.myTransposed = transposed;
            this.myRegular = regular;
        }

        @Override
        public Component getRendererComponent(int row, boolean forDisplay) {
            RowHeaderCellComponentBase c = TableResultRowHeader.this.isTransposed() ? this.myTransposed : this.myRegular;
            int li = this.isLeftSide() ? 1 : 0;
            int ri = 1 - li;
            c.setBorder(BorderFactory.createCompoundBorder((Border)new CustomLineBorder(TableResultRowHeader.this.myTable.getGridColor(), 0, ri, 0, li), (Border)JBUI.Borders.empty((int)0, (int)8)));
            c.setRow(row, forDisplay);
            return c;
        }

        private boolean isLeftSide() {
            TableScrollPane parent = (TableScrollPane)((Object)ComponentUtil.getParentOfType(TableScrollPane.class, (Component)((Object)TableResultRowHeader.this.myTable)));
            return parent == null || !parent.isFlipped();
        }
    }

    protected abstract class RowHeaderCellComponentBase
    extends CellRendererPanel {
        private int myRow;

        protected RowHeaderCellComponentBase() {
        }

        public void setRow(int row, boolean forDisplay) {
            this.myRow = row;
        }

        public int getRow() {
            return this.myRow;
        }

        public boolean isShowing() {
            return true;
        }

        protected void paintComponent(Graphics g) {
            this.paintBackground(g);
        }

        public Color getBackground() {
            Color stripedColor;
            Color background;
            Color color = background = TableResultRowHeader.this.myTable.isTransposed() ? TableResultRowHeader.this.myResultPanel.getColorModel().getColumnHeaderBackground(this.getColumnModelIndex()) : TableResultRowHeader.this.myResultPanel.getColorModel().getRowHeaderBackground(this.getRowModelIndex());
            if (background != null) {
                return background;
            }
            Color hoveredColor = TableResultRowHeader.this.myTable.getShowHorizontalLines() || TableResultRowHeader.this.myTable.isStriped() ? null : TableResultRowHeader.this.myResultPanel.getHoveredRowBackground();
            Color color2 = stripedColor = TableResultRowHeader.this.myTable.isStriped() ? TableResultRowHeader.this.myResultPanel.getStripeRowBackground() : null;
            return hoveredColor != null && this.myRow == TableHoverListener.getHoveredRow((JTable)((Object)TableResultRowHeader.this.myTable)) ? hoveredColor : (stripedColor != null && this.myRow % 2 == 0 ? stripedColor : TableResultRowHeader.this.myTable.getBackground());
        }

        public Color getForeground() {
            return TableResultRowHeader.this.myTable.isTransposed() ? TableResultRowHeader.this.myResultPanel.getColorModel().getColumnHeaderForeground(this.getColumnModelIndex()) : TableResultRowHeader.this.myResultPanel.getColorModel().getRowHeaderForeground(this.getRowModelIndex());
        }

        private void paintBackground(Graphics g) {
            Color backup = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(backup);
        }

        @NotNull
        private ModelIndex<GridRow> getRowModelIndex() {
            assert (!TableResultRowHeader.this.isTransposed());
            ModelIndex modelIndex = ModelIndex.forRow((CoreGrid)TableResultRowHeader.this.myResultPanel, (int)TableResultRowHeader.this.myResultPanel.getRawIndexConverter().row2Model().applyAsInt(this.myRow));
            if (modelIndex == null) {
                RowHeaderCellComponentBase.$$$reportNull$$$0(0);
            }
            return modelIndex;
        }

        @NotNull
        private ModelIndex<GridColumn> getColumnModelIndex() {
            assert (TableResultRowHeader.this.isTransposed());
            ModelIndex modelIndex = ModelIndex.forColumn((CoreGrid)TableResultRowHeader.this.myResultPanel, (int)TableResultRowHeader.this.myResultPanel.getRawIndexConverter().column2Model().applyAsInt(this.myRow));
            if (modelIndex == null) {
                RowHeaderCellComponentBase.$$$reportNull$$$0(1);
            }
            return modelIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/run/ui/table/TableResultRowHeader$RowHeaderCellComponentBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRowModelIndex";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnModelIndex";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class GutterMouseListener
    extends PopupHandler {
        private boolean mySelectWhileDraggingInExclusiveMode;
        private int myResizingRow = -1;
        private boolean myResizingColumn = false;

        private GutterMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (TableResultRowHeader.this.isTransposed() && SwingUtilities.isLeftMouseButton(e) && e.getModifiersEx() == 512) {
                int viewRow = TableResultRowHeader.this.myTable.rowAtPoint(e.getPoint());
                int modelColumn = TableResultRowHeader.this.myResultPanel.getRawIndexConverter().column2Model().applyAsInt(viewRow);
                DataGridSettings settings = GridUtil.getSettings(TableResultRowHeader.this.myResultPanel);
                TableResultRowHeader.this.myTable.toggleSortOrder((ModelIndex<GridColumn>)ModelIndex.forColumn((CoreGrid)TableResultRowHeader.this.myResultPanel, (int)modelColumn), settings == null || settings.isAddToSortViaAltClick());
                return;
            }
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0) {
                this.packRow(e);
                this.toggleColumnSorting(e);
            }
            super.mouseClicked(e);
        }

        public void invokePopup(Component comp, int x, int y) {
            Point point = new Point(x, y);
            int viewRow = TableResultRowHeader.this.myTable.rowAtPoint(point);
            if (viewRow < 0) {
                return;
            }
            if (TableResultRowHeader.this.isTransposed()) {
                int modelColumn = TableResultRowHeader.this.myResultPanel.getRawIndexConverter().column2Model().applyAsInt(viewRow);
                if (modelColumn >= 0) {
                    TableResultRowHeader.this.myTable.invokeColumnPopup((ModelIndex<GridColumn>)ModelIndex.forColumn((CoreGrid)TableResultRowHeader.this.myResultPanel, (int)modelColumn), comp, point);
                }
            } else if (TableResultRowHeader.this.myPopupActions != null) {
                ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("EditorPopup", TableResultRowHeader.this.myPopupActions);
                menu.getComponent().show(comp, x, y);
            } else {
                int modelRow = TableResultRowHeader.this.myResultPanel.getRawIndexConverter().row2Model().applyAsInt(viewRow);
                if (modelRow >= 0) {
                    TableResultRowHeader.this.myTable.invokeRowPopup(comp, x, y);
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (this.shouldResizeColumn(e)) {
                TableResultRowHeader.this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (this.shouldResizeRow(e)) {
                TableResultRowHeader.this.setCursor(Cursor.getPredefinedCursor(9));
            } else {
                TableResultRowHeader.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        private boolean shouldResizeRow(MouseEvent e) {
            return this.getRowToResize(e) != -1;
        }

        private boolean shouldResizeColumn(MouseEvent e) {
            return TableResultRowHeader.this.myTable.isTransposed() && e.getX() >= TableResultRowHeader.this.getWidth() - 5 && e.getX() <= TableResultRowHeader.this.getWidth();
        }

        public void mousePressed(MouseEvent e) {
            if (this.shouldResizeColumn(e)) {
                this.myResizingColumn = true;
            } else {
                int rowToResize = this.getRowToResize(e);
                if (rowToResize != -1) {
                    this.myResizingRow = rowToResize;
                } else {
                    TableResultRowHeader.this.myResultPanel.getAutoscrollLocker().runWithLock(() -> this.processSelectionEvent(e, false));
                }
            }
            super.mousePressed(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.myResizingRow = -1;
            this.myResizingColumn = false;
            super.mouseReleased(e);
        }

        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                GutterMouseListener.$$$reportNull$$$0(0);
            }
            if (this.myResizingColumn) {
                TableResultRowHeader.this.updatePreferredSize(e.getX(), true);
                TableResultRowHeader.this.revalidate();
                TableResultRowHeader.this.repaint();
            } else if (this.myResizingRow != -1) {
                int newRowHeight;
                Rectangle cellRect = TableResultRowHeader.this.myTable.getCellRect(this.myResizingRow, 0, true);
                int oldRowHeight = TableResultRowHeader.this.myTable.getRowHeight(this.myResizingRow);
                if (oldRowHeight != (newRowHeight = Math.max(TableResultRowHeader.this.myTable.getRowHeight(), e.getY() - cellRect.y))) {
                    TableResultRowHeader.this.myTable.setRowHeight(this.myResizingRow, newRowHeight);
                }
            } else {
                this.processSelectionEvent(e, true);
            }
        }

        private int getRowToResize(MouseEvent e) {
            int rowAtPoint = TableResultRowHeader.this.rowForPoint(e.getPoint());
            if (rowAtPoint == -1) {
                return -1;
            }
            Rectangle cellRect = TableResultRowHeader.this.myTable.getCellRect(rowAtPoint, 0, true);
            int yInCellRect = e.getY() - cellRect.y;
            return yInCellRect < 4 ? (rowAtPoint == 0 ? -1 : rowAtPoint - 1) : (yInCellRect > cellRect.height - 4 ? rowAtPoint : -1);
        }

        private void processSelectionEvent(MouseEvent e, boolean isDragEvent) {
            int currentRow = TableResultRowHeader.this.rowForPoint(e.getPoint());
            if (currentRow == -1) {
                e.consume();
                return;
            }
            if (!TableResultRowHeader.this.myTable.hasFocus()) {
                IdeFocusManager.getInstance((Project)TableResultRowHeader.this.myResultPanel.getProject()).requestFocus((Component)((Object)TableResultRowHeader.this.myTable), true);
            }
            boolean selected = this.processSelectionEventInternal(e, isDragEvent, currentRow);
            TableResultRowHeader.this.myResultPanel.getHiddenColumnSelectionHolder().setWholeRowSelected(!TableResultRowHeader.this.isTransposed() && selected);
            e.consume();
        }

        private boolean processSelectionEventInternal(MouseEvent e, boolean isDragEvent, int currentRow) {
            boolean interval = GridUtil.isIntervalModifierSet(e);
            boolean exclusive = GridUtil.isExclusiveModifierSet(e);
            TableSelectionModel selectionModel = (TableSelectionModel)ObjectUtils.tryCast(SelectionModelUtil.get(TableResultRowHeader.this.myResultPanel, TableResultRowHeader.this.myTable), TableSelectionModel.class);
            if (selectionModel == null) {
                return false;
            }
            if (interval) {
                int lead = TableResultRowHeader.this.myTable.getSelectionModel().getLeadSelectionIndex();
                if (exclusive) {
                    selectionModel.addRowSelectionInterval(currentRow, lead);
                    selectionModel.addColumnSelectionInterval(TableResultRowHeader.this.myTable.getColumnCount() - 1, 0);
                } else {
                    selectionModel.setRowSelectionInterval(currentRow, lead);
                    selectionModel.setColumnSelectionInterval(TableResultRowHeader.this.myTable.getColumnCount() - 1, 0);
                }
                return true;
            }
            if (exclusive) {
                if (!isDragEvent) {
                    boolean bl = this.mySelectWhileDraggingInExclusiveMode = !TableResultRowHeader.this.myTable.isRowSelected(currentRow) || TableResultRowHeader.this.myTable.getSelectedColumnCount() != TableResultRowHeader.this.myTable.getColumnCount();
                }
                if (this.mySelectWhileDraggingInExclusiveMode) {
                    selectionModel.addRowSelection((ModelIndexSet<GridRow>)ModelIndexSet.forRows((CoreGrid)TableResultRowHeader.this.myResultPanel, (int[])new int[]{currentRow}));
                    selectionModel.addColumnSelectionInterval(TableResultRowHeader.this.myTable.getColumnCount() - 1, 0);
                } else {
                    TableResultRowHeader.this.myTable.removeRowSelectionInterval(currentRow, currentRow);
                }
                return this.mySelectWhileDraggingInExclusiveMode;
            }
            int lead = isDragEvent ? TableResultRowHeader.this.myTable.getSelectionModel().getLeadSelectionIndex() : currentRow;
            selectionModel.setRowSelectionInterval(currentRow, lead);
            selectionModel.setColumnSelectionInterval(TableResultRowHeader.this.myTable.getColumnCount() - 1, 0);
            return true;
        }

        private void toggleColumnSorting(MouseEvent e) {
            if (!e.isConsumed() && TableResultRowHeader.this.isTransposed() && TableResultRowHeader.this.myResultPanel.isSortViaOrderBy()) {
                ViewIndex viewIndex = ViewIndex.forColumn((CoreGrid)TableResultRowHeader.this.myResultPanel, (int)TableResultRowHeader.this.rowForPoint(e.getPoint()));
                ModelIndex idx = viewIndex.toModel((CoreGrid)TableResultRowHeader.this.myResultPanel);
                TableResultRowHeader.this.myResultPanel.toggleSortColumns(Collections.singletonList(idx), false);
                e.consume();
            }
        }

        private void packRow(MouseEvent e) {
            int rowToResize = this.getRowToResize(e);
            if (e.isConsumed() || rowToResize == -1) {
                return;
            }
            int expandedHeight = this.getExpandedRowHeight(rowToResize);
            int newHeight = TableResultRowHeader.this.myTable.getRowHeight(rowToResize) >= expandedHeight ? TableResultRowHeader.this.myTable.getRowHeight() : expandedHeight;
            TableResultRowHeader.this.myTable.setRowHeight(rowToResize, newHeight);
        }

        private int getExpandedRowHeight(int row) {
            int expandedHeight = TableResultRowHeader.this.myTable.getRowHeight();
            for (int column = 0; column < TableResultRowHeader.this.myTable.getColumnCount(); ++column) {
                TableCellRenderer renderer2 = TableResultRowHeader.this.myTable.getCellRenderer(row, column);
                if (renderer2 == null) continue;
                Component c = TableResultRowHeader.this.myTable.prepareRenderer(renderer2, row, column);
                expandedHeight = Math.max(expandedHeight, c.getPreferredSize().height);
            }
            return expandedHeight;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/table/TableResultRowHeader$GutterMouseListener", "mouseDragged"));
        }
    }

    protected class RowNumberRowHeaderCellComponent
    extends RowHeaderCellComponentBase {
        protected RowNumberRowHeaderCellComponent() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintLineNumber(g);
        }

        public Dimension getPreferredSize() {
            int preferredWidth2 = this.getPreferredWidth();
            return new Dimension(preferredWidth2, TableResultRowHeader.this.myTable.getRowHeight(this.getRow()));
        }

        private int getPreferredWidth() {
            Insets insets = this.getInsets();
            return this.preferredWidthOf(this.getRowNumberString()) + (insets.right + insets.left);
        }

        private void paintLineNumber(Graphics g) {
            Font fontBackup = g.getFont();
            g.setFont(TableResultRowHeader.this.myTable.getFont());
            Insets insets = this.getInsets();
            int middleX = insets.left + (this.getWidth() - insets.left - insets.right) / 2;
            String rowNum = this.getRowNumberString();
            int stringWidth = g.getFontMetrics().stringWidth(rowNum);
            int baseline = this.getBaseline();
            g.drawString(rowNum, middleX - stringWidth / 2, baseline);
            FontMetrics metrics = TableResultRowHeader.this.myTable.getFontMetrics(TableResultRowHeader.this.myTable.getFont());
            int height = metrics.getAscent() - metrics.getDescent();
            this.drawEffects(g, new Rectangle(middleX - stringWidth / 2, baseline - height, stringWidth, height));
            g.setFont(fontBackup);
        }

        @NotNull
        private String getRowNumberString() {
            String string = GridUtil.getRowName(TableResultRowHeader.this.myResultPanel, this.getRow());
            if (string == null) {
                RowNumberRowHeaderCellComponent.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void drawEffects(Graphics g, Rectangle r) {
        }

        private int getBaseline() {
            FontMetrics metrics = TableResultRowHeader.this.myTable.getFontMetrics(TableResultRowHeader.this.myTable.getFont());
            return (TableResultRowHeader.this.myTable.getTextLineHeight() + metrics.getAscent() - metrics.getDescent()) / 2;
        }

        private int preferredWidthOf(String text) {
            return TableResultRowHeader.this.myTable.getFontMetrics(TableResultRowHeader.this.myTable.getFont()).stringWidth(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/table/TableResultRowHeader$RowNumberRowHeaderCellComponent", "getRowNumberString"));
        }
    }

    protected class ColumnInfoRowHeaderCellComponent
    extends RowHeaderCellComponentBase {
        private final JLabel myNameLabel;
        private final JLabel mySortLabel;

        public ColumnInfoRowHeaderCellComponent() {
            this.myNameLabel = new TableResultView.LabelWithFallbackFont(TableResultRowHeader.this.myTable);
            this.mySortLabel = new TableResultView.LabelWithFallbackFont(TableResultRowHeader.this.myTable);
            this.setLayout(new BorderLayout());
            this.myNameLabel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)CellRenderingUtils.NAME_LABEL_ROW_INSETS));
            this.mySortLabel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)CellRenderingUtils.SORT_LABEL_ROW_INSETS));
            this.mySortLabel.setVerticalAlignment(0);
            this.add(this.myNameLabel, "Center");
            this.add(this.mySortLabel, "East");
        }

        @Override
        public void setRow(int viewRowIdx, boolean forDisplay) {
            super.setRow(viewRowIdx, forDisplay);
            assert (TableResultRowHeader.this.isTransposed());
            ModelIndex modelColumnIdx = ViewIndex.forColumn((CoreGrid)TableResultRowHeader.this.myResultPanel, (int)viewRowIdx).toModel((CoreGrid)TableResultRowHeader.this.myResultPanel);
            GridColumn column = (GridColumn)TableResultRowHeader.this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(modelColumnIdx);
            if (column == null) {
                return;
            }
            Font font = TableResultRowHeader.this.myTable.getTableHeader().getFont();
            Color fg = this.getForeground();
            this.myNameLabel.setFont(font);
            this.mySortLabel.setFont(font);
            this.myNameLabel.setForeground(fg);
            this.mySortLabel.setForeground(fg);
            Icon icon = GridHelper.get(TableResultRowHeader.this.myResultPanel).getColumnIcon(TableResultRowHeader.this.myResultPanel, column, forDisplay);
            this.myNameLabel.setIcon(icon);
            String displayTypeName = ChangeColumnDisplayTypeAction.isBinary((ModelIndex<GridColumn>)modelColumnIdx, TableResultRowHeader.this.myResultPanel) ? " (" + TableResultRowHeader.this.myResultPanel.getDisplayType((ModelIndex<GridColumn>)modelColumnIdx).getName() + ")" : "";
            this.myNameLabel.setText(TableResultRowHeader.this.myResultPanel.getName(column) + displayTypeName);
            this.mySortLabel.setText("");
            this.mySortLabel.setIcon(null);
            if (TableResultRowHeader.this.myResultPanel.isSortViaOrderBy() && TableResultRowHeader.this.myResultPanel.getComparator((ModelIndex<GridColumn>)modelColumnIdx) != null) {
                int sortOrder = TableResultRowHeader.this.myResultPanel.getSortOrder(column);
                this.mySortLabel.setIcon(TableResultView.getSortOrderIcon(sortOrder));
                this.mySortLabel.setText(TableResultRowHeader.this.myResultPanel.countSortedColumns() > 1 ? TableResultView.getSortOrderText(sortOrder) : "");
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.drawEffects(g, TableResultView.getLabelTextRect(this.myNameLabel));
        }

        protected void drawEffects(Graphics g, Rectangle r) {
        }
    }
}

