/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.NestedTablesDataGridModel;
import com.intellij.database.run.ui.table.LocalFilterState;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/run/ui/table/FilterStateControllerForNestedTables;", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "(Lcom/intellij/database/datagrid/DataGrid;)V", "activeFilterState", "Lcom/intellij/database/run/ui/table/LocalFilterState;", "getActiveFilterState", "()Lcom/intellij/database/run/ui/table/LocalFilterState;", "filterStateStack", "", "enterNestedTable", "coordinate", "Lcom/intellij/database/datagrid/NestedTablesDataGridModel$NestedTableCellCoordinate;", "exitNestedTable", "steps", "", "intellij.grid.impl"})
public final class FilterStateControllerForNestedTables {
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final List<LocalFilterState> filterStateStack;

    public FilterStateControllerForNestedTables(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.grid = grid;
        this.filterStateStack = new ArrayList();
        this.filterStateStack.add(new LocalFilterState(this.grid, false, 2, null));
    }

    @NotNull
    public final LocalFilterState getActiveFilterState() {
        return (LocalFilterState)CollectionsKt.last(this.filterStateStack);
    }

    @NotNull
    public final LocalFilterState enterNestedTable(@NotNull NestedTablesDataGridModel.NestedTableCellCoordinate coordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        this.filterStateStack.add(new LocalFilterState(this.grid, this.getActiveFilterState().isEnabled()));
        this.grid.getResultView().onLocalFilterStateChanged();
        return (LocalFilterState)CollectionsKt.last(this.filterStateStack);
    }

    @NotNull
    public final LocalFilterState exitNestedTable(int steps) {
        int depth = this.filterStateStack.size();
        if (steps >= depth) {
            throw new IllegalStateException("Current nested tables depth is " + depth + ". Cannot backtrack by " + steps + " steps.");
        }
        this.filterStateStack.subList(Math.max(1, depth - steps), depth).clear();
        this.grid.getResultView().onLocalFilterStateChanged();
        return (LocalFilterState)CollectionsKt.last(this.filterStateStack);
    }
}

