/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.database.DataGridBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridEditorPanel;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridEditorPanelBase
extends JPanel
implements GridEditorPanel,
EditorColorsListener,
DataProvider {
    protected final Project myProject;
    protected final DataGrid myGrid;
    protected final EditorEx myEditor;
    private String myPrefix;
    private String myDefaultText;

    GridEditorPanelBase(@NotNull Project project, @NotNull DataGrid grid, @NotNull String prefix, @NotNull String defaultText, @NotNull Document document) {
        if (project == null) {
            GridEditorPanelBase.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            GridEditorPanelBase.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            GridEditorPanelBase.$$$reportNull$$$0(2);
        }
        if (defaultText == null) {
            GridEditorPanelBase.$$$reportNull$$$0(3);
        }
        if (document == null) {
            GridEditorPanelBase.$$$reportNull$$$0(4);
        }
        this.setLayout(new BorderLayout());
        this.myProject = project;
        this.myGrid = grid;
        this.myEditor = this.createEditor(document);
        this.myPrefix = prefix;
        this.myDefaultText = defaultText;
        this.updateEditorPrefix();
        Disposer.register((Disposable)this.myGrid, () -> EditorFactory.getInstance().releaseEditor((Editor)this.myEditor));
        GridHelper.get(this.myGrid).updateFilterSortPSI(this.myGrid);
        final JBLabel clearFieldLabel = new JBLabel(AllIcons.Actions.Close);
        clearFieldLabel.setOpaque(false);
        clearFieldLabel.setVisible(document.getTextLength() != 0);
        clearFieldLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                GridEditorPanelBase.this.clearText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridEditorPanelBase$1", "mouseReleased"));
            }
        });
        this.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                int oldLength = event.getOldLength();
                int newLength = event.getNewLength();
                if (oldLength == 0 || newLength == 0 || oldLength == GridEditorPanelBase.this.myDefaultText.length() || newLength == GridEditorPanelBase.this.myDefaultText.length()) {
                    clearFieldLabel.setVisible(event.getDocument().getTextLength() != 0);
                    GridEditorPanelBase.this.updateEditorPrefix();
                }
            }

            public void bulkUpdateFinished(@NotNull Document document) {
                if (document == null) {
                    2.$$$reportNull$$$0(1);
                }
                clearFieldLabel.setVisible(document.getTextLength() != 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridEditorPanelBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "documentChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bulkUpdateFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myGrid);
        this.add((Component)clearFieldLabel, "East");
        this.add((Component)this.myEditor.getComponent(), "Center");
    }

    protected void updatePrefix(@NotNull String prefix, @NotNull String defaultText) {
        if (prefix == null) {
            GridEditorPanelBase.$$$reportNull$$$0(5);
        }
        if (defaultText == null) {
            GridEditorPanelBase.$$$reportNull$$$0(6);
        }
        this.myPrefix = prefix;
        this.myDefaultText = defaultText;
        this.updateEditorPrefix();
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myEditor.getDocument().getText();
        if (string == null) {
            GridEditorPanelBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    abstract void clearText();

    protected void setHighlighter() {
        GridHelper.get(this.myGrid).setFilterSortHighlighter(this.myGrid, (Editor)this.myEditor);
    }

    @NotNull
    private EditorEx createEditor(@NotNull Document document) {
        if (document == null) {
            GridEditorPanelBase.$$$reportNull$$$0(8);
        }
        EditorEx editor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject);
        editor.putUserData(EditorTextField.SUPPLEMENTARY_KEY, (Object)true);
        editor.setOneLineMode(true);
        editor.getSettings().setCaretRowShown(false);
        editor.getSettings().setShowIntentionBulb(false);
        EditorTextField.setupTextFieldEditor((EditorEx)editor);
        editor.getComponent().setFocusable(false);
        editor.getComponent().setOpaque(false);
        editor.getComponent().setBorder((Border)JBUI.Borders.empty((int)0, (int)7));
        GridEditorPanelBase.setScheme(editor, (EditorColorsScheme)this.myGrid.getEditorColorsScheme());
        editor.setEmbeddedIntoDialogWrapper(true);
        editor.getContentComponent().setOpaque(false);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            GridEditorPanelBase.$$$reportNull$$$0(9);
        }
        return editorEx;
    }

    public void onError(@NotNull ErrorInfo errorInfo) {
        if (errorInfo == null) {
            GridEditorPanelBase.$$$reportNull$$$0(10);
        }
        JComponent component = this.myEditor.getContentComponent();
        GridUtil.showErrorBalloon(errorInfo, component, GridEditorPanelBase.getFilterEditorCaretPoint(this.myEditor));
    }

    @Override
    protected Graphics getComponentGraphics(Graphics g) {
        return IdeBackgroundUtil.withEditorBackground((Graphics)g, (JComponent)this);
    }

    @Override
    public Color getBackground() {
        return this.myEditor == null ? super.getBackground() : this.myEditor.getBackgroundColor();
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getComponent(), true));
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean b = this.myEditor.getContentComponent().requestFocusInWindow();
        if (!this.myEditor.isDisposed()) {
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        return b;
    }

    @Override
    public boolean handleError(@NotNull GridRequestSource source, @NotNull ErrorInfo errorInfo) {
        GridEditorPanelRequestPlace place;
        if (source == null) {
            GridEditorPanelBase.$$$reportNull$$$0(11);
        }
        if (errorInfo == null) {
            GridEditorPanelBase.$$$reportNull$$$0(12);
        }
        if ((place = (GridEditorPanelRequestPlace)ObjectUtils.tryCast((Object)source.place, GridEditorPanelRequestPlace.class)) == null || place.myPanel != this) {
            return false;
        }
        this.onError(errorInfo);
        return true;
    }

    @NotNull
    protected static Point getFilterEditorCaretPoint(@NotNull EditorEx editor) {
        if (editor == null) {
            GridEditorPanelBase.$$$reportNull$$$0(13);
        }
        VisualPosition caretPosition = editor.getCaretModel().getVisualPosition();
        Point point = editor.visualPositionToXY(caretPosition);
        point.translate(0, editor.getContentComponent().getHeight());
        Point point2 = point;
        if (point2 == null) {
            GridEditorPanelBase.$$$reportNull$$$0(14);
        }
        return point2;
    }

    private void updateEditorPrefix() {
        EditorColorsScheme scheme = this.myEditor.getColorsScheme();
        TextAttributes attributes = scheme.getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT).clone();
        TextAttributes keywordAttributes = scheme.getAttributes(DefaultLanguageHighlighterColors.KEYWORD).clone();
        DocumentEx document = this.myEditor.getDocument();
        if (document.getTextLength() == 0 || this.myDefaultText.equals(document.getText()) || GridEditorPanelBase.isComment(document.getText())) {
            keywordAttributes.setForegroundColor(attributes.getForegroundColor());
        }
        this.myEditor.setPrefixTextAndAttributes(this.myPrefix + " ", keywordAttributes);
    }

    protected static boolean isComment(@NotNull String text) {
        if (text == null) {
            GridEditorPanelBase.$$$reportNull$$$0(15);
        }
        return text.startsWith("--") || text.startsWith("#") || text.startsWith("//") || text.startsWith("/*");
    }

    private static void setScheme(@NotNull EditorEx editor, @NotNull EditorColorsScheme scheme) {
        if (editor == null) {
            GridEditorPanelBase.$$$reportNull$$$0(16);
        }
        if (scheme == null) {
            GridEditorPanelBase.$$$reportNull$$$0(17);
        }
        editor.setColorsScheme(editor.createBoundColorSchemeDelegate(scheme));
        editor.setBackgroundColor(editor.getBackgroundColor());
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        GridEditorPanelBase.setScheme(this.myEditor, (EditorColorsScheme)this.myGrid.getEditorColorsScheme());
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            GridEditorPanelBase.$$$reportNull$$$0(18);
        }
        if (PlatformCoreDataKeys.FILE_EDITOR.is(dataId)) {
            return TextEditorProvider.getInstance().getTextEditor((Editor)this.myEditor);
        }
        return null;
    }

    @NotNull
    static CustomShortcutSet getShowHistoryShortcut() {
        return new CustomShortcutSet(KeyStroke.getKeyStroke(40, 512));
    }

    @NotNull
    static JBPopup createHistoryPopup(@NotNull List<String> history, @NotNull Project project, @NotNull Editor editor, @NotNull Runnable apply) {
        if (history == null) {
            GridEditorPanelBase.$$$reportNull$$$0(19);
        }
        if (project == null) {
            GridEditorPanelBase.$$$reportNull$$$0(20);
        }
        if (editor == null) {
            GridEditorPanelBase.$$$reportNull$$$0(21);
        }
        if (apply == null) {
            GridEditorPanelBase.$$$reportNull$$$0(22);
        }
        JBList historyList = new JBList((Collection)ContainerUtil.filter(history, value -> !value.isEmpty()));
        Runnable itemChosenCallback = () -> GridEditorPanelBase.lambda$createHistoryPopup$4((JList)historyList, project, editor, apply);
        JBPopup jBPopup = JBPopupFactory.getInstance().createListPopupBuilder((JList)historyList).setMovable(false).setRequestFocus(true).setItemChosenCallback(itemChosenCallback).createPopup();
        if (jBPopup == null) {
            GridEditorPanelBase.$$$reportNull$$$0(23);
        }
        return jBPopup;
    }

    @Override
    public void apply() {
        GridFilteringModel model2 = this.myGrid.getDataHookup().getFilteringModel();
        if (model2 != null && this.myGrid.isSafeToReload()) {
            this.myGrid.getDataHookup().getLoader().applyFilterAndSorting(new GridRequestSource((GridRequestSource.RequestPlace)new GridEditorPanelRequestPlace(this, this.myGrid)));
        }
    }

    @Override
    @NotNull
    public JComponent getGridPreferredFocusedComponent() {
        JComponent jComponent = this.myGrid.getPreferredFocusedComponent();
        if (jComponent == null) {
            GridEditorPanelBase.$$$reportNull$$$0(24);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        GridEditorPanelBase gridEditorPanelBase = this;
        if (gridEditorPanelBase == null) {
            GridEditorPanelBase.$$$reportNull$$$0(25);
        }
        return gridEditorPanelBase;
    }

    @Override
    @NotNull
    public EditorEx getEditor() {
        EditorEx editorEx = this.myEditor;
        if (editorEx == null) {
            GridEditorPanelBase.$$$reportNull$$$0(26);
        }
        return editorEx;
    }

    private static /* synthetic */ void lambda$createHistoryPopup$4(JList historyList, Project project, Editor editor, Runnable apply) {
        String selectedFilter = (String)historyList.getSelectedValue();
        if (selectedFilter != null) {
            WriteCommandAction.writeCommandAction((Project)project).run(() -> {
                Document document = editor.getDocument();
                document.replaceString(0, document.getTextLength(), (CharSequence)selectedFilter);
                CaretModel caretModel = editor.getCaretModel();
                if (caretModel.getOffset() >= document.getTextLength()) {
                    caretModel.moveToOffset(document.getTextLength());
                }
            });
            apply.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 14, 23, 24, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultText";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: 
            case 9: 
            case 14: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridEditorPanelBase";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 13: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridEditorPanelBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterEditorCaretPoint";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createHistoryPopup";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getGridPreferredFocusedComponent";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updatePrefix";
                break;
            }
            case 7: 
            case 9: 
            case 14: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onError";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleError";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFilterEditorCaretPoint";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isComment";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setScheme";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createHistoryPopup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 14, 23, 24, 25, 26 -> new IllegalStateException(string);
        };
    }

    private static class GridEditorPanelRequestPlace
    implements GridRequestSource.GridRequestPlace<GridRow, GridColumn> {
        final GridEditorPanel myPanel;
        final DataGrid myGrid;

        GridEditorPanelRequestPlace(@NotNull GridEditorPanel panel2, @NotNull DataGrid grid) {
            if (panel2 == null) {
                GridEditorPanelRequestPlace.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                GridEditorPanelRequestPlace.$$$reportNull$$$0(1);
            }
            this.myPanel = panel2;
            this.myGrid = grid;
        }

        @NotNull
        public DataGrid getGrid() {
            DataGrid dataGrid = this.myGrid;
            if (dataGrid == null) {
                GridEditorPanelRequestPlace.$$$reportNull$$$0(2);
            }
            return dataGrid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/GridEditorPanelBase$GridEditorPanelRequestPlace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/GridEditorPanelBase$GridEditorPanelRequestPlace";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGrid";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    protected class HistoryIcon
    extends JBLabel {
        HistoryIcon(Icon icon) {
            if (icon == null) {
                HistoryIcon.$$$reportNull$$$0(0);
            }
            super(icon);
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GridEditorPanelBase.this.showHistoryPopup();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridEditorPanelBase$HistoryIcon$1", "mousePressed"));
                }
            });
            new HelpTooltip().setTitle(DataGridBundle.message((String)"action.ShowHistoryAction.tooltip", (Object[])new Object[0])).setShortcut(KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)GridEditorPanelBase.getShowHistoryShortcut())).setLocation(HelpTooltip.Alignment.BOTTOM).installOn((JComponent)((Object)this));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/database/run/ui/grid/GridEditorPanelBase$HistoryIcon", "<init>"));
        }
    }

    static class ShowHistoryAction
    extends FilterFieldAction {
        ShowHistoryAction(@NotNull @NotNull Function<@NotNull DataGrid, @Nullable GridEditorPanel> getPanel) {
            if (getPanel == null) {
                ShowHistoryAction.$$$reportNull$$$0(0);
            }
            super(DataGridBundle.message((String)"action.ShowHistoryAction.text", (Object[])new Object[0]), getPanel);
        }

        @Override
        protected void actionPerformed(@NotNull GridEditorPanel panel2, @Nullable Project project) {
            if (panel2 == null) {
                ShowHistoryAction.$$$reportNull$$$0(1);
            }
            panel2.showHistoryPopup();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/GridEditorPanelBase$ShowHistoryAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ApplyAction
    extends FilterFieldAction {
        public ApplyAction(@NotNull @NotNull Function<@NotNull DataGrid, @Nullable GridEditorPanel> getPanel) {
            if (getPanel == null) {
                ApplyAction.$$$reportNull$$$0(0);
            }
            super(DataGridBundle.message((String)"action.ApplyAction.text", (Object[])new Object[0]), getPanel);
        }

        @Override
        protected void actionPerformed(@NotNull GridEditorPanel panel2, @Nullable Project project) {
            if (panel2 == null) {
                ApplyAction.$$$reportNull$$$0(1);
            }
            if (ApplyAction.isValidTextEntered((Document)panel2.getEditor().getDocument(), project)) {
                panel2.apply();
            } else {
                ApplyAction.showInvalidFilterCriteriaBalloon(panel2, panel2.getInvalidTextErrorMessage());
            }
        }

        private static boolean isValidTextEntered(Document document, Project project) {
            String filter = document.getText();
            if (StringUtil.isEmptyOrSpaces((String)filter) || GridEditorPanelBase.isComment(filter)) {
                return true;
            }
            PsiFile psi = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            return psi == null || psi.getLanguage().getID().equals("GenericSQL") || !PsiTreeUtil.hasErrorElements((PsiElement)psi);
        }

        private static void showInvalidFilterCriteriaBalloon(@NotNull GridEditorPanel panel2, @NotNull @NlsContexts.PopupContent String message) {
            if (panel2 == null) {
                ApplyAction.$$$reportNull$$$0(2);
            }
            if (message == null) {
                ApplyAction.$$$reportNull$$$0(3);
            }
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.WARNING, null).setShowCallout(true).setHideOnAction(true).setHideOnClickOutside(true).createBalloon();
            Point point = GridEditorPanelBase.getFilterEditorCaretPoint(panel2.getEditor());
            balloon.show(new RelativePoint((Component)panel2.getEditor().getComponent(), point), Balloon.Position.below);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getPanel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/GridEditorPanelBase$ApplyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showInvalidFilterCriteriaBalloon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class CancelAction
    extends FilterFieldAction {
        CancelAction(@NotNull @NotNull Function<@NotNull DataGrid, @Nullable GridEditorPanel> getPanel) {
            if (getPanel == null) {
                CancelAction.$$$reportNull$$$0(0);
            }
            super(DataGridBundle.message((String)"action.CancelAction.text", (Object[])new Object[0]), getPanel);
        }

        @Override
        protected void actionPerformed(@NotNull GridEditorPanel panel2, @Nullable Project project) {
            if (panel2 == null) {
                CancelAction.$$$reportNull$$$0(1);
            }
            JComponent component = panel2.getGridPreferredFocusedComponent();
            IdeFocusManager.findInstanceByComponent((Component)component).requestFocus((Component)component, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/GridEditorPanelBase$CancelAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class FilterFieldAction
    extends DumbAwareAction {
        @NotNull
        private final @NotNull Function<@NotNull DataGrid, @Nullable GridEditorPanel> myGetPanel;

        FilterFieldAction(@Nullable @NlsActions.ActionText String text, @NotNull @NotNull Function<@NotNull DataGrid, @Nullable GridEditorPanel> getPanel) {
            if (getPanel == null) {
                FilterFieldAction.$$$reportNull$$$0(0);
            }
            super(text);
            this.myGetPanel = getPanel;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                FilterFieldAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            DataGrid grid;
            if (e == null) {
                FilterFieldAction.$$$reportNull$$$0(2);
            }
            GridEditorPanel panel2 = (grid = GridUtil.getDataGrid(e.getDataContext())) == null ? null : (GridEditorPanel)this.myGetPanel.fun((Object)grid);
            e.getPresentation().setEnabled(panel2 != null && LookupManager.getActiveLookup((Editor)panel2.getEditor()) == null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid grid;
            GridEditorPanel panel2;
            if (e == null) {
                FilterFieldAction.$$$reportNull$$$0(3);
            }
            GridEditorPanel gridEditorPanel = panel2 = (grid = GridUtil.getDataGrid(e.getDataContext())) == null ? null : (GridEditorPanel)this.myGetPanel.fun((Object)grid);
            if (panel2 == null) {
                return;
            }
            this.actionPerformed(panel2, e.getProject());
        }

        protected abstract void actionPerformed(@NotNull GridEditorPanel var1, @Nullable Project var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/GridEditorPanelBase$FilterFieldAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/GridEditorPanelBase$FilterFieldAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

