/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.loaders;

import com.intellij.database.extensions.Binding;
import com.intellij.database.extensions.DataConsumer;
import com.intellij.database.extensions.DataLoaderBindings;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.database.extractors.BaseExtractorsHelper;
import com.intellij.database.loaders.DataLoader;
import com.intellij.database.loaders.DataLoaderManager;
import com.intellij.database.loaders.LazyStampedCache;
import com.intellij.database.loaders.RestrictedClassLoader;
import com.intellij.database.loaders.ScriptProgressMessagesListener;
import com.intellij.database.loaders.ScriptedDataLoader;
import com.intellij.database.loaders.ScriptedDataLoaderKt;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.io.PathKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u000223B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u001eH\u0016J \u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020.2\u0006\u0010)\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020#H\u0016R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b8BX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00064"}, d2={"Lcom/intellij/database/loaders/ScriptedDataLoader;", "Lcom/intellij/database/loaders/DataLoader;", "scriptPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "dependenciesProgress", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/database/loaders/ScriptProgressMessagesListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "loaderDesc", "Lkotlin/Result;", "Lcom/intellij/database/loaders/ScriptedDataLoader$LoaderImpl;", "getLoaderDesc-d1pmJ48", "()Ljava/lang/Object;", "loaderDescCache", "Lcom/intellij/database/loaders/LazyStampedCache;", "", "modeLine", "Lcom/intellij/database/loaders/ScriptedDataLoader$ModeLine;", "getModeLine-d1pmJ48", "modeLineCache", "getScriptPath", "()Ljava/nio/file/Path;", "cleanup", "", "ensureInitialized", "consumer", "Lcom/intellij/database/loaders/DataLoader$ScriptProgressMessagesConsumer;", "equals", "", "other", "", "getAssociatedExtensions", "", "", "getDisplayName", "getId", "hashCode", "", "isSuitable", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isTableFirstFormat", "loadFromFile", "project", "Lcom/intellij/openapi/project/Project;", "dataConsumer", "Lcom/intellij/database/extensions/DataConsumer;", "toString", "LoaderImpl", "ModeLine", "intellij.grid.impl"})
public final class ScriptedDataLoader
implements DataLoader {
    @NotNull
    private final Path scriptPath;
    @NotNull
    private LazyStampedCache<ModeLine, Long> modeLineCache;
    @NotNull
    private LazyStampedCache<LoaderImpl, Long> loaderDescCache;
    @NotNull
    private final EventDispatcher<ScriptProgressMessagesListener> dependenciesProgress;

    public ScriptedDataLoader(@NotNull Path scriptPath) {
        Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
        this.scriptPath = scriptPath;
        this.modeLineCache = new LazyStampedCache((Function0)new Function0<ModeLine>(this){
            final /* synthetic */ ScriptedDataLoader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ModeLine invoke() {
                return ModeLine.Companion.parseModeLine(this.this$0.getScriptPath());
            }
        }, (Function0)new Function0<Long>(this){
            final /* synthetic */ ScriptedDataLoader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return ScriptedDataLoaderKt.access$stamp(this.this$0.getScriptPath());
            }
        }, null, 4, null);
        this.loaderDescCache = new LazyStampedCache((Function0)new Function0<LoaderImpl>(this){
            final /* synthetic */ ScriptedDataLoader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LoaderImpl invoke() {
                Path path = this.this$0.getScriptPath();
                EventListener eventListener = ScriptedDataLoader.access$getDependenciesProgress$p(this.this$0).getMulticaster();
                Intrinsics.checkNotNullExpressionValue((Object)eventListener, (String)"getMulticaster(...)");
                return LoaderImpl.Companion.describe(path, (DataLoader.ScriptProgressMessagesConsumer)eventListener);
            }
        }, (Function0)new Function0<Long>(this){
            final /* synthetic */ ScriptedDataLoader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return ScriptedDataLoaderKt.access$stamp(this.this$0.getScriptPath());
            }
        }, loaderDescCache.3.INSTANCE);
        EventDispatcher eventDispatcher = EventDispatcher.create(ScriptProgressMessagesListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.dependenciesProgress = eventDispatcher;
    }

    @NotNull
    public final Path getScriptPath() {
        return this.scriptPath;
    }

    private final Object getModeLine-d1pmJ48() {
        return this.modeLineCache.getResult-d1pmJ48();
    }

    private final Object getLoaderDesc-d1pmJ48() {
        return this.loaderDescCache.getResult-d1pmJ48();
    }

    @NotNull
    public String getId() {
        return ((Object)this.scriptPath.getFileName()).toString();
    }

    @NotNull
    public String getDisplayName() {
        Object object = this.getModeLine-d1pmJ48();
        Object object2 = (ModeLine)(Result.isFailure-impl((Object)object) ? null : object);
        if (object2 == null || (object2 = ((ModeLine)object2).getDisplayName()) == null) {
            String string = BaseExtractorsHelper.Script.extractSimpleName((String)this.getId());
            object2 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractSimpleName(...)");
        }
        return object2;
    }

    public boolean isTableFirstFormat() {
        Object object = this.getModeLine-d1pmJ48();
        ModeLine modeLine = (ModeLine)(Result.isFailure-impl((Object)object) ? null : object);
        return !(modeLine != null ? Intrinsics.areEqual((Object)modeLine.getTableFirstFormat(), (Object)false) : false);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ScriptedDataLoader && Intrinsics.areEqual((Object)((ScriptedDataLoader)other).scriptPath, (Object)this.scriptPath);
    }

    public int hashCode() {
        return ((Object)this.scriptPath).hashCode();
    }

    public final void cleanup() {
        this.loaderDescCache.drop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInitialized(@NotNull DataLoader.ScriptProgressMessagesConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        ScriptProgressMessagesListener listener2 = new ScriptProgressMessagesListener(consumer){
            private final /* synthetic */ DataLoader.ScriptProgressMessagesConsumer $$delegate_0;
            {
                this.$$delegate_0 = $consumer;
            }

            public void message(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$$delegate_0.message(text);
            }
        };
        this.dependenciesProgress.addListener((EventListener)listener2);
        try {
            Object object = this.getLoaderDesc-d1pmJ48();
            ResultKt.throwOnFailure((Object)object);
        }
        finally {
            this.dependenciesProgress.removeListener((EventListener)listener2);
        }
    }

    public void loadFromFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull DataConsumer dataConsumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dataConsumer, (String)"dataConsumer");
        Object object = this.getLoaderDesc-d1pmJ48();
        ResultKt.throwOnFailure((Object)object);
        ((LoaderImpl)object).runLoad(project, MapsKt.mapOf((Pair)TuplesKt.to((Object)"FILE", (Object)FileUtil.toSystemDependentName((String)file.getPath()))), dataConsumer);
    }

    @NotNull
    public Iterable<String> getAssociatedExtensions() {
        Object object = this.getModeLine-d1pmJ48();
        Object object2 = (ModeLine)(Result.isFailure-impl((Object)object) ? null : object);
        return object2 != null && (object2 = ((ModeLine)object2).getExtensions()) != null ? (Iterable)object2 : (Iterable)CollectionsKt.emptyList();
    }

    public boolean isSuitable(@NotNull VirtualFile file) {
        String string;
        List<String> extensions2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String name = string2;
        Object object = this.getModeLine-d1pmJ48();
        ModeLine modeLine = (ModeLine)(Result.isFailure-impl((Object)object) ? null : object);
        List<String> list = extensions2 = modeLine != null ? modeLine.getExtensions() : null;
        if (list != null) {
            Object v3;
            block3: {
                object = list;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    String it = (String)t;
                    boolean bl = false;
                    if (!StringsKt.endsWith((String)name, (String)it, (boolean)true)) continue;
                    v3 = t;
                    break block3;
                }
                v3 = null;
            }
            string = v3;
        } else {
            string = null;
        }
        return string != null;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(scriptPath=" + this.scriptPath + ")";
    }

    public static final /* synthetic */ EventDispatcher access$getDependenciesProgress$p(ScriptedDataLoader $this) {
        return $this.dependenciesProgress;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ \u0010\n\u001a\u00020\u000e2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bj\u0002`\t0\u0006H\u0016J*\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bj\u0002`\t0\u00062\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bj\u0002`\t0\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/loaders/ScriptedDataLoader$LoaderImpl;", "Lcom/intellij/database/extensions/DataLoaderBindings$Loader;", "classLoader", "Lcom/intellij/database/loaders/RestrictedClassLoader;", "(Lcom/intellij/database/loaders/RestrictedClassLoader;)V", "<set-?>", "Lcom/intellij/util/ThrowableConsumer;", "Lcom/intellij/database/extensions/DataLoaderBindings$Loader$LoadContext;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "load", "getLoad", "()Lcom/intellij/util/ThrowableConsumer;", "cleanup", "", "runLoad", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "", "", "", "dataConsumer", "Lcom/intellij/database/extensions/DataConsumer;", "Companion", "LoadContextImpl", "intellij.grid.impl"})
    private static final class LoaderImpl
    implements DataLoaderBindings.Loader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final RestrictedClassLoader classLoader;
        @NotNull
        private ThrowableConsumer<DataLoaderBindings.Loader.LoadContext, Exception> load;
        @NotNull
        private static final Binding<DataLoader.ScriptProgressMessagesConsumer> DEPENDENCIES_PROGRESS_CONSUMER = new Binding("DEPENDENCIES_PROGRESS_CONSUMER");

        public LoaderImpl(@NotNull RestrictedClassLoader classLoader) {
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            this.classLoader = classLoader;
            this.load = LoaderImpl::load$lambda$0;
        }

        @NotNull
        public final ThrowableConsumer<DataLoaderBindings.Loader.LoadContext, Exception> getLoad() {
            return this.load;
        }

        public final void runLoad(@NotNull Project project, @NotNull Map<String, ? extends Object> parameters, @NotNull DataConsumer dataConsumer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)dataConsumer, (String)"dataConsumer");
            ClassLoaderUtil.runWithClassLoader((ClassLoader)this.classLoader, () -> LoaderImpl.runLoad$lambda$1(this, project, parameters, dataConsumer));
        }

        public void load(@NotNull ThrowableConsumer<DataLoaderBindings.Loader.LoadContext, Exception> load) {
            Intrinsics.checkNotNullParameter(load, (String)"load");
            this.load = load;
        }

        public final void cleanup() {
            this.classLoader.cleanup();
        }

        private static final void load$lambda$0(DataLoaderBindings.Loader.LoadContext it) {
        }

        private static final void runLoad$lambda$1(LoaderImpl this$0, Project $project, Map $parameters, DataConsumer $dataConsumer) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$parameters, (String)"$parameters");
            Intrinsics.checkNotNullParameter((Object)$dataConsumer, (String)"$dataConsumer");
            this$0.load.consume((Object)new LoadContextImpl($project, $parameters, $dataConsumer));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/loaders/ScriptedDataLoader$LoaderImpl$Companion;", "", "()V", "DEPENDENCIES_PROGRESS_CONSUMER", "Lcom/intellij/database/extensions/Binding;", "Lcom/intellij/database/loaders/DataLoader$ScriptProgressMessagesConsumer;", "describe", "Lcom/intellij/database/loaders/ScriptedDataLoader$LoaderImpl;", "scriptPath", "Ljava/nio/file/Path;", "dependenciesProgressConsumer", "initEngine", "", "engine", "Lcom/intellij/ide/script/IdeScriptEngine;", "intellij.grid.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LoaderImpl describe(@NotNull Path scriptPath, @NotNull DataLoader.ScriptProgressMessagesConsumer dependenciesProgressConsumer) {
                Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
                Intrinsics.checkNotNullParameter((Object)dependenciesProgressConsumer, (String)"dependenciesProgressConsumer");
                RestrictedClassLoader restrictedCl = new RestrictedClassLoader(ExtensionScriptsUtil.getClassLoader((PluginId)ExtractorScripts.getPluginId()));
                IdeScriptEngine engine = ExtensionScriptsUtil.getEngineFor(null, (ClassLoader)restrictedCl, (Path)scriptPath, null, (boolean)true);
                if (engine == null) {
                    throw new ProcessCanceledException();
                }
                LoaderImpl loader = new LoaderImpl(restrictedCl);
                ExtensionScriptsUtil.setBindings((IdeScriptEngine)engine).bind(DataLoaderBindings.LOADER, (Object)loader).bind(DEPENDENCIES_PROGRESS_CONSUMER, (Object)dependenciesProgressConsumer);
                try {
                    System.setProperty("grape.root", ((Object)DataLoaderManager.Companion.getGrapeDir$intellij_grid_impl()).toString());
                    this.initEngine(engine);
                    ExtensionScriptsUtil.evalScript(null, (IdeScriptEngine)engine, (Path)scriptPath);
                }
                catch (ProcessCanceledException c) {
                    throw c;
                }
                catch (Throwable e) {
                    ScriptedDataLoaderKt.access$getLogger$p().warn(e);
                    if (e.getCause() instanceof ProcessCanceledException) {
                        ExceptionUtil.rethrow((Throwable)e.getCause());
                    }
                    ExceptionUtil.rethrow((Throwable)e);
                }
                return loader;
            }

            private final void initEngine(IdeScriptEngine engine) {
                if (!Intrinsics.areEqual((Object)engine.getLanguage(), (Object)"Groovy")) {
                    return;
                }
                try {
                    engine.eval("def logger = new com.intellij.database.extensions.IvyMessagesAdapter(DEPENDENCIES_PROGRESS_CONSUMER)\norg.apache.ivy.util.Message.setDefaultLogger(logger)");
                }
                catch (Throwable th) {
                    ScriptedDataLoaderKt.access$getLogger$p().warn("Failed to prepare loader script", th);
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c2\u0003J\t\u0010\r\u001a\u00020\tH\u00c2\u0003J3\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/loaders/ScriptedDataLoader$LoaderImpl$LoadContextImpl;", "Lcom/intellij/database/extensions/DataLoaderBindings$Loader$LoadContext;", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "", "", "", "consumer", "Lcom/intellij/database/extensions/DataConsumer;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;Lcom/intellij/database/extensions/DataConsumer;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "getDataConsumer", "getParameters", "getProject", "hashCode", "", "toString", "intellij.grid.impl"})
        private static final class LoadContextImpl
        implements DataLoaderBindings.Loader.LoadContext {
            @NotNull
            private final Project project;
            @NotNull
            private final Map<String, Object> parameters;
            @NotNull
            private final DataConsumer consumer;

            public LoadContextImpl(@NotNull Project project, @NotNull Map<String, ? extends Object> parameters, @NotNull DataConsumer consumer) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
                this.project = project;
                this.parameters = parameters;
                this.consumer = consumer;
            }

            @NotNull
            public Project getProject() {
                return this.project;
            }

            @NotNull
            public Map<String, Object> getParameters() {
                return this.parameters;
            }

            @NotNull
            public DataConsumer getDataConsumer() {
                return this.consumer;
            }

            private final Project component1() {
                return this.project;
            }

            private final Map<String, Object> component2() {
                return this.parameters;
            }

            private final DataConsumer component3() {
                return this.consumer;
            }

            @NotNull
            public final LoadContextImpl copy(@NotNull Project project, @NotNull Map<String, ? extends Object> parameters, @NotNull DataConsumer consumer) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
                return new LoadContextImpl(project, parameters, consumer);
            }

            public static /* synthetic */ LoadContextImpl copy$default(LoadContextImpl loadContextImpl, Project project, Map map, DataConsumer dataConsumer, int n, Object object) {
                if ((n & 1) != 0) {
                    project = loadContextImpl.project;
                }
                if ((n & 2) != 0) {
                    map = loadContextImpl.parameters;
                }
                if ((n & 4) != 0) {
                    dataConsumer = loadContextImpl.consumer;
                }
                return loadContextImpl.copy(project, map, dataConsumer);
            }

            @NotNull
            public String toString() {
                return "LoadContextImpl(project=" + this.project + ", parameters=" + this.parameters + ", consumer=" + this.consumer + ")";
            }

            public int hashCode() {
                int result = this.project.hashCode();
                result = result * 31 + ((Object)this.parameters).hashCode();
                result = result * 31 + this.consumer.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LoadContextImpl)) {
                    return false;
                }
                LoadContextImpl loadContextImpl = (LoadContextImpl)other;
                if (!Intrinsics.areEqual((Object)this.project, (Object)loadContextImpl.project)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.parameters, loadContextImpl.parameters)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.consumer, (Object)loadContextImpl.consumer);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0002B'\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0000J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ6\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/loaders/ScriptedDataLoader$ModeLine;", "", "()V", "extensions", "", "", "displayName", "tableFirstFormat", "", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;)V", "getDisplayName", "()Ljava/lang/String;", "getExtensions", "()Ljava/util/List;", "getTableFirstFormat", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "append", "ml", "component1", "component2", "component3", "copy", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;)Lcom/intellij/database/loaders/ScriptedDataLoader$ModeLine;", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.grid.impl"})
    private static final class ModeLine {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<String> extensions;
        @Nullable
        private final String displayName;
        @Nullable
        private final Boolean tableFirstFormat;
        @NotNull
        private static final ModeLine EMPTY = new ModeLine();
        @NotNull
        private static final Regex modeLineAssignmentPattern = new Regex("\\s+(\\w+)\\s*=\\s*(([^\\\\ ]|\\\\.)+)");

        public ModeLine(@NotNull List<String> extensions2, @Nullable String displayName, @Nullable Boolean tableFirstFormat) {
            Intrinsics.checkNotNullParameter(extensions2, (String)"extensions");
            this.extensions = extensions2;
            this.displayName = displayName;
            this.tableFirstFormat = tableFirstFormat;
        }

        @NotNull
        public final List<String> getExtensions() {
            return this.extensions;
        }

        @Nullable
        public final String getDisplayName() {
            return this.displayName;
        }

        @Nullable
        public final Boolean getTableFirstFormat() {
            return this.tableFirstFormat;
        }

        private ModeLine() {
            this(CollectionsKt.emptyList(), null, null);
        }

        @NotNull
        public final ModeLine append(@Nullable ModeLine ml) {
            Boolean bl;
            if (ml == null || ml == EMPTY) {
                return this;
            }
            if (this == EMPTY) {
                return ml;
            }
            List list = CollectionsKt.plus((Collection)this.extensions, (Iterable)ml.extensions);
            String string = ml.displayName;
            if (string == null) {
                string = this.displayName;
            }
            if ((bl = ml.tableFirstFormat) == null) {
                bl = this.tableFirstFormat;
            }
            return new ModeLine(list, string, bl);
        }

        @NotNull
        public final List<String> component1() {
            return this.extensions;
        }

        @Nullable
        public final String component2() {
            return this.displayName;
        }

        @Nullable
        public final Boolean component3() {
            return this.tableFirstFormat;
        }

        @NotNull
        public final ModeLine copy(@NotNull List<String> extensions2, @Nullable String displayName, @Nullable Boolean tableFirstFormat) {
            Intrinsics.checkNotNullParameter(extensions2, (String)"extensions");
            return new ModeLine(extensions2, displayName, tableFirstFormat);
        }

        public static /* synthetic */ ModeLine copy$default(ModeLine modeLine, List list, String string, Boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                list = modeLine.extensions;
            }
            if ((n & 2) != 0) {
                string = modeLine.displayName;
            }
            if ((n & 4) != 0) {
                bl = modeLine.tableFirstFormat;
            }
            return modeLine.copy(list, string, bl);
        }

        @NotNull
        public String toString() {
            return "ModeLine(extensions=" + this.extensions + ", displayName=" + this.displayName + ", tableFirstFormat=" + this.tableFirstFormat + ")";
        }

        public int hashCode() {
            int result = ((Object)this.extensions).hashCode();
            result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
            result = result * 31 + (this.tableFirstFormat == null ? 0 : ((Object)this.tableFirstFormat).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModeLine)) {
                return false;
            }
            ModeLine modeLine = (ModeLine)other;
            if (!Intrinsics.areEqual(this.extensions, modeLine.extensions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displayName, (Object)modeLine.displayName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tableFirstFormat, (Object)modeLine.tableFirstFormat);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/loaders/ScriptedDataLoader$ModeLine$Companion;", "", "()V", "EMPTY", "Lcom/intellij/database/loaders/ScriptedDataLoader$ModeLine;", "getEMPTY", "()Lcom/intellij/database/loaders/ScriptedDataLoader$ModeLine;", "modeLineAssignmentPattern", "Lkotlin/text/Regex;", "createModeLine", "path", "Ljava/nio/file/Path;", "line", "", "createModeLineFragment", "name", "value", "parseModeLine", "intellij.grid.impl"})
        @SourceDebugExtension(value={"SMAP\nScriptedDataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptedDataLoader.kt\ncom/intellij/database/loaders/ScriptedDataLoader$ModeLine$Companion\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,358:1\n52#2:359\n1#3:360\n1#3:363\n1313#4,2:361\n*S KotlinDebug\n*F\n+ 1 ScriptedDataLoader.kt\ncom/intellij/database/loaders/ScriptedDataLoader$ModeLine$Companion\n*L\n181#1:359\n181#1:360\n182#1:361,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ModeLine getEMPTY() {
                return EMPTY;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final ModeLine parseModeLine(@NotNull Path path) {
                ModeLine res;
                block14: {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    res = null;
                    res = this.getEMPTY();
                    try {
                        InputStream inputStream = PathKt.inputStreamIfExists((Path)path);
                        if (inputStream == null) break block14;
                        Closeable closeable = inputStream;
                        Throwable throwable = null;
                        try {
                            InputStream stream = (InputStream)closeable;
                            boolean bl = false;
                            Reader $this$useLines$iv = new InputStreamReader(stream);
                            boolean $i$f$useLines = false;
                            Closeable closeable2 = $this$useLines$iv;
                            int n = 8192;
                            closeable2 = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n);
                            Throwable throwable2 = null;
                            try {
                                BufferedReader it$iv = (BufferedReader)closeable2;
                                boolean bl2 = false;
                                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                                boolean bl3 = false;
                                Sequence $this$forEach$iv = lines;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    String line = (String)element$iv;
                                    boolean bl4 = false;
                                    if (!StringsKt.startsWith$default((String)line, (String)"//", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((CharSequence)line, (char)'#', (boolean)false, (int)2, null)) break;
                                    res = res.append(Companion.createModeLine(path, line));
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    catch (ProcessCanceledException c) {
                        throw c;
                    }
                    catch (Throwable th) {
                        ScriptedDataLoaderKt.access$getLogger$p().warn(th);
                    }
                }
                return res;
            }

            @Nullable
            public final ModeLine createModeLine(@NotNull Path path, @NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                int curIdx = StringsKt.indexOf$default((CharSequence)line, (String)" IJ: ", (int)0, (boolean)false, (int)6, null);
                if (curIdx == -1) {
                    return null;
                }
                curIdx += 4;
                ModeLine res = null;
                while (true) {
                    ModeLine cur;
                    String string;
                    MatchResult match;
                    if ((match = modeLineAssignmentPattern.find((CharSequence)line, curIdx)) == null) {
                        if (curIdx + 4 >= line.length()) break;
                        Logger logger = ScriptedDataLoaderKt.access$getLogger$p();
                        String string2 = line.substring(0, curIdx);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        String string3 = line.substring(curIdx);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        logger.warn("Invalid modeline `" + string2 + "<!!!>" + string3 + "` in " + ((Object)path.toAbsolutePath()).toString());
                        break;
                    }
                    if (curIdx != match.getRange().getFirst()) {
                        Logger logger = ScriptedDataLoaderKt.access$getLogger$p();
                        String string4 = line.substring(0, curIdx);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        String string5 = line.substring(curIdx, match.getRange().getFirst());
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        String string6 = line.substring(match.getRange().getFirst());
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                        logger.warn("Skipping modeline part `" + string4 + "[[[" + string5 + "]]]" + string6 + "` in " + ((Object)path.toAbsolutePath()).toString());
                    }
                    MatchGroup matchGroup = match.getGroups().get(1);
                    String name = matchGroup != null ? matchGroup.getValue() : null;
                    Object object = match.getGroups().get(2);
                    if (object != null && (object = object.getValue()) != null) {
                        Object it = object;
                        boolean bl = false;
                        string = StringUtil.unescapeStringCharacters((String)it);
                    } else {
                        string = null;
                    }
                    String value = string;
                    curIdx = match.getRange().getLast() + 1;
                    if (name == null || value == null || (cur = this.createModeLineFragment(path, name, value)) == null) continue;
                    ModeLine modeLine = res;
                    if (modeLine == null || (modeLine = modeLine.append(cur)) == null) {
                        modeLine = cur;
                    }
                    res = modeLine;
                }
                return res;
            }

            private final ModeLine createModeLineFragment(Path path, String name, String value) {
                return switch (name) {
                    case "extensions" -> {
                        char[] var5_5 = new char[]{';'};
                        yield ModeLine.copy$default(this.getEMPTY(), StringsKt.split$default((CharSequence)value, (char[])var5_5, (boolean)false, (int)0, (int)6, null), null, null, 6, null);
                    }
                    case "displayName" -> ModeLine.copy$default(this.getEMPTY(), null, value, null, 5, null);
                    case "tableFirstFormat" -> ModeLine.copy$default(this.getEMPTY(), null, null, Intrinsics.areEqual((Object)value, (Object)"true"), 3, null);
                    default -> {
                        ScriptedDataLoaderKt.access$getLogger$p().warn("Invalid modeline parameter `" + name + " = " + value + "` in " + ((Object)path.toAbsolutePath()).toString());
                        yield null;
                    }
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

