/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.bigdatatools.visualization.charts.analyser.SeriesSuggester;
import com.intellij.bigdatatools.visualization.charts.core.ChartPage;
import com.intellij.bigdatatools.visualization.charts.core.ChartPageKt;
import com.intellij.bigdatatools.visualization.charts.core.axes.settings.AxesSettings;
import com.intellij.bigdatatools.visualization.charts.core.settings.ChartSettings;
import com.intellij.bigdatatools.visualization.charts.settings.SeriesSettingsPanel;
import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.actions.ShowChartUnderTableAction;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridConversionUtil;
import com.intellij.database.datagrid.GridPanel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/actions/SwitchToChartAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "()V", "addChartToolbar", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "chartPage", "Lcom/intellij/bigdatatools/visualization/charts/core/ChartPage;", "createChartPane", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getParentComponent", "Ljava/awt/Container;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nSwitchToChartAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwitchToChartAction.kt\ncom/intellij/database/actions/SwitchToChartAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,117:1\n4098#2,11:118\n*S KotlinDebug\n*F\n+ 1 SwitchToChartAction.kt\ncom/intellij/database/actions/SwitchToChartAction\n*L\n55#1:118,11\n*E\n"})
public final class SwitchToChartAction
extends DumbAwareToggleAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Container container = this.getParentComponent(e);
        if (container == null) {
            return false;
        }
        Container parentComponent = container;
        return parentComponent instanceof OnePixelSplitter && ((OnePixelSplitter)parentComponent).getSecondComponent().isVisible();
    }

    private final Container getParentComponent(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            return null;
        }
        DataGrid grid = dataGrid;
        GridPanel gridPanel = grid.getPanel();
        Container container = gridPanel instanceof Container ? (Container)((Object)gridPanel) : null;
        return container != null ? container.getParent() : null;
    }

    /*
     * WARNING - void declaration
     */
    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        OnePixelSplitter onePixelSplitter;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Container container = this.getParentComponent(e);
        if (container == null) {
            return;
        }
        Container parentComponent = container;
        if (!(parentComponent instanceof OnePixelSplitter)) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            OnePixelSplitter onePixelSplitter2;
            OnePixelSplitter $this$setSelected_u24lambda_u241 = onePixelSplitter2 = new OnePixelSplitter(false);
            boolean bl = false;
            Object[] objectArray = (Object[])e.getData(DatabaseDataKeys.DATA_GRID_KEY);
            if (objectArray == null) {
                return;
            }
            Object[] objectArray2 = objectArray;
            Intrinsics.checkNotNull((Object)objectArray2);
            Object[] grid = objectArray2;
            Component[] componentArray = parentComponent.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            objectArray2 = componentArray;
            OnePixelSplitter onePixelSplitter3 = $this$setSelected_u24lambda_u241;
            boolean $i$f$filterIsInstance = false;
            void var12_11 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof JComponent)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            onePixelSplitter3.setFirstComponent((JComponent)CollectionsKt.first((List)((List)destination$iv$iv)));
            $this$setSelected_u24lambda_u241.setSecondComponent((JComponent)this.createChartPane((DataGrid)grid).getComponent());
            GridUtil.addDataProvider($this$setSelected_u24lambda_u241.getSecondComponent(), arg_0 -> SwitchToChartAction.setSelected$lambda$1$lambda$0((DataGrid)grid, arg_0));
            parentComponent.add((Component)$this$setSelected_u24lambda_u241);
            onePixelSplitter = onePixelSplitter2;
        } else {
            onePixelSplitter = (OnePixelSplitter)parentComponent;
        }
        OnePixelSplitter splitter = onePixelSplitter;
        splitter.getFirstComponent().setVisible(!state);
        splitter.getSecondComponent().setVisible(state);
    }

    private final void addChartToolbar(DataGrid grid, ChartPage chartPage) {
        ActionToolbar actionToolbar2;
        Boolean inEditorResults = (Boolean)GridUtil.IN_EDITOR_RESULTS.get((UserDataHolder)grid, (Object)false);
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("Console.TableResult.Inlay.Chart");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionToolbar $this$addChartToolbar_u24lambda_u242 = actionToolbar2 = actionManager.createActionToolbar("BDTChartToolbar", (ActionGroup)anAction, inEditorResults == false);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)inEditorResults);
        if (inEditorResults.booleanValue()) {
            $this$addChartToolbar_u24lambda_u242.getComponent().setOpaque(false);
            Insets insets = $this$addChartToolbar_u24lambda_u242.getComponent().getBorder().getBorderInsets($this$addChartToolbar_u24lambda_u242.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getBorderInsets(...)");
            Insets insets2 = insets;
            $this$addChartToolbar_u24lambda_u242.getComponent().setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createBorder((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground(), (int)1), (Border)new JBEmptyBorder(0, insets2.left, 0, insets2.right)));
        } else {
            Insets insets = $this$addChartToolbar_u24lambda_u242.getComponent().getBorder().getBorderInsets($this$addChartToolbar_u24lambda_u242.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getBorderInsets(...)");
            Insets insets3 = insets;
            $this$addChartToolbar_u24lambda_u242.getComponent().setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createBorder((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground(), (int)8), (Border)new JBEmptyBorder(insets3.top, insets3.left, insets3.bottom, insets3.right)));
        }
        ActionToolbar actionToolbar3 = actionToolbar2;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar3, (String)"apply(...)");
        ActionToolbar chartToolbar = actionToolbar3;
        chartToolbar.setTargetComponent((JComponent)chartPage.getComponent());
        chartPage.getComponent().add((Component)chartToolbar.getComponent(), inEditorResults != false ? "East" : "North");
    }

    private final ChartPage createChartPane(DataGrid grid) {
        ChartPage chartPage;
        DataFrame dataFrame = DataGridConversionUtil.INSTANCE.getDataFrame(grid);
        List settings = SeriesSuggester.INSTANCE.getSingleSuggestion(dataFrame);
        ChartPage $this$createChartPane_u24lambda_u243 = chartPage = new ChartPage(new ChartSettings(new AxesSettings(false, false, 3, null), settings), SeriesSettingsPanel.Mode.WITHOUT_COLUMNS_LIST);
        boolean bl = false;
        $this$createChartPane_u24lambda_u243.assignDataFrame(dataFrame);
        this.addChartToolbar(grid, $this$createChartPane_u24lambda_u243);
        Object object = GridUtil.IN_EDITOR_RESULTS.get((UserDataHolder)grid, (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (((Boolean)object).booleanValue()) {
            $this$createChartPane_u24lambda_u243.getComponent().setBorder(IdeBorderFactory.createBorder((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground()));
        }
        ChartPage chartPage2 = chartPage;
        UiUtils.putUserData((JComponent)chartPage2.getComponent(), (Key)ChartPageKt.getCHART_PAGE_KEY(), (Object)chartPage2);
        Disposer.register((Disposable)((Disposable)grid), (Disposable)((Disposable)chartPage2));
        ShowChartUnderTableAction.Companion.addGridContentListener(grid, chartPage2);
        return chartPage2;
    }

    private static final Object setSelected$lambda$1$lambda$0(DataGrid $grid, String dataId) {
        Intrinsics.checkNotNullParameter((Object)$grid, (String)"$grid");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return DatabaseDataKeys.DATA_GRID_KEY.is(dataId) ? $grid : null;
    }
}

