/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.parallelStacks.threads.view;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.parallelStacks.base.XDebuggerParallelStacksBundle;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksColors;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksNodeHeader;
import com.intellij.xdebugger.impl.parallelStacks.base.view.UpdatableGraph2DView;
import com.intellij.xdebugger.impl.parallelStacks.threads.MultipleFramesNode;
import com.intellij.xdebugger.impl.parallelStacks.threads.StackWithId;
import com.intellij.xdebugger.impl.parallelStacks.threads.view.ParallelThreadsView;
import com.intellij.xdebugger.impl.parallelStacks.threads.view.ThreadsViewNodeRealizer;
import java.awt.Color;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ThreadsViewNodeHeader;", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksNodeHeader;", "frameRealizer", "Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ThreadsViewNodeRealizer;", "parentView", "Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ParallelThreadsView;", "graphView", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;", "(Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ThreadsViewNodeRealizer;Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ParallelThreadsView;Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;)V", "createHeaderHintComponent", "Ljavax/swing/JComponent;", "shouldShowHint", "", "ThreadsListComponent", "intellij.platform.debugger.parallelStacks"})
@SourceDebugExtension(value={"SMAP\nThreadsViewNodeHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadsViewNodeHeader.kt\ncom/intellij/xdebugger/impl/parallelStacks/threads/view/ThreadsViewNodeHeader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class ThreadsViewNodeHeader
extends ParallelStacksNodeHeader {
    @NotNull
    private final ThreadsViewNodeRealizer frameRealizer;
    @NotNull
    private final ParallelThreadsView parentView;

    public ThreadsViewNodeHeader(@NotNull ThreadsViewNodeRealizer frameRealizer, @NotNull ParallelThreadsView parentView, @NotNull UpdatableGraph2DView graphView) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)frameRealizer, (String)"frameRealizer");
        Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
        Intrinsics.checkNotNullParameter((Object)graphView, (String)"graphView");
        super(frameRealizer, graphView);
        this.frameRealizer = frameRealizer;
        this.parentView = parentView;
        MultipleFramesNode multipleFramesNode = this.frameRealizer.getData();
        List<XExecutionStack> list = this.frameRealizer.getStacks();
        if (multipleFramesNode.getStacks().size() == 1) {
            Object v0;
            block4: {
                var8_6 = multipleFramesNode.getFrames().get(0).getStack();
                Iterable iterable = list;
                for (Object t2 : iterable) {
                    XExecutionStack xExecutionStack = (XExecutionStack)t2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)xExecutionStack, (Object)var8_6)) continue;
                    v0 = t2;
                    break block4;
                }
                v0 = null;
            }
            if ((object = (XExecutionStack)v0) == null || (object = object.getDisplayName()) == null) {
                object = "@" + multipleFramesNode.getStacks().get(0);
            }
        } else {
            var8_6 = new XExecutionStack[]{Integer.valueOf(multipleFramesNode.getStacks().size())};
            object = XDebuggerParallelStacksBundle.message("label.threads", (Object[])var8_6);
        }
        String string = object;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        this.setText(string2);
    }

    @Override
    @NotNull
    protected JComponent createHeaderHintComponent() {
        return new ThreadsListComponent(this.frameRealizer, this.parentView).toLabel();
    }

    @Override
    protected boolean shouldShowHint() {
        return this.frameRealizer.getData().getStacks().size() > 1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ThreadsViewNodeHeader$ThreadsListComponent;", "Lcom/intellij/ui/SimpleColoredComponent;", "frameRealizer", "Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ThreadsViewNodeRealizer;", "view", "Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ParallelThreadsView;", "(Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ThreadsViewNodeRealizer;Lcom/intellij/xdebugger/impl/parallelStacks/threads/view/ParallelThreadsView;)V", "toLabel", "Ljavax/swing/JLabel;", "intellij.platform.debugger.parallelStacks"})
    private static final class ThreadsListComponent
    extends SimpleColoredComponent {
        public ThreadsListComponent(@NotNull ThreadsViewNodeRealizer frameRealizer, @NotNull ParallelThreadsView view) {
            Intrinsics.checkNotNullParameter((Object)frameRealizer, (String)"frameRealizer");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            String string = "\\n";
            List<StackWithId> list = frameRealizer.getData().getStacks();
            int n10 = list.size();
            for (int i2 = 0; i2 < n10; ++i2) {
                Long l2 = view.getActiveThreadId();
                SimpleTextAttributes simpleTextAttributes = l2 != null && list.get(i2).getThreadId() == l2.longValue() ? new SimpleTextAttributes(0, (Color)ParallelStacksColors.INSTANCE.getACTIVE_HEADER_TEXT_COLOR()) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                this.append(list.get(i2).getStack().getDisplayName(), simpleTextAttributes);
                if (i2 >= CollectionsKt.getLastIndex(list)) continue;
                this.append(string);
            }
        }

        @NotNull
        public final JLabel toLabel() {
            JLabel jLabel = this.formatToLabel(new JLabel());
            Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"formatToLabel(...)");
            return jLabel;
        }
    }
}

