/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommentLineData {
    protected String line;
    int commentOffset;
    int textStartOffset;
    boolean startsWithLetter;
    private final List<TextRange> unbreakableRanges;

    public CommentLineData(@NotNull String line) {
        if (line == null) {
            CommentLineData.o(0);
        }
        this.commentOffset = -1;
        this.textStartOffset = -1;
        this.startsWithLetter = false;
        this.unbreakableRanges = new ArrayList<TextRange>();
        this.line = line;
    }

    public void addUnbreakableRange(@NotNull TextRange range) {
        if (range == null) {
            CommentLineData.o(1);
        }
        this.unbreakableRanges.add(range);
    }

    protected int calcWrapPos(int rightMargin) {
        if (!this.hasText()) {
            return -1;
        }
        int n10 = this.o(rightMargin);
        String string = this.line.substring(0, n10);
        int n11 = string.lastIndexOf(32);
        if (n11 < this.textStartOffset && (n11 = this.line.indexOf(32, this.textStartOffset)) != this.h(n11)) {
            return -1;
        }
        return n11;
    }

    public boolean hasText() {
        return this.textStartOffset > this.commentOffset;
    }

    public boolean canBeMergedWithPrevious() {
        return this.hasText() && this.startsWithLetter;
    }

    @NotNull
    public String getText() {
        if (this.hasText()) {
            String string = this.line.substring(this.textStartOffset);
            if (string == null) {
                CommentLineData.o(2);
            }
            return string;
        }
        return "";
    }

    public void merge(@NotNull CommentLineData lineData) {
        if (lineData == null) {
            CommentLineData.o(3);
        }
        for (TextRange textRange : lineData.unbreakableRanges) {
            this.unbreakableRanges.add(textRange.shiftRight(this.line.length() + 1));
        }
        this.line = this.line + " " + lineData.getText();
    }

    public int getLineLength() {
        int n10 = 0;
        for (int i2 = 0; i2 < this.line.length(); ++i2) {
            char c10 = this.line.charAt(i2);
            n10 = this.o(n10, c10);
        }
        return n10;
    }

    @Nullable
    public Pair<String, String> splitLine(int rightMargin) {
        int n10 = this.calcWrapPos(rightMargin);
        if (n10 >= 0) {
            return new Pair((Object)this.line.substring(0, n10), (Object)this.line.substring(n10));
        }
        return null;
    }

    @NotNull
    public String getLine() {
        String string = this.line;
        if (string == null) {
            CommentLineData.o(4);
        }
        return string;
    }

    public boolean isTagLine() {
        return false;
    }

    public void setTagLine(boolean isTagLine) {
    }

    @NotNull
    public String getLinePrefix() {
        return "";
    }

    protected abstract int getTabSize();

    private int o(int n10) {
        int n11 = 0;
        int n12 = 0;
        while (n11 < n10) {
            if (n12 < this.line.length()) {
                char c10 = this.line.charAt(n12);
                if ((n11 = this.o(n11, c10)) > n10) break;
                ++n12;
                continue;
            }
            --n12;
            break;
        }
        return this.h(n12);
    }

    private int h(int n10) {
        for (TextRange textRange : this.unbreakableRanges) {
            if (!textRange.contains(n10)) continue;
            return textRange.getStartOffset();
        }
        return n10;
    }

    private int o(int n10, char c10) {
        return n10 + (c10 == '\t' ? this.getTabSize() : 1);
    }

    private static /* synthetic */ void o(int n10) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n10) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n10) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/formatter/comments/CommentLineData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineData";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/formatter/comments/CommentLineData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLine";
                break;
            }
        }
        switch (n10) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addUnbreakableRange";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n10) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

