/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.usages;

import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.find.usages.api.UsageOptions;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.lsp.api.LspBundle;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.util.IconUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001aH\u0016J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\r\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lcom/intellij/platform/lsp/impl/usages/LspSearchTarget;", "Lcom/intellij/find/usages/api/SearchTarget;", "lspServers", "", "Lcom/intellij/platform/lsp/api/LspServer;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "position", "Lorg/eclipse/lsp4j/Position;", "(Ljava/util/Collection;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/eclipse/lsp4j/Position;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "fileNameAndPosition", "", "Lcom/intellij/openapi/util/NlsSafe;", "lspServerPresentableName", "Lorg/jetbrains/annotations/NonNls;", "getLspServers", "()Ljava/util/Collection;", "getPosition", "()Lorg/eclipse/lsp4j/Position;", "usageHandler", "Lcom/intellij/find/usages/api/UsageHandler;", "getUsageHandler", "()Lcom/intellij/find/usages/api/UsageHandler;", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "hashCode", "", "presentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "intellij.platform.lsp.impl"})
public final class LspSearchTarget
implements SearchTarget {
    @NotNull
    private final Collection<LspServer> lspServers;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final Position position;
    @NotNull
    private final String fileNameAndPosition;
    @NotNull
    private final String lspServerPresentableName;
    @NotNull
    private final UsageHandler usageHandler;

    public LspSearchTarget(@NotNull Collection<? extends LspServer> lspServers, @NotNull VirtualFile file2, @NotNull Position position) {
        Intrinsics.checkNotNullParameter(lspServers, (String)"lspServers");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.lspServers = lspServers;
        this.file = file2;
        this.position = position;
        this.fileNameAndPosition = this.file.getName() + ":" + (this.position.getLine() + 1) + ":" + (this.position.getCharacter() + 1);
        Object object = (LspServer)CollectionsKt.singleOrNull((Iterable)this.lspServers);
        if (object == null || (object = object.getDescriptor()) == null || (object = ((LspServerDescriptor)object).getPresentableName()) == null) {
            object = "LSP";
        }
        this.lspServerPresentableName = object;
        this.usageHandler = arg_0 -> LspSearchTarget.o(this, arg_0);
    }

    @NotNull
    public final Collection<LspServer> getLspServers() {
        return this.lspServers;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final Position getPosition() {
        return this.position;
    }

    @NotNull
    public Pointer<? extends SearchTarget> createPointer() {
        Pointer pointer2 = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer2, (String)"hardPointer(...)");
        return pointer2;
    }

    @NotNull
    public UsageHandler getUsageHandler() {
        return this.usageHandler;
    }

    @NotNull
    public TargetPresentation presentation() {
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(this.fileNameAndPosition).icon(IconUtil.getIcon((VirtualFile)this.file, (int)1, (Project)((LspServer)CollectionsKt.first((Iterable)this.lspServers)).getProject())).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.platform.lsp.impl.usages.LspSearchTarget");
        LspSearchTarget cfr_ignored_0 = (LspSearchTarget)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)((LspSearchTarget)other).file)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.position, (Object)((LspSearchTarget)other).position);
    }

    public int hashCode() {
        int n10 = this.file.hashCode();
        n10 = 31 * n10 + this.position.hashCode();
        return n10;
    }

    private static final String o(LspSearchTarget lspSearchTarget, UsageOptions usageOptions) {
        Intrinsics.checkNotNullParameter((Object)lspSearchTarget, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)usageOptions, (String)"it");
        Object[] objectArray = new Object[]{lspSearchTarget.lspServerPresentableName, lspSearchTarget.fileNameAndPosition};
        return LspBundle.INSTANCE.message("0.find.references.1", objectArray);
    }
}

