/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.navigation;

import com.intellij.model.Pointer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.backend.presentation.TargetPresentationBuilder;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\fH\u0016J\u001d\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001d\u0010\u0013\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/lsp/impl/navigation/LspNavigationTarget;", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "locationLink", "Lorg/eclipse/lsp4j/LocationLink;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/eclipse/lsp4j/LocationLink;)V", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "createPointer", "Lcom/intellij/model/Pointer;", "o", "", "Lcom/intellij/openapi/util/NlsSafe;", "file", "position", "Lorg/eclipse/lsp4j/Position;", "o", "navigationRequest", "Lcom/intellij/platform/backend/navigation/NavigationRequest;", "intellij.platform.lsp.impl"})
final class LspNavigationTarget
implements NavigationTarget {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile targetFile;
    @NotNull
    private final LocationLink locationLink;

    public LspNavigationTarget(@NotNull Project project, @NotNull VirtualFile targetFile, @NotNull LocationLink locationLink) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)locationLink, (String)"locationLink");
        this.project = project;
        this.targetFile = targetFile;
        this.locationLink = locationLink;
    }

    @NotNull
    public Pointer<LspNavigationTarget> createPointer() {
        Pointer pointer2 = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer2, (String)"hardPointer(...)");
        return pointer2;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentationBuilder targetPresentationBuilder = TargetPresentation.Companion.builder(this.o(this.targetFile, this.locationLink));
        Position position = this.locationLink.getTargetSelectionRange().getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        TargetPresentation targetPresentation = targetPresentationBuilder.locationText(this.o(this.targetFile, position)).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @Nullable
    public NavigationRequest navigationRequest() {
        Document document = FileDocumentManager.getInstance().getDocument(this.targetFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        Position position = this.locationLink.getTargetSelectionRange().getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        Integer n10 = Lsp4jUtilKt.getOffsetInDocument(document2, position);
        if (n10 == null) {
            return null;
        }
        int n11 = n10;
        return NavigationRequest.Companion.sourceNavigationRequest(this.project, this.targetFile, n11);
    }

    private final String o(VirtualFile virtualFile, LocationLink locationLink) {
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return "";
        }
        Document document2 = document;
        Range range = locationLink.getTargetSelectionRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getTargetSelectionRange(...)");
        TextRange textRange = Lsp4jUtilKt.getRangeInDocument(document2, range);
        if (textRange == null) {
            return "";
        }
        TextRange textRange2 = textRange;
        if (textRange2.getLength() > 0) {
            String string = StringUtil.shortenTextWithEllipsis((String)document2.getText(textRange2), (int)20, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            return string;
        }
        if (document2.getTextLength() > textRange2.getStartOffset()) {
            int n10 = Math.min(document2.getTextLength(), textRange2.getStartOffset() + 20);
            return document2.getText(new TextRange(textRange2.getStartOffset(), n10)) + "\u2026";
        }
        return "";
    }

    private final String o(VirtualFile virtualFile, Position position) {
        return virtualFile.getName() + ":" + (position.getLine() + 1) + ":" + (position.getCharacter() + 1);
    }
}

