/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.formatter;

import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.service.AsyncDocumentFormattingService;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.FormattingService;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspBundle;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.api.customization.LspFormattingSupport;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u000fH\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/lsp/impl/formatter/LspFormattingService;", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService;", "()V", "canFormat", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "createFormattingTask", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService$FormattingTask;", "formattingRequest", "Lcom/intellij/formatting/service/AsyncFormattingRequest;", "getFeatures", "", "Lcom/intellij/formatting/service/FormattingService$Feature;", "getName", "", "Lorg/jetbrains/annotations/Nls;", "getNotificationGroupId", "o", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "LspFormattingTask", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspFormattingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspFormattingService.kt\ncom/intellij/platform/lsp/impl/formatter/LspFormattingService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LspServerManagerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerManagerImpl\n*L\n1#1,82:1\n1#2:83\n1#2:85\n77#3:84\n*S KotlinDebug\n*F\n+ 1 LspFormattingService.kt\ncom/intellij/platform/lsp/impl/formatter/LspFormattingService\n*L\n33#1:85\n33#1:84\n*E\n"})
final class LspFormattingService
extends AsyncDocumentFormattingService {
    @NotNull
    protected String getName() {
        return LspBundle.INSTANCE.message("lsp.based.formatter", new Object[0]);
    }

    @NotNull
    protected String getNotificationGroupId() {
        return "LSP window/showMessage";
    }

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        return SetsKt.emptySet();
    }

    public boolean canFormat(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return this.o(psiFile) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final LspServerImpl o(PsiFile psiFile) {
        Object e2;
        Object v5;
        boolean bl;
        Object object;
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        virtualFile2 = virtualFile2;
        if (virtualFile == null) return null;
        Object object2 = object = virtualFile2;
        boolean bl2 = false;
        if (!object2.isInLocalFileSystem()) return null;
        if (object2 instanceof VirtualFileWindow) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        VirtualFile virtualFile2 = object;
        virtualFile2 = virtualFile2;
        if (virtualFile3 == null) {
            return null;
        }
        VirtualFile virtualFile4 = virtualFile2;
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        LspServerManagerImpl lspServerManagerImpl = LspServerManagerImpl.Companion.getInstanceImpl(project);
        boolean bl4 = false;
        object = LspServerManagerImpl.access$getLspServers$p(lspServerManagerImpl);
        object2 = object.iterator();
        do {
            if (!object2.hasNext()) {
                v5 = null;
                return v5;
            }
            e2 = object2.next();
            LspServerImpl lspServerImpl = (LspServerImpl)e2;
            boolean bl5 = false;
            if (lspServerImpl.getState() == LspServerState.Running) {
                boolean bl6;
                LspServerImpl lspServerImpl2 = lspServerImpl;
                boolean bl7 = false;
                if (lspServerImpl2.getDescriptor().getLspFormattingSupport() == null) {
                    bl6 = false;
                } else if (!lspServerImpl2.hasFormattingRelatedCapabilities$intellij_platform_lsp_impl()) {
                    bl6 = false;
                } else if (!lspServerImpl2.getDescriptor().isSupportedFile(virtualFile4)) {
                    bl6 = false;
                } else {
                    LspFormattingSupport lspFormattingSupport;
                    FormattingModelBuilder formattingModelBuilder = LanguageFormatting.INSTANCE.forContext((PsiElement)psiFile);
                    boolean bl8 = formattingModelBuilder != null;
                    boolean bl9 = lspServerImpl2.doesServerExplicitlyWantToFormatThisFile$intellij_platform_lsp_impl(virtualFile4);
                    bl6 = lspFormattingSupport.shouldFormatThisFileExclusivelyByServer(virtualFile4, bl8, bl9);
                }
                if (bl6) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v5 = e2;
        return v5;
    }

    @Nullable
    protected AsyncDocumentFormattingService.FormattingTask createFormattingTask(@NotNull AsyncFormattingRequest formattingRequest) {
        Intrinsics.checkNotNullParameter((Object)formattingRequest, (String)"formattingRequest");
        VirtualFile virtualFile = formattingRequest.getContext().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiFile psiFile = formattingRequest.getContext().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        LspServerImpl lspServerImpl = this.o(psiFile);
        if (lspServerImpl == null) {
            return null;
        }
        LspServerImpl lspServerImpl2 = lspServerImpl;
        return new LspFormattingTask(lspServerImpl2, virtualFile2, formattingRequest);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/lsp/impl/formatter/LspFormattingService$LspFormattingTask;", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService$FormattingTask;", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "formattingRequest", "Lcom/intellij/formatting/service/AsyncFormattingRequest;", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/formatting/service/AsyncFormattingRequest;)V", "cancel", "", "isRunUnderProgress", "run", "", "intellij.platform.lsp.impl"})
    private static final class LspFormattingTask
    implements AsyncDocumentFormattingService.FormattingTask {
        @NotNull
        private final LspServerImpl lspServer;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final AsyncFormattingRequest formattingRequest;

        public LspFormattingTask(@NotNull LspServerImpl lspServer, @NotNull VirtualFile file2, @NotNull AsyncFormattingRequest formattingRequest) {
            Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)formattingRequest, (String)"formattingRequest");
            this.lspServer = lspServer;
            this.file = file2;
            this.formattingRequest = formattingRequest;
        }

        public boolean isRunUnderProgress() {
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public void run() {
            String string = this.formattingRequest.getDocumentText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDocumentText(...)");
            String string2 = string;
            CodeStyleSettings codeStyleSettings = this.formattingRequest.getContext().getCodeStyleSettings();
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getCodeStyleSettings(...)");
            CodeStyleSettings codeStyleSettings2 = codeStyleSettings;
            Object object = new FormattingOptions();
            Object object2 = object;
            TextDocumentIdentifier textDocumentIdentifier = this.lspServer.getDocumentIdentifier(this.file);
            boolean bl = false;
            object2.setTabSize(codeStyleSettings2.getIndentSize(this.file.getFileType()));
            object2.setInsertSpaces(!codeStyleSettings2.useTabCharacter(this.file.getFileType()));
            FormattingOptions formattingOptions = object;
            TextDocumentIdentifier textDocumentIdentifier2 = textDocumentIdentifier;
            DocumentFormattingParams documentFormattingParams = new DocumentFormattingParams(textDocumentIdentifier2, formattingOptions);
            object = (List)LspServer.sendRequestSync$default(this.lspServer, 0, (Function1)new Function1<LanguageServer, CompletableFuture<List<? extends TextEdit>>>(documentFormattingParams){
                final /* synthetic */ DocumentFormattingParams $params;
                {
                    this.$params = $params;
                    super(1);
                }

                @NotNull
                public final CompletableFuture<List<? extends TextEdit>> invoke(@NotNull LanguageServer it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    CompletableFuture completableFuture = it.getTextDocumentService().formatting(this.$params);
                    Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"formatting(...)");
                    return completableFuture;
                }
            }, 1, null);
            object2 = (Collection)object;
            if (object2 == null || object2.isEmpty()) {
                this.formattingRequest.onTextReady(null);
                return;
            }
            object2 = new DocumentImpl((CharSequence)string2, false, true);
            Lsp4jUtilKt.applyTextEdits((Document)object2, (List<? extends TextEdit>)object);
            this.formattingRequest.onTextReady(object2.getText());
        }
    }
}

